/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.model;

import java.util.ArrayList;
import oracle.dbtools.migration.cloud.ui.backendDelegation.BackendDelegator;
import oracle.dbtools.util.Logger;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class CloudMigrationModel
extends HashStructureAdapter
implements CommitListener {
    public static final String KEY = CloudMigrationModel.class.getSimpleName();
    private static CloudMigrationModel _model = null;
    private ArrayList<String> availableSchemasList = new ArrayList();
    private ArrayList<String> selectedSchemasList = new ArrayList();
    private ArrayList<String> previouslyDeployedSchemasList = new ArrayList();
    private ArrayList<String> newDeployableSchemasList = new ArrayList();
    boolean navigatorContext = false;
    boolean menuContext = false;
    BackendDelegator backendDelegator = new BackendDelegator(this);
    public static final String SOURCE_CONNECTION = "source_connection";
    public static final String TARGET_CONNECTION = "target_connection";

    public static CloudMigrationModel getInstance() {
        if (null == _model) {
            _model = new CloudMigrationModel();
        }
        return _model;
    }

    protected CloudMigrationModel() {
        super(HashStructure.newInstance());
        this.setString("REDSHIFT_S3_BUCKET_KEY", null);
        this.setString("REDSHIFT_AWS_SECRET_ACCESS_TYPE_KEY", null);
        this.setString("REDSHIFT_AWS_ACCESS_TYPE_KEY", null);
    }

    public String toString() {
        HashStructure hashStructure = this.getHashStructure();
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (String string : hashStructure.keySet()) {
            stringBuilder.append(string).append(" = ").append(String.valueOf(hashStructure.getObject(string))).append('\n');
        }
        return stringBuilder.toString();
    }

    public HashStructure getHash() {
        return this.getHashStructure();
    }

    public String getSourceConnection() {
        return this.getHashStructure().getString(SOURCE_CONNECTION);
    }

    public void setSourceConnection(String string) {
        this.getHashStructure().putString(SOURCE_CONNECTION, string);
    }

    public String getTargetConnection() {
        return this.getHashStructure().getString(TARGET_CONNECTION);
    }

    public void setTargetConnection(String string) {
        this.getHashStructure().putString(TARGET_CONNECTION, string);
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
        CloudMigrationModel cloudMigrationModel = (CloudMigrationModel)((Object)applyEvent.getTraversableContext().get(KEY));
        if (this == cloudMigrationModel) {
            Logger.info(((Object)((Object)this)).getClass(), (String)"checkCommit");
        }
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        CloudMigrationModel cloudMigrationModel = (CloudMigrationModel)((Object)applyEvent.getTraversableContext().get(KEY));
        if (this == cloudMigrationModel) {
            Logger.info(((Object)((Object)this)).getClass(), (String)"commit");
            this.backendDelegator.startBackendThread2();
        }
    }

    public void rollback(ApplyEvent applyEvent) {
        CloudMigrationModel cloudMigrationModel = (CloudMigrationModel)((Object)applyEvent.getTraversableContext().get(KEY));
        if (this == cloudMigrationModel) {
            Logger.info(((Object)((Object)this)).getClass(), (String)"rollback");
        }
    }

    public void cancel(ApplyEvent applyEvent) {
        CloudMigrationModel cloudMigrationModel = (CloudMigrationModel)((Object)applyEvent.getTraversableContext().get(KEY));
        if (this == cloudMigrationModel) {
            Logger.info(((Object)((Object)this)).getClass(), (String)"cancel");
            this.cleanSelectedSchemas();
            this.cleanAvailableSchemas();
            this.cleanRedshiftCredentials(cloudMigrationModel);
        }
        if (cloudMigrationModel != null) {
            cloudMigrationModel = null;
        }
    }

    public void setBoolean(String string, Boolean bl) {
        this.getHashStructure().putBoolean(string, bl.booleanValue());
    }

    public Boolean getBoolean(String string) {
        return this.getHashStructure().getBoolean(string);
    }

    public void setInteger(String string, Integer n) {
        this.getHashStructure().putInt(string, n.intValue());
    }

    public Integer getInteger(String string) {
        return this.getHashStructure().getInt(string);
    }

    public void setString(String string, String string2) {
        this.getHashStructure().putString(string, string2);
    }

    public String getString(String string) {
        return this.getHashStructure().getString(string);
    }

    public void addSchemaToAvailableSchemasList(String string) {
        this.availableSchemasList.add(string);
    }

    public String[] getAvailableSchemas() {
        String[] stringArray = new String[this.availableSchemasList.size()];
        return this.availableSchemasList.toArray(stringArray);
    }

    public void addSchemaToSelectedSchemasList(String string) {
        this.selectedSchemasList.add(string);
    }

    public String[] getSelectedSchemas() {
        String[] stringArray = new String[this.selectedSchemasList.size()];
        return this.selectedSchemasList.toArray(stringArray);
    }

    public void removeFromAvailableSchemas(String string) {
        this.availableSchemasList.remove(string);
    }

    public void removeFromSelectedSchemas(String string) {
        this.selectedSchemasList.remove(string);
    }

    public void cleanSelectedSchemas() {
        this.selectedSchemasList.clear();
    }

    public void cleanAvailableSchemas() {
        this.availableSchemasList.clear();
    }

    public void cleanRedshiftCredentials(CloudMigrationModel cloudMigrationModel) {
        cloudMigrationModel.setString("REDSHIFT_S3_BUCKET_KEY", null);
        cloudMigrationModel.setString("REDSHIFT_AWS_SECRET_ACCESS_TYPE_KEY", null);
        cloudMigrationModel.setString("REDSHIFT_AWS_ACCESS_TYPE_KEY", null);
    }

    public void addSchemaToPreviouslyDeployedSchemasList(String string) {
        this.previouslyDeployedSchemasList.add(string);
    }

    public String[] getPreviouslyDeployedSchemas() {
        String[] stringArray = new String[this.previouslyDeployedSchemasList.size()];
        return this.previouslyDeployedSchemasList.toArray(stringArray);
    }

    public void removePreviouslyDeployedSchemasList() {
        this.previouslyDeployedSchemasList.clear();
    }

    public String[] getNewDeployableSchemas() {
        String[] stringArray = new String[this.newDeployableSchemasList.size()];
        return this.newDeployableSchemasList.toArray(stringArray);
    }

    public void addSchemaToNewDeployableSchemasList(String string) {
        this.newDeployableSchemasList.add(string);
    }

    public void removeNewDeployableSchemasList() {
        this.newDeployableSchemasList.clear();
    }

    public void setNavigatorInvocationContext() {
        this.navigatorContext = true;
        this.menuContext = false;
    }

    public void setMenuInvocationContext() {
        this.navigatorContext = false;
        this.menuContext = true;
    }

    public boolean getNavigatorInvocationContext() {
        return this.navigatorContext;
    }

    public boolean getMenuInvocationContext() {
        return this.menuContext;
    }

    public void clearAllLists() {
        if (this.availableSchemasList != null) {
            this.availableSchemasList.clear();
        }
        if (this.selectedSchemasList != null) {
            this.selectedSchemasList.clear();
        }
        if (this.previouslyDeployedSchemasList != null) {
            this.previouslyDeployedSchemasList.clear();
        }
        if (this.newDeployableSchemasList != null) {
            this.newDeployableSchemasList.clear();
        }
    }
}

