/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class IOTPropertiesValidator
extends AbstractChildDBObjectValidator<OracleIndexOrganizedTableProperties> {
    public IOTPropertiesValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("overflowable");
        collection.add("mapped");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"pctThreshold"}, level=ValidationLevel.FULL)
    public void validatePctThreshold(OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties, OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties2) throws ValidationException {
        Integer n = oracleIndexOrganizedTableProperties2.getPctThreshold();
        if (n != null && (n < 1 || n > 50)) {
            throw new ValidationException((DBObject)oracleIndexOrganizedTableProperties2, APIBundle.get((String)"IOT_PROPERTY_ERROR_PCT_THRESHOLD"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"keyCompression"}, level=ValidationLevel.FULL)
    public void validateKeyCompression(OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties, OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties2) throws ValidationException {
        Integer n = oracleIndexOrganizedTableProperties2.getKeyCompression();
        if (n != null) {
            Integer n2;
            PKConstraint pKConstraint = PKConstraint.getPrimaryKey((Relation)((Table)oracleIndexOrganizedTableProperties2.getParent()));
            Integer n3 = n2 = pKConstraint != null ? new Integer(pKConstraint.getColumns().length) : null;
            if (n2 != null && n2 == 1) {
                throw new ValidationException((DBObject)oracleIndexOrganizedTableProperties2, APIBundle.get((String)"IOT_PROPERTY_ERROR_KEY_COMPRESSION_INVALID_VALUE1"));
            }
            if (n < 0 || n2 == null || n.compareTo(n2) >= 0) {
                throw new ValidationException((DBObject)oracleIndexOrganizedTableProperties2, APIBundle.get((String)"IOT_PROPERTY_ERROR_KEY_COMPRESSION_INVALID_VALUE2"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"includeColumn"}, level=ValidationLevel.FULL)
    public void validateIncludeColumn(OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties, OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties2) throws ValidationException {
        DBObjectID dBObjectID = oracleIndexOrganizedTableProperties2.getIncludeColumn();
        if (dBObjectID != null) {
            Column column = null;
            try {
                column = dBObjectID != null ? (Column)dBObjectID.resolveID() : null;
            }
            catch (DBException dBException) {
                this.logException(dBException, Level.FINE);
            }
            if (column != null) {
                Column[] columnArray;
                int n;
                Column[] columnArray2;
                Table table;
                String string = column.getName();
                column = null;
                if (ModelUtil.hasLength((String)string) && (table = (Table)oracleIndexOrganizedTableProperties2.getParent()) != null) {
                    columnArray2 = table.getColumns();
                    n = columnArray2.length;
                    for (int i = 0; i < n; ++i) {
                        columnArray = columnArray2[i];
                        if (!string.equals(columnArray.getName())) continue;
                        column = columnArray;
                        break;
                    }
                }
                if (column == null) {
                    throw new ValidationException((DBObject)oracleIndexOrganizedTableProperties2, APIBundle.get((String)"IOT_PROPERTY_ERROR_INVALID_INCLUDING_COLUMN2"));
                }
                table = (Table)oracleIndexOrganizedTableProperties2.getParent();
                Constraint[] constraintArray = columnArray2 = table == null ? null : table.getConstraints();
                if (columnArray2 != null && columnArray2.length > 0) {
                    for (n = 0; n < columnArray2.length; ++n) {
                        if (!columnArray2[n].getConstraintType().equals("PKConstraint")) continue;
                        PKConstraint pKConstraint = (PKConstraint)columnArray2[n];
                        columnArray = pKConstraint.getColumns();
                        if (columnArray.length <= 0 || column.getName().equals(columnArray[columnArray.length - 1].getName())) break;
                        for (int i = 0; i < columnArray.length - 1; ++i) {
                            if (!column.getName().equals(columnArray[i].getName())) continue;
                            throw new ValidationException((DBObject)oracleIndexOrganizedTableProperties2, APIBundle.get((String)"IOT_PROPERTY_ERROR_INVALID_INCLUDING_COLUMN2"));
                        }
                        break;
                    }
                }
            }
        }
    }
}

