/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class ColumnSequenceProcessor
extends UpdateProcessor {
    public static final String AUTO_GENERATED_SEQUENCE = "AUTO_GENERATED_SEQUENCE";
    public static final String AUTO_GENERATED_SEQUENCE_TRIGGER = "AUTO_GENERATED_SEQUENCE_TRIGGER";
    public static final String REUSE_SEQUENCE = "ColumnSequenceExpander.ReuseSequence";
    public static final String TRIGGER_NULL_CHECK = "ColumnSequenceExpander.TriggerNullCheck";
    @Deprecated
    public static final String NEW_SEQUENCE_NAME = "ColumnSequenceExpander.NewSequenceName";
    @Deprecated
    public static final String NEW_TRIGGER_NAME = "ColumnSequenceExpander.NewTriggerName";
    private static final String COLSEQ_SEARCH = "<<COLUMN_SEQUENCES>> BEGIN {^END COLUMN_SEQUENCES}... END COLUMN_SEQUENCES;";
    private static final String COLSEQ_STATEMENT_SEARCH = "<if [IF {^{THEN}}... THEN]> SELECT <seq ?.> INTO : ? .<col ?> FROM [SYS.]DUAL";
    private static final String EMPTY_CODE_SEARCH = "BEGIN <null NULL;> END;";
    private static final String COLSEQ_HEADER = "  <<COLUMN_SEQUENCES>>\n  BEGIN\n";
    private static final String COLSEQ_FOOTER = "  END COLUMN_SEQUENCES;\n";
    private static final String EMPTY_COLSEQ_BLOCK = "  <<COLUMN_SEQUENCES>>\n  BEGIN\n    NULL;\n  END COLUMN_SEQUENCES;\n";
    private static final String IF_INSERTING = "    IF INSERTING THEN\n  ";
    private static final String IF_INSERTING_AND_NULL = "    IF INSERTING AND :<NEW>.<COLUMN> IS NULL THEN\n  ";
    private static final String END_IF = "    END IF;\n";
    private static final String SELECT_INTO = "    SELECT <SEQUENCE>.NEXTVAL INTO :<NEW>.<COLUMN> FROM SYS.DUAL;\n";
    private static final String NEW_TOKEN = "<NEW>";
    private static final String COLUMN_TOKEN = "<COLUMN>";
    private static final String SEQUENCE_TOKEN = "<SEQUENCE>";
    private static final String TRIGGER_SUFFIX = "_TRG";
    private static final String SEQUENCE_SUFFIX = "_SEQ";
    private static final String END = "END";
    private static final String NEW = "NEW";
    private static final String NEXTVAL = "NEXTVAL";
    private static final Set<String> s_props = new HashSet<String>();

    public ColumnSequenceProcessor() {
        ColumnSequenceProcessor.getColumnSequenceProps();
    }

    /*
     * WARNING - void declaration
     */
    public void processUpdate(DBObjectTransaction dBObjectTransaction, Difference difference) {
        SystemObject systemObject = dBObjectTransaction.getDiffUpdatedObject(difference);
        if (systemObject instanceof Table) {
            Object holder;
            Table table = (Table)systemObject;
            if (ModelUtil.areEqual((Object)Table.TableType.EXTERNAL, (Object)table.getProperty("TableType"))) {
                for (Column column2 : table.getColumns()) {
                    if (!ColumnSequenceProcessor.hasColumnSequenceProps(column2)) continue;
                    ColumnSequenceProcessor.clearColumnSequenceProps(column2);
                }
                return;
            }
            Schema schema = table.getSchema();
            Schema schema2 = (Schema)dBObjectTransaction.getCopyForUpdate((SystemObject)schema);
            if (schema != null && schema2 != null && !schema.getName().equals(schema2.getName())) {
                return;
            }
            ArrayList<Difference> arrayList = new ArrayList<Difference>();
            ArrayList<Difference> arrayList2 = new ArrayList<Difference>();
            ArrayList<Difference> arrayList3 = new ArrayList<Difference>();
            this.getColumnSequenceDiffs(difference, arrayList, arrayList2, arrayList3);
            HashSet<DBObjectID> hashSet = new HashSet<DBObjectID>();
            for (Difference difference2 : arrayList) {
                Column dBObjectID = (Column)difference2.getOriginalObject();
                DBObjectID dBObjectID2 = (DBObjectID)dBObjectID.getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER);
                if (dBObjectID2 == null) continue;
                hashSet.add(dBObjectID2);
            }
            for (Difference difference3 : arrayList3) {
                DBObjectID dBObjectID;
                if (!AUTO_GENERATED_SEQUENCE_TRIGGER.equals(difference3.getPropertyName()) || difference3.getOriginalObject() == null || (dBObjectID = (DBObjectID)difference3.getOriginalObject()) == null) continue;
                hashSet.add(dBObjectID);
            }
            for (DBObjectID dBObjectID : hashSet) {
                this.setEmptyColSeqCode(dBObjectID, dBObjectTransaction);
            }
            hashSet.clear();
            if (difference.getOriginalObject() == null) {
                void var13_29;
                holder = table.getColumns();
                int n = ((Column[])holder).length;
                boolean bl = false;
                while (var13_29 < n) {
                    Object object = holder[var13_29];
                    DBObjectID dBObjectID = (DBObjectID)object.getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER);
                    if (dBObjectID != null) {
                        hashSet.add(dBObjectID);
                    }
                    ++var13_29;
                }
            }
            for (Difference difference2 : arrayList2) {
                Column column = (Column)difference2.getUpdatedObject();
                DBObjectID dBObjectID = (DBObjectID)column.getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER);
                if (dBObjectID == null) continue;
                hashSet.add(dBObjectID);
            }
            for (Difference difference3 : arrayList3) {
                Column column;
                DBObjectID dBObjectID;
                if (difference3.getUpdatedObject() == null || (dBObjectID = (DBObjectID)(column = (Column)difference3.getParent().getParent().getUpdatedObject()).getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER)) == null) continue;
                hashSet.add(dBObjectID);
            }
            holder = new Holder();
            ((Holder)holder).value = Boolean.FALSE;
            for (DBObjectID dBObjectID : hashSet) {
                this.generateColSeqCode(table, dBObjectID, dBObjectTransaction, (Holder<Boolean>)holder);
            }
            if (((Boolean)((Holder)holder).value).booleanValue()) {
                dBObjectTransaction.includeUpdate(systemObject);
            }
        }
    }

    private void setColSeqBlock(Trigger trigger, String string, DBObjectTransaction dBObjectTransaction) throws CancelledException {
        Trigger trigger2 = (Trigger)dBObjectTransaction.getCopyForUpdate((SystemObject)trigger);
        if (trigger2 != null) {
            PlSqlParser plSqlParser;
            int n = -1;
            int n2 = -1;
            DBObjectProvider dBObjectProvider = dBObjectTransaction.getProvider();
            if (trigger2.getSource() == null) {
                trigger2.setSource(PlSqlUtil.getDefaultSource(dBObjectProvider, (PlSqlSourceObject)trigger2));
            }
            if ((plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)trigger2, (DBObjectProvider)dBObjectProvider)) != null) {
                Object object;
                PlSqlSearch plSqlSearch = new PlSqlSearch(COLSEQ_SEARCH);
                PlSqlSearch plSqlSearch2 = new PlSqlSearch(EMPTY_CODE_SEARCH);
                if (plSqlSearch.isWithin(plSqlParser.getTokenAtOffset(0))) {
                    n = plSqlSearch.getStartToken().getStart();
                    n2 = plSqlSearch.getEndToken().getEnd() + 1;
                } else if (plSqlSearch2.isWithin(plSqlParser.getTokenAtOffset(0))) {
                    n = plSqlSearch2.getNamedMatchStartToken("null").getStart();
                    n2 = plSqlSearch2.getNamedMatchEndToken("null").getEnd() + 1;
                } else {
                    object = plSqlParser.getTokenAtOffset(trigger2.getSource().length());
                    if (!object.isCode()) {
                        object = (PlSqlToken)object.getPrevCodeToken();
                    }
                    while (!object.matches(END) && object.getStart() >= 10) {
                        object = (PlSqlToken)object.getPrevCodeToken();
                    }
                    if (object.matches(END)) {
                        n2 = n = object.getStart();
                    }
                }
                if (n > -1 && n2 >= n) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(trigger2.getSource().substring(0, n));
                    if (n2 == n) {
                        ((StringBuilder)object).append(string);
                    } else {
                        ((StringBuilder)object).append(string.trim());
                    }
                    ((StringBuilder)object).append(trigger2.getSource().substring(n2));
                    trigger2.setSource(((StringBuilder)object).toString());
                }
                dBObjectTransaction.includeUpdate((SystemObject)trigger2);
            }
        }
    }

    private void setEmptyColSeqCode(DBObjectID dBObjectID, DBObjectTransaction dBObjectTransaction) {
        try {
            Trigger trigger = (Trigger)dBObjectID.resolveID();
            this.setColSeqBlock(trigger, EMPTY_COLSEQ_BLOCK, dBObjectTransaction);
        }
        catch (DBException dBException) {
            DBLog.getLogger((Object)((Object)this)).warning(dBException.getMessage());
        }
    }

    private void generateColSeqCode(Table table, DBObjectID dBObjectID, DBObjectTransaction dBObjectTransaction, Holder<Boolean> holder) {
        try {
            String string;
            DBObjectProvider dBObjectProvider = dBObjectTransaction.getProvider();
            Trigger trigger = (Trigger)dBObjectID.resolveID();
            if (trigger == null && dBObjectID instanceof BaseObjectID) {
                string = this.getNameToUse(dBObjectProvider, "TRIGGER", ((BaseObjectID)dBObjectID).getName(), table);
                trigger = (Trigger)dBObjectProvider.getObjectFactory().newObject(Trigger.class, (DBObject)table.getSchema(), string);
                ColumnSequenceProcessor.initialiseTrigger(trigger, dBObjectProvider, table, string);
            }
            string = trigger.getSchema().getName();
            String string2 = trigger.getReferencingNewAs();
            if (string2 == null) {
                string2 = NEW;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(COLSEQ_HEADER);
            for (Column column : table.getColumns()) {
                DBObjectID dBObjectID2 = (DBObjectID)column.getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER);
                if (!dBObjectID.equals(dBObjectID2)) continue;
                if (dBObjectID instanceof ReferenceID) {
                    column.setProperty(AUTO_GENERATED_SEQUENCE_TRIGGER, (Object)trigger.getID());
                    holder.value = Boolean.TRUE;
                }
                String string3 = dBObjectProvider.getExternalName(column.getName());
                Object object = "";
                String string4 = "";
                DBObjectID dBObjectID3 = (DBObjectID)column.getProperty(AUTO_GENERATED_SEQUENCE);
                if (dBObjectID3 instanceof ReferenceID) {
                    object = this.getNameToUse(dBObjectProvider, "SEQUENCE", ((ReferenceID)dBObjectID3).getName(), table);
                    var19_20 = table.getSchema();
                    string4 = var19_20.getName();
                    if (table.getProperty("TemplateObject") == null && (var20_21 = ((ReferenceID)dBObjectID3).getSchemaName()) != null) {
                        string4 = var20_21;
                        var19_20 = dBObjectProvider.getSchema(var20_21);
                    }
                    var20_21 = (Sequence)dBObjectProvider.getObjectFactory().newObject(Sequence.class, (DBObject)var19_20, (String)object);
                    TemporaryObjectID temporaryObjectID = (TemporaryObjectID)TemporaryObjectID.createID((DBObject)var20_21);
                    var20_21.setID((DBObjectID)temporaryObjectID);
                    column.setProperty(AUTO_GENERATED_SEQUENCE, (Object)temporaryObjectID);
                    holder.value = Boolean.TRUE;
                    dBObjectTransaction.includeUpdate(null, (SystemObject)var20_21);
                } else if (dBObjectID3 instanceof BaseObjectID) {
                    var19_20 = (BaseObjectID)dBObjectID3;
                    object = var19_20.getName();
                    var20_21 = var19_20.getSchemaName();
                    if (var20_21 != null) {
                        string4 = var20_21;
                    }
                } else {
                    object = DBUtil.getDBObjectName((DBObjectID)dBObjectID3);
                }
                object = dBObjectProvider.getExternalName((String)object);
                if (ModelUtil.hasLength((String)string4) && !string4.equals(string)) {
                    object = dBObjectProvider.getExternalName(string4) + "." + (String)object;
                }
                if (Boolean.TRUE.equals(column.getProperty(TRIGGER_NULL_CHECK))) {
                    stringBuilder.append(IF_INSERTING_AND_NULL.replaceAll(NEW_TOKEN, string2).replaceAll(COLUMN_TOKEN, string3));
                } else {
                    stringBuilder.append(IF_INSERTING);
                }
                stringBuilder.append(SELECT_INTO.replaceAll(SEQUENCE_TOKEN, (String)object).replaceAll(NEW_TOKEN, string2).replaceAll(COLUMN_TOKEN, string3));
                stringBuilder.append(END_IF);
            }
            stringBuilder.append(COLSEQ_FOOTER);
            this.setColSeqBlock(trigger, stringBuilder.toString(), dBObjectTransaction);
        }
        catch (DBException dBException) {
            DBLog.getLogger((Object)((Object)this)).warning(dBException.getMessage());
        }
    }

    private void getColumnSequenceDiffs(Difference difference, List<Difference> list, List<Difference> list2, List<Difference> list3) {
        Difference difference2 = difference.getChildDifference("columns", true);
        if (difference2 != null) {
            for (Difference difference3 : difference2.getChildren()) {
                if (difference3.isSame()) continue;
                if (difference3.getOriginalObject() != null && difference3.getUpdatedObject() == null) {
                    if (!ColumnSequenceProcessor.hasColumnSequenceProps((Column)difference3.getOriginalObject())) continue;
                    list.add(difference3);
                    continue;
                }
                if (difference3.getOriginalObject() == null && difference3.getUpdatedObject() != null) {
                    if (!ColumnSequenceProcessor.hasColumnSequenceProps((Column)difference3.getUpdatedObject())) continue;
                    list2.add(difference3);
                    continue;
                }
                Difference difference4 = difference3.getChildDifference("properties", true);
                if (difference4 == null) continue;
                for (String string : ColumnSequenceProcessor.getColumnSequenceProps()) {
                    Difference difference5 = difference4.getChildDifference(string, true);
                    if (difference5 == null) continue;
                    list3.add(difference5);
                }
            }
        }
    }

    private String getNameToUse(DBObjectProvider dBObjectProvider, String string, String object, Table table) {
        DBObjectID dBObjectID = (DBObjectID)table.getProperty("TemplateObject");
        if (dBObjectID != null) {
            Object object2 = DBUtil.getDBObjectName((DBObjectID)dBObjectID);
            object2 = "TRIGGER".equals(string) ? (String)object2 + TRIGGER_SUFFIX : (String)object2 + SEQUENCE_SUFFIX;
            if (((String)object2).equals(object)) {
                object = table.getName();
                object = "TRIGGER".equals(string) ? (String)object + TRIGGER_SUFFIX : (String)object + SEQUENCE_SUFFIX;
            }
        }
        object = dBObjectProvider.getUniqueName(string, (DBObject)table.getSchema(), (String)object);
        return object;
    }

    public boolean onlyProcessesPrimaryUpdates() {
        return true;
    }

    public static void initialiseTrigger(Trigger trigger, DBObjectProvider dBObjectProvider, Table table, String string) {
        trigger.setSchema(table.getSchema());
        trigger.setName(string);
        trigger.setBaseType(Trigger.BaseType.TABLE);
        trigger.setBaseObjectID(table.getID());
        trigger.setTiming(Trigger.Timing.BEFORE);
        trigger.setEvents(new String[]{"INSERT"});
        trigger.setStatementLevel(false);
        trigger.setSource(null);
        TemporaryObjectID temporaryObjectID = (TemporaryObjectID)TemporaryObjectID.createID((DBObject)trigger);
        trigger.setID((DBObjectID)temporaryObjectID);
    }

    public static boolean hasColumnSequenceProps(Column column) {
        for (String string : ColumnSequenceProcessor.getColumnSequenceProps()) {
            if (column.getProperty(string) == null) continue;
            return true;
        }
        return false;
    }

    public static void clearColumnSequenceProps(Column column) {
        Map map = column.getProperties();
        if (map != null) {
            for (String string : ColumnSequenceProcessor.getColumnSequenceProps()) {
                map.remove(string);
            }
        }
    }

    public static boolean isColumnSequenceProp(String string) {
        return ColumnSequenceProcessor.getColumnSequenceProps().contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> getColumnSequenceProps() {
        Set<String> set = s_props;
        synchronized (set) {
            if (s_props.isEmpty()) {
                TemplateExpander.registerInitialiser((TemplateExpander.Initialiser)new TemplateInitialiser());
                s_props.add(AUTO_GENERATED_SEQUENCE_TRIGGER);
                s_props.add(AUTO_GENERATED_SEQUENCE);
                s_props.add(TRIGGER_NULL_CHECK);
                s_props.add(REUSE_SEQUENCE);
            }
        }
        return s_props;
    }

    public static void refreshColumnSequenceProps(Column column) {
        Column column2;
        DBObjectID dBObjectID = column.getID();
        if (dBObjectID instanceof TemporaryObjectID && (column2 = (Column)TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)dBObjectID))) != null) {
            for (String string : ColumnSequenceProcessor.getColumnSequenceProps()) {
                column.setProperty(string, column2.getProperty(string));
            }
        }
    }

    public static List<ColumnInfo> getColumnInfos(String string, DBObjectProvider dBObjectProvider) {
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        PlSqlSearch plSqlSearch = new PlSqlSearch(COLSEQ_SEARCH);
        PlSqlSearch plSqlSearch2 = new PlSqlSearch(COLSEQ_STATEMENT_SEARCH);
        PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
        if (plSqlSearch.isWithin(plSqlToken)) {
            plSqlToken = plSqlSearch.getStartToken();
            PlSqlToken plSqlToken2 = plSqlSearch.getEndToken();
            while (plSqlSearch2.isWithin(plSqlToken, plSqlToken2)) {
                PlSqlToken plSqlToken3;
                PlSqlToken plSqlToken4;
                PlSqlSearch plSqlSearch3;
                PlSqlToken plSqlToken5 = plSqlSearch2.getNamedMatchStartToken("col");
                PlSqlToken plSqlToken6 = (PlSqlToken)((PlSqlToken)((PlSqlToken)plSqlToken5.getPrevCodeToken()).getPrevCodeToken()).getPrevCodeToken();
                String string2 = dBObjectProvider.getInternalName(plSqlToken5.getSource());
                PlSqlToken plSqlToken7 = plSqlSearch2.getNamedMatchStartToken("if");
                PlSqlToken plSqlToken8 = plSqlSearch2.getNamedMatchEndToken("if");
                boolean bl = false;
                if (plSqlToken7 != null) {
                    plSqlSearch3 = new PlSqlSearch(plSqlToken6.getSource(true, (Token)plSqlToken5) + " IS NULL");
                    if (plSqlSearch3.isWithin(plSqlToken7, plSqlToken8)) {
                        bl = true;
                        plSqlToken4 = plSqlSearch3.getStartToken();
                        plSqlToken3 = plSqlSearch3.getEndToken();
                    } else {
                        plSqlToken4 = plSqlToken7;
                        plSqlToken3 = plSqlToken7;
                    }
                } else {
                    plSqlToken3 = plSqlToken4 = plSqlSearch2.getStartToken();
                }
                plSqlSearch3 = plSqlSearch2.getNamedMatchStartToken("seq");
                PlSqlToken plSqlToken9 = plSqlSearch2.getNamedMatchEndToken("seq");
                String string3 = plSqlSearch2.getNamedMatch("seq");
                String[] stringArray = string3.split("\\.");
                if (stringArray.length > 1 && stringArray.length < 4 && NEXTVAL.equalsIgnoreCase(stringArray[stringArray.length - 1])) {
                    String string4 = null;
                    String string5 = dBObjectProvider.getInternalName(stringArray[0]);
                    if (stringArray.length == 3) {
                        string4 = string5;
                        string5 = dBObjectProvider.getInternalName(stringArray[1]);
                    }
                    ColumnInfo columnInfo = new ColumnInfo(string2, plSqlToken6.getStart(), plSqlToken5.getEnd(), string4, string5, plSqlSearch3.getStart(), plSqlToken9.getEnd(), bl, plSqlToken4.getStart(), plSqlToken3.getEnd());
                    arrayList.add(columnInfo);
                }
                plSqlToken = plSqlSearch2.getEndToken();
            }
        }
        return arrayList;
    }

    public static void registerProcessorProperties(Class<? extends DBObjectProvider> clazz) {
        Metadata metadata = Metadata.getInstance();
        PropertyDefinition propertyDefinition = new PropertyDefinition(REUSE_SEQUENCE, Boolean.class, clazz, new Class[]{Column.class});
        propertyDefinition.setNullBehaviour(Nullable.NullBehaviour.NULL_MEANS_FALSE);
        metadata.registerProperty((PropertyInfo)propertyDefinition);
        PropertyDefinition propertyDefinition2 = new PropertyDefinition(TRIGGER_NULL_CHECK, Boolean.class, clazz, new Class[]{Column.class});
        propertyDefinition2.setNullBehaviour(Nullable.NullBehaviour.NULL_MEANS_FALSE);
        metadata.registerProperty((PropertyInfo)propertyDefinition2);
        metadata.registerIDProperty(AUTO_GENERATED_SEQUENCE, false, Sequence.class, null, clazz, new Class[]{Column.class});
        metadata.registerIDProperty(AUTO_GENERATED_SEQUENCE_TRIGGER, false, Trigger.class, null, clazz, new Class[]{Column.class});
    }

    @Deprecated
    public static String getUniqueName(DBObjectProvider dBObjectProvider, String string, Schema schema, String string2) {
        return null;
    }

    private static class TemplateInitialiser
    implements TemplateExpander.Initialiser {
        private TemplateInitialiser() {
        }

        public void initialiseObject(DBObject dBObject, DBObject dBObject2) {
            if ("TABLE".equals(dBObject.getType())) {
                Table table = (Table)dBObject;
                Table table2 = (Table)dBObject2;
                String string = table.getName();
                for (Column column : table.getColumns()) {
                    DBObjectID dBObjectID = (DBObjectID)column.getProperty(ColumnSequenceProcessor.AUTO_GENERATED_SEQUENCE_TRIGGER);
                    if (dBObjectID == null) continue;
                    Column column2 = table2.getColumn(column.getName());
                    String string2 = table.getSchema().getName();
                    String string3 = string + ColumnSequenceProcessor.TRIGGER_SUFFIX;
                    String string4 = string + ColumnSequenceProcessor.SEQUENCE_SUFFIX;
                    column2.setProperty(ColumnSequenceProcessor.AUTO_GENERATED_SEQUENCE_TRIGGER, (Object)new ReferenceID("TRIGGER", string2, string3));
                    if (Boolean.TRUE.equals(column.getProperty(ColumnSequenceProcessor.REUSE_SEQUENCE))) continue;
                    column2.setProperty(ColumnSequenceProcessor.AUTO_GENERATED_SEQUENCE, (Object)new ReferenceID("SEQUENCE", string2, string4));
                }
            }
        }
    }

    public static class ColumnInfo {
        private final String m_columnName;
        private final String m_sequenceSchemaName;
        private final String m_sequenceName;
        private final boolean m_nullCheck;
        private final int m_columnStart;
        private final int m_columnEnd;
        private final int m_sequenceStart;
        private final int m_sequenceEnd;
        private final int m_nullCheckStart;
        private final int m_nullCheckEnd;

        private ColumnInfo(String string, int n, int n2, String string2, String string3, int n3, int n4, boolean bl, int n5, int n6) {
            this.m_columnName = string;
            this.m_sequenceSchemaName = string2;
            this.m_sequenceName = string3;
            this.m_nullCheck = bl;
            this.m_columnStart = n;
            this.m_columnEnd = n2;
            this.m_sequenceStart = n3;
            this.m_sequenceEnd = n4;
            this.m_nullCheckStart = n5;
            this.m_nullCheckEnd = n6;
        }

        public String getColumnName() {
            return this.m_columnName;
        }

        public String getSequenceSchemaName() {
            return this.m_sequenceSchemaName;
        }

        public String getSequenceName() {
            return this.m_sequenceName;
        }

        public boolean isCheckForNull() {
            return this.m_nullCheck;
        }

        public int getColumnStart() {
            return this.m_columnStart;
        }

        public int getColumnEnd() {
            return this.m_columnEnd;
        }

        public int getSequenceStart() {
            return this.m_sequenceStart;
        }

        public int getSequenceEnd() {
            return this.m_sequenceEnd;
        }

        public int getNullCheckStart() {
            return this.m_nullCheckStart;
        }

        public int getNullCheckEnd() {
            return this.m_nullCheckEnd;
        }
    }
}

