/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.javatools.ui.AttributedStringBuilder;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ExpansionTreeTip;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.SuperTextAttribute;
import oracle.javatools.ui.plaf.SuperLabelUI;
import oracle.javatools.util.PlatformUtils;

public abstract class SuperTreeCellRenderer<T>
implements TreeCellRenderer {
    private static final Border DEFAULT_FOCUS_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Tree.selectionBorderColor")), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    protected static Border noFocusBorder;
    protected static Border focusBorder;
    private TreeSuperLabel label = new TreeSuperLabel();
    private JTree tree;
    private int renderingRow = 0;
    private int hyperlinkRow = -1;
    private JLabel iconLabel = new JLabel();
    private JPanel content = new JPanel(new LayoutM());
    private Color textSelectionColor = UIManager.getColor("Tree.selectionForeground");
    private Color backgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
    private final HyperlinkRowMap hyperlinkRowMap = new HyperlinkRowMap();
    private boolean isPaintingOldRow = false;
    private Set<ActionListener> actionListeners = new CopyOnWriteArraySet<ActionListener>();

    @Deprecated
    public SuperTreeCellRenderer() {
        this.content.setOpaque(false);
        this.content.add((Component)this.iconLabel, "Before");
        this.content.add(this.label);
        this.label.setRequireModifierForHyperlink(true);
    }

    public SuperTreeCellRenderer(JTree tree) {
        this.content.setOpaque(false);
        this.content.add((Component)this.iconLabel, "Before");
        this.content.add(this.label);
        this.label.setRequireModifierForHyperlink(true);
        this.tree = tree;
        MouseL mouseL = new MouseL();
        tree.addMouseListener(mouseL);
        tree.addMouseMotionListener(mouseL);
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    protected void fireActionEvent(int id, String command) {
        ActionEvent event = new ActionEvent(this, id, command);
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(event);
        }
    }

    public void setTextSelectionColor(Color textSelectionColor) {
        this.textSelectionColor = textSelectionColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor != null ? this.textSelectionColor : Color.GREEN;
    }

    public void setHyperlinkForeground(Color hyperlinkForeground) {
        this.label.setHyperlinkForeground(hyperlinkForeground);
    }

    public Color getHyperlinkForeground() {
        return this.label.getHyperlinkForeground();
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    @Override
    public final JComponent getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
        if (!this.isPaintingOldRow) {
            if (this.renderingRow != row) {
                ((SuperLabelUI)this.label.getUI()).setActiveHyperlink(null);
            }
            this.renderingRow = row;
        }
        this.cellSetup(tree, value, isSelected, expanded, leaf, row, cellHasFocus);
        AttributedString text = this.getCellText(tree, value, isSelected, expanded, leaf, row, cellHasFocus);
        if (text == null) {
            this.label.setText("");
        } else {
            this.label.setAttributedText(text);
        }
        this.iconLabel.setIcon(this.getCellIcon(tree, value, isSelected, expanded, leaf, row, cellHasFocus));
        return this.content;
    }

    public abstract Icon getCellIcon(JTree var1, T var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);

    public abstract AttributedString getCellText(JTree var1, T var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);

    protected void cellSetup(JTree tree, T value, boolean selected, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
        this.label.setComponentOrientation(tree.getComponentOrientation());
        Color bg = null;
        Color fg = null;
        JTree.DropLocation dropLocation = tree.getDropLocation();
        fg = dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row ? this.getTextSelectionColor() : (selected ? this.getTextSelectionColor() : tree.getForeground());
        if (selected) {
            this.label.setBackground(bg == null ? this.getBackgroundSelectionColor() : bg);
            this.label.setForeground(fg == null ? this.getTextSelectionColor() : fg);
            this.label.setOpaque(true);
        } else {
            this.label.setBackground(tree.getBackground());
            this.label.setForeground(tree.getForeground());
            this.label.setOpaque(false);
        }
        if (value instanceof Icon) {
            this.iconLabel.setIcon((Icon)value);
            this.label.setText("");
        } else {
            this.iconLabel.setIcon(null);
            this.label.setText(value == null ? "" : value.toString());
        }
        this.label.setEnabled(tree.isEnabled());
        this.label.setFont(tree.getFont());
        Border border = null;
        border = cellHasFocus ? focusBorder : noFocusBorder;
        this.label.setBorder(border);
        this.label.setHyperlinkForeground(selected ? UIManager.getColor("Tree.selectionForeground") : Colors.HYPERLINK);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JTree tree = new JTree();
        SuperTreeCellRenderer<DefaultMutableTreeNode> renderer = new SuperTreeCellRenderer<DefaultMutableTreeNode>(tree){

            @Override
            public AttributedString getCellText(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
                Color color = Color.GREEN;
                if (row == 1) {
                    color = Color.BLUE;
                }
                if (row == 2) {
                    color = Color.RED;
                }
                if (selected) {
                    color = this.getTextSelectionColor();
                }
                String text = value.getUserObject().toString();
                AttributedStringBuilder<TextAttribute, Color> asb = new AttributedStringBuilder<TextAttribute, Color>(text, TextAttribute.FOREGROUND, color);
                HashMap<TextAttribute, Serializable> attrs = new HashMap<TextAttribute, Serializable>();
                attrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                attrs.put(TextAttribute.SIZE, Integer.valueOf(10));
                attrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT);
                asb.append(" (java.lang.fruit)", attrs);
                asb.append(" Link", (TextAttribute)((Object)SuperTextAttribute.HYPERLINK), (Color)((Object)text));
                if (selected) {
                    attrs.put(TextAttribute.FOREGROUND, this.getTextSelectionColor());
                }
                return asb.toAttributedString();
            }

            @Override
            public Icon getCellIcon(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
                if (leaf) {
                    return UIManager.getIcon("FileChooser.homeFolderIcon");
                }
                return null;
            }
        };
        tree.setCellRenderer(renderer);
        renderer.addActionListener(e -> System.out.println(e.getActionCommand()));
        tree.setRowHeight(18);
        f.add(new JScrollPane(tree));
        f.setSize(400, 600);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private SuperLabelUI.Hyperlink lookForHyperlink(Point p) {
        SuperLabelUI.Hyperlink newHyperlink = null;
        SuperLabelUI.Hyperlink oldHyperlink = ((SuperLabelUI)this.label.getUI()).getActiveHyperlink();
        int row = this.tree.getRowForLocation(p.x, p.y);
        if (row != this.hyperlinkRow && this.hyperlinkRow > -1) {
            this.isPaintingOldRow = true;
            this.label.setPaintHyperlink(false);
            Rectangle oldBounds = this.tree.getRowBounds(this.hyperlinkRow);
            this.hyperlinkRow = -1;
            if (oldBounds != null) {
                this.tree.paintImmediately(oldBounds);
            }
            this.label.setPaintHyperlink(true);
            this.isPaintingOldRow = false;
        }
        if (row == -1) {
            this.hyperlinkRow = -1;
            return null;
        }
        Rectangle rowBounds = this.tree.getRowBounds(row);
        if (rowBounds == null) {
            return null;
        }
        if (row != this.renderingRow) {
            this.tree.paintImmediately(rowBounds);
        }
        int x = p.x - rowBounds.x - this.label.getX() - this.label.getInsets().left;
        int y = p.y - rowBounds.y;
        int newHyperlinkRow = -1;
        List<SuperLabelUI.Hyperlink> links = this.hyperlinkRowMap.getHyperlinks(row);
        block0: for (SuperLabelUI.Hyperlink hyperlink : links) {
            for (Rectangle area : hyperlink.getBounds()) {
                if (!area.contains(x, y)) continue;
                newHyperlink = hyperlink;
                newHyperlinkRow = row;
                break block0;
            }
        }
        if (oldHyperlink != newHyperlink) {
            this.hyperlinkRow = newHyperlinkRow;
            ((SuperLabelUI)this.label.getUI()).setActiveHyperlink(newHyperlink);
            this.tree.paintImmediately(rowBounds);
            ExpansionTreeTip expansionTreeTip = (ExpansionTreeTip)this.tree.getClientProperty("expansion-tree-tip-component");
            if (expansionTreeTip != null) {
                expansionTreeTip.forceRepaint();
            }
        } else {
            this.hyperlinkRow = -1;
        }
        return newHyperlink;
    }

    static {
        noFocusBorder = DEFAULT_NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        focusBorder = DEFAULT_FOCUS_BORDER;
    }

    private class TreeSuperLabel
    extends SuperLabel {
        private TreeSuperLabel() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (SuperTreeCellRenderer.this.isPaintingOldRow) {
                return;
            }
            List<SuperLabelUI.Hyperlink> hyperlinks = ((SuperLabelUI)SuperTreeCellRenderer.this.label.getUI()).getHyperlinks();
            SuperTreeCellRenderer.this.hyperlinkRowMap.setHyperlinks(SuperTreeCellRenderer.this.renderingRow, new ArrayList<SuperLabelUI.Hyperlink>(hyperlinks));
        }
    }

    private class LayoutM
    implements LayoutManager {
        private final int iconTextGap = 2;

        private LayoutM() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension iconD = SuperTreeCellRenderer.this.iconLabel.getPreferredSize();
            Dimension textD = SuperTreeCellRenderer.this.label.getPreferredSize();
            return new Dimension(iconD.width + 2 + textD.width + 3, Math.max(iconD.height, textD.height));
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension iconD = SuperTreeCellRenderer.this.iconLabel.getMinimumSize();
            Dimension textD = SuperTreeCellRenderer.this.label.getMinimumSize();
            return new Dimension(iconD.width + 2 + textD.width + 3, Math.max(iconD.height, textD.height));
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension iconD = SuperTreeCellRenderer.this.iconLabel.getPreferredSize();
            Dimension textD = SuperTreeCellRenderer.this.label.getPreferredSize();
            int iconYOff = 0;
            int textYOff = 0;
            if (parent.getHeight() > textD.height) {
                textYOff = (parent.getHeight() - textD.height) / 2;
            }
            if (parent.getHeight() > iconD.height) {
                iconYOff = (parent.getHeight() - iconD.height) / 2;
            }
            SuperTreeCellRenderer.this.iconLabel.setBounds(0, iconYOff, iconD.width, iconD.height);
            int labelWidth = 10000;
            SuperTreeCellRenderer.this.label.setBounds(iconD.width + 2, textYOff, labelWidth, textD.height);
        }
    }

    private class HyperlinkRowMap {
        private List<SuperLabelUI.Hyperlink>[] hyperlinksByRow = new List[0];

        private HyperlinkRowMap() {
        }

        private List<SuperLabelUI.Hyperlink> getHyperlinks(int row) {
            if (row >= this.hyperlinksByRow.length) {
                return Collections.emptyList();
            }
            List<SuperLabelUI.Hyperlink> linksByRow = this.hyperlinksByRow[row];
            return linksByRow == null ? Collections.emptyList() : linksByRow;
        }

        private void setHyperlinks(int row, List<SuperLabelUI.Hyperlink> hyperlinks) {
            if (hyperlinks == null) {
                hyperlinks = Collections.emptyList();
            }
            if (this.hyperlinksByRow.length > row) {
                this.hyperlinksByRow[row] = hyperlinks;
                return;
            }
            int newSize = row + 40;
            List[] newHyperlinksByRow = new List[newSize];
            System.arraycopy(this.hyperlinksByRow, 0, newHyperlinksByRow, 0, this.hyperlinksByRow.length);
            this.hyperlinksByRow = newHyperlinksByRow;
            this.hyperlinksByRow[row] = hyperlinks;
        }
    }

    private class MouseL
    extends MouseInputAdapter {
        private MouseL() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SuperTreeCellRenderer.this.lookForHyperlink(e.getPoint());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SuperTreeCellRenderer.this.lookForHyperlink(e.getPoint());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SuperTreeCellRenderer.this.lookForHyperlink(e.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            SuperTreeCellRenderer.this.lookForHyperlink(e.getPoint());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            boolean ok = true;
            if (SuperTreeCellRenderer.this.label.isRequireModifierForHyperlink()) {
                ok = false;
                if (PlatformUtils.isMac() && e.isMetaDown()) {
                    ok = true;
                } else if (e.isControlDown()) {
                    ok = true;
                }
            }
            if (!ok) {
                return;
            }
            SuperLabelUI.Hyperlink hyperlink = SuperTreeCellRenderer.this.lookForHyperlink(e.getPoint());
            if (hyperlink != null) {
                int row = SuperTreeCellRenderer.this.tree.getRowForLocation(e.getX(), e.getY());
                if (row > -1) {
                    SuperTreeCellRenderer.this.tree.setSelectionRow(row);
                }
                SuperTreeCellRenderer.this.fireActionEvent(100001, hyperlink.getValue());
            }
        }
    }
}

