/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;
import oracle.javatools.ui.infotip.InfoTip;

final class InfoTipRectangle {
    private RectangleComponent rectangleComp = new RectangleComponent();

    InfoTipRectangle(JLayeredPane layeredPane, Rectangle r) {
        this.show(layeredPane, r);
    }

    InfoTipRectangle(final InfoTip infoTip) {
        infoTip.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("visible")) {
                    boolean visible = (Boolean)evt.getNewValue();
                    if (visible) {
                        InfoTipRectangle.this.show(infoTip.getLayeredPane(), infoTip.getBounds());
                    } else {
                        InfoTipRectangle.this.hide();
                    }
                }
            }
        });
    }

    void show(JLayeredPane layeredPane, Rectangle r) {
        int extraBounds = 3;
        this.rectangleComp.setForeground(UIManager.getColor("controlShadow"));
        this.rectangleComp.setSize(r.width + extraBounds + extraBounds, r.height + extraBounds + extraBounds);
        this.rectangleComp.setLocation(r.x - extraBounds, r.y - extraBounds);
        this.rectangleComp.validate();
        layeredPane.add((Component)this.rectangleComp, (Object)(JLayeredPane.POPUP_LAYER - 4));
    }

    void hide() {
        this.rectangleComp.getParent().remove(this.rectangleComp);
        this.rectangleComp = null;
    }

    private class RectangleComponent
    extends JComponent {
        public static final int STROKE_SIZE = 2;

        RectangleComponent() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(2.0f, 1, 1));
            g2.setColor(this.getForeground());
            Rectangle bounds = this.getBounds();
            g2.drawRect(2, 2, bounds.width - 2 - 2, bounds.height - 2 - 2);
        }
    }
}

