/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.lang.ref.SoftReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.javatools.ui.ghost.GhostBorder;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;

public class GhostPointingPalette
extends GhostPalette {
    private Rectangle pointingRect;
    private JComponent pointingComp;
    private int pointWidth = 15;
    private PointingCompListener pointingCompListener = new PointingCompListener();
    private PointingLayer pointingLayer;
    private boolean showRect = true;
    private final SizeListener sizeListener = new SizeListener();
    private static int INSET = 4;
    private static int ROUNDEDNESS = 5;
    private static final int TITLE_HEIGHT = 22;
    private static Border _sTitleBorder;
    private static Border _sEmptyTitleBorder;

    public GhostPointingPalette() {
        this.pointingLayer = new PointingLayer();
    }

    public void setPointing(JComponent pointComp, Point locationInComponent) {
        this.setPointing(pointComp, new Rectangle(locationInComponent));
    }

    public void setPointing(JComponent pointComp, Rectangle RectangleInComponent) {
        if (this.pointingComp != null) {
            this.pointingComp.removeComponentListener(this.pointingCompListener);
        }
        this.pointingRect = new Rectangle(RectangleInComponent);
        this.pointingComp = pointComp;
        this.pointingComp.addComponentListener(this.pointingCompListener);
        this.pointingComp.addAncestorListener(this.pointingCompListener);
        this._updateBorder();
    }

    @Override
    public void repaint() {
        if (!this.isShowing()) {
            return;
        }
        super.repaint();
    }

    @Override
    public void repaint(Rectangle r) {
        if (!this.isShowing()) {
            return;
        }
        super.repaint(r);
        r.grow(10, 10);
        this.pointingLayer.repaint(r);
    }

    public void setShowRectangle(boolean showRect) {
        this.showRect = showRect;
    }

    @Override
    public void hidePanel() {
        assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
        JComponent focusComp = this.pointingComp;
        this.setVisible(false);
        this.dispose();
        if (focusComp != null && this.getReceivesFocus()) {
            focusComp.requestFocus();
        }
        focusComp = null;
    }

    private Point getClosestPoint() {
        if (this.pointingRect == null || this.pointingComp == null || !this.isShowing() || !this.pointingComp.isShowing()) {
            return null;
        }
        int x = this.pointingRect.x;
        if (this.pointingRect.width != 0) {
            int xRatio = this.getWidth() / this.pointingRect.width;
            int pCenterX = this.pointingComp.getLocationOnScreen().x + this.pointingRect.x + this.pointingRect.width / 2;
            int gCenterX = this.getLocationOnScreen().x + this.getWidth() / 2;
            if (xRatio == 0) {
                xRatio = 1;
            }
            int xOffset = (gCenterX - pCenterX) / xRatio;
            int x1 = this.pointingRect.width / 2 + xOffset;
            x1 = Math.min(x1, this.pointingRect.width);
            x1 = Math.max(x1, 0);
            x += x1;
        }
        int y = this.pointingRect.y;
        if (this.pointingRect.height != 0) {
            int yRatio = this.getHeight() / this.pointingRect.height;
            int pCenterY = this.pointingComp.getLocationOnScreen().y + this.pointingRect.y + this.pointingRect.height / 2;
            int gCenterY = this.getLocationOnScreen().y + this.getHeight() / 2;
            if (yRatio == 0) {
                yRatio = 1;
            }
            int yOffset = (gCenterY - pCenterY) / yRatio;
            int y1 = this.pointingRect.height / 2 + yOffset;
            y1 = Math.min(y1, this.pointingRect.height);
            y1 = Math.max(y1, 0);
            y += y1;
        }
        return new Point(x, y);
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (this.pointingLayer != null) {
            if (this.pointingLayer.getParent() != null) {
                JComponent pointParent = (JComponent)this.pointingLayer.getParent();
                pointParent.removeComponentListener(this.sizeListener);
                pointParent.remove(this.pointingLayer);
                pointParent.repaint();
            }
            this.pointingLayer = null;
        }
        if (this.pointingComp != null) {
            this.pointingComp.removeComponentListener(this.pointingCompListener);
            this.pointingComp.removeAncestorListener(this.pointingCompListener);
        }
        this.pointingComp = null;
    }

    @Override
    public void show(JLayeredPane layeredPane, boolean positionInLayer, boolean fadeIn) {
        if (this.pointingRect != null) {
            this.pointingLayer = new PointingLayer();
            this.pointingLayer.setLocation(0, 0);
            this.pointingLayer.setPreferredSize(layeredPane.getSize());
            this.pointingLayer.setSize(layeredPane.getSize());
            layeredPane.add((Component)this.pointingLayer, (Object)(JLayeredPane.POPUP_LAYER - 5));
            layeredPane.addComponentListener(this.sizeListener);
        }
        this.positionPanel(layeredPane, positionInLayer);
        this.makeVisible(fadeIn);
    }

    @Override
    public void show(boolean positionInLayer, boolean fadeIn) {
        JLayeredPane lp = GhostPointingPalette.getActiveLayeredPane();
        if (lp == null) {
            return;
        }
        this.show(lp, positionInLayer, fadeIn);
    }

    @Override
    public void repaintVisible() {
        if (this.pointingLayer == null) {
            return;
        }
        Rectangle r = this.pointingLayer.createShape(true).getBounds();
        r.grow(12, 12);
        this.pointingLayer.repaint(r);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this._updateBorder();
    }

    @Override
    public void setCloseVisible(boolean visible) {
        super.setCloseVisible(visible);
        this._updateBorder();
    }

    private static Border _sGetTitleBorder() {
        if (_sTitleBorder == null) {
            _sTitleBorder = BorderFactory.createEmptyBorder(INSET + 22, INSET, INSET - 1, INSET);
        }
        return _sTitleBorder;
    }

    private static Border _sGetEmptyTitleBorder() {
        if (_sEmptyTitleBorder == null) {
            _sEmptyTitleBorder = BorderFactory.createEmptyBorder(INSET, INSET, INSET - 1, INSET);
        }
        return _sEmptyTitleBorder;
    }

    private void _updateBorder() {
        if (this.pointingComp == null) {
            this.setBorder(new GhostBorder());
        } else if (this.getTitle() != null || this.isCloseVisible()) {
            this.setBorder(GhostPointingPalette._sGetTitleBorder());
        } else {
            this.setBorder(GhostPointingPalette._sGetEmptyTitleBorder());
        }
    }

    private class PointingCompListener
    extends ComponentAdapter
    implements AncestorListener {
        private PointingCompListener() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (!GhostPointingPalette.this.isMovable()) {
                GhostPointingPalette.this.fadeInOut(false);
            }
            GhostPointingPalette.this.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            GhostPointingPalette.this.dispose();
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            GhostPointingPalette.this.dispose();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            GhostPointingPalette.this.repaint();
        }
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent ce) {
            if (GhostPointingPalette.this.pointingLayer != null) {
                GhostPointingPalette.this.pointingLayer.setSize(GhostPointingPalette.this.pointingLayer.getParent().getSize());
            }
        }
    }

    private class PointingLayer
    extends JComponent {
        private SoftReference<BufferedImage> imgRef1;
        private SoftReference<BufferedImage> imgRef2;

        private PointingLayer() {
        }

        private Object[] getImage(SoftReference<BufferedImage> imgRef, int w, int h) {
            BufferedImage img = null;
            if (imgRef != null) {
                img = imgRef.get();
            }
            Object[] ret = new Object[2];
            if (img == null || img.getWidth() != w || img.getHeight() != h) {
                img = new BufferedImage(w, h, 2);
                imgRef = new SoftReference<BufferedImage>(img);
            } else {
                Graphics2D g2D = img.createGraphics();
                g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, w, h);
                g2D.fill(rect);
            }
            ret[0] = img;
            ret[1] = imgRef;
            Graphics2D g2 = img.createGraphics();
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, w, h);
            g2.setComposite(AlphaComposite.Src);
            return ret;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Shape shape = this.createShape(true);
            if (shape == null) {
                return;
            }
            Rectangle shapeR = shape.getBounds();
            Object[] ret = this.getImage(this.imgRef1, shapeR.width + 12, shapeR.height + 12);
            BufferedImage shapeImage = (BufferedImage)ret[0];
            this.imgRef1 = (SoftReference)ret[1];
            Graphics2D shapeG = shapeImage.createGraphics();
            shapeG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintBoundingBox(g2);
            this.paintShadow(g2, shape, shapeR, shapeImage, shapeG);
            shape = this.createShape(false);
            shapeG.translate(-shapeR.x, -shapeR.y);
            this.paintBackground(shapeG, shape);
            this.paintBoundary(shapeG, shape);
            this.paintClearAreas(shapeG);
            shapeG.translate(shapeR.x, shapeR.y);
            g2.setComposite(AlphaComposite.getInstance(3, 0.93f * GhostPointingPalette.this.fadeAmount));
            g2.drawImage(shapeImage, null, shapeR.x, shapeR.y);
            shapeG.dispose();
            g2.dispose();
        }

        private void paintBoundary(Graphics2D g2, Shape shape) {
            g2.setColor(UIConstants.getColor("ghost.panel.border", GhostPointingPalette.this.look));
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            g2.draw(shape);
        }

        private void paintClearAreas(Graphics2D shapeG) {
            shapeG.setComposite(AlphaComposite.Clear);
            for (JComponent comp : GhostPointingPalette.this.getTransparentComponents()) {
                Rectangle thatR = comp.getBounds();
                Rectangle thisR = SwingUtilities.convertRectangle(comp.getParent(), thatR, this);
                shapeG.fill(thisR);
            }
        }

        private void paintBoundingBox(Graphics2D g2) {
            if (GhostPointingPalette.this.pointingRect != null && GhostPointingPalette.this.showRect) {
                Stroke s = g2.getStroke();
                g2.setStroke(new BasicStroke(2.0f, 1, 1));
                g2.setColor(UIConstants.getColor("ghost.panel.border", GhostPointingPalette.this.look));
                g2.draw(SwingUtilities.convertRectangle(GhostPointingPalette.this.pointingComp, GhostPointingPalette.this.pointingRect, this));
                g2.setStroke(s);
            }
        }

        private void paintBackground(Graphics2D shapeG, Shape shape) {
            shapeG.setColor(UIConstants.getColor("ghost.panel.background", GhostPointingPalette.this.look));
            shapeG.fill(shape);
        }

        private void paintShadow(Graphics2D g2, Shape shape, Rectangle shapeR, BufferedImage shapeImage, Graphics2D shapeG) {
            shapeG.setColor(new Color(0, 0, 0));
            shapeG.translate(-shapeR.x + 6, -shapeR.y + 6);
            shapeG.fill(shape);
            shapeG.translate(shapeR.x - 6, shapeR.y - 6);
            float i = 0.04f;
            float[] elements = new float[]{i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i};
            Kernel myKernel = new Kernel(5, 5, elements);
            ConvolveOp simpleBlur = new ConvolveOp(myKernel);
            Object[] ret = this.getImage(this.imgRef2, shapeImage.getWidth(), shapeImage.getHeight());
            BufferedImage img2 = (BufferedImage)ret[0];
            this.imgRef2 = (SoftReference)ret[1];
            Graphics2D img2g = img2.createGraphics();
            img2g.setComposite(AlphaComposite.getInstance(3, 0.93f * GhostPointingPalette.this.fadeAmount * 0.2f));
            img2g.drawImage(shapeImage, simpleBlur, 0, 0);
            img2g.setComposite(AlphaComposite.Clear);
            img2g.translate(-shapeR.x, -shapeR.y);
            img2g.fill(this.createShape(false));
            img2g.dispose();
            g2.drawImage(img2, null, shapeR.x, shapeR.y);
            shapeG.setComposite(AlphaComposite.Clear);
            shapeG.fillRect(0, 0, shapeImage.getWidth(), shapeImage.getHeight());
            shapeG.setComposite(AlphaComposite.Src);
        }

        private Shape createShape(boolean isShadow) {
            int width = GhostPointingPalette.this.getWidth() + INSET + INSET;
            int height = GhostPointingPalette.this.getHeight() + INSET + INSET;
            int x = GhostPointingPalette.this.getX() - INSET;
            int y = GhostPointingPalette.this.getY() - INSET;
            int x0 = x + INSET;
            int x1 = x + width - INSET;
            int y0 = y + INSET;
            int y1 = y + height - INSET;
            Point pointingPoint = GhostPointingPalette.this.getClosestPoint();
            if (pointingPoint == null) {
                return null;
            }
            Point layerPoint = SwingUtilities.convertPoint(GhostPointingPalette.this.pointingComp, pointingPoint, this);
            Rectangle vRect = GhostPointingPalette.this.pointingComp.getVisibleRect();
            vRect.grow(4, 4);
            boolean isPointVisible = vRect.contains(pointingPoint);
            int xOffset = layerPoint.y < y0 && y0 - layerPoint.y < GhostPointingPalette.this.pointWidth * 2 || layerPoint.y > y1 && layerPoint.y - y1 < GhostPointingPalette.this.pointWidth * 2 ? layerPoint.x : (x0 + width / 2) / 3 + 2 * layerPoint.x / 3;
            int pointLeft = xOffset - GhostPointingPalette.this.pointWidth / 2;
            pointLeft = Math.max(x0 + ROUNDEDNESS, pointLeft);
            pointLeft = Math.min(pointLeft, x1 - ROUNDEDNESS - GhostPointingPalette.this.pointWidth);
            int pointRight = pointLeft + GhostPointingPalette.this.pointWidth;
            int yOffset = layerPoint.x < x0 && x0 - layerPoint.x < GhostPointingPalette.this.pointWidth * 2 || layerPoint.x > x1 && layerPoint.x - x1 < GhostPointingPalette.this.pointWidth * 2 ? layerPoint.y : (y0 + height / 2) / 3 + 2 * layerPoint.y / 3;
            int pointTop = yOffset - GhostPointingPalette.this.pointWidth / 2;
            pointTop = Math.max(y0 + ROUNDEDNESS, pointTop);
            pointTop = Math.min(pointTop, y1 - ROUNDEDNESS - GhostPointingPalette.this.pointWidth);
            int pointfooter = pointTop + GhostPointingPalette.this.pointWidth;
            GeneralPath gp = new GeneralPath();
            gp.moveTo(x0 + ROUNDEDNESS, y0);
            if (isPointVisible && layerPoint.y < y0 && x0 - layerPoint.x <= y0 - layerPoint.y && layerPoint.x - x1 <= y0 - layerPoint.y) {
                gp.lineTo(pointLeft, y0);
                if (!isShadow) {
                    gp.lineTo(layerPoint.x, layerPoint.y);
                } else {
                    gp.lineTo(layerPoint.x - 6, layerPoint.y - 6);
                }
                gp.lineTo(pointRight, y0);
            }
            gp.lineTo(x1 - ROUNDEDNESS, y0);
            gp.quadTo(x1, y0, x1, y0 + ROUNDEDNESS);
            if (isPointVisible && layerPoint.x > x1 && layerPoint.x - x1 > y0 - layerPoint.y && layerPoint.x - x1 > layerPoint.y - y1) {
                gp.lineTo(x1, pointTop);
                if (!isShadow) {
                    gp.lineTo(layerPoint.x, layerPoint.y);
                } else {
                    gp.lineTo(layerPoint.x - 6, layerPoint.y - 6);
                }
                gp.lineTo(x1, pointfooter);
            }
            gp.lineTo(x1, y1 - ROUNDEDNESS);
            gp.quadTo(x1, y1, x1 - ROUNDEDNESS, y1);
            if (isPointVisible && layerPoint.y > y1 && x0 - layerPoint.x <= layerPoint.y - y1 && layerPoint.x - x1 <= layerPoint.y - y1) {
                gp.lineTo(pointRight, y1);
                if (!isShadow) {
                    gp.lineTo(layerPoint.x, layerPoint.y);
                } else {
                    gp.lineTo(layerPoint.x - 6, layerPoint.y - 6);
                }
                gp.lineTo(pointLeft, y1);
            }
            gp.lineTo(x0 + ROUNDEDNESS, y1);
            gp.quadTo(x0, y1, x0, y1 - ROUNDEDNESS);
            if (isPointVisible && layerPoint.x < x0 && x0 - layerPoint.x > y0 - layerPoint.y && x0 - layerPoint.x > layerPoint.y - y1) {
                gp.lineTo(x0, pointfooter);
                if (!isShadow) {
                    gp.lineTo(layerPoint.x, layerPoint.y);
                } else {
                    gp.lineTo(layerPoint.x - 6, layerPoint.y - 6);
                }
                gp.lineTo(x0, pointTop);
            }
            gp.lineTo(x0, y0 + ROUNDEDNESS);
            gp.quadTo(x0, y0, x0 + ROUNDEDNESS, y0);
            return gp;
        }
    }
}

