/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.builders.BuiltToolBar;
import oracle.javatools.ui.builders.ExAppBasicPanel;
import oracle.javatools.ui.builders.ToolBarBuilder;
import oracle.javatools.ui.search.SearchField;

final class ExAppToolBarPanel
extends ExAppBasicPanel {
    private static BuiltToolBar tc;

    ExAppToolBarPanel() {
        this.selectTextArea.setEnabled(false);
    }

    @Override
    protected JComponent createControlPanel() {
        JPanel controlPanel = new JPanel((LayoutManager)new MigLayout("aligny top, ins 5 5 5 16, gapy 2"));
        JButton buildButton = new JButton("Build");
        buildButton.setFont(buildButton.getFont().deriveFont(1));
        buildButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExAppToolBarPanel.this.build();
            }
        });
        controlPanel.add((Component)new JLabel("Select your configuration, then press:"), "gapbottom 16, span, split");
        controlPanel.add((Component)buildButton, "wrap");
        controlPanel.add((Component)Actions.cb, "");
        controlPanel.add((Component)Actions.lcb, "gapleft 10, span, wrap");
        controlPanel.add((Component)Separator.cb, "");
        controlPanel.add((Component)Separator.lcb, "gapleft 10, span, wrap");
        controlPanel.add((Component)Components.cb, "");
        controlPanel.add((Component)Components.lcb, "gapleft 10, span, wrap");
        controlPanel.add((Component)DropActions.cb, "");
        controlPanel.add((Component)DropActions.tf, "");
        controlPanel.add((Component)DropActions.lcb, "gapleft 10, span, wrap");
        controlPanel.add((Component)IconDropActions.cb, "");
        controlPanel.add((Component)IconDropActions.lcb, "gapleft 10, span, wrap");
        controlPanel.add((Component)ActionsSecondary.cb, "span, wrap");
        controlPanel.add((Component)new JLabel("Search:"), "split, span");
        controlPanel.add((Component)Search.cb, "");
        controlPanel.add((Component)Search.tf, "wrap");
        return controlPanel;
    }

    private void build() {
        ToolBarBuilder builder = new ToolBarBuilder();
        StringBuilder createSB = new StringBuilder("");
        StringBuilder selectSB = new StringBuilder("");
        createSB.append("ToolBarBuilder builder = new ToolBarBuilder();\n");
        Actions.build(builder, createSB);
        ActionsSecondary.build(builder, createSB);
        Separator.build(builder, createSB);
        Components.build(builder, createSB);
        Search.build(builder, createSB);
        DropActions.build(builder, createSB);
        IconDropActions.build(builder, createSB);
        createSB.append("\nBuiltToolBar builtToolBar = builder.build();\n\nadd(builtToolBar.getGUI());");
        this.constructTextArea.setText(createSB.toString());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)builder.build().getGUI(), "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setOpaque(true);
        centerPanel.setBackground(Color.WHITE);
        centerPanel.setPreferredSize(new Dimension(400, 40));
        panel.add(centerPanel);
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        ResizeComponent rc = new ResizeComponent(panel);
        this.updateComponent(rc);
    }

    @Override
    protected void dump() {
    }

    private static class Actions {
        static JCheckBox cb = new JCheckBox("Actions");
        static JCheckBox lcb = new JCheckBox("Left Aligned");

        private Actions() {
        }

        public static void build(ToolBarBuilder builder, StringBuilder createSB) {
            if (!cb.isSelected()) {
                return;
            }
            AbstractAction action1 = new AbstractAction(null, OracleIcons.getIcon((String)"database.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Database Action!");
                }
            };
            AbstractAction action2 = new AbstractAction(null, OracleIcons.getIcon((String)"garbg.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Garbage Action!");
                }
            };
            builder.addActions(lcb.isSelected(), action1, action2);
            createSB.append("builder.addActions(" + lcb.isSelected() + ", action1, action2);\n");
        }

        static {
            cb.setToolTipText("Add 'javax.swing.Action's.");
        }
    }

    private static class Separator {
        static JCheckBox cb = new JCheckBox("Separator");
        static JCheckBox lcb = new JCheckBox("Left Aligned");

        private Separator() {
        }

        public static void build(ToolBarBuilder builder, StringBuilder createSB) {
            if (!cb.isSelected()) {
                return;
            }
            builder.addSeparator(lcb.isSelected());
            createSB.append("builder.addSeparator(" + lcb.isSelected() + ");\n");
        }

        static {
            cb.setToolTipText("Add a separator - generally items are added left to right on the toolbar in the order presented to the builder");
        }
    }

    private static class Components {
        static JCheckBox cb = new JCheckBox("Components");
        static JCheckBox lcb = new JCheckBox("Left Aligned");

        private Components() {
        }

        public static void build(ToolBarBuilder builder, StringBuilder createSB) {
            if (!cb.isSelected()) {
                return;
            }
            JComboBox<Object> cb = new JComboBox<Object>(new Object[]{"100%", "75%", "50%", "25%"});
            builder.addComponents(lcb.isSelected(), cb);
            createSB.append("builder.addComponents(" + lcb.isSelected() + ", aComponent);\n");
        }

        static {
            cb.setToolTipText("Add one or more 'javax.swing.JComponents's.");
        }
    }

    private static class DropActions {
        static JCheckBox cb = new JCheckBox("Drop Actions (Text)");
        static JCheckBox lcb = new JCheckBox("Left Aligned");
        static JTextField tf = new JTextField("&Fruit", 8);

        private DropActions() {
        }

        public static void build(ToolBarBuilder builder, StringBuilder createSB) {
            if (!cb.isSelected()) {
                return;
            }
            AbstractAction action1 = new AbstractAction("Apples"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Apples");
                }
            };
            AbstractAction action2 = new AbstractAction("Pears"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Pears");
                }
            };
            builder.addDropActions(lcb.isSelected(), tf.getText(), action1, action2);
            createSB.append("builder.addDropActions(" + lcb.isSelected() + ", \"" + tf.getText() + "\", action1, action2);\n");
        }

        static {
            cb.setToolTipText("Add a drop list of 'javax.swing.Action's.");
        }
    }

    private static class IconDropActions {
        static JCheckBox cb = new JCheckBox("Drop Actions (Icon)");
        static JCheckBox lcb = new JCheckBox("Left Aligned");

        private IconDropActions() {
        }

        public static void build(ToolBarBuilder builder, StringBuilder createSB) {
            if (!cb.isSelected()) {
                return;
            }
            AbstractAction action1 = new AbstractAction("Action 1"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Action 1");
                }
            };
            AbstractAction action2 = new AbstractAction("Action 2"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Action 2");
                }
            };
            builder.addDropActions(lcb.isSelected(), OracleIcons.getIcon((String)"bullist.png"), "ToolTip", action1, action2);
            createSB.append("builder.addDropActions(" + lcb.isSelected() + ", icon, \"ToolTip\", action1, action2);\n");
        }

        static {
            cb.setToolTipText("Add a drop list of 'javax.swing.Action's, with an icon label");
        }
    }

    private static class ActionsSecondary {
        static JCheckBox cb = new JCheckBox("Secondary Actions");

        private ActionsSecondary() {
        }

        public static void build(ToolBarBuilder builder, StringBuilder createSB) {
            if (!cb.isSelected()) {
                return;
            }
            AbstractAction action1 = new AbstractAction("Import"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Import");
                }
            };
            AbstractAction action2 = new AbstractAction("Export"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Export");
                }
            };
            builder.setActionsSecondary(action1, action2);
            createSB.append("builder.setActionsSecondary(firstAction, secondAction);\n");
        }

        static {
            cb.setToolTipText("Add 'javax.swing.Action's.");
        }
    }

    private static class Search {
        static JComboBox cb = new JComboBox<Object>(new Object[]{"None", "Filter", "Search", "Find"});
        static JTextField tf = new JTextField("Prompt", 8);

        private Search() {
        }

        public static void build(ToolBarBuilder builder, StringBuilder createSB) {
            switch (cb.getSelectedIndex()) {
                case 0: {
                    return;
                }
                case 1: {
                    builder.setSearch(SearchField.Style.FILTER, tf.getText());
                    createSB.append("builder.setSearch(SearchField.Style.FILTER, \"" + tf.getText() + "\");\n");
                    break;
                }
                case 2: {
                    builder.setSearch(SearchField.Style.SEARCH, tf.getText());
                    createSB.append("builder.setSearch(SearchField.Style.SEARCH, \"" + tf.getText() + "\");\n");
                    break;
                }
                case 3: {
                    builder.setSearch(SearchField.Style.FIND, tf.getText());
                    createSB.append("builder.setSearch(SearchField.Style.FIND, \"" + tf.getText() + "\");\n");
                }
            }
        }

        static {
            cb.setToolTipText("Add a search area to the toolbar");
        }
    }
}

