/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.TextLayer;
import oracle.javatools.ui.builders.BasicBuilder;
import oracle.javatools.util.CollectionEvent;
import oracle.javatools.util.CollectionListener;
import oracle.javatools.util.ListenableCollection;

abstract class ExAppBasicPanel {
    protected JPanel testPanel = new JPanel();
    protected JTextArea constructTextArea = new JTextArea();
    protected final JTextArea selectTextArea = new JTextArea();
    protected Label label = new Label();
    protected Resize resize = new Resize();
    protected Actions actions = new Actions();
    protected Checkable checkable = new Checkable();
    protected DoubleClick doubleclick = new DoubleClick();
    protected EmptyText emptytext = new EmptyText();
    protected MoreActions moreactions = new MoreActions();
    protected Rollover rollover = new Rollover();
    protected SelectionEnabled selectionenabled = new SelectionEnabled();
    protected Titlebar titlebar = new Titlebar();
    protected static final String CODE_INDENT = "    ";

    ExAppBasicPanel() {
    }

    protected abstract JComponent createControlPanel();

    protected abstract void dump();

    protected void updateComponent(JComponent builtComponent) {
        this.testPanel.removeAll();
        this.testPanel.add(builtComponent);
        this.testPanel.getParent().validate();
        this.testPanel.repaint();
    }

    JComponent createContent() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("fill, ins 5 10 5 5"));
        this.constructTextArea.setEditable(false);
        this.constructTextArea.setFont(new Font("Monospaced", 0, 11));
        this.selectTextArea.setEditable(false);
        this.selectTextArea.setFont(new Font("Monospaced", 0, 11));
        JButton dumpButton = new JButton("Dump");
        dumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExAppBasicPanel.this.dump();
            }
        });
        p.add((Component)this.createControlPanel(), "dock west");
        p.add((Component)new JSeparator(1), "dock west");
        p.add((Component)this.testPanel, "grow, wrap");
        p.add((Component)ExAppBasicPanel.headingLabel("Creation Code"), "gap 4 0 0 0, growy 0, wrap");
        p.add((Component)new JScrollPane(this.constructTextArea), "gap 4 4 0 4, growx, growy 120, bottom, wrap");
        p.add((Component)ExAppBasicPanel.headingLabel("Select Code"), "gap 4 0 0 0, growy 0, wrap");
        p.add((Component)new JScrollPane(this.selectTextArea), "gap 4 4 0 4, growx, h 40, growy 0, bottom, wrap");
        p.add((Component)new JLabel("Dump Model to Console:"), "split, gap 4 4 4 2, growy 0");
        p.add((Component)dumpButton, "growy 0, wrap, gap bottom 4");
        this.createExampleTestComponent();
        return p;
    }

    private void createExampleTestComponent() {
        JPanel p = new JPanel(){
            private Stroke s = new BasicStroke(4.0f, 1, 1, 0.0f, new float[]{10.0f, 10.0f}, 0.0f);

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(new Color(100, 100, 100, 100));
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(this.s);
                int b = 5;
                g2.drawRoundRect(b, b, this.getWidth() - b - b, this.getHeight() - b - b, 10, 10);
            }
        };
        p.setPreferredSize(new Dimension(165, 200));
        JLayer<2> l = new JLayer<2>(p, new TextLayer("Built Component Will Appear Here", TextLayer.LARGE_FONT));
        this.testPanel.add(l);
    }

    protected static JLabel headingLabel(String string) {
        JLabel label = new JLabel(string);
        label.setFont(label.getFont().deriveFont(1, (float)label.getFont().getSize() + 0.5f));
        return label;
    }

    protected class Label {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Label", this.def);
        JTextField tf = new JTextField("&Label:", 12);

        protected Label() {
            this.cb.setToolTipText("Add label for this component, set the text including a '&' for the Mnemonic");
        }

        void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setLabel(this.tf.getText());
                createSB.append("builder.setLabel(\"" + this.tf.getText() + "\");\n");
            }
        }
    }

    protected class Resize {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Resize", this.def);

        protected Resize() {
            this.cb.setToolTipText("Make the component resizable by the user - a grip area will appear in the bottom right of the built component");
        }

        void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setResizable(this.cb.isSelected());
                createSB.append("builder.setResizable(" + Boolean.toString(this.cb.isSelected()) + ");\n");
            }
        }
    }

    protected class Actions {
        JCheckBox cb = new JCheckBox("Custom Toolbar Actions");

        protected Actions() {
            this.cb.setToolTipText("Provide custom actions to be placed on the toolbar.");
        }

        public void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (!this.cb.isSelected()) {
                return;
            }
            AbstractAction action1 = new AbstractAction(null, OracleIcons.getIcon((String)"database.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Database Action!");
                }
            };
            AbstractAction action2 = new AbstractAction(null, OracleIcons.getIcon((String)"garbg.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Garbage Action!");
                }
            };
            builder.setActions(action1, action2);
            createSB.append("builder.setActions(databaseAction, trashAction);\n");
        }
    }

    protected class Checkable {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Checkable", this.def);
        JButton b1 = new JButton("API: Add an Item");
        JButton b2 = new JButton("API: Remove an Item");
        ListenableCollection checkedItems;

        protected Checkable() {
            this.cb.setToolTipText("Add a checkbox for each item, track and set what's checked via passed in collection");
            this.b1.setToolTipText("Modify the collection of checked items via an API");
            this.b2.setToolTipText("Modify the collection of checked items via an API");
            this.b1.setEnabled(false);
            this.b2.setEnabled(false);
            this.b2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Iterator i = Checkable.this.checkedItems.iterator();
                    if (i.hasNext()) {
                        Checkable.this.checkedItems.remove(i.next());
                    }
                }
            });
        }

        void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                this.checkedItems = builder.setCheckable(Collections.emptyList());
                this.checkedItems.addListener(new CollectionListener(){

                    public void collectionChanged(CollectionEvent event) {
                        for (Object o : Checkable.this.checkedItems) {
                            System.out.print(o + " ");
                        }
                        System.out.println();
                    }
                });
                createSB.append("Collection currentSelection = builder.setCheckable(initialSelection);\n");
            }
            this.b1.setEnabled(true);
            this.b2.setEnabled(true);
        }
    }

    protected class DoubleClick {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Double-Click", this.def);

        protected DoubleClick() {
            this.cb.setToolTipText("Pass an ActionListener that will get called when the user double clicks on an item");
        }

        void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setDoubleClickListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Double Click! ");
                    }
                });
                createSB.append("builder.setDoubleClickListener(doubleClickActionListener);\n");
            }
        }
    }

    protected class EmptyText {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Empty Text: ", this.def);
        JCheckBox lcb = new JCheckBox("Large");
        JTextField tf = new JTextField("No Items", 16);

        protected EmptyText() {
            this.cb.setToolTipText("Set the text to appear when no items are present");
            this.lcb.setToolTipText("Make the empty text larger so it is suitable for larger components");
        }

        void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                if (this.lcb.isSelected()) {
                    builder.setEmptyTextLarge(this.tf.getText());
                    createSB.append("builder.setEmptyTextLarge(\"" + this.tf.getText() + "\");\n");
                } else {
                    builder.setEmptyText(this.tf.getText());
                    createSB.append("builder.setEmptyText(\"" + this.tf.getText() + "\");\n");
                }
            }
        }
    }

    protected class MoreActions {
        JCheckBox cb = new JCheckBox("Secondary Toolbar Actions:");
        JTextField tf = new JTextField("&Actions", 12);

        protected MoreActions() {
            this.cb.setToolTipText("Add secondary items, these will appear in a drop down on the toolbar");
        }

        public void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (!this.cb.isSelected()) {
                return;
            }
            AbstractAction action1 = new AbstractAction("Action 1"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Action 1!");
                }
            };
            AbstractAction action2 = new AbstractAction("Action 2"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Action 2!");
                }
            };
            builder.setActionsSecondary(this.tf.getText(), action1, action2);
            createSB.append("builder.setActionsSecondary(\"" + this.tf.getText() + "\", firstAction, secondAction);\n");
        }
    }

    protected class Rollover {
        boolean def = true;
        JCheckBox cb = new JCheckBox("Rollover", this.def);

        protected Rollover() {
            this.cb.setToolTipText("Show rollover highlighting as the mouse moves over the items");
        }

        void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            builder.setRollover(this.cb.isSelected());
            if (this.cb.isSelected() != this.def) {
                createSB.append("builder.setRollover(" + Boolean.toString(this.cb.isSelected()) + ");\n");
            }
        }
    }

    protected class SelectionEnabled {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Selection Enabled", this.def);
        JButton b = new JButton("Example");

        protected SelectionEnabled() {
            this.cb.setToolTipText("Pass in a component, like a button, so it will be enabled or disabled as selection changes");
            this.b.setToolTipText("An example button - select and deselect something in the component to see this automatically enable");
        }

        void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setSelectionEnabledComponent(this.b);
                createSB.append("builder.setSelectionEnabledComponent(aComponent);\n");
            }
        }
    }

    protected class Titlebar {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Titlebar", this.def);

        protected Titlebar() {
            this.cb.setToolTipText("Add a titlebar area to this component");
        }

        void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setTitlebar(this.cb.isSelected());
                createSB.append("builder.setTitlebar(" + Boolean.toString(this.cb.isSelected()) + ");\n");
            }
        }
    }
}

