/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public final class Components {
    private Components() {
    }

    public static JLayeredPane findLayeredPane(Component target) {
        Window ancestor = SwingUtilities.getWindowAncestor(target);
        return ancestor instanceof JFrame || ancestor instanceof JDialog ? ((RootPaneContainer)((Object)ancestor)).getLayeredPane() : null;
    }

    public static void setCaretPositionCenter(JTextComponent c, int position) {
        Document document = c.getDocument();
        if (document != null) {
            position = Math.min(position, document.getLength());
            position = Math.max(position, 0);
            Components.ensureVisibleAndCentered(c, position);
            c.setCaretPosition(position);
        }
    }

    public static void moveCaretPositionCenter(JTextComponent c, int position) {
        Document document = c.getDocument();
        if (document != null) {
            position = Math.min(position, document.getLength());
            position = Math.max(position, 0);
            Components.ensureVisibleAndCentered(c, position);
            c.moveCaretPosition(position);
            c.getCaret().setSelectionVisible(true);
        }
    }

    private static void ensureVisibleAndCentered(final JTextComponent c, final int location) {
        boolean shouldForce = false;
        try {
            if (!c.isVisible()) {
                shouldForce = true;
            } else {
                Rectangle positionRect = c.modelToView(location);
                if (positionRect == null) {
                    shouldForce = true;
                }
            }
        }
        catch (BadLocationException e) {
            return;
        }
        final boolean passForce = shouldForce;
        Runnable centerTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Rectangle positionRect = c.modelToView(location);
                    Components.ensureVisibleAndCentered(c, positionRect, passForce);
                }
                catch (BadLocationException e) {
                    return;
                }
            }
        };
        SwingUtilities.invokeLater(centerTask);
    }

    private static void ensureVisibleAndCentered(JComponent c, Rectangle positionRect, boolean force) {
        if (positionRect == null) {
            return;
        }
        Rectangle visibleRect = new Rectangle();
        c.computeVisibleRect(visibleRect);
        boolean doScroll = false;
        int visibleYstart = visibleRect.y;
        int visibleYend = visibleYstart + visibleRect.height;
        int positionYstart = positionRect.y;
        int positionYend = positionYstart + positionRect.height;
        if (force || positionYstart < visibleYstart || positionYend > visibleYend) {
            doScroll = true;
            visibleRect.y = positionYstart - (visibleRect.height - positionRect.height >> 1);
            visibleRect.y = Math.max(0, visibleRect.y);
            int editorHeight = c.getHeight();
            if (visibleRect.y + visibleRect.height > editorHeight) {
                visibleRect.y = editorHeight - visibleRect.height;
            }
        }
        int visibleXstart = visibleRect.x;
        int visibleXend = visibleXstart + visibleRect.width;
        int positionXstart = positionRect.x;
        int positionXend = positionXstart + positionRect.width;
        if (positionXstart < visibleXstart || positionXend > visibleXend) {
            doScroll = true;
            visibleRect.x = positionXstart - (visibleRect.width - positionRect.width >> 1);
            visibleRect.x = Math.max(0, visibleRect.x);
            int editorWidth = c.getWidth();
            if (visibleRect.x + visibleRect.width > editorWidth) {
                visibleRect.x = editorWidth - visibleRect.width;
            }
        }
        if (doScroll) {
            c.scrollRectToVisible(visibleRect);
        }
    }
}

