/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.StoreListener;
import oracle.jdeveloper.db.StoreProvider;
import oracle.jdevimpl.db.StoreContext;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;
import oracle.jdevimpl.db.resource.ConnBundle;

public final class DatabaseConnectionStores {
    public static final String CENTRAL_STORE = "IdeConnections";
    private static DatabaseConnectionStores s_instance;
    private final List<StoreProvider> m_providers = new ArrayList<StoreProvider>();
    private boolean m_providersInit;
    private final Collection<StoreListener> m_listeners = new HashSet<StoreListener>();
    private boolean m_listenersInit;

    public static final DatabaseConnectionStores getInstance() {
        if (s_instance == null) {
            s_instance = new DatabaseConnectionStores();
        }
        return s_instance;
    }

    private DatabaseConnectionStores() {
    }

    private synchronized Collection<StoreListener> getListeners() {
        if (!this.m_listenersInit) {
            this.m_listenersInit = true;
            DatabaseConnectionHook databaseConnectionHook = DatabaseConnectionHook.getHook();
            if (databaseConnectionHook != null) {
                for (StoreListener storeListener : databaseConnectionHook.getStoreListeners()) {
                    this.addStoreListener(storeListener);
                }
            }
        }
        return Collections.unmodifiableCollection(new HashSet<StoreListener>(this.m_listeners));
    }

    private synchronized List<StoreProvider> getProviders() {
        if (!this.m_providersInit) {
            this.m_providersInit = true;
            this.registerStoreProviderImpl(new CentralStoreProvider());
            DatabaseConnectionHook databaseConnectionHook = DatabaseConnectionHook.getHook();
            if (databaseConnectionHook != null) {
                for (StoreProvider storeProvider : databaseConnectionHook.getStoreProviders()) {
                    this.registerStoreProviderImpl(storeProvider);
                }
            }
        }
        return this.m_providers;
    }

    void fireStoreAdded(String string) {
        for (StoreListener storeListener : this.getListeners()) {
            try {
                storeListener.storeAdded(string);
            }
            catch (Exception exception) {
                this.getLogger().log(Level.WARNING, "DatabaseConnectionStores listener error", exception);
            }
        }
        this.printStores();
    }

    void fireStoreRemoved(String string, DatabaseConnections databaseConnections) {
        for (StoreListener storeListener : this.getListeners()) {
            try {
                storeListener.storeRemoved(string);
            }
            catch (Exception exception) {
                this.getLogger().log(Level.WARNING, "DatabaseConnectionStores listener error", exception);
            }
        }
        if (databaseConnections != null) {
            databaseConnections.closeStore();
        }
        this.printStores();
    }

    public void addStoreListener(StoreListener storeListener) {
        this.m_listeners.add(storeListener);
    }

    public void removeStoreListener(StoreListener storeListener) {
        this.m_listeners.remove(storeListener);
    }

    public Collection<String> listStores() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoreProvider storeProvider : this.getProviders()) {
            arrayList.addAll(storeProvider.listStores());
        }
        return arrayList;
    }

    public Collection<String> listStores(Context context) {
        if (context == null) {
            return this.listStores();
        }
        return StoreContext.getContext().listStores(context);
    }

    public DatabaseConnections getCurrentStore() {
        if (Ide.isRunning()) {
            return this.getCurrentStore(Context.newIdeContext());
        }
        return DatabaseConnections.getInstance();
    }

    public DatabaseConnections getCurrentStore(Context context) {
        String string = this.getCurrentStoreName(context);
        return this.getStore(string);
    }

    public String getCurrentStoreName(Context context) {
        Collection<String> collection;
        String string = null;
        if (context != null) {
            for (StoreProvider storeProvider : this.getProviders()) {
                String string2 = storeProvider.getCurrentStore(context);
                if (!ModelUtil.hasLength((String)string2)) continue;
                string = string2;
                break;
            }
            if (string == null) {
                collection = context.getElement();
                string = DBObjectNodeUtil.getStoreName((Object)collection);
            }
        }
        if (string == null) {
            if (StoreContext.getContext().isCentralStoreAvailable()) {
                string = CENTRAL_STORE;
            } else {
                collection = this.listStores();
                if (collection.size() == 1) {
                    string = (String)collection.iterator().next();
                }
            }
        }
        return string;
    }

    public String getCurrentConnection(Context context) {
        ConnectionInfo connectionInfo = this.getCurrentConnectionInfo(context);
        return connectionInfo == null ? null : connectionInfo.getConnectionName();
    }

    public ConnectionInfo getCurrentConnectionInfo(Context context) {
        ConnectionInfo connectionInfo = null;
        if (context != null) {
            String string = this.getCurrentStoreName(context);
            StoreProvider storeProvider = this.findProvider(string);
            String string2 = null;
            string2 = storeProvider == null ? DBObjectNodeUtil.getConnectionName((Object)context.getElement()) : storeProvider.getCurrentConnection(context);
            connectionInfo = new ConnectionInfo(string, string2);
        }
        return connectionInfo != null && connectionInfo.isValid() ? connectionInfo : null;
    }

    public Database getCurrentDatabase(Context context) {
        Database database = null;
        ConnectionInfo connectionInfo = this.getCurrentConnectionInfo(context);
        if (connectionInfo.isValid()) {
            try {
                database = connectionInfo.getDatabase();
            }
            catch (DBException dBException) {
                this.getLogger().warning(connectionInfo.getConnectionName() + ": " + dBException.getMessage());
            }
        }
        return database;
    }

    public DatabaseConnections getStore(String string) {
        if (string == null) {
            return null;
        }
        for (StoreProvider storeProvider : this.getProviders()) {
            DatabaseConnections databaseConnections = storeProvider.getStore(string);
            if (databaseConnections == null) continue;
            return databaseConnections;
        }
        return null;
    }

    private StoreProvider findProvider(String string) {
        StoreProvider storeProvider = null;
        if (string != null) {
            for (StoreProvider storeProvider2 : this.getProviders()) {
                Collection<String> collection = storeProvider2.listStores();
                if (collection == null || !collection.contains(string)) continue;
                storeProvider = storeProvider2;
                break;
            }
        }
        return storeProvider;
    }

    public String getShortLabel(String string) {
        String string2 = null;
        StoreProvider storeProvider = this.findProvider(string);
        if (storeProvider != null) {
            string2 = storeProvider.getShortLabel(string);
        }
        return string2;
    }

    public Icon getIcon(String string) {
        Icon icon = null;
        StoreProvider storeProvider = this.findProvider(string);
        if (storeProvider != null) {
            icon = storeProvider.getIcon(string);
        }
        return icon;
    }

    public String getToolTipText(String string) {
        String string2 = null;
        StoreProvider storeProvider = this.findProvider(string);
        if (storeProvider != null) {
            string2 = storeProvider.getToolTipText(string);
        }
        return string2;
    }

    @Deprecated
    public void registerStoreProvider(StoreProvider storeProvider) {
        this.getLogger().log(Level.INFO, "Programatic StoreProvider registration deprecated, use extension.xml to register: " + storeProvider.getClass().getName());
        this.registerStoreProviderImpl(storeProvider);
    }

    private void registerStoreProviderImpl(StoreProvider storeProvider) {
        this.m_providers.add(0, storeProvider);
        for (String string : storeProvider.listStores()) {
            this.fireStoreAdded(string);
        }
        this.getLogger().log(Level.FINE, "Registered new database connection store provider: " + storeProvider.getClass().getName());
    }

    private Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    private void printStores() {
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            Collection<String> collection = this.listStores();
            if (collection.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Available database connection stores: \n");
                for (String string : collection) {
                    stringBuilder.append(string).append("\n");
                }
                logger.log(Level.FINE, stringBuilder.toString());
            } else {
                logger.log(Level.FINE, "There are no available database connection stores.");
            }
        }
    }

    public static DatabaseProvider getReferenceable(String string, String string2) {
        DatabaseConnections databaseConnections;
        if (string != null && (databaseConnections = DatabaseConnectionStores.getInstance().getStore(string)) != null) {
            try {
                return databaseConnections.getReferenceable(string2);
            }
            catch (ConnectionException connectionException) {
                DBLog.getLogger(DatabaseConnectionStores.class).log(Level.WARNING, "Cannot get connection " + string2 + " from store " + string, connectionException);
            }
        }
        return null;
    }

    private class CentralStoreProvider
    extends StoreProvider {
        private CentralStoreProvider() {
        }

        @Override
        public DatabaseConnections getStore(String string) {
            if (string.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return DatabaseConnections.getInstance();
            }
            return null;
        }

        @Override
        public String getShortLabel(String string) {
            if (string.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return ConnBundle.get("CENTRAL_STORE_NAME");
            }
            return null;
        }

        @Override
        public Icon getIcon(String string) {
            if (string.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return OracleIcons.getIcon((String)"dbconn.png");
            }
            return null;
        }

        @Override
        public String getToolTipText(String string) {
            if (string.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return ConnBundle.get("CENTRAL_STORE_TTT");
            }
            return null;
        }

        @Override
        public Collection<String> listStores() {
            Collection<Object> collection = StoreContext.getContext().isCentralStoreAvailable() ? Collections.singleton(DatabaseConnectionStores.CENTRAL_STORE) : Collections.emptyList();
            return collection;
        }

        @Override
        protected String getCurrentStore(Context context) {
            return null;
        }
    }
}

