/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.incremental.parseforest;

import org.metaborg.parsetable.characterclasses.CharacterClassFactory;
import org.metaborg.parsetable.states.IState;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseForest;
import org.spoofax.jsglr2.parseforest.ICharacterNode;
import org.spoofax.jsglr2.util.TreePrettyPrinter;

public class IncrementalCharacterNode
extends IncrementalParseForest
implements ICharacterNode {
    public static final IncrementalCharacterNode EOF_NODE = new IncrementalCharacterNode(-1);
    public final int character;

    public IncrementalCharacterNode(int character) {
        super(Character.charCount(character));
        this.character = character;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean isReusable(IState stackState) {
        return true;
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public int character() {
        return this.character;
    }

    @Override
    public String descriptor() {
        return "'" + (this.character == -1 ? "EOF" : (this.character < 32 ? "\\" + this.character : CharacterClassFactory.intToString(this.character))) + "'";
    }

    @Override
    protected void prettyPrint(TreePrettyPrinter printer) {
        printer.println(this.descriptor());
    }

    @Override
    public String getYield() {
        return this.character == -1 ? "" : (Character.isSupplementaryCodePoint(this.character) ? new String(Character.toChars(this.character)) : "" + (char)this.character);
    }

    @Override
    public String getYield(int length) {
        return length > 0 ? this.getYield() : "";
    }
}

