/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.evaluation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.evaluation.BaseTaskEvaluator;
import org.metaborg.runtime.task.evaluation.BaseTaskQueuer;
import org.metaborg.runtime.task.evaluation.ITaskEvaluationFrontend;
import org.metaborg.runtime.task.evaluation.ITaskEvaluationQueue;
import org.metaborg.runtime.task.evaluation.ITaskEvaluator;
import org.metaborg.runtime.task.evaluation.ITaskQueuer;
import org.metaborg.runtime.task.evaluation.TaskEvaluationDebugging;
import org.metaborg.util.collection.BiLinkedHashMultimap;
import org.metaborg.util.collection.BiSetMultimap;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;

public class TaskEvaluationQueue
implements ITaskEvaluationQueue,
ITaskEvaluationFrontend {
    private final ITaskEngine taskEngine;
    private final ITermFactory factory;
    private final Queue<IStrategoTerm> evaluationQueue = Lists.newLinkedList();
    private final Set<IStrategoTerm> queued = Sets.newHashSet();
    private BiSetMultimap<IStrategoTerm, IStrategoTerm> runtimeDependencies = BiLinkedHashMultimap.create();
    private final Map<IStrategoConstructor, ITaskQueuer> taskQueuers = Maps.newLinkedHashMap();
    private final ITaskQueuer baseTaskQueuer;
    private final Map<IStrategoConstructor, ITaskEvaluator> taskEvaluators = Maps.newLinkedHashMap();
    private final ITaskEvaluator baseTaskEvaluator;
    private IStrategoTerm currentTaskID = null;
    private boolean currentDelayed = false;
    private Set<IStrategoTerm> scheduled;
    private final Set<IStrategoTerm> skipped = Sets.newHashSet();
    private final Set<IStrategoTerm> evaluated = Sets.newHashSet();

    public TaskEvaluationQueue(ITaskEngine taskEngine, ITermFactory factory) {
        this.taskEngine = taskEngine;
        this.factory = factory;
        this.baseTaskQueuer = new BaseTaskQueuer();
        this.baseTaskEvaluator = new BaseTaskEvaluator(factory);
    }

    @Override
    public void queue(IStrategoTerm taskID) {
        if (!this.queued.contains(taskID)) {
            this.evaluationQueue.add(taskID);
            this.queued.add(taskID);
        }
    }

    @Override
    public void queueOrDefer(IStrategoTerm taskID) {
        Iterable<IStrategoTerm> dependencies = this.taskEngine.getDependencies(taskID, false);
        HashSet dependenciesSet = Sets.newHashSet(dependencies);
        for (IStrategoTerm dependency : dependencies) {
            if (!this.taskEngine.getTask(dependency).solved()) continue;
            dependenciesSet.remove(dependency);
        }
        if (dependenciesSet.isEmpty()) {
            this.queue(taskID);
        } else {
            this.runtimeDependencies.putAll(taskID, dependenciesSet);
        }
    }

    @Override
    public void solved(IStrategoTerm taskID) {
        HashSet dependents = Sets.newHashSet(this.taskEngine.getDependents(taskID, false));
        dependents.addAll(this.runtimeDependencies.getInverse((Object)taskID));
        for (IStrategoTerm dependentTaskID : dependents) {
            boolean removed = this.runtimeDependencies.remove(dependentTaskID, taskID);
            if (!removed || this.runtimeDependencies.get(dependentTaskID).size() != 0 || this.taskEngine.getTask(dependentTaskID).solved()) continue;
            this.queue(dependentTaskID);
        }
    }

    @Override
    public void skipped(IStrategoTerm taskID) {
        this.scheduled.remove(taskID);
        this.skipped.add(taskID);
    }

    @Override
    public void delayed(IStrategoTerm taskID, Iterable<IStrategoTerm> dependencies) {
        TaskEvaluationDebugging.debugDelayedDependecy(this.taskEngine, taskID, dependencies);
        this.currentDelayed = true;
        this.runtimeDependencies.removeAll(taskID);
        for (IStrategoTerm dependency : dependencies) {
            this.runtimeDependencies.put(taskID, dependency);
        }
        this.taskEngine.setDynamicDependencies(taskID, dependencies);
        this.scheduled.add(taskID);
    }

    @Override
    public boolean isDelayed() {
        return this.currentDelayed;
    }

    @Override
    public void addRuntimeDependency(IStrategoTerm taskID, IStrategoTerm dependencyTaskID) {
        this.runtimeDependencies.put(taskID, dependencyTaskID);
    }

    @Override
    public void removeRuntimeDependency(IStrategoTerm taskID, IStrategoTerm dependencyTaskID) {
        this.runtimeDependencies.remove(taskID, dependencyTaskID);
    }

    @Override
    public void addTaskQueuer(IStrategoConstructor constructor, ITaskQueuer taskQueuer) {
        if (this.taskQueuers.put(constructor, taskQueuer) != null) {
            throw new RuntimeException("Task queuer for " + constructor + " already exists.");
        }
    }

    @Override
    public void registerTaskEvaluator(IStrategoConstructor constructor, ITaskEvaluator taskEvaluator) {
        if (this.taskEvaluators.put(constructor, taskEvaluator) != null) {
            throw new RuntimeException("Task evaluator for " + constructor + " already exists.");
        }
    }

    @Override
    public IStrategoTuple evaluate(Set<IStrategoTerm> scheduled, IContext context, Strategy collect, Strategy insert, Strategy perform) {
        try {
            this.scheduled = scheduled;
            for (ITaskQueuer taskQueuer : this.taskQueuers.values()) {
                taskQueuer.queue(this.taskEngine, this, this.scheduled);
                this.evaluateQueuedTasks(context, collect, insert, perform, false);
            }
            this.baseTaskQueuer.queue(this.taskEngine, this, this.scheduled);
            this.evaluateQueuedTasks(context, collect, insert, perform, false);
            if (!this.scheduled.isEmpty()) {
                this.evaluateCyclic(context, collect, insert, perform);
            }
            IStrategoTuple iStrategoTuple = this.factory.makeTuple(this.factory.makeList(this.evaluated), this.factory.makeList(this.skipped), this.factory.makeList(this.scheduled));
            return iStrategoTuple;
        }
        finally {
            this.reset();
        }
    }

    private void evaluateCyclic(IContext context, Strategy collect, Strategy insert, Strategy perform) {
        TaskEvaluationDebugging.debugUnevaluated(this.taskEngine, this.scheduled, this.runtimeDependencies);
        BiSetMultimap<IStrategoTerm, IStrategoTerm> copiedRuntimeDependencies = BiLinkedHashMultimap.create(this.runtimeDependencies);
        HashSet taskIDs = Sets.newHashSet((Iterable)copiedRuntimeDependencies.keySet());
        for (IStrategoTerm taskID : taskIDs) {
            this.queue(taskID);
        }
        this.evaluateQueuedTasks(context, collect, insert, perform, true);
        ArrayListMultimap values = ArrayListMultimap.create();
        for (IStrategoTerm taskID : taskIDs) {
            ITask task = this.taskEngine.getTask(taskID);
            if (task.failed()) continue;
            values.putAll((Object)taskID, (Iterable)task.results());
        }
        int i = 0;
        while (i < 25) {
            ITask task;
            System.out.println("Fixpoint cycle " + i);
            this.runtimeDependencies = BiLinkedHashMultimap.create(copiedRuntimeDependencies);
            for (IStrategoTerm taskID : taskIDs) {
                this.queue(taskID);
            }
            this.evaluateQueuedTasks(context, collect, insert, perform, true);
            boolean done = true;
            for (IStrategoTerm taskID : taskIDs) {
                task = this.taskEngine.getTask(taskID);
                if (values.get((Object)taskID).isEmpty()) {
                    if (task.failed() || task.results().empty()) continue;
                    done = false;
                    break;
                }
                if (task.failed() || task.results().empty()) {
                    done = false;
                    break;
                }
                HashMultiset oldValues = HashMultiset.create((Iterable)values.get((Object)taskID));
                HashMultiset newValues = HashMultiset.create((Iterable)task.results());
                Multiset diff1 = Multisets.difference((Multiset)newValues, (Multiset)oldValues);
                Multiset diff2 = Multisets.difference((Multiset)oldValues, (Multiset)newValues);
                if (diff1.isEmpty() && diff2.isEmpty()) continue;
                done = false;
                break;
            }
            if (done) {
                System.out.println("Done with fixpoint evaluation!");
                break;
            }
            values.clear();
            for (IStrategoTerm taskID : taskIDs) {
                task = this.taskEngine.getTask(taskID);
                if (task.failed()) continue;
                values.putAll((Object)taskID, (Iterable)task.results());
            }
            ++i;
        }
    }

    @Override
    public IStrategoTerm current() {
        return this.currentTaskID;
    }

    @Override
    public void reset() {
        this.evaluationQueue.clear();
        this.queued.clear();
        this.runtimeDependencies.clear();
        this.currentTaskID = null;
        this.currentDelayed = false;
        this.scheduled = null;
        this.skipped.clear();
        this.evaluated.clear();
        for (ITaskEvaluator evaluator : this.taskEvaluators.values()) {
            evaluator.reset();
        }
        this.baseTaskEvaluator.reset();
    }

    private void evaluateQueuedTasks(IContext context, Strategy collect, Strategy insert, Strategy perform, boolean cycle) {
        IStrategoTerm taskID;
        while ((taskID = this.evaluationQueue.poll()) != null) {
            this.currentTaskID = taskID;
            this.currentDelayed = false;
            ITask task = this.taskEngine.getTask(taskID);
            this.evaluated.add(taskID);
            this.scheduled.remove(taskID);
            this.queued.remove(taskID);
            this.taskEngine.invalidate(taskID);
            ITaskEvaluator taskEvaluator = this.getTaskEvaluator(task.instruction());
            taskEvaluator.evaluate(taskID, task, this.taskEngine, this, context, collect, insert, perform, cycle);
            if (this.currentDelayed) {
                this.taskEngine.invalidate(taskID);
            }
            this.currentTaskID = null;
            this.currentDelayed = false;
        }
    }

    private ITaskEvaluator getTaskEvaluator(IStrategoAppl instruction) {
        ITaskEvaluator taskEvaluator = this.taskEvaluators.get(instruction.getConstructor());
        if (taskEvaluator == null) {
            return this.baseTaskEvaluator;
        }
        return taskEvaluator;
    }
}

