/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.collection;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.u.IUnifier;

public class VarMultimap<T> {
    private final Multimap<ITermVar, T> map = HashMultimap.create();

    public boolean put(ITermVar key, T value, IUnifier unifier) {
        Set.Immutable<ITermVar> reps = unifier.getVars(key);
        boolean change = false;
        for (ITermVar rep : reps) {
            change |= this.map.put((Object)rep, value);
        }
        return change;
    }

    public boolean remove(ITermVar key, T value, IUnifier unifier) {
        Set.Immutable<ITermVar> reps = unifier.getVars(key);
        boolean change = false;
        for (ITermVar rep : reps) {
            change |= this.map.remove((Object)rep, value);
        }
        return change;
    }

    public Collection<ITermVar> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public boolean contains(ITermVar key, T value, IUnifier unifier) {
        Set.Immutable<ITermVar> reps = unifier.getVars(key);
        return reps.stream().anyMatch(rep -> this.map.containsEntry(rep, value));
    }

    public Set<T> get(ITermVar key, IUnifier unifier) {
        Set.Immutable<ITermVar> reps = unifier.getVars(key);
        return reps.stream().flatMap(rep -> this.map.get(rep).stream()).collect(Collectors.toSet());
    }

    public int size() {
        return this.map.size();
    }

    public boolean update(Collection<ITermVar> vars, IUnifier unifier) {
        boolean change = false;
        for (ITermVar var : vars) {
            change |= this.update(var, unifier);
        }
        return change;
    }

    public boolean update(ITermVar var, IUnifier unifier) {
        Collection values = this.map.removeAll((Object)var);
        Set.Immutable<ITermVar> reps = unifier.getVars(var);
        boolean change = false;
        for (ITermVar rep : reps) {
            change |= this.map.putAll((Object)rep, (Iterable)values);
        }
        return change;
    }
}

