/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.secrets;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.secrets.SecretsAsync;
import com.oracle.bmc.secrets.model.SecretBundle;
import com.oracle.bmc.secrets.model.SecretBundleVersionSummary;
import com.oracle.bmc.secrets.requests.GetSecretBundleByNameRequest;
import com.oracle.bmc.secrets.requests.GetSecretBundleRequest;
import com.oracle.bmc.secrets.requests.ListSecretBundleVersionsRequest;
import com.oracle.bmc.secrets.responses.GetSecretBundleByNameResponse;
import com.oracle.bmc.secrets.responses.GetSecretBundleResponse;
import com.oracle.bmc.secrets.responses.ListSecretBundleVersionsResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretsAsyncClient
extends BaseAsyncClient
implements SecretsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SECRETS").serviceEndpointPrefix("").serviceEndpointTemplate("https://secrets.vaults.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SecretsAsyncClient.class);

    SecretsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetSecretBundleResponse> getSecretBundle(GetSecretBundleRequest request, AsyncHandler<GetSecretBundleRequest, GetSecretBundleResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSecretBundleResponse::builder).logger(LOG, "getSecretBundle").serviceDetails("Secrets", "GetSecretBundle", "https://docs.oracle.com/iaas/api/#/en/secretretrieval/20190301/SecretBundle/GetSecretBundle").method(Method.GET).requestBuilder(GetSecretBundleRequest::builder).basePath("/20190301").appendPathParam("secretbundles").appendPathParam(request.getSecretId()).appendQueryParam("versionNumber", (Object)request.getVersionNumber()).appendQueryParam("secretVersionName", (Object)request.getSecretVersionName()).appendEnumQueryParam("stage", (BmcEnum)request.getStage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecretBundle.class, GetSecretBundleResponse.Builder::secretBundle).handleResponseHeaderString("etag", GetSecretBundleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSecretBundleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSecretBundleByNameResponse> getSecretBundleByName(GetSecretBundleByNameRequest request, AsyncHandler<GetSecretBundleByNameRequest, GetSecretBundleByNameResponse> handler) {
        Objects.requireNonNull(request.getSecretName(), "secretName is required");
        Objects.requireNonNull(request.getVaultId(), "vaultId is required");
        return this.clientCall(request, GetSecretBundleByNameResponse::builder).logger(LOG, "getSecretBundleByName").serviceDetails("Secrets", "GetSecretBundleByName", "https://docs.oracle.com/iaas/api/#/en/secretretrieval/20190301/SecretBundle/GetSecretBundleByName").method(Method.POST).requestBuilder(GetSecretBundleByNameRequest::builder).basePath("/20190301").appendPathParam("secretbundles").appendPathParam("actions").appendPathParam("getByName").appendQueryParam("secretName", (Object)request.getSecretName()).appendQueryParam("vaultId", (Object)request.getVaultId()).appendQueryParam("versionNumber", (Object)request.getVersionNumber()).appendQueryParam("secretVersionName", (Object)request.getSecretVersionName()).appendEnumQueryParam("stage", (BmcEnum)request.getStage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecretBundle.class, GetSecretBundleByNameResponse.Builder::secretBundle).handleResponseHeaderString("opc-request-id", GetSecretBundleByNameResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSecretBundleVersionsResponse> listSecretBundleVersions(ListSecretBundleVersionsRequest request, AsyncHandler<ListSecretBundleVersionsRequest, ListSecretBundleVersionsResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSecretBundleVersionsResponse::builder).logger(LOG, "listSecretBundleVersions").serviceDetails("Secrets", "ListSecretBundleVersions", "https://docs.oracle.com/iaas/api/#/en/secretretrieval/20190301/SecretBundleVersionSummary/ListSecretBundleVersions").method(Method.GET).requestBuilder(ListSecretBundleVersionsRequest::builder).basePath("/20190301").appendPathParam("secretbundles").appendPathParam(request.getSecretId()).appendPathParam("versions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SecretBundleVersionSummary.class, ListSecretBundleVersionsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSecretBundleVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSecretBundleVersionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Deprecated
    public SecretsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SecretsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SecretsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SecretsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SecretsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SecretsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SecretsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SecretsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SecretsAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "secrets";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"secrets");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public SecretsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SecretsAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

