/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest2.navigator;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.editor.RestHandlerEditor;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestRole;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.navigator.RestFolder;
import oracle.dbtools.rest.navigator.RestHandlerEditorNode;
import oracle.dbtools.rest.navigator.RestHandlerNode;
import oracle.dbtools.rest.ui.RestBaseDialog;
import oracle.dbtools.rest.ui.RestModuleDialog;
import oracle.dbtools.rest.ui.RestRenameDialog;
import oracle.dbtools.rest.ui.RestRenameModuleDialog;
import oracle.dbtools.rest.ui.RestResourceHandlerDialog;
import oracle.dbtools.rest.ui.RestRoleDialog;
import oracle.dbtools.rest.ui.RestSecurityDialog;
import oracle.dbtools.rest.ui.RestTemplateDialog;
import oracle.dbtools.rest.ui.RestValidateDialog;
import oracle.dbtools.rest.utils.RestExecuteScript;
import oracle.dbtools.rest.utils.RestExportDefinitions;
import oracle.dbtools.rest.utils.RestLoadData;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.wizard.RestWizard;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.javatools.dialogs.MessageDialog;

public class RestDevController
implements Controller {
    public static final int NEW_MODULE_ID = Ide.findOrCreateCmdID((String)"rest2.NEW_MODULE");
    public static final int NEW_PRIVILEGE_ID = Ide.findOrCreateCmdID((String)"rest2.NEW_PRIVILEGE");
    public static final int ADD_TEMPLATE_ID = Ide.findOrCreateCmdID((String)"rest2.ADD_TEMPLATE");
    public static final int ADD_GET_HANDLER_ID = Ide.findOrCreateCmdID((String)"rest2.ADD_GET_HANDLER");
    public static final int ADD_DELETE_HANDLER_ID = Ide.findOrCreateCmdID((String)"rest2.ADD_DELETE_HANDLER");
    public static final int ADD_POST_HANDLER_ID = Ide.findOrCreateCmdID((String)"rest2.ADD_POST_HANDLER");
    public static final int ADD_PUT_HANDLER_ID = Ide.findOrCreateCmdID((String)"rest2.ADD_PUT_HANDLER");
    public static final int NEW_ROLE_ID = Ide.findOrCreateCmdID((String)"rest2.NEW_ROLE");
    public static final int DELETE_ID = Ide.findOrCreateCmdID((String)"rest2.DELETE");
    public static final int EDIT_ID = Ide.findOrCreateCmdID((String)"rest2.EDIT");
    public static final int RENAME_ID = Ide.findOrCreateCmdID((String)"rest2.RENAME");
    public static final int VALIDATE_ID = Ide.findOrCreateCmdID((String)"rest2.VALIDATE");
    public static final int EXPORT_ID = Ide.findOrCreateCmdID((String)"rest2.EXPORT");
    public static final int SAVE_TO_WORKSHEET_ID = Ide.findOrCreateCmdID((String)"rest2.SAVE_TO_WORKSHEET");
    public static final int SAVE_TO_CLIPBOARD_ID = Ide.findOrCreateCmdID((String)"rest2.SAVE_TO_CLIPBOARD");
    private static RestDevController INSTANCE;
    private RESTTask<?> _backgroundTask;
    private final Object taskLock = new Object();

    public static synchronized RestDevController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestDevController();
        }
        return INSTANCE;
    }

    private RestDevController() {
    }

    private boolean validate(Context context, boolean bl) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject.getObjectType().equals("REST_MODULE")) {
            RestModule restModule = RestLoadData.createRestModuleTemplateHandler(context);
            return RestValidateDialog.isModuleValid(restModule, bl);
        }
        if (dBObject.getObjectType().equals("REST_PRIVILEGE")) {
            RestPrivilege restPrivilege = RestLoadData.createRestPrivilege(dBObject);
            return RestValidateDialog.isPrivilegeValid(restPrivilege, bl);
        }
        return false;
    }

    private void processExport(Context context, int n) {
        if (n == EXPORT_ID) {
            RestExportDefinitions.exportREST(context);
        } else if (n == SAVE_TO_WORKSHEET_ID) {
            RestExportDefinitions.saveToWorksheet(context);
        } else if (n == SAVE_TO_CLIPBOARD_ID) {
            RestExportDefinitions.saveToClipboard(context);
        }
    }

    private void export(Context context, int n) {
        this.processExport(context, n);
    }

    private void createModuleViaWizard(Context context) {
        if (this.isCreateAllowed(context)) {
            RestWizard.getInstance().launchCreatelModule(context);
        }
    }

    private boolean isCreateAllowed(Context context) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent().getParent();
        DBObject dBObject2 = new DBObject(navigatorTreeNode2.getElement());
        String string = dBObject2.getObjectName();
        String string2 = dBObject2.getConnectionName();
        if (string != null && string2 != null && string.equals(string2)) {
            return true;
        }
        String string3 = "";
        if (dBObject.getObjectFolderType().equals("REST_MODULE")) {
            string3 = "REST_MODULE";
        } else if (dBObject.getObjectFolderType().equals("REST_PRIVILEGE")) {
            string3 = "LABEL_PRIVILEGE";
        } else if (dBObject.getObjectFolderType().equals("REST_ROLE")) {
            string3 = "LABEL_ROLE";
        }
        RestDevController.msgCreateObj(string3, navigatorTreeNode2.getElement().getShortLabel());
        return false;
    }

    private static void msgCreateObj(String string, String string2) {
        final String string3 = RestArb.getString(string);
        final String string4 = RestArb.format("ERR_CREATE_REST_OBJ", string3, string2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MessageDialog.information(null, (Object)string4, (String)string3, null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void createTemplate(Context context) {
        RestWizard.getInstance().launchCreateTemplate(context);
    }

    private void createHandler(Context context, RestResourceHandler.HTTP_METHOD_TYPE hTTP_METHOD_TYPE) {
        RestHandlerNode restHandlerNode = (RestHandlerNode)this.launchHandlerDialog(context, hTTP_METHOD_TYPE);
        if (restHandlerNode != null) {
            DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
            restHandlerNode.setParentURL(dBObject.getURL());
            this.setHandlerNodeValues(dBObject, restHandlerNode);
            URL uRL = DBURLFormatHelper.getChildURL((URL)dBObject.getURL(), (String)"REST_HANDLER", (String)hTTP_METHOD_TYPE.getType().toUpperCase());
            restHandlerNode.setURL(uRL);
            String string = this.getHandlerPath(dBObject.getURL(), hTTP_METHOD_TYPE.getType().toUpperCase());
            restHandlerNode.setTemplateMethodId(string);
            RestHandlerEditorNode restHandlerEditorNode = new RestHandlerEditorNode(restHandlerNode);
            this.showEditor(restHandlerEditorNode, false);
        }
    }

    private void setHandlerNodeValues(DBObject dBObject, RestHandlerNode restHandlerNode) {
        BigDecimal bigDecimal;
        restHandlerNode.setUsingRestApi(true);
        Map map = dBObject.getDictionary();
        long l = 0L;
        if (map.containsKey("MODULE_ID")) {
            bigDecimal = (BigDecimal)map.get("MODULE_ID");
            l = bigDecimal.longValue();
            restHandlerNode.setModuleId(l);
        }
        if (map.containsKey("TEMPLATE_ID")) {
            bigDecimal = (BigDecimal)map.get("TEMPLATE_ID");
            l = bigDecimal.longValue();
            restHandlerNode.setTemplateId(l);
        }
        if (map.containsKey("MODULE_NAME")) {
            restHandlerNode.setModuleName((String)map.get("MODULE_NAME"));
        }
        if (map.containsKey("URI_PREFIX")) {
            restHandlerNode.setModuleURI((String)map.get("URI_PREFIX"));
        }
        if (map.containsKey("URI_TEMPLATE")) {
            restHandlerNode.setTemplateURI((String)map.get("URI_TEMPLATE"));
        }
    }

    private URL getTemplateURL(URL uRL) {
        String string = uRL.getPath();
        string = string.substring(0, string.lastIndexOf("/"));
        string = string.substring(0, string.lastIndexOf("/"));
        String string2 = uRL.getProtocol();
        String string3 = DBURLFormatHelper.getConnectionName((URL)uRL);
        int n = string.indexOf(string3);
        String string4 = string.substring(n + 1);
        URL uRL2 = URLFactory.newURL((String)string2, (String)string4);
        return uRL2;
    }

    private void createPrivilege(Context context) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null && dBObject.getObjectType().equals("REST_PRIVILEGE_FOLDER") && this.isCreateAllowed(context)) {
            NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent();
            if (RestSecurityDialog.internalRolesExists()) {
                this.processPrivilege(context, navigatorTreeNode2, null, false);
            } else {
                this.setupPrivilegeInternalRoles(context, navigatorTreeNode2, dBObject.getConnectionName(), null, false);
            }
        }
    }

    private void setupPrivilegeInternalRoles(final Context context, final NavigatorTreeNode navigatorTreeNode, final String string, final RestPrivilege restPrivilege, final boolean bl) {
        this.startTask(new RESTTask<List<String>>(RestArb.getString("TASK_RETRIEVE_PRIV")){

            protected List<String> doWork() throws TaskException {
                List<String> list = null;
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    list = InstallDBUtils.getNames(connection, "select name from user_ords_roles where schema_id = 10", hashMap);
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                return list;
            }
        }, new RESTHandler<List<String>>(){

            @Override
            protected void handleTaskFinished(List<String> list) {
                if (list != null) {
                    RestSecurityDialog.setInternalRoles(list);
                }
                RestDevController.this.processPrivilege(context, navigatorTreeNode, restPrivilege, bl);
            }
        });
    }

    private void processPrivilege(Context context, NavigatorTreeNode navigatorTreeNode, RestPrivilege restPrivilege, boolean bl) {
        List<String> list = null;
        List<String> list2 = null;
        List<String> list3 = null;
        Object object = navigatorTreeNode.children();
        while (object.hasMoreElements()) {
            boolean bl2;
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)object.nextElement();
            boolean bl3 = bl2 = navigatorTreeNode2.getChildCount() > 0;
            if (!(navigatorTreeNode2.getElement() instanceof ObjectFolder)) continue;
            ObjectFolder objectFolder = (ObjectFolder)navigatorTreeNode2.getElement();
            if (objectFolder.getObjectType().equals("REST_MODULE")) {
                list = bl2 ? RestUtils.getChildrenNames(navigatorTreeNode2) : this.getChildrenNames(objectFolder);
                continue;
            }
            if (objectFolder.getObjectType().equals("REST_ROLE")) {
                list2 = bl2 ? RestUtils.getChildrenNames(navigatorTreeNode2) : this.getChildrenNames(objectFolder);
                continue;
            }
            if (bl || !objectFolder.getObjectType().equals("REST_PRIVILEGE")) continue;
            list3 = bl2 ? RestUtils.getChildrenNames(navigatorTreeNode2) : this.getChildrenNames(objectFolder);
        }
        if (bl) {
            object = new RestSecurityDialog(restPrivilege, list3, list2, list, true, true);
            if (object.runDialog() && object.valuesChanged()) {
                RestExecuteScript.updateRestPrivilege(context, (RestPrivilege)object.getObject());
            }
        } else {
            object = new RestSecurityDialog(list3, list2, list, true);
            if (object.runDialog()) {
                RestExecuteScript.createRestPrivilege(context, (RestPrivilege)object.getObject());
            }
        }
    }

    private List<String> getChildrenNames(ObjectFolder objectFolder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
            List list = dBFolderInstance.listChildren();
            for (DBChildInstance dBChildInstance : list) {
                String string = (String)dBChildInstance.getProperty("NAME");
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private void createRole(Context context) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null && dBObject.getObjectType().equals("REST_ROLE_FOLDER") && this.isCreateAllowed(context)) {
            NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
            ObjectFolder objectFolder = (ObjectFolder)context.getElement();
            List<String> list = objectFolder.isLoaded() ? RestUtils.getChildrenNames(navigatorTreeNode) : this.getChildrenNames(objectFolder);
            RestRoleDialog restRoleDialog = new RestRoleDialog(list);
            if (restRoleDialog.runDialog()) {
                RestRole restRole = (RestRole)restRoleDialog.getObject();
                RestExecuteScript.createRestRole(context, restRole);
            }
        }
    }

    private RestFolder launchHandlerDialog(Context context, RestResourceHandler.HTTP_METHOD_TYPE hTTP_METHOD_TYPE) {
        Object object;
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        Map map = dBObject.getDictionary();
        long l = 25L;
        if (map.containsKey("ITEMS_PER_PAGE")) {
            object = (BigDecimal)map.get("ITEMS_PER_PAGE");
            l = ((BigDecimal)object).longValue();
        }
        object = null;
        object = new RestResourceHandlerDialog(hTTP_METHOD_TYPE, l, true);
        RestHandlerNode restHandlerNode = null;
        if (object.runDialog() && object.getObject() != null) {
            RestResourceHandler restResourceHandler = (RestResourceHandler)object.getObject();
            restResourceHandler.setConnectionName(dBObject.getConnectionName());
            restHandlerNode = new RestHandlerNode(restResourceHandler);
            return restHandlerNode;
        }
        return restHandlerNode;
    }

    private void edit(Context context) {
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null) {
            String string = dBObject.getObjectType();
            RestBaseDialog restBaseDialog = null;
            switch (string) {
                case "REST_HANDLER": {
                    this.openEditor(context);
                    break;
                }
                case "REST_MODULE": {
                    RestModule restModule = RestLoadData.createRestModule(dBObject);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    restBaseDialog = new RestModuleDialog(restModule, arrayList, arrayList2, dBObject.getSchemaName(), true, true);
                    if (!restBaseDialog.runDialog() || !restBaseDialog.valuesChanged()) break;
                    restModule = (RestModule)restBaseDialog.getObject();
                    RestExecuteScript.updateRestModule(context, restModule);
                    break;
                }
                case "REST_TEMPLATE": {
                    String string2 = (String)dBObject.getDictionary().get("URI_TEMPLATE");
                    RestTemplate restTemplate = RestLoadData.createRestTemplate(dBObject);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    RestLoadData.retreiveRestTemplateUris(navigatorTreeNode, arrayList, string2);
                    String string3 = (String)dBObject.getDictionary().get("URI_PREFIX");
                    String string4 = restTemplate.getURIPattern();
                    restBaseDialog = new RestTemplateDialog(restTemplate, arrayList, string3, dBObject.getSchemaName(), true);
                    if (!restBaseDialog.runDialog() || !restBaseDialog.valuesChanged()) break;
                    RestTemplate restTemplate2 = (RestTemplate)restBaseDialog.getObject();
                    if (RestUtils.valuesDifferent(string4, restTemplate2.getURIPattern())) {
                        RestExecuteScript.updateRenameRestTemplate(context, restTemplate2);
                        break;
                    }
                    RestExecuteScript.updateRestTemplate(context, restTemplate2);
                    break;
                }
                case "REST_PRIVILEGE": {
                    RestPrivilege restPrivilege = RestLoadData.createRestPrivilege(dBObject);
                    NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent().getParent();
                    if (RestSecurityDialog.internalRolesExists()) {
                        this.processPrivilege(context, navigatorTreeNode2, restPrivilege, true);
                        break;
                    }
                    this.setupPrivilegeInternalRoles(context, navigatorTreeNode2, dBObject.getConnectionName(), restPrivilege, true);
                    break;
                }
            }
        }
    }

    private void rename(Context context) {
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null) {
            String string = dBObject.getObjectType();
            RestBaseDialog restBaseDialog = null;
            String string2 = null;
            NavigatorTreeNode navigatorTreeNode2 = null;
            List<String> list = null;
            switch (string) {
                case "REST_MODULE": {
                    String string3;
                    string2 = string3 = (String)dBObject.getDictionary().get("MODULE_NAME");
                    String string4 = (String)dBObject.getDictionary().get("URI_PREFIX");
                    RestModule restModule = new RestModule();
                    restModule.setName(string3);
                    restModule.setURIPrefix(string4);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    RestLoadData.retreiveRestModuleNamesUriPrefixes(navigatorTreeNode, arrayList, arrayList2, string3);
                    restBaseDialog = new RestRenameModuleDialog(restModule, arrayList, arrayList2);
                    if (!restBaseDialog.runDialog() || !restBaseDialog.valuesChanged()) break;
                    String string5 = null;
                    String string6 = null;
                    RestModule restModule2 = (RestModule)restBaseDialog.getObject();
                    if (RestUtils.valuesDifferent(restModule.getName(), restModule2.getName())) {
                        string5 = restModule2.getName();
                    }
                    if (RestUtils.valuesDifferent(restModule.getURIPrefix(), restModule2.getURIPrefix())) {
                        string6 = restModule2.getURIPrefix();
                    }
                    RestExecuteScript.renameRestModule(context, string3, string5, string6);
                    break;
                }
                case "REST_PRIVILEGE": {
                    String string7;
                    String string8;
                    navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent();
                    list = RestUtils.getChildrenNames(navigatorTreeNode2);
                    string2 = string8 = (String)dBObject.getDictionary().get("PRIVILEGE_NAME");
                    if (list != null && list.contains(string8)) {
                        list.remove(string8);
                    }
                    if (!(restBaseDialog = new RestRenameDialog("LABEL_PRIVILEGE", "f1_rest_rename_privilege_html", string2, list)).runDialog() || !ModelUtil.areDifferent((Object)string2, (Object)(string7 = (String)restBaseDialog.getObject()))) break;
                    RestExecuteScript.renameRestPrivilege(context, string2, string7);
                    break;
                }
                case "REST_ROLE": {
                    String string9;
                    String string10;
                    navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent();
                    list = RestUtils.getChildrenNames(navigatorTreeNode2);
                    string2 = string10 = (String)dBObject.getDictionary().get("NAME");
                    if (list != null && list.contains(string10)) {
                        list.remove(string10);
                    }
                    if (!(restBaseDialog = new RestRenameDialog("LABEL_ROLE", "f1_rest_rename_role_html", string2, list)).runDialog() || !ModelUtil.areDifferent((Object)string2, (Object)(string9 = (String)restBaseDialog.getObject()))) break;
                    RestExecuteScript.renameRestRole(context, string2, string9);
                    break;
                }
            }
        }
    }

    private void delete(Context context) {
        String string;
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null && this.confirmDelete(string = dBObject.getObjectType(), dBObject.getObjectName())) {
            URL uRL = dBObject.getURL();
            switch (string) {
                case "REST_MODULE": {
                    RestExecuteScript.deleteRestModule(context);
                    this.removeEditors(uRL);
                    break;
                }
                case "REST_TEMPLATE": {
                    RestExecuteScript.deleteRestTemplate(context);
                    this.removeEditors(uRL);
                    break;
                }
                case "REST_HANDLER": {
                    RestExecuteScript.deleteRestHandler(context);
                    this.removeEditors(uRL);
                    break;
                }
                case "REST_PRIVILEGE": {
                    RestExecuteScript.deleteRestPrivilege(context);
                    break;
                }
                case "REST_ROLE": {
                    RestExecuteScript.deleteRestRole(context);
                    break;
                }
            }
        }
    }

    private boolean confirmDelete(String string, String string2) {
        String string3 = "";
        if (string.equals("REST_MODULE")) {
            string3 = RestArb.getString("LABEL_MODULE");
        } else if (string.equals("REST_TEMPLATE")) {
            string3 = RestArb.getString("LABEL_TEMPLATE");
        } else if (string.equals("REST_HANDLER")) {
            string3 = RestArb.getString("LABEL_RESOURCE_HANDLER");
        } else if (string.equals("REST_PRIVILEGE")) {
            string3 = RestArb.getString("LABEL_PRIVILEGE");
        } else if (string.equals("REST_ROLE")) {
            string3 = RestArb.getString("LABEL_ROLE");
        }
        return MessageDialog.confirm(null, (Object)RestArb.format("DELETE_CONFIRMATION", string3, string2), (String)RestArb.format("DELETE_TITLE", string3), null);
    }

    private void removeEditors(URL uRL) {
        String string = uRL.getPath();
        List list = EditorManager.getEditorManager().getAllEditors();
        if (list != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Editor editor : list) {
                Object object;
                if (editor instanceof RestHandlerEditor) {
                    object = (RestHandlerEditor)editor;
                    if (!object.getTemplateMethodId().startsWith(string)) continue;
                    arrayList.add(object);
                    continue;
                }
                if (editor instanceof XMLBasedEditor) {
                    DBObject dBObject;
                    URL uRL2;
                    object = (XMLBasedEditor)editor;
                    ViewerNode viewerNode = object.getViewerNode();
                    if (viewerNode == null || !(uRL2 = (dBObject = viewerNode.getDBObject()).getURL()).getPath().equals(uRL.getPath())) continue;
                    arrayList.add(editor);
                    continue;
                }
                object = editor.getContext().getNode().getURL();
                if (!((URL)object).getPath().equals(uRL.getPath())) continue;
                arrayList.add(editor);
            }
            if (!arrayList.isEmpty()) {
                EditorManager.getEditorManager().closeEditors(arrayList);
            }
        }
    }

    private RestHandlerEditorNode findEditorNode(URL uRL) {
        String string = uRL.getPath();
        RestHandlerEditorNode restHandlerEditorNode = null;
        List list = EditorManager.getEditorManager().getAllEditors();
        if (list != null) {
            for (Editor editor : list) {
                RestHandlerEditor restHandlerEditor;
                if (!(editor instanceof RestHandlerEditor) || (restHandlerEditor = (RestHandlerEditor)editor).getTemplateMethodId() == null || !restHandlerEditor.getTemplateMethodId().equals(string)) continue;
                restHandlerEditorNode = (RestHandlerEditorNode)restHandlerEditor.getNode();
                break;
            }
        }
        return restHandlerEditorNode;
    }

    private void openEditor(Context context) {
        URL uRL = context.getNode().getURL();
        RestHandlerEditorNode restHandlerEditorNode = this.findEditorNode(uRL);
        if (restHandlerEditorNode == null) {
            DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
            restHandlerEditorNode = dBObject == null ? this.createHandlerEditorNode(uRL) : this.createHandlerEditorNode(dBObject);
        }
        this.showEditor(restHandlerEditorNode, false);
    }

    private RestHandlerEditorNode createHandlerEditorNode(URL uRL) {
        DBObject dBObject;
        DatabaseNode databaseNode;
        if (uRL != null && (databaseNode = DatabaseNavigatorElementFactory.getObjectNode((URL)uRL)) != null && (dBObject = new DBObject((Element)databaseNode)) != null) {
            return this.createHandlerEditorNode(dBObject);
        }
        return null;
    }

    private RestHandlerEditorNode createHandlerEditorNode(DBObject dBObject) {
        RestResourceHandler restResourceHandler;
        if (dBObject != null && (restResourceHandler = RestLoadData.createRestHandler(dBObject)) != null) {
            restResourceHandler.setConnectionName(dBObject.getConnectionName());
            RestHandlerNode restHandlerNode = new RestHandlerNode(restResourceHandler);
            restHandlerNode.setTemplateMethodId(dBObject.getURL().getPath());
            restHandlerNode.setParentURL(this.getTemplateURL(dBObject.getURL()));
            this.setHandlerNodeValues(dBObject, restHandlerNode);
            RestHandlerEditorNode restHandlerEditorNode = new RestHandlerEditorNode(restHandlerNode);
            return restHandlerEditorNode;
        }
        return null;
    }

    private RestHandlerEditor showEditor(RestHandlerEditorNode restHandlerEditorNode, boolean bl) {
        Context context = Context.newIdeContext((Node)restHandlerEditorNode);
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        openEditorOptions.setFlags(5);
        RestHandlerEditor restHandlerEditor = (RestHandlerEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
        if (bl) {
            restHandlerEditor.refresh();
        }
        return restHandlerEditor;
    }

    private String getTemplateMethodId(URL uRL, String string) {
        return this.getHandlerPath(uRL, string);
    }

    private String getHandlerPath(URL uRL, String string) {
        String string2 = uRL.getPath() + "/REST_HANDLER/" + string.toUpperCase();
        return string2;
    }

    private boolean handlerMethodExistInEditor(String string) {
        String string2 = string;
        boolean bl = false;
        int n = string.indexOf("IdeConnections");
        if (n > 0) {
            string2 = string.substring(n);
        }
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            RestHandlerEditor restHandlerEditor;
            if (!(editor instanceof RestHandlerEditor) || !(restHandlerEditor = (RestHandlerEditor)editor).getTemplateMethodId().equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private List<String> getHandlers(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectNode objectNode = null;
        objectNode = context.getNode() instanceof IViewerNode ? (ObjectNode)((IViewerNode)context.getNode()).getDBObject().getElement() : (ObjectNode)context.getElement();
        try {
            DBObjectInstance dBObjectInstance = objectNode.getNodeInstance();
            if (dBObjectInstance != null) {
                List list = dBObjectInstance.listChildren("REST_HANDLER");
                for (DBChildInstance dBChildInstance : list) {
                    String string = (String)dBChildInstance.getProperty("NAME");
                    if (string == null) continue;
                    arrayList.add(string);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private boolean handlerExists(int n, Context context) {
        String string = "";
        if (n == ADD_GET_HANDLER_ID) {
            string = RestResourceHandler.HTTP_METHOD_TYPE.GET.getType().toUpperCase();
        } else if (n == ADD_POST_HANDLER_ID) {
            string = RestResourceHandler.HTTP_METHOD_TYPE.POST.getType().toUpperCase();
        } else if (n == ADD_PUT_HANDLER_ID) {
            string = RestResourceHandler.HTTP_METHOD_TYPE.PUT.getType().toUpperCase();
        } else if (n == ADD_DELETE_HANDLER_ID) {
            string = RestResourceHandler.HTTP_METHOD_TYPE.DELETE.getType().toUpperCase();
        }
        List<String> list = null;
        NavigatorTreeNode navigatorTreeNode = null;
        if (context.getNode() instanceof IViewerNode) {
            ObjectNode objectNode = (ObjectNode)((IViewerNode)context.getNode()).getDBObject().getElement();
            navigatorTreeNode = RestUtils.findTreeNode(objectNode.getURL());
        } else {
            navigatorTreeNode = RestUtils.findTreeNode(context);
        }
        boolean bl = false;
        if (navigatorTreeNode != null && (list = navigatorTreeNode.getChildCount() > 0 ? RestUtils.getChildrenNames(navigatorTreeNode) : this.getHandlers(context)) != null) {
            for (String string2 : list) {
                if (!string2.toUpperCase().equals(string)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            URL uRL = context.getNode().getURL();
            if (uRL != null) {
                String string2;
                string2 = this.getTemplateMethodId(uRL, string);
                bl = this.handlerMethodExistInEditor(string2);
            } else {
                bl = true;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Missing Template URL");
            }
        }
        return bl;
    }

    private boolean restObjExists(int n, Context context) {
        Element element = null;
        element = context.getNode() instanceof IViewerNode ? ((IViewerNode)context.getNode()).getDBObject().getElement() : context.getElement();
        if (element != null) {
            if (element instanceof ObjectNode) {
                return true;
            }
            if (element instanceof ObjectFolder) {
                ObjectFolder objectFolder = (ObjectFolder)element;
                NavigatorTreeNode navigatorTreeNode = null;
                navigatorTreeNode = context.getNode() instanceof IViewerNode ? RestUtils.findTreeNode(objectFolder.getURL()) : RestUtils.findTreeNode(context);
                if (navigatorTreeNode != null && navigatorTreeNode.getChildCount() > 0) {
                    return true;
                }
                try {
                    List list;
                    DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
                    if (dBFolderInstance != null && (list = dBFolderInstance.listChildren()).size() > 0) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        block15: {
            int n = ideAction.getCommandId();
            try {
                if (n == NEW_PRIVILEGE_ID) {
                    this.createPrivilege(context);
                    break block15;
                }
                if (n == NEW_MODULE_ID) {
                    this.createModuleViaWizard(context);
                    break block15;
                }
                if (n == ADD_TEMPLATE_ID) {
                    this.createTemplate(context);
                    break block15;
                }
                if (n == ADD_GET_HANDLER_ID) {
                    this.createHandler(context, RestResourceHandler.HTTP_METHOD_TYPE.GET);
                    break block15;
                }
                if (n == ADD_POST_HANDLER_ID) {
                    this.createHandler(context, RestResourceHandler.HTTP_METHOD_TYPE.POST);
                    break block15;
                }
                if (n == ADD_PUT_HANDLER_ID) {
                    this.createHandler(context, RestResourceHandler.HTTP_METHOD_TYPE.PUT);
                    break block15;
                }
                if (n == ADD_DELETE_HANDLER_ID) {
                    this.createHandler(context, RestResourceHandler.HTTP_METHOD_TYPE.DELETE);
                    break block15;
                }
                if (n == NEW_ROLE_ID) {
                    this.createRole(context);
                    break block15;
                }
                if (n == EDIT_ID) {
                    this.edit(context);
                    break block15;
                }
                if (n == RENAME_ID) {
                    this.rename(context);
                    break block15;
                }
                if (n == DELETE_ID) {
                    this.delete(context);
                    break block15;
                }
                if (n == VALIDATE_ID) {
                    this.validate(context, true);
                    break block15;
                }
                if (n == EXPORT_ID || n == SAVE_TO_WORKSHEET_ID || n == SAVE_TO_CLIPBOARD_ID) {
                    this.export(context, n);
                    break block15;
                }
                return false;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        try {
            boolean bl2 = this.isTaskRunning();
            int n = ideAction.getCommandId();
            if (n == EDIT_ID || n == RENAME_ID || n == VALIDATE_ID) {
                ideAction.setEnabled(true);
                bl = true;
            } else if (n == DELETE_ID) {
                ideAction.setEnabled(!bl2);
                bl = true;
            } else if (n == NEW_MODULE_ID || n == ADD_TEMPLATE_ID) {
                ideAction.setEnabled(true);
                bl = true;
            } else if (n == NEW_PRIVILEGE_ID || n == NEW_ROLE_ID) {
                ideAction.setEnabled(true);
                bl = true;
            } else if (n == ADD_GET_HANDLER_ID || n == ADD_POST_HANDLER_ID || n == ADD_PUT_HANDLER_ID || n == ADD_DELETE_HANDLER_ID) {
                boolean bl3 = this.handlerExists(n, context);
                ideAction.setEnabled(!bl3);
                bl = true;
            } else if (n == EXPORT_ID || n == SAVE_TO_WORKSHEET_ID || n == SAVE_TO_CLIPBOARD_ID) {
                boolean bl4 = this.restObjExists(n, context);
                ideAction.setEnabled(bl4);
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return true;
        }
    }

    public void invokeEditor(URL uRL) {
        RestHandlerEditorNode restHandlerEditorNode = this.findEditorNode(uRL);
        if (restHandlerEditorNode == null) {
            restHandlerEditorNode = this.createHandlerEditorNode(uRL);
            if (restHandlerEditorNode != null) {
                this.showEditor(restHandlerEditorNode, false);
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Cannot invoke REST Handler editor.");
            }
        } else {
            this.showEditor(restHandlerEditorNode, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void startTask(final RESTTask<T> rESTTask, final RESTHandler<T> rESTHandler) {
        rESTTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                try {
                    rESTHandler.handleCancel();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
                }
                RestDevController.this.clearTask();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                try {
                    rESTHandler.handleFailure();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
                }
                RestDevController.this.clearTask();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    final Object object = rESTTask.getResult();
                    if (object != null) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                rESTHandler.handleTaskFinished(object);
                            }
                        };
                        if (SwingUtilities.isEventDispatchThread()) {
                            runnable.run();
                        } else {
                            SwingUtilities.invokeLater(runnable);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
                }
                RestDevController.this.clearTask();
            }
        });
        Object object = this.taskLock;
        synchronized (object) {
            RaptorTaskManager.getInstance().addTask(rESTTask);
            this._backgroundTask = rESTTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTaskRunning() {
        Object object = this.taskLock;
        synchronized (object) {
            return this._backgroundTask != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTask() {
        Object object = this.taskLock;
        synchronized (object) {
            this._backgroundTask = null;
        }
    }

    private static abstract class RESTTask<V>
    extends RaptorTask<V> {
        protected RESTTask(String string) {
            super(string, true, IRaptorTaskRunMode.MODAL_OPTIONAL);
            this.setCancellable(false);
            this.setPausable(false);
        }
    }

    private static abstract class RESTHandler<V> {
        private RESTHandler() {
        }

        protected abstract void handleTaskFinished(V var1);

        protected void handleCancel() {
        }

        protected void handleFailure() {
        }
    }
}

