/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.patterns;

import oracle.dbtools.rest.patterns.GlobPattern;
import oracle.dbtools.rest.patterns.PathToken;
import oracle.dbtools.rest.patterns.PathTokenPattern;
import oracle.dbtools.rest.utils.RestUtils;

class GlobPatternImpl
extends PathTokenPattern
implements GlobPattern {
    GlobPatternImpl(Iterable<PathToken> iterable) {
        super(iterable);
        if (RestUtils.nullOrEmpty(iterable)) {
            throw new IllegalStateException("Empty glob pattern is not allowed");
        }
    }

    static class Builder
    extends PathTokenPattern.Builder
    implements GlobPattern.Builder {
        Builder() {
        }

        @Override
        public Builder addFile(CharSequence charSequence) {
            super.addFile(charSequence);
            return this;
        }

        @Override
        public Builder addFolder(CharSequence charSequence) {
            super.addFolder(charSequence);
            return this;
        }

        @Override
        public Builder addGlob() {
            this.add(PathToken.glob());
            return this;
        }

        @Override
        public GlobPattern build() {
            return new GlobPatternImpl(this.tokens());
        }

        @Override
        protected void validate(PathToken.Type type, PathToken pathToken) {
            if (type == null || PathToken.Type.SEPARATOR == type) {
                this.expect(pathToken, PathToken.Type.LITERAL, PathToken.Type.GLOB);
            } else if (type == PathToken.Type.GLOB) {
                this.expect(pathToken, new PathToken.Type[]{null});
            } else if (type == PathToken.Type.LITERAL) {
                this.expect(pathToken, PathToken.Type.SEPARATOR);
            }
        }
    }
}

