/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.Map;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.util.AutoBastionUtil;
import org.apache.hc.core5.http.ParseException;

public class BastionSession {
    private static String publicKey = null;
    private static String bastionSessionBody = null;
    private static String sessionReqResponse = null;
    private static OCIRESTClient client = null;
    private static String region = null;
    private static String bastionId = null;
    private static String connOCID = null;

    public BastionSession(String connOCID, OCIRESTClient client, String region, String bastionId, String publicKey) throws IOException, GeneralSecurityException, ParseException {
        BastionSession.connOCID = connOCID;
        BastionSession.client = client;
        BastionSession.region = region;
        BastionSession.bastionId = bastionId;
        BastionSession.publicKey = publicKey;
        AutoBastionUtil autoBastionUtil = new AutoBastionUtil(connOCID, client, region);
        this.createBastionSessionReqBody(autoBastionUtil.getDatabasePort(), autoBastionUtil.getDbEndpointIP(), bastionId);
    }

    private void createBastionSessionReqBody(String databasePort, String databaseIP, String bastionId) throws IOException {
        JsonFactory f = new JsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator g = f.createGenerator((Writer)writer);
        g.writeStartObject();
        g.writeObjectFieldStart("targetResourceDetails");
        g.writeStringField("targetResourcePort", databasePort);
        g.writeStringField("targetResourcePrivateIpAddress", databaseIP);
        g.writeStringField("sessionType", "PORT_FORWARDING");
        g.writeEndObject();
        g.writeStringField("bastionId", bastionId);
        g.writeObjectFieldStart("keyDetails");
        g.writeStringField("publicKeyContent", publicKey);
        g.writeEndObject();
        g.writeStringField("displayName", "BastionSqlclSession");
        g.writeStringField("keyType", "PUB");
        g.writeEndObject();
        g.close();
        bastionSessionBody = ((Object)writer).toString();
    }

    private void createBastionSession() throws GeneralSecurityException, IOException, ParseException {
        String bastionSessionHost = "bastion." + region + ".oci.oraclecloud.com";
        OCIRequest req = new OCIRequest.Builder().host(bastionSessionHost).method("post").contentType("application/json").body(bastionSessionBody).target("/20210331/sessions").build();
        sessionReqResponse = client.getString(req);
    }

    public String getBastionSessionId() throws IOException, GeneralSecurityException, ParseException {
        this.createBastionSession();
        JSON j = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
        Map map = j.mapFrom((Object)sessionReqResponse);
        return (String)map.get("id");
    }
}

