/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.OracleOciStorageLocation;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.transfer.utility.TransferException;
import oracle.dbtools.util.Logger;

public class StoreAndForwardStorageLocation
extends Location {
    private static final Class<?> clazz = OracleOciStorageLocation.class;
    private CloudStorageUrl storageUrl;
    private String profile;
    private String credential;
    private static final int PIPE_SIZE = 8192;
    private List<BusyTaskListener> _taskListeners = new ArrayList<BusyTaskListener>();
    private static DecimalFormat df = new DecimalFormat("#00.0000");

    public StoreAndForwardStorageLocation(CloudStorageUrl storageUrl, String profile) {
        this.storageUrl = storageUrl;
        this.profile = profile;
    }

    public StoreAndForwardStorageLocation(CloudStorageUrl storageUrl, String credential, Connection conn) {
        this.storageUrl = storageUrl;
        this.credential = credential;
    }

    private OutputStream asOutputStreamTemp(CloudStorageUrl target) throws IOException {
        OutputStream out = null;
        return out;
    }

    public OutputStream asOutputStream(final Path path, UserTaskListener aListener) throws IOException {
        Logger.info(this.getClass(), (String)String.valueOf(path));
        OutputStream os = null;
        final UserTaskListener listener = aListener;
        try {
            final CloudStorageUrl targetCsu = this.getTargetUrl(path);
            targetCsu.validateUrlAsObject();
            Path tempPath = FileSystems.getDefault().getPath(System.getProperty("java.io.tmpdir"), targetCsu.getNameSpace() + "_" + targetCsu.getBucket() + "_" + targetCsu.getObject());
            final File tempFile = tempPath.toFile();
            os = new FileOutputStream(tempFile);
            os = new FilterOutputStream(os){

                @Override
                public void close() throws IOException {
                    super.close();
                    String name = String.valueOf(targetCsu.getFinalUrlAsOCI().getPath());
                    RaptorTask<Void> task = new RaptorTask<Void>(name, true, IRaptorTaskRunMode.NO_GUI){

                        protected Void doWork() throws TaskException {
                            int retry = 3;
                            while (retry != 0) {
                                try {
                                    String target = null == path ? null : path.toString();
                                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(tempFile));
                                    StoreAndForwardStorageLocation.this.copy(is, target);
                                    retry = 0;
                                }
                                catch (Throwable t) {
                                    if (t instanceof TransferException) {
                                        if (--retry != 0) continue;
                                        throw new TaskException(t);
                                    }
                                    if (t instanceof TaskException) {
                                        throw (TaskException)t;
                                    }
                                    throw new TaskException(t);
                                }
                            }
                            return null;
                        }
                    };
                    if (listener != null) {
                        task.getDescriptor().addListener((IRaptorTaskListener)new UserTaskListenerWrapper(listener){

                            @Override
                            public void done() {
                                super.done();
                                tempFile.delete();
                            }
                        });
                    } else {
                        task.getDescriptor().addListener((IRaptorTaskListener)new UserTaskListener(){

                            @Override
                            public void done() {
                                super.done();
                                tempFile.delete();
                            }
                        });
                    }
                    BusyTaskListener ourListener = new BusyTaskListener();
                    task.getDescriptor().addListener((IRaptorTaskListener)ourListener);
                    RaptorTaskManager.getInstance().addTask((RaptorTask)task);
                }
            };
        }
        catch (Throwable t) {
            throw StoreAndForwardStorageLocation.asIOException(t);
        }
        return os;
    }

    public OutputStream asOutputStreamOrig(final Path path, UserTaskListener aListener) throws IOException {
        Logger.info(this.getClass(), (String)String.valueOf(path));
        PipedOutputStream os = null;
        UserTaskListener listener = aListener;
        try {
            CloudStorageUrl targetUrl = this.getTargetUrl(path);
            targetUrl.validateUrlAsObject();
            final PipedInputStream is = new PipedInputStream(8192);
            os = new PipedOutputStream(is){

                @Override
                public void close() throws IOException {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {
                        Logger.ignore(this.getClass(), (Throwable)e);
                    }
                    super.close();
                }
            };
            String name = String.valueOf(targetUrl.getFinalUrlAsOCI().getPath());
            RaptorTask<Void> task = new RaptorTask<Void>(name, true, IRaptorTaskRunMode.NO_GUI){

                protected Void doWork() throws TaskException {
                    try {
                        String target = null == path ? null : path.toString();
                        StoreAndForwardStorageLocation.this.copy(is, target);
                    }
                    catch (Throwable t) {
                        if (t instanceof TaskException) {
                            throw (TaskException)t;
                        }
                        throw new TaskException(t);
                    }
                    return null;
                }
            };
            if (listener != null) {
                task.getDescriptor().addListener((IRaptorTaskListener)listener);
            }
            BusyTaskListener ourListener = new BusyTaskListener();
            task.getDescriptor().addListener((IRaptorTaskListener)ourListener);
            RaptorTaskManager.getInstance().addTask((RaptorTask)task);
            ourListener.waitForStart();
        }
        catch (Throwable t) {
            throw StoreAndForwardStorageLocation.asIOException(t);
        }
        return os;
    }

    protected static String describe(RaptorTaskEvent event) {
        return StoreAndForwardStorageLocation.describe(event.getTaskDescriptor());
    }

    protected static String describe(BusyTaskListener listener) {
        return StoreAndForwardStorageLocation.describe(listener.getTaskDescriptor());
    }

    protected static String describe(RaptorTaskDescriptor rtd) {
        String msg = rtd.getMessage();
        String desc = String.format("\n    %s %s %s\n", rtd.getName(), rtd.getStatus(), null == msg ? "" : msg);
        return desc;
    }

    protected CloudStorageUrl getTargetUrl(Path path) throws IOException {
        return this.getTargetUrl(null == path ? null : path.toString().replace("\\", "/"));
    }

    protected CloudStorageUrl getTargetUrl(String path) throws IOException {
        try {
            if (path != null && !path.isEmpty()) {
                CloudStorageUrl targetUrl = new CloudStorageUrl(this.storageUrl.getFinalUrl());
                targetUrl.qualifiedUrl(path);
                return targetUrl;
            }
        }
        catch (Throwable t) {
            throw StoreAndForwardStorageLocation.asIOException(t);
        }
        return this.storageUrl;
    }

    @Override
    public ScriptOutput logExecuteScript(String tagName, String executeScriptStr, String scriptName, String targetDir) {
        return super.logExecuteScript(tagName, executeScriptStr, scriptName, targetDir);
    }

    @Override
    public ScriptOutput executeScript(String executeScriptStr, String scriptName, String targetDir) {
        return super.executeScript(executeScriptStr, scriptName, targetDir);
    }

    @Override
    public String toString() {
        String url = this.storageUrl.toString();
        try {
            url = String.valueOf(this.storageUrl.getFinalUrl());
        }
        catch (Throwable t) {
            Logger.ignore(this.getClass(), (Throwable)t);
        }
        return (this.profile != null ? this.profile : this.credential) + "@" + url + " " + super.toString();
    }

    @Override
    public boolean doPreProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException {
        return super.doPreProcessing(transferId, fileInfos, targetDir);
    }

    @Override
    public void doPostProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException, TransferRestartRequest {
        super.doPostProcessing(transferId, fileInfos, targetDir);
    }

    protected boolean hasTask() {
        return !this._taskListeners.isEmpty();
    }

    protected String listTasks() {
        StringBuilder buf = new StringBuilder();
        for (BusyTaskListener listener : this._taskListeners) {
            buf.append(StoreAndForwardStorageLocation.describe(listener)).append('\n');
        }
        return buf.toString();
    }

    private void removeTask(BusyTaskListener task) {
        this._taskListeners.remove((Object)task);
    }

    private void addTask(BusyTaskListener task) {
        this._taskListeners.add(task);
    }

    private static String fileToString(String filePath) {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }

    protected class BusyTaskListener
    extends RaptorTaskAdapter {
        private boolean started;
        private RaptorTaskDescriptor taskDescriptor;

        protected BusyTaskListener() {
        }

        public boolean hasStarted() {
            return this.started;
        }

        public void waitForStart() throws InterruptedException {
            while (!this.hasStarted()) {
                Thread.sleep(250L);
            }
        }

        protected RaptorTaskDescriptor getTaskDescriptor() {
            return this.taskDescriptor;
        }

        public void stateChanged(RaptorTaskEvent event) {
            super.stateChanged(event);
            this.taskDescriptor = event.getTaskDescriptor();
        }

        public void taskScheduled(RaptorTaskEvent event) {
            Logger.info(clazz, (String)StoreAndForwardStorageLocation.describe(event));
            StoreAndForwardStorageLocation.this.addTask(this);
        }

        public void taskRunning(RaptorTaskEvent event) {
            this.started = true;
        }

        public void taskCancelled(RaptorTaskEvent event) {
            Logger.info(clazz, (String)StoreAndForwardStorageLocation.describe(event));
            this.done();
        }

        public void taskFailed(RaptorTaskEvent event) {
            Logger.info(clazz, (String)StoreAndForwardStorageLocation.describe(event), (Throwable)event.getThrowable());
            this.done();
        }

        public void taskFinished(RaptorTaskEvent event) {
            Logger.info(clazz, (String)StoreAndForwardStorageLocation.describe(event));
            this.done();
        }

        protected void done() {
            StoreAndForwardStorageLocation.this.removeTask(this);
        }
    }

    public static class UserTaskListenerWrapper
    extends UserTaskListener {
        UserTaskListener delegate;

        public UserTaskListenerWrapper(UserTaskListener listener) {
            this.delegate = listener;
        }

        @Override
        public void done() {
            this.delegate.done();
        }

        public void taskPaused(RaptorTaskEvent event) {
            this.delegate.taskPaused(event);
        }

        public void taskScheduled(RaptorTaskEvent event) {
            this.delegate.taskScheduled(event);
        }

        public void messageChanged(RaptorTaskEvent event) {
            this.delegate.messageChanged(event);
        }

        public void progressChanged(RaptorTaskEvent event) {
            this.delegate.progressChanged(event);
        }

        public String toString() {
            return super.toString() + "[delegate=" + ((Object)((Object)this.delegate)).toString() + "]";
        }

        @Override
        public Throwable getThrowable() {
            return this.delegate.getThrowable();
        }

        @Override
        public boolean hasStarted() {
            return this.delegate.hasStarted();
        }

        @Override
        public void waitForStart() throws InterruptedException {
            this.delegate.waitForStart();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public void waitForDone() throws InterruptedException {
            this.delegate.waitForDone();
        }

        @Override
        public IRaptorTaskStatus getStatus() {
            return this.delegate.getStatus();
        }

        @Override
        public void taskRunning(RaptorTaskEvent event) {
            this.delegate.taskRunning(event);
        }

        @Override
        public void stateChanged(RaptorTaskEvent event) {
            this.delegate.stateChanged(event);
        }

        @Override
        public void taskCancelled(RaptorTaskEvent event) {
            this.delegate.taskCancelled(event);
        }

        @Override
        public void taskFailed(RaptorTaskEvent event) {
            this.delegate.taskFailed(event);
        }

        @Override
        public void taskFinished(RaptorTaskEvent event) {
            this.delegate.taskFinished(event);
        }
    }

    public static class UserTaskListener
    extends RaptorTaskAdapter {
        private Throwable _taskThrowable;
        private boolean started;
        private boolean done;
        private IRaptorTaskStatus _status;

        public Throwable getThrowable() {
            return this._taskThrowable;
        }

        public boolean hasStarted() {
            return this.started;
        }

        public void waitForStart() throws InterruptedException {
            while (!this.hasStarted()) {
                Thread.sleep(250L);
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public void waitForDone() throws InterruptedException {
            while (!this.isDone()) {
                Thread.sleep(250L);
            }
        }

        public IRaptorTaskStatus getStatus() {
            return this._status;
        }

        public void taskRunning(RaptorTaskEvent event) {
            this.started = true;
        }

        public void stateChanged(RaptorTaskEvent event) {
            super.stateChanged(event);
            this._status = event.getTaskDescriptor().getStatus();
        }

        public void taskCancelled(RaptorTaskEvent event) {
            Logger.info(clazz, (String)StoreAndForwardStorageLocation.describe(event));
            this.done();
        }

        public void taskFailed(RaptorTaskEvent event) {
            Logger.info(clazz, (String)StoreAndForwardStorageLocation.describe(event), (Throwable)event.getThrowable());
            this._taskThrowable = event.getThrowable();
            this.done();
        }

        public void taskFinished(RaptorTaskEvent event) {
            Logger.info(clazz, (String)StoreAndForwardStorageLocation.describe(event));
            this.done();
        }

        public void done() {
            this.done = true;
        }
    }
}

