/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.transfer.TransferManager;
import oracle.dbtools.transfer.TransferMessages;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.OracleOciStorageLocation;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.ContentLengthInputStream;
import oracle.dbtools.transfer.utility.InputStreamLoggingWrapper;
import oracle.dbtools.transfer.utility.InputStreamProgressWrapper;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.transfer.utility.RunnableTimer;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.transfer.utility.SimpleByteProgressMonitor;
import oracle.dbtools.util.Logger;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BFILE;

public class OracleDbDirectoryLocation
extends Location {
    private String connName;
    private Connection conn = null;
    private boolean lock;
    static final boolean LOG_STREAMS = true;
    private static QueryXMLSupport _queries;
    private static final String UTLFILE_FOPEN = "utlFile_fopen";
    private static final String UTLFILE_PUTRAW = "utlFile_putRaw";
    private static final String UTLFILE_GETRAW = "utlFile_getRaw";
    private static final String UTLFILE_FCLOSE = "utlFile_fclose";
    private static final String UTLFILE_FREMOVE = "utlFile_fremove";
    private static final String DBDIRECTORY_PUT = "dbDirectory_put";
    private static final String DBDIRECTORY_GET = "dbDirectory_get";
    private static final String BFILENAME = "bfilename";
    private static String dirPath;
    private static String fileName2;
    private static String filePath2;
    private static DecimalFormat df;
    private static String NAMESPACE_URL;
    private static String PROFILE;
    private static String BUCKET;
    private static String OBJECT;

    public OracleDbDirectoryLocation(Connection conn) {
        assert (conn != null);
        this.conn = conn;
        OracleDbDirectoryLocation.getXMLQueries();
    }

    @Override
    public boolean isCloneable() {
        return false;
    }

    @Override
    public Location clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectImpl() throws IOException {
        try {
            if (null == this.conn || this.conn.isClosed()) {
                throw new IOException();
            }
        }
        catch (Throwable t) {
            String msg = TransferMessages.getString("DbmsCloud_CONN_NOT_AVAILABLE");
            Logger.severe(this.getClass(), (String)msg, (Throwable)t);
            throw new IOException(msg, t);
        }
    }

    @Override
    public InputStream asInputStream(Path path, long position, long size) throws IOException {
        return this.asInputStream(path, position, size, null);
    }

    private InputStream asInputStream(Path path, long position, long size, TransferTaskProgressMonitor progressMonitor) throws IOException {
        InputStream in;
        block21: {
            Logger.info(this.getClass(), (String)String.format("%s:%d,%d", path, position, size));
            in = null;
            try {
                String loc = path.toString().replace("\\", "/");
                String[] locParts = loc.split("/");
                if (locParts.length != 2) {
                    String fmt = "Invalid path \"%s\". Format is DIRECTORY/file.";
                    String msg = String.format(fmt, path.toString());
                    throw new IOException(msg);
                }
                String directory = locParts[0];
                String filename = locParts[1];
                if (this.conn == null) {
                    throw new IOException(TransferMessages.getString("DbmsCloud_CON_REQ"));
                }
                this.lock = LockManager.lock((Connection)this.conn);
                if (!this.lock) {
                    throw new IOException(TransferMessages.getString("DbmsCloud_CONN_NOT_AVAILABLE"));
                }
                String call = _queries.getQuery(BFILENAME, this.conn).getSql();
                if (call == null) {
                    throw new IOException(TransferMessages.format("DbDirectory_CANT_FIND_SQL", BFILENAME));
                }
                try (OracleCallableStatement stmt = (OracleCallableStatement)this.conn.prepareCall(call);){
                    stmt.registerOutParameter(1, -13);
                    stmt.setString(2, directory);
                    stmt.setString(3, filename);
                    stmt.execute();
                    BFILE f = stmt.getBfile(1);
                    if (f.fileExists()) {
                        f.open(LargeObjectAccessMode.MODE_READONLY);
                        in = f.getBinaryStream();
                        if (in != null) {
                            in = new ContentLengthInputStream(in, (int)f.length());
                            in = new InputStreamLoggingWrapper(in);
                            in = new FilterInputStream(in, (OracleBfile)f){
                                final /* synthetic */ OracleBfile val$f;
                                {
                                    this.val$f = oracleBfile;
                                    super(in);
                                }

                                @Override
                                public void close() throws IOException {
                                    super.close();
                                    try {
                                        this.val$f.close();
                                    }
                                    catch (SQLException e) {
                                        Logger.ignore(this.getClass(), (Throwable)e);
                                    }
                                }
                            };
                            if (progressMonitor != null) {
                                in = new InputStreamProgressWrapper(in, progressMonitor, size);
                            }
                        }
                        break block21;
                    }
                    throw new IOException(TransferMessages.format("DbDirectory_FILE_NOT_FOUND", filename, directory));
                }
                catch (Throwable e) {
                    throw OracleDbDirectoryLocation.asIOException(e);
                }
            }
            catch (Throwable t) {
                throw OracleDbDirectoryLocation.asIOException(t);
            }
            finally {
                if (this.lock) {
                    LockManager.unlock((Connection)this.conn);
                }
            }
        }
        return in;
    }

    @Override
    public long copy(InputStream in, String target, TransferTaskProgressMonitor progressMonitor, CopyOption ... options) throws IOException {
        Logger.info(this.getClass(), (String)target);
        long length = 0L;
        try {
            String loc = target.replace("\\", "/");
            String[] locParts = loc.split("/");
            if (locParts.length != 2) {
                String fmt = "Invalid target \"$s\". Format is DIRECTORY/file.";
                String msg = String.format(fmt, target);
                throw new IOException(msg);
            }
            String directory = locParts[0];
            String filename = locParts[1];
            if (this.conn == null) {
                throw new UnsupportedOperationException("Connection is required");
            }
            this.lock = LockManager.lock((Connection)this.conn);
            if (!this.lock) {
                throw new IOException(TransferMessages.getString("DbmsCloud_CONN_NOT_AVAILABLE"));
            }
            String call = _queries.getQuery(DBDIRECTORY_PUT, this.conn).getSql();
            if (call == null) {
                throw new IOException(TransferMessages.format("DbDirectory_CANT_FIND_SQL", DBDIRECTORY_PUT));
            }
            in = new InputStreamLoggingWrapper(in);
            if (progressMonitor != null) {
                in = new InputStreamProgressWrapper(in, progressMonitor, in.available());
            }
            try (CallableStatement stmt = this.conn.prepareCall(call);){
                stmt.setBlob(1, in);
                stmt.setString(2, directory);
                stmt.setString(3, filename);
                stmt.execute();
            }
            catch (Throwable t) {
                throw OracleDbDirectoryLocation.asIOException(t);
            }
        }
        catch (Throwable t) {
            throw OracleDbDirectoryLocation.asIOException(t);
        }
        finally {
            if (this.lock) {
                LockManager.unlock((Connection)this.conn);
            }
        }
        return length;
    }

    @Override
    public void delete(String target) throws IOException {
        Logger.info(this.getClass(), (String)target);
        try {
            String loc = target.replace("\\", "/");
            String[] locParts = loc.split("/");
            if (locParts.length != 2) {
                String fmt = "Invalid target \"$s\". Format is DIRECTORY/file.";
                String msg = String.format(fmt, target);
                throw new IOException(msg);
            }
            String directory = locParts[0];
            String filename = locParts[1];
            if (this.conn == null) {
                throw new UnsupportedOperationException("Connection is required");
            }
            this.lock = LockManager.lock((Connection)this.conn);
            if (!this.lock) {
                throw new IOException(TransferMessages.getString("DbmsCloud_CONN_NOT_AVAILABLE"));
            }
            String call = _queries.getQuery(UTLFILE_FREMOVE, this.conn).getSql();
            if (call == null) {
                throw new IOException(TransferMessages.format("DbDirectory_CANT_FIND_SQL", UTLFILE_FREMOVE));
            }
            CallableStatement stmt = this.conn.prepareCall(call);
            stmt.setString("LOCATION", directory);
            stmt.setString("FILENAME", filename);
            stmt.execute();
        }
        catch (Throwable t) {
            throw OracleDbDirectoryLocation.asIOException(t);
        }
        finally {
            if (this.lock) {
                LockManager.unlock((Connection)this.conn);
            }
        }
    }

    @Override
    public ScriptOutput logExecuteScript(String tagName, String executeScriptStr, String scriptName, String targetDir) {
        throw new UnsupportedOperationException(TransferMessages.format("TransferUnsupportedOp", "logExecuteScript"));
    }

    @Override
    public ScriptOutput executeScript(String executeScriptStr, String scriptName, String targetDir) {
        throw new UnsupportedOperationException(TransferMessages.format("TransferUnsupportedOp", "executeScript"));
    }

    @Override
    public MD5 getMd5(Path path, long offset, long size) {
        throw new UnsupportedOperationException(TransferMessages.format("TransferUnsupportedOp", "getMD5"));
    }

    @Override
    public String toString() {
        return this.connName + " " + super.toString();
    }

    @Override
    public boolean doPreProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException {
        return super.doPreProcessing(transferId, fileInfos, targetDir);
    }

    private static synchronized QueryXMLSupport getXMLQueries() {
        if (_queries == null) {
            _queries = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(OracleDbDirectoryLocation.class.getClassLoader(), "oracle/dbtools/transfer/location/OracleDbDirectoryQueries.xml"));
        }
        return _queries;
    }

    public static void main(String[] args) {
        TransferManager.INSTANCE.setPackageLogStream(System.out, false);
        TransferManager.INSTANCE.setPackageLogLevel(Level.INFO);
        Location loc = null;
        try {
            Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521/orcl", "system", "oracle");
            loc = new OracleDbDirectoryLocation(conn);
            ((OracleDbDirectoryLocation)loc).testOciStorageIO("DATA_PUMP_DIR", filePath2, PROFILE, NAMESPACE_URL, BUCKET);
        }
        catch (Throwable t) {
            Logger.severe(OracleDbDirectoryLocation.class, (Throwable)t);
        }
        finally {
            if (loc != null) {
                loc.disconnect();
            }
        }
    }

    private void testRoundTripIO(String directory) throws IOException {
        String tag = String.format("testRoundTripIO(\"%s\")", directory);
        Logger.info(this.getClass(), (String)tag);
        File file = File.createTempFile("testRoundTripIO", ".pangram");
        String filename = file.getName();
        file.delete();
        String out = "The wizard quickly jinxed the gnomes before they vaporized\n";
        ByteArrayInputStream source = new ByteArrayInputStream(out.getBytes(StandardCharsets.UTF_8));
        String target = directory + "/" + filename;
        this.copy(source, target, new SimpleByteProgressMonitor(FileInfo.CHUNK_SIZE), StandardCopyOption.REPLACE_EXISTING);
        Path path = Paths.get(target, new String[0]);
        InputStream in = this.asInputStream(path, 0L, 0L, new SimpleByteProgressMonitor(FileInfo.CHUNK_SIZE));
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                sb.append((char)c);
            }
        }
        if (!out.equals(sb.toString())) {
            throw new IOException(String.format("testRoundTripIO failed. '%s' != '%s'\n", out, sb.toString()));
        }
        Logger.info(this.getClass(), (String)String.format("testRoundTripIO passed. '%s' == '%s'\n", out, sb.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFileRoundTripIO(String directory, String filePath) {
        String tag = String.format("testFileRoundTripIO(\"%s\", \"%s\")", directory, filePath);
        Logger.info(this.getClass(), (String)tag);
        try {
            File file = new File(filePath);
            URL fileURL = file.toURI().toURL();
            String objectName = this.getClass().getSimpleName() + "-" + file.getName();
            InputStream source = fileURL.openStream();
            String target = directory + "/" + objectName;
            long start = System.nanoTime();
            this.copy(source, target, new SimpleByteProgressMonitor(FileInfo.CHUNK_SIZE), StandardCopyOption.REPLACE_EXISTING);
            long now = System.nanoTime();
            long duration = now - start;
            double elapsed = (double)duration / 1.0E9;
            Logger.info(this.getClass(), (String)(file.getName() + " Upload Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
            start = System.nanoTime();
            try (InputStream in = this.asInputStream(Paths.get(directory, objectName), 0L, 0L, new SimpleByteProgressMonitor(FileInfo.CHUNK_SIZE));
                 FileOutputStream os = new FileOutputStream(filePath + "-" + this.getClass().getSimpleName());){
                int l;
                byte[] buffer = new byte[Short.MAX_VALUE];
                while ((l = in.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, l);
                }
                os.flush();
            }
            now = System.nanoTime();
            duration = now - start;
            elapsed = (double)duration / 1.0E9;
            Logger.info(this.getClass(), (String)(file.getName() + " Download Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
            Logger.info(this.getClass(), (String)"testRoundTripIO complete - check files\n");
        }
        catch (Throwable t) {
            Logger.warn(this.getClass(), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testOciStorageIO(String directory, String filePath, String profile, String namespaceUrl, String bucket) {
        String tag = String.format("testOciStorageIO(\"%s\", \"%s\", \"%s\", \"%s\", \"%s\")", directory, filePath, profile, namespaceUrl, bucket);
        Logger.info(this.getClass(), (String)tag);
        OracleOciStorageLocation storage = null;
        try {
            File file = new File(filePath);
            URL fileURL = file.toURI().toURL();
            String objectName = this.getClass().getSimpleName() + "-" + file.getName();
            InputStream source = fileURL.openStream();
            String target = directory + "/" + objectName;
            long start = System.nanoTime();
            this.copy(source, target, new SimpleByteProgressMonitor(), StandardCopyOption.REPLACE_EXISTING);
            long now = System.nanoTime();
            long duration = now - start;
            double elapsed = (double)duration / 1.0E9;
            Logger.info(this.getClass(), (String)(file.getName() + " Upload Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
            CloudStorageUrl csUrl = new CloudStorageUrl(namespaceUrl);
            storage = new OracleOciStorageLocation(csUrl, profile);
            storage.connect();
            InputStream in = this.asInputStream(Paths.get(directory, objectName), 0L, 0L, new SimpleByteProgressMonitor(FileInfo.CHUNK_SIZE));
            String ociTarget = bucket + "/o/" + objectName;
            start = System.nanoTime();
            storage.copy(in, ociTarget, new SimpleByteProgressMonitor(FileInfo.CHUNK_SIZE), StandardCopyOption.REPLACE_EXISTING);
            now = System.nanoTime();
            duration = now - start;
            elapsed = (double)duration / 1.0E9;
            Logger.info(this.getClass(), (String)(file.getName() + " Copy to oci Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
            in = storage.asInputStream(Paths.get(bucket, "o", objectName), 0L, 0L, new SimpleByteProgressMonitor(FileInfo.CHUNK_SIZE));
            target = target + ".oci";
            start = System.nanoTime();
            this.copy(in, target, new SimpleByteProgressMonitor(FileInfo.CHUNK_SIZE), StandardCopyOption.REPLACE_EXISTING);
            now = System.nanoTime();
            duration = now - start;
            elapsed = (double)duration / 1.0E9;
            Logger.info(this.getClass(), (String)(file.getName() + " Copy to dir Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
            Logger.info(this.getClass(), (String)"testOciStorageIO complete - check files\n");
        }
        catch (Throwable t) {
            Logger.warn(this.getClass(), (Throwable)t);
        }
        finally {
            if (storage != null) {
                storage.disconnect();
            }
        }
    }

    private InputStream getBfileStream(String directory, String filename) throws IOException {
        InputStream in;
        block10: {
            in = null;
            try (Statement stmt = this.conn.createStatement();){
                String query = "SELECT BFILENAME('%s', '%s') FROM dual";
                ResultSet rs = stmt.executeQuery(String.format(query, directory, filename));
                rs.next();
                BFILE f = ((OracleResultSet)rs).getBfile(1);
                rs.close();
                if (f.fileExists()) {
                    f.open(LargeObjectAccessMode.MODE_READONLY);
                    in = f.getBinaryStream();
                    if (in != null) {
                        in = new FilterInputStream(in, (OracleBfile)f){
                            final /* synthetic */ OracleBfile val$f;
                            {
                                this.val$f = oracleBfile;
                                super(in);
                            }

                            @Override
                            public void close() throws IOException {
                                super.close();
                                try {
                                    this.val$f.close();
                                }
                                catch (SQLException e) {
                                    Logger.ignore(this.getClass(), (Throwable)e);
                                }
                            }
                        };
                    }
                    break block10;
                }
                String msg = "File '%s' not found in directory '%s'";
                throw new IOException(String.format(msg, filename, directory));
            }
            catch (Throwable e) {
                throw OracleDbDirectoryLocation.asIOException(e);
            }
        }
        return in;
    }

    static {
        dirPath = "/Users/bjeffrie/SHARED/test/";
        fileName2 = "Bank_Account_or_Service_Complaints.csv";
        filePath2 = dirPath + fileName2;
        df = new DecimalFormat("#00.0000");
        NAMESPACE_URL = "https://objectstorage.us-phoenix-1.oraclecloud.com/n/oraclefreedb";
        PROFILE = "freedb";
        BUCKET = "/b/brian";
        OBJECT = "/o/test.object";
    }
}

