/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.wls;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import oracle.jrf.InternalJrfUtils;
import oracle.jrf.JRFService;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.templates.JRFTemplateHelper;
import oracle.jrf.templates.NamedResource;
import oracle.jrf.wls.WlsServerPlatformSupport;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.EditSessionConfigurationManagerMBean;
import weblogic.management.runtime.EditSessionConfigurationRuntimeMBean;

public class WlsJRFService
extends JRFService {
    private static final String EDIT_SERVICE_MBEAN = "com.bea:Name=EditService,Type=weblogic.management.mbeanservers.edit.EditServiceMBean";
    private static final String PROTOCOL = "wlx";
    private static final String JNDI = "/jndi/";
    private static final String EDITURI = "weblogic.management.mbeanservers.edit";
    private static final String DOMAINURI = "weblogic.management.mbeanservers.domainruntime";
    private Logger logger = Logger.getLogger(JrfUtils.JRF_LOGGER);

    private JMXConnector getJMXConnector(String uri) throws Exception {
        JMXServiceURL serviceUrl = new JMXServiceURL(PROTOCOL, null, 0, JNDI + uri);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        return JMXConnectorFactory.newJMXConnector(serviceUrl, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyJRF(String target) throws Exception {
        String domainDir = JrfUtils.getDomainHome();
        connector.connect();
        try (JMXConnector connector = this.getJMXConnector(EDITURI);){
            MBeanServerConnection conn = connector.getMBeanServerConnection();
            ObjectName es = new ObjectName(EDIT_SERVICE_MBEAN);
            ObjectName cfgMgr = (ObjectName)conn.getAttribute(es, "ConfigurationManager");
            ObjectName cfgRoot = InternalJrfUtils.startEditSession(conn, cfgMgr);
            ObjectName targetMBean = null;
            if ("*".equals(target)) {
                this.applyJRFToAllTargets(conn, cfgMgr, cfgRoot, domainDir);
            } else {
                targetMBean = InternalJrfUtils.lookupMBean(conn, cfgRoot, "lookupServer", target);
                if (targetMBean == null) {
                    targetMBean = InternalJrfUtils.lookupMBean(conn, cfgRoot, "lookupCluster", target);
                    if (targetMBean != null) {
                        this.applyJRFToCluster(conn, cfgMgr, cfgRoot, targetMBean, domainDir);
                    }
                } else {
                    ObjectName clusterMBean = (ObjectName)conn.getAttribute(targetMBean, "Cluster");
                    if (clusterMBean == null) {
                        this.applyJRFToStandaloneServer(conn, cfgMgr, cfgRoot, targetMBean, domainDir);
                    } else {
                        targetMBean = clusterMBean;
                        this.applyJRFToCluster(conn, cfgMgr, cfgRoot, clusterMBean, domainDir);
                    }
                }
                if (targetMBean == null) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10018", new String[]{target}));
                }
            }
            conn.invoke(cfgMgr, "save", null, null);
            InternalJrfUtils.activate(conn, cfgMgr);
        }
    }

    private String getAdminUrlByProtocol(String protocol) throws Exception {
        String AdminUrl = null;
        ServerMBean server = WlsServerPlatformSupport.getAdminServerMBean();
        NetworkAccessPointMBean[] naps = server.getNetworkAccessPoints();
        for (NetworkAccessPointMBean nap : server.getNetworkAccessPoints()) {
            if (!nap.getProtocol().equals(protocol)) continue;
            String ipByNap = nap.getPublicAddress();
            InetAddress address = InetAddress.getByName(ipByNap);
            String resolvedHost = address.getCanonicalHostName();
            AdminUrl = nap.getProtocol() + "://" + resolvedHost + ":" + nap.getPublicPort();
        }
        return AdminUrl;
    }

    @Override
    public String getAdminUrl() throws Exception {
        return this.getAdminUrlByProtocol("t3");
    }

    @Override
    public String getSslAdminUrl() throws Exception {
        return this.getAdminUrlByProtocol("t3s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyJRF(String target, String editSessionName) throws Exception {
        String domainDir = JrfUtils.getDomainHome();
        JMXConnector defaultconnector = this.getJMXConnector(DOMAINURI);
        defaultconnector.connect();
        MBeanServerConnection defaultconn = defaultconnector.getMBeanServerConnection();
        DomainRuntimeServiceMBean domainRuntimeServiceMBean = (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)defaultconn, (ObjectName)new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME));
        DomainRuntimeMBean domainRuntimeMBean = domainRuntimeServiceMBean.getDomainRuntime();
        EditSessionConfigurationManagerMBean editSessionCfgM = domainRuntimeMBean.getEditSessionConfigurationManager();
        EditSessionConfigurationRuntimeMBean editSession = editSessionCfgM.lookupEditSessionConfiguration(editSessionName);
        String newmbeanServer = editSession.getEditSessionServerJndi();
        JMXConnector connector = this.getJMXConnector(newmbeanServer);
        connector.connect();
        MBeanServerConnection conn = connector.getMBeanServerConnection();
        try {
            ObjectName es = new ObjectName(EDIT_SERVICE_MBEAN);
            ObjectName cfgMgr = (ObjectName)conn.getAttribute(es, "ConfigurationManager");
            ObjectName cfgRoot = null;
            boolean isLocked = (Boolean)conn.getAttribute(cfgMgr, "Editor");
            cfgRoot = (ObjectName)conn.invoke(cfgMgr, "startEdit", new Object[]{60000, 120000}, new String[]{"java.lang.Integer", "java.lang.Integer"});
            ObjectName targetMBean = null;
            if ("*".equals(target)) {
                this.applyJRFToAllTargets(conn, cfgMgr, cfgRoot, domainDir);
            } else {
                targetMBean = InternalJrfUtils.lookupMBean(conn, cfgRoot, "lookupServer", target);
                if (targetMBean == null) {
                    targetMBean = InternalJrfUtils.lookupMBean(conn, cfgRoot, "lookupCluster", target);
                    if (targetMBean != null) {
                        this.applyJRFToCluster(conn, cfgMgr, cfgRoot, targetMBean, domainDir);
                    }
                } else {
                    ObjectName clusterMBean = (ObjectName)conn.getAttribute(targetMBean, "Cluster");
                    if (clusterMBean == null) {
                        this.applyJRFToStandaloneServer(conn, cfgMgr, cfgRoot, targetMBean, domainDir);
                    } else {
                        targetMBean = clusterMBean;
                        this.applyJRFToCluster(conn, cfgMgr, cfgRoot, clusterMBean, domainDir);
                    }
                }
                if (targetMBean == null) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10018", new String[]{target}));
                }
            }
            conn.invoke(cfgMgr, "save", null, null);
            if (!isLocked) {
                InternalJrfUtils.activate(conn, cfgMgr);
            }
        }
        finally {
            defaultconnector.close();
            connector.close();
        }
    }

    private void applyJRFToAllTargets(MBeanServerConnection conn, ObjectName cfgMgr, ObjectName cfgRoot, String domainDir) throws Exception {
        for (ObjectName server : (ObjectName[])conn.getAttribute(cfgRoot, "Servers")) {
            ObjectName cluster = (ObjectName)conn.getAttribute(server, "Cluster");
            if (cluster != null) continue;
            this.applyJRFToStandaloneServer(conn, cfgMgr, cfgRoot, server, domainDir);
        }
        for (ObjectName cluster : (ObjectName[])conn.getAttribute(cfgRoot, "Clusters")) {
            this.applyJRFToCluster(conn, cfgMgr, cfgRoot, cluster, domainDir);
        }
    }

    private void applyJRFToCluster(MBeanServerConnection conn, ObjectName cfgMgr, ObjectName cfgRoot, ObjectName clusterMBean, String domainDir) throws Exception {
        File oraHomeDir = new File(JrfUtils.getCommonComponentsHome());
        this.copyConfigsForCluster(conn, cfgRoot, clusterMBean, domainDir, oraHomeDir);
        this.configureTarget(conn, cfgRoot, clusterMBean, true);
    }

    private void applyJRFToStandaloneServer(MBeanServerConnection conn, ObjectName cfgMgr, ObjectName cfgRoot, ObjectName saServer, String domainDir) throws Exception {
        File oraHomeDir = new File(JrfUtils.getCommonComponentsHome());
        String saServerName = (String)conn.getAttribute(saServer, "Name");
        File serverDir = new File(new File(JrfUtils.getServersConfigDir(domainDir)), saServerName);
        File domainConfigDir = new File(ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory());
        InternalJrfUtils.copyServerConfigTemplateToServerDir(domainConfigDir, oraHomeDir, serverDir);
        this.configureDiagnostics(conn, cfgRoot, saServerName);
        this.configureTarget(conn, cfgRoot, saServer, false);
    }

    private void configureDiagnostics(MBeanServerConnection conn, ObjectName cfgRoot, String serverName) throws Exception {
        Object[] params = new Object[]{serverName};
        String[] signature = new String[]{String.class.getName()};
        ObjectName serverObjName = (ObjectName)conn.invoke(cfgRoot, "lookupServer", params, signature);
        ObjectName diagConfig = (ObjectName)conn.getAttribute(serverObjName, "ServerDiagnosticConfig");
        Attribute diagCtxEnable = new Attribute("DiagnosticContextEnabled", true);
        conn.setAttribute(diagConfig, diagCtxEnable);
        ObjectName webServerObjName = (ObjectName)conn.getAttribute(serverObjName, "WebServer");
        ObjectName webServerLogObjName = (ObjectName)conn.getAttribute(webServerObjName, "WebServerLog");
        Attribute logFormat = new Attribute("LogFileFormat", new String("extended"));
        conn.setAttribute(webServerLogObjName, logFormat);
        Attribute elfFields = new Attribute("ELFFields", new String("date time cs-method ctx-ecid ctx-rid cs-uri sc-status bytes"));
        conn.setAttribute(webServerLogObjName, elfFields);
    }

    private void configureTarget(MBeanServerConnection conn, ObjectName cfgRoot, ObjectName targetMBean, boolean isClusterTarget) throws Exception {
        for (String[] pair : InternalJrfUtils.WL_TYPE_TO_MBEAN_LOOKUPSERVICE) {
            String resourceType = pair[0];
            String lookupService = pair[1];
            List<? extends NamedResource> resources = JRFTemplateHelper.getJRFManagedResourcesFromTemplate(resourceType, JRFTemplateHelper.getJRFTemplateForWLS());
            for (NamedResource namedResource : resources) {
                String compName = namedResource.getName();
                ObjectName comp = InternalJrfUtils.lookupMBean(conn, cfgRoot, lookupService, compName);
                if (comp == null) {
                    this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{resourceType, compName, JrfUtils.getDomainHome()}));
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10017", new String[]{"applyJRF", JrfUtils.getDomainHome()}));
                }
                if (isClusterTarget) {
                    String clusterTargetName = (String)conn.getAttribute(targetMBean, "Name");
                    for (ObjectName server : (ObjectName[])conn.getAttribute(cfgRoot, "Servers")) {
                        String serverClusterName;
                        ObjectName cluster = (ObjectName)conn.getAttribute(server, "Cluster");
                        if (cluster == null || !(serverClusterName = (String)conn.getAttribute(cluster, "Name")).equals(clusterTargetName)) continue;
                        InternalJrfUtils.removeTarget(conn, comp, server);
                    }
                }
                InternalJrfUtils.addTarget(conn, comp, targetMBean);
            }
        }
    }

    private void copyConfigsForCluster(MBeanServerConnection conn, ObjectName cfgRoot, ObjectName clusterMBean, String domainDir, File oraHomeDir) throws Exception {
        String clusterTargetName = (String)conn.getAttribute(clusterMBean, "Name");
        for (ObjectName server : (ObjectName[])conn.getAttribute(cfgRoot, "Servers")) {
            String clusterName;
            ObjectName cluster = (ObjectName)conn.getAttribute(server, "Cluster");
            if (cluster == null || !(clusterName = (String)conn.getAttribute(cluster, "Name")).equals(clusterTargetName)) continue;
            String serverName = (String)conn.getAttribute(server, "Name");
            File serverDir = new File(new File(JrfUtils.getServersConfigDir(domainDir)), serverName);
            File domainConfigDir = new File(ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory());
            InternalJrfUtils.copyServerConfigTemplateToServerDir(domainConfigDir, oraHomeDir, serverDir);
        }
    }

    @Override
    public boolean checkIfJRFApplied(String target) throws Exception {
        return this.checkIfJRFAppliedOnMutipleTargets(new String[]{target}).get(target) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> checkIfJRFAppliedOnMutipleTargets(String[] targets) throws Exception {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        connector.connect();
        try (JMXConnector connector = this.getJMXConnector(DOMAINURI);){
            MBeanServerConnection conn = connector.getMBeanServerConnection();
            ObjectName drs = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
            ObjectName domainConfig = (ObjectName)conn.getAttribute(drs, "DomainConfiguration");
            ResourceChecker startupClassResourceChecker = new ResourceChecker("startup-class", "lookupStartupClass", conn, domainConfig);
            ResourceChecker libraryResourceChecker = new ResourceChecker("library", "lookupLibrary", conn, domainConfig);
            for (String target : targets) {
                try {
                    String configTargetName = target;
                    ObjectName targetServerMBean = (ObjectName)conn.invoke(domainConfig, "lookupServer", new Object[]{target}, new String[]{"java.lang.String"});
                    if (targetServerMBean != null) {
                        ObjectName clu = (ObjectName)conn.getAttribute(targetServerMBean, "Cluster");
                        if (clu != null) {
                            configTargetName = (String)conn.getAttribute(clu, "Name");
                        }
                    } else if (conn.invoke(domainConfig, "lookupCluster", new Object[]{target}, new String[]{"java.lang.String"}) == null) {
                        throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20013", new String[]{target}));
                    }
                    if (!startupClassResourceChecker.checkResourcesOnTarget(configTargetName)) {
                        hm.put(target, 0);
                        continue;
                    }
                    if (!startupClassResourceChecker.checkResourcesOnTarget(configTargetName)) {
                        hm.put(target, 0);
                        continue;
                    }
                    hm.put(target, 1);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20036", new String[]{target, e.getMessage()}));
                    hm.put(target, -1);
                }
            }
        }
        return hm;
    }

    private class ResourceChecker {
        String resourceType;
        String lookupService;
        MBeanServerConnection conn;
        ObjectName domainConfig;
        String missingComponentName;
        Map<String, List<String>> resourceTargets;

        public ResourceChecker(String resourceType, String lookupService, MBeanServerConnection conn, ObjectName domainConfig) {
            this.resourceType = resourceType;
            this.lookupService = lookupService;
            this.conn = conn;
            this.domainConfig = domainConfig;
        }

        public boolean checkResourcesOnTarget(String target) throws Exception {
            if (this.resourceTargets == null) {
                String compName = JRFTemplateHelper.getJRFManagedResourcesFromTemplate(this.resourceType, JRFTemplateHelper.getJRFTemplateForWLS()).get(0).getName();
                if (!this.checkResourceOnTarget(target, compName, this.getResourceTargetsFor(compName))) {
                    WlsJRFService.this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{this.resourceType, compName, target}));
                    return false;
                }
                this.loadResourceTargets();
            }
            for (Map.Entry<String, List<String>> entry : this.resourceTargets.entrySet()) {
                String compName = entry.getKey();
                if (this.checkResourceOnTarget(target, compName, entry.getValue())) continue;
                WlsJRFService.this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{this.resourceType, compName, target}));
                return false;
            }
            return true;
        }

        private boolean checkResourceOnTarget(String target, String compName, List<String> targetStrings) throws Exception {
            if (this.missingComponentName != null) {
                WlsJRFService.this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{this.resourceType, this.missingComponentName, "*"}));
                return false;
            }
            return targetStrings.contains(target);
        }

        private List<String> getResourceTargetsFor(String compName) throws Exception {
            ObjectName comp = (ObjectName)this.conn.invoke(this.domainConfig, this.lookupService, new Object[]{compName}, new String[]{"java.lang.String"});
            if (comp == null) {
                this.missingComponentName = compName;
                return null;
            }
            ObjectName[] targets = (ObjectName[])this.conn.getAttribute(comp, "Targets");
            ArrayList<String> targetStrings = new ArrayList<String>(targets.length);
            for (ObjectName targetMBean : targets) {
                targetStrings.add((String)this.conn.getAttribute(targetMBean, "Name"));
            }
            return targetStrings;
        }

        private void loadResourceTargets() throws Exception {
            List<? extends NamedResource> resources = JRFTemplateHelper.getJRFManagedResourcesFromTemplate(this.resourceType, JRFTemplateHelper.getJRFTemplateForWLS());
            this.resourceTargets = new HashMap<String, List<String>>(resources.size());
            for (NamedResource namedResource : resources) {
                String compName = namedResource.getName();
                this.resourceTargets.put(compName, this.getResourceTargetsFor(compName));
                if (this.missingComponentName == null) continue;
                return;
            }
            this.conn = null;
            this.lookupService = null;
            this.domainConfig = null;
        }
    }
}

