/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain;

import java.sql.Connection;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.interfaces.ICommandSyntax;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.BICModel;
import oracle.dbtools.sqlcl.commands.blockchain.BICOptions;
import oracle.dbtools.sqlcl.commands.blockchain.BICParser;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;

public class ImmutableCommand
extends CommandListener
implements IHelp,
SQLCLService,
Connected,
ICommandSyntax {
    public static final String COMMAND = "immutable_table";
    public static final String COMMAND_S = "im";

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return Messages.getString("IMMUTABLE.DESCRIPTION");
    }

    public String getExtensionName() {
        return COMMAND;
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] ipcmd = cmd.getSql().toLowerCase().split(" ");
        if (!ipcmd[0].trim().equalsIgnoreCase(this.getCommand()) && !ipcmd[0].trim().equalsIgnoreCase(this.getCommandShortName())) {
            return false;
        }
        try {
            BICModel model = new BICModel(conn, ctx, cmd);
            Version currentVersion = new Version(model.getDbVersion());
            if (currentVersion.compareTo(BICOptions.MINIMUM_COMPATIBLE_VERSION) < 0) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_DB_VERSION"), this.getCommand().toUpperCase(), model.getDbVersion())});
            }
            BICParser parser = new BICParser(model, this.getCommand());
            parser.parse();
        }
        catch (BICException e) {
            ctx.writeln(e.getMessage());
        }
        return true;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return COMMAND;
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean needsConnection() {
        return true;
    }

    public String getCommandLongName() {
        return COMMAND;
    }

    public Map<String, Map<String, StandardParameter>> getCommandModel() {
        return null;
    }

    public String getCommandShortName() {
        return COMMAND_S;
    }

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        int lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString());
        HelpPages helpPages = new HelpPagesBuilder(ctx.getEnvironment()).lineSize(lineSize).addHelpContainerFor((Object)this).addPages((Iterable)new CommandPageAssemblers(BICOptions.immutableType, new Type[0])).build();
        return helpPages.get(pagePath);
    }

    public Type getParserType() {
        return BICOptions.immutableType;
    }
}

