/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Optional;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.BICModel;
import oracle.dbtools.sqlcl.commands.blockchain.BICOptions;
import oracle.dbtools.sqlcl.commands.blockchain.BlockchainProcessor;
import oracle.dbtools.sqlcl.commands.blockchain.CertificateProcessor;
import oracle.dbtools.sqlcl.commands.blockchain.DDLProcessor;
import oracle.dbtools.sqlcl.commands.blockchain.ImmutableProcessor;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;

public class BICParser {
    private final BICModel model;
    private final String parserType;
    String command;

    public BICParser(BICModel model, String parserType) {
        this.model = model;
        this.parserType = parserType;
    }

    public void parse() {
        try {
            ParsedCommand parsedCommand;
            Parser parser = this.parserType.equalsIgnoreCase("certificate") ? new Parser(BICOptions.certType, this.model.getContext().getEnvironment()) : (this.parserType.equalsIgnoreCase("immutable_table") ? new Parser(BICOptions.immutableType, this.model.getContext().getEnvironment()) : new Parser(BICOptions.blockchainType, this.model.getContext().getEnvironment()));
            ArrayList errorConsumer = new ArrayList();
            this.command = this.model.getCommand().getSql();
            try {
                Optional opt = parser.parse(this.command, errorConsumer::add);
                if (!opt.isPresent()) {
                    throw new BICException(errorConsumer.toArray(new String[errorConsumer.size()]));
                }
                parsedCommand = (ParsedCommand)opt.get();
            }
            catch (Exception e) {
                throw new BICException(errorConsumer.toArray(new String[errorConsumer.size()]));
            }
            block7 : switch (this.parserType) {
                case "certificate": {
                    switch (parsedCommand.getType().getName()) {
                        case "ADD": {
                            CertificateProcessor.addCertificate(this.model, parsedCommand);
                            break block7;
                        }
                        case "ADD_COPY": {
                            CertificateProcessor.addCopyCertificate(this.model, parsedCommand);
                            break block7;
                        }
                        case "DROP": {
                            CertificateProcessor.dropCertificate(this.model, parsedCommand);
                            break block7;
                        }
                        case "LIST": {
                            CertificateProcessor.listCertificate(this.model);
                            break block7;
                        }
                    }
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_OPTION"), parsedCommand.getType().getName(), this.command)});
                }
                case "immutable_table": {
                    switch (parsedCommand.getType().getName()) {
                        case "ADD_INTERVAL_PARTITIONING": {
                            ImmutableProcessor.addIntPartitioning(this.model, parsedCommand);
                            break block7;
                        }
                        case "DELETE_EXPIRED_ROWS": {
                            ImmutableProcessor.delExpRows(this.model, parsedCommand);
                            break block7;
                        }
                        case "DESC": {
                            DDLProcessor.descTable(this.model, parsedCommand);
                            break block7;
                        }
                    }
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_OPTION"), parsedCommand.getType().getName(), this.command)});
                }
                case "blockchain_table": {
                    switch (parsedCommand.getType().getName()) {
                        case "ADD_INTERVAL_PARTITIONING": {
                            ImmutableProcessor.addIntPartitioning(this.model, parsedCommand);
                            break block7;
                        }
                        case "DESC": {
                            DDLProcessor.descTable(this.model, parsedCommand);
                            break block7;
                        }
                        case "COUNTERSIGN_ROW": {
                            BlockchainProcessor.countersignRow(this.model, parsedCommand);
                            break block7;
                        }
                        case "DELETE_EXPIRED_ROWS": {
                            ImmutableProcessor.delExpRows(this.model, parsedCommand);
                            break block7;
                        }
                        case "GET_BYTES_FOR_ROW_HASH": {
                            BlockchainProcessor.getBytForRowHash(this.model, parsedCommand);
                            break block7;
                        }
                        case "GET_BYTES_FOR_ROW_SIGNATURE": {
                            BlockchainProcessor.getBytForRowSig(this.model, parsedCommand);
                            break block7;
                        }
                        case "GET_DIGEST": {
                            BlockchainProcessor.getBloDigest(this.model, parsedCommand);
                            break block7;
                        }
                        case "GET_SIGNED_DIGEST": {
                            BlockchainProcessor.getSigBloDigest(this.model, parsedCommand);
                            break block7;
                        }
                        case "SIGN_ROW": {
                            BlockchainProcessor.signRow(this.model, parsedCommand);
                            break block7;
                        }
                        case "SIGN_ROW_WITH_COUNTERSIGNATURE": {
                            BlockchainProcessor.signRowWithCountersignature(this.model, parsedCommand);
                            break block7;
                        }
                        case "VERIFY_ROWS": {
                            BlockchainProcessor.verifyRows(this.model, parsedCommand);
                            break block7;
                        }
                        case "VERIFY_TABLE": {
                            BlockchainProcessor.verTabBlockchain(this.model, parsedCommand);
                            break block7;
                        }
                        case "VERIFY_USER_CHAINS": {
                            BlockchainProcessor.verifyUserChains(this.model, parsedCommand);
                            break block7;
                        }
                    }
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_OPTION"), parsedCommand.getType().getName(), this.command)});
                }
                default: {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_SUBCOMMAND"), parsedCommand.getType().getName(), this.command)});
                }
            }
        }
        catch (SQLException e) {
            BICException temp = new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            this.model.getContext().write(temp.getMessage());
        }
        catch (BICException e) {
            this.model.getContext().write(e.getMessage());
        }
    }
}

