/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers.adapters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.markers.MarkerEvent;
import oracle.ide.markers.MarkerEventFilterByEventType;
import oracle.ide.markers.MarkerEventFilterWithMarkerFilter;
import oracle.ide.markers.MarkerEventHandler;
import oracle.ide.markers.MarkerEventType;
import oracle.ideimpl.markers.MarkerEventHandlerDescriptor;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.util.Filter;

public class HashStructureToMarkerEventHandlerDescriptorAdapterFactory
implements AdapterFactory<HashStructure, MarkerEventHandlerDescriptor> {
    private static final String HANDLER_IMPL_ATTR = "impl";
    private static final String FILTER_IMPL_ATTR = "filter-impl";
    private static final String HANDLER_FOR_ELMT = "for";
    private static final String MARKER_TYPE_ATTR = "marker-type";
    private static final String INCLUDE_SUBS_ATTR = "include-subtypes";
    private static final String MARKER_EVENT_ELMT = "marker-event";
    private static final String EVENT_TYPE_ATTR = "type";
    private static final boolean INCLUDE_SUBS_DEFAULT = false;

    public MarkerEventHandlerDescriptor adapt(HashStructure hash) {
        if (null == hash) {
            return null;
        }
        if (!hash.containsKey(HANDLER_IMPL_ATTR)) {
            return null;
        }
        return new DeclaredMarkerEventHandlerDescriptor(hash);
    }

    private static class DeclaredMarkerEventHandlerDescriptor
    extends HashStructureAdapter
    implements MarkerEventHandlerDescriptor {
        private static final String NO_MARKER_TYPES_MSG = "At least one marker type must be specified";
        private final LazyClassAdapter lazyLoader;
        private MarkerEventHandler handlerInstance;
        private Filter<MarkerEvent> preFilter;
        private Filter<MarkerEvent> declaredFilter;

        private DeclaredMarkerEventHandlerDescriptor(HashStructure hash) {
            super(hash);
            this.lazyLoader = LazyClassAdapter.getInstance((HashStructure)hash);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MarkerEventHandler getHandler() {
            DeclaredMarkerEventHandlerDescriptor declaredMarkerEventHandlerDescriptor = this;
            synchronized (declaredMarkerEventHandlerDescriptor) {
                if (null == this.handlerInstance) {
                    try {
                        this.handlerInstance = this.initHandlerInstance();
                    }
                    catch (Exception e) {
                        FeedbackManager.reportException((Throwable)e);
                    }
                }
            }
            return this.handlerInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean matches(MarkerEvent value) {
            DeclaredMarkerEventHandlerDescriptor declaredMarkerEventHandlerDescriptor = this;
            synchronized (declaredMarkerEventHandlerDescriptor) {
                if (null == this.preFilter) {
                    this.preFilter = this.initPreFilter();
                }
            }
            if (!this.preFilter.matches((Object)value)) {
                return false;
            }
            declaredMarkerEventHandlerDescriptor = this;
            synchronized (declaredMarkerEventHandlerDescriptor) {
                if (null == this.declaredFilter) {
                    this.declaredFilter = this.initDeclaredFilter();
                }
            }
            return this.declaredFilter != null ? this.declaredFilter.matches((Object)value) : false;
        }

        private MarkerEventHandler initHandlerInstance() {
            return (MarkerEventHandler)this.lazyLoader.createInstance(MarkerEventHandler.class, HashStructureToMarkerEventHandlerDescriptorAdapterFactory.HANDLER_IMPL_ATTR);
        }

        private Filter<MarkerEvent> initPreFilter() {
            List forElements = this._hash.getAsList(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.HANDLER_FOR_ELMT);
            if (forElements.isEmpty()) {
                throw new IllegalArgumentException(NO_MARKER_TYPES_MSG);
            }
            ArrayList<Filter> forFilters = new ArrayList<Filter>();
            for (Object o1 : forElements) {
                if (!(o1 instanceof HashStructure)) continue;
                HashStructure forElement = (HashStructure)o1;
                MetaClass markerMetaClass = LazyClassAdapter.getInstance((HashStructure)forElement).getMetaClass(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.MARKER_TYPE_ATTR);
                boolean includeSubtypes = forElement.getBoolean(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.INCLUDE_SUBS_ATTR, false);
                Filter<MarkerEvent> f1 = includeSubtypes ? MarkerEventFilterWithMarkerFilter.filterByMarkerTypeIncludingSubtypes(markerMetaClass) : MarkerEventFilterWithMarkerFilter.filterByMarkerTypeExcludingSubtypes(markerMetaClass);
                HashSet<MarkerEventType> eventTypes = new HashSet<MarkerEventType>();
                List markerEventElements = forElement.getAsList(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.MARKER_EVENT_ELMT);
                if (null != markerEventElements) {
                    for (Object o2 : markerEventElements) {
                        if (!(o2 instanceof HashStructure)) continue;
                        HashStructure markerEventElement = (HashStructure)o2;
                        eventTypes.add(MarkerEventType.valueOf(markerEventElement.getString(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.EVENT_TYPE_ATTR)));
                    }
                }
                MarkerEventFilterByEventType f2 = new MarkerEventFilterByEventType(eventTypes.toArray(new MarkerEventType[eventTypes.size()]));
                Filter forFilter = Filter.Instances.and((Filter[])new Filter[]{f1, f2});
                forFilters.add(forFilter);
            }
            switch (forFilters.size()) {
                case 0: {
                    throw new IllegalArgumentException(NO_MARKER_TYPES_MSG);
                }
                case 1: {
                    return (Filter)forFilters.get(0);
                }
            }
            return Filter.Instances.or((Filter[])forFilters.toArray(new Filter[forFilters.size()]));
        }

        private Filter<MarkerEvent> initDeclaredFilter() {
            Filter filter = (Filter)this.lazyLoader.createInstance(Filter.class, HashStructureToMarkerEventHandlerDescriptorAdapterFactory.FILTER_IMPL_ATTR);
            if (null != filter) {
                return filter;
            }
            String filterImplName = this._hash.getString(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.FILTER_IMPL_ATTR);
            filter = null != filterImplName ? Filter.Instances.acceptsNone() : Filter.Instances.acceptsAll();
            return filter;
        }

        @Override
        public String getHandlerName() {
            return this._hash.getString(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.HANDLER_IMPL_ATTR);
        }

        @Override
        public String getFilterName() {
            return this._hash.getString(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.FILTER_IMPL_ATTR);
        }

        @Override
        public List<String> getMarkerTypeNames() {
            ArrayList<String> markerTypeNames = new ArrayList<String>();
            List forHashes = this._hash.getAsList(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.HANDLER_FOR_ELMT);
            for (Object obj : forHashes) {
                if (!(obj instanceof HashStructure)) continue;
                markerTypeNames.add(((HashStructure)obj).getString(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.MARKER_TYPE_ATTR));
            }
            return markerTypeNames;
        }

        @Override
        public List<MarkerEventType> getMarkerEventTypes(String markerTypeName) {
            List forElements = this._hash.getAsList(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.HANDLER_FOR_ELMT);
            for (Object obj : forElements) {
                HashStructure forElement;
                if (!(obj instanceof HashStructure) || !markerTypeName.equals((forElement = (HashStructure)obj).getString(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.MARKER_TYPE_ATTR))) continue;
                List eventElements = forElement.getAsList(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.MARKER_EVENT_ELMT);
                switch (eventElements != null ? eventElements.size() : 0) {
                    case 0: {
                        return Arrays.asList(MarkerEventType.values());
                    }
                }
                HashSet<MarkerEventType> eventTypes = new HashSet<MarkerEventType>();
                for (Object o2 : eventElements) {
                    if (!(o2 instanceof HashStructure)) continue;
                    String type = ((HashStructure)o2).getString(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.EVENT_TYPE_ATTR);
                    eventTypes.add(MarkerEventType.valueOf(type));
                }
                return new ArrayList<MarkerEventType>(eventTypes);
            }
            return Collections.emptyList();
        }

        @Override
        public boolean includesSubtypes(String markerTypeName) {
            List forElements = this._hash.getAsList(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.HANDLER_FOR_ELMT);
            for (Object obj : forElements) {
                HashStructure forElement;
                if (!(obj instanceof HashStructure) || !markerTypeName.equals((forElement = (HashStructure)obj).getString(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.MARKER_TYPE_ATTR))) continue;
                return forElement.getBoolean(HashStructureToMarkerEventHandlerDescriptorAdapterFactory.INCLUDE_SUBS_ATTR, false);
            }
            return false;
        }
    }
}

