/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.builder.gui.palette;

import ilog.views.builder.gui.palette.IlvPaletteModel;
import ilog.views.builder.util.IlvRuleUtils;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.diagrammer.IlvDiagrammerCSS;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.internal.DiagrammerUtilities;
import ilog.views.diagrammer.project.IlvDiagrammerProject;
import ilog.views.sdm.renderer.IlvStyleSheetRenderer;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.internal.IlvURLUtil;
import java.awt.Image;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IlvSDMPaletteModel
implements IlvPaletteModel {
    private String a;
    private IlvDiagrammer b = new IlvDiagrammer();
    public static final String ShapeType = "_shapeType";

    public IlvSDMPaletteModel(String string) {
        this.a = string;
    }

    public Collection getCategories() {
        File file = new File(this.a);
        File[] fileArray = file.listFiles(new FilenameFilter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                if (!file2.isDirectory()) return false;
                if (file2.toString().endsWith("CVS")) return false;
                return true;
            }
        });
        if (fileArray != null) {
            return Arrays.asList(fileArray);
        }
        return Collections.EMPTY_LIST;
    }

    public String getCategoryName(Object object) {
        File file = (File)object;
        try {
            ResourceBundle resourceBundle = IlvSDMPaletteModel.a(file, "category", IlvLocaleUtil.getCurrentLocale());
            return resourceBundle.getString("Name");
        }
        catch (Exception exception) {
            return file.getName();
        }
    }

    public String getCategoryDescription(Object object) {
        File file = (File)object;
        try {
            ResourceBundle resourceBundle = IlvSDMPaletteModel.a(file, "category", IlvLocaleUtil.getCurrentLocale());
            return resourceBundle.getString("Description");
        }
        catch (Exception exception) {
            return "No Description for this category";
        }
    }

    public String getCategoryProperty(Object object, String string) {
        File file = (File)object;
        try {
            ResourceBundle resourceBundle = IlvSDMPaletteModel.a(file, "category", IlvLocaleUtil.getCurrentLocale());
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        catch (Exception exception) {
            return file.getName();
        }
    }

    private static ResourceBundle a(File file, String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            String string2 = file.toString().replace(File.separatorChar, '.') + '.' + string;
            resourceBundle = IlvResourceUtil.getBundle((String)string2, (Locale)locale);
        }
        catch (Exception exception) {
            try {
                URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{IlvURLUtil.convertFileToAbsoluteURL((File)file)});
                resourceBundle = IlvResourceUtil.getBundle((String)string, (Locale)locale, (ClassLoader)uRLClassLoader);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            System.err.println("IlvSDMPaletteModel.getBundle(): " + file + " " + string);
        }
        return resourceBundle;
    }

    public Collection getObjects(Object object) {
        int n;
        File[] fileArray;
        Object object2;
        File file = (File)object;
        String string = this.getCategoryProperty(object, "elements");
        if (string != null) {
            object2 = string.split("\\s");
            fileArray = new File[((String[])object2).length];
            for (n = 0; n < ((String[])object2).length; ++n) {
                fileArray[n] = new File(file, object2[n] + IlvDiagrammerProject.suffix);
            }
        } else {
            fileArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(IlvDiagrammerProject.suffix);
                }
            });
        }
        object2 = new LinkedList();
        for (n = 0; n < fileArray.length; ++n) {
            try {
                Look look = new Look(file, IlvURLUtil.convertFileToAbsoluteURL((File)fileArray[n]), this.b);
                object2.add(look);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return object2;
    }

    public Icon getObjectIcon(Object object) {
        Look look = (Look)object;
        return look.getIcon();
    }

    public String getObjectPath(Object object) {
        Look look = (Look)object;
        return look.getShape();
    }

    public String getObjectShapeType(Object object) {
        Look look = (Look)object;
        return look.getShapeType();
    }

    public String getObjectShortDescription(Object object) {
        Look look = (Look)object;
        return look.getShortDescription();
    }

    public String getObjectId(Object object) {
        Look look = (Look)object;
        return look.getId();
    }

    public URL getObjectStyleSheet(Object object) {
        Look look = (Look)object;
        return look.getStyleSheet();
    }

    public boolean isCategoryLongDescription(Object object) {
        File file = (File)object;
        String string = this.getCategoryProperty(object, "longdescription");
        return "true".equals(string);
    }

    public String getObjectLongDescription(Object object) {
        Look look = (Look)object;
        return look.getLongDescription();
    }

    public IlvRule[] getDecorationRules(Object object) {
        IlvDiagrammer ilvDiagrammer = new IlvDiagrammer();
        IlvDiagrammerCSS ilvDiagrammerCSS = new IlvDiagrammerCSS(ilvDiagrammer);
        try {
            ilvDiagrammer.setStyleSheet(this.getObjectStyleSheet(object));
            IlvRule[] ilvRuleArray = ilvDiagrammerCSS.getAllRules(false);
            return ilvRuleArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static class Look {
        private URL a;
        private ImageIcon b;
        private String c;
        private String d;
        private String e;
        private String f;
        private String g;
        private File h;

        public Look(File file, URL uRL, IlvDiagrammer ilvDiagrammer) throws Exception {
            this.h = file;
            ilvDiagrammer.setDataFile(uRL);
            IlvDiagrammerProject ilvDiagrammerProject = ilvDiagrammer.getProject();
            this.a = ilvDiagrammerProject.getStyleSheet();
            try {
                this.c = (String)ilvDiagrammerProject.getProperty(file, "ShortDescription");
            }
            catch (MissingResourceException missingResourceException) {
                this.c = IlvURLUtil.convertFileURLToFile((URL)uRL).getName();
            }
            Iterator iterator = ilvDiagrammer.getObjects();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if ("anchor".equals(ilvDiagrammer.getTag(e))) continue;
                Rule[] ruleArray = IlvStyleSheetRenderer.getInstance(ilvDiagrammer.getEngine()).getCSSEngine().getMatchedRules().getRules(e);
                this.e = IlvRuleUtils.getDeclarationValue((Rule[])ruleArray, (String)"shape");
                this.f = IlvRuleUtils.getDeclarationValue((Rule[])ruleArray, (String)IlvSDMPaletteModel.ShapeType, (boolean)true);
                Image image = DiagrammerUtilities.createIcon(ilvDiagrammer, e, 0, 0);
                if (image != null) {
                    this.b = new ImageIcon(image);
                    this.d = (String)ilvDiagrammerProject.getProperty(file, "LongDescription");
                }
                this.g = ilvDiagrammer.getID(e);
                break;
            }
        }

        public URL getStyleSheet() {
            return this.a;
        }

        public ImageIcon getIcon() {
            return this.b;
        }

        public String getShortDescription() {
            return this.c;
        }

        public String getLongDescription() {
            return this.d;
        }

        public String getShape() {
            return this.e;
        }

        public String getShapeType() {
            return this.f;
        }

        public String getId() {
            return this.g;
        }
    }
}

