/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvPolylineLinkImage;
import ilog.views.graphlayout.IlvConnectedComponentAdapter;
import ilog.views.graphlayout.IlvConnectedComponentCollectionAdapter;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.IlvGrapherAdapter;
import ilog.views.graphlayout.IlvInappropriateLinkException;
import ilog.views.graphlayout.IlvLayoutProvider;
import ilog.views.graphlayout.internalutil.IlvArrayStableSort;
import ilog.views.graphlayout.internalutil.IlvGraphModelDFS;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.LogResUtil;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.linkconnector.IlvFreeLinkConnector;
import ilog.views.linkconnector.IlvPinLinkConnector;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class IlvGraphLayoutUtil {
    private static final String a = "__GLayoutUtilConnCompFinder";
    private static final String b = "__GLayoutUtilTestTree";
    private static final String c = "__GLayoutUtilCountNodesConnComp";
    private static FreeLinkConnectorFactory d = null;

    private IlvGraphLayoutUtil() {
    }

    public static void EnsureAppropriateLinkTypes(IlvGraphLayout ilvGraphLayout, boolean bl) {
        if (ilvGraphLayout == null) {
            throw new IllegalArgumentException("layout cannot be null");
        }
        IlvGraphModel ilvGraphModel = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel instanceof IlvGrapherAdapter) {
            IlvGraphLayoutUtil.EnsureAppropriateLinkTypes((IlvGrapherAdapter)ilvGraphModel, ilvGraphLayout, bl, false, false, true);
        }
    }

    public static void EnsureAppropriateLinkTypes(IlvGrapherAdapter ilvGrapherAdapter, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2, boolean bl3) {
        IlvGraphLayoutUtil.EnsureAppropriateLinkTypes(ilvGrapherAdapter, ilvGraphLayout, bl, bl2, bl3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EnsureAppropriateLinkTypes(IlvGrapherAdapter ilvGrapherAdapter, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        IlvGrapher ilvGrapher = null;
        if (bl2 && ilvGrapherAdapter != null && (ilvGrapher = ilvGrapherAdapter.getGrapher()) != null) {
            ilvGrapher.setContentsAdjusting(true);
        }
        try {
            IlvGraphLayoutUtil.a(ilvGraphLayout, ilvGrapherAdapter, bl, bl2, bl3, bl4);
        }
        finally {
            if (ilvGrapher != null) {
                ilvGrapher.setContentsAdjusting(false);
            }
        }
    }

    public static void EnsureAppropriateLinkConnectors(IlvGraphLayout ilvGraphLayout, boolean bl) {
        if (ilvGraphLayout == null) {
            throw new IllegalArgumentException("layout cannot be null");
        }
        IlvGraphModel ilvGraphModel = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel instanceof IlvGrapherAdapter) {
            IlvGraphLayoutUtil.EnsureAppropriateLinkConnectors((IlvGrapherAdapter)ilvGraphModel, ilvGraphLayout, bl, false, true);
        }
    }

    public static void EnsureAppropriateLinkConnectors(IlvGrapherAdapter ilvGrapherAdapter, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2) {
        IlvGraphLayoutUtil.EnsureAppropriateLinkConnectors(ilvGrapherAdapter, ilvGraphLayout, bl, bl2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EnsureAppropriateLinkConnectors(IlvGrapherAdapter ilvGrapherAdapter, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2, boolean bl3) {
        if (ilvGrapherAdapter == null) {
            throw new IllegalArgumentException("grapherAdapter cannot be null");
        }
        IlvGrapher ilvGrapher = null;
        if (bl2 && ilvGrapherAdapter != null && (ilvGrapher = ilvGrapherAdapter.getGrapher()) != null) {
            ilvGrapher.setContentsAdjusting(true);
        }
        try {
            IlvGraphLayoutUtil.a(ilvGrapherAdapter, ilvGraphLayout, bl, bl2, bl3);
        }
        finally {
            if (ilvGrapher != null) {
                ilvGrapher.setContentsAdjusting(false);
            }
        }
    }

    private static void a(IlvGrapherAdapter ilvGrapherAdapter, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            Enumeration enumeration = ilvGrapherAdapter.getSubgraphs();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                IlvGraphModel ilvGraphModel = ilvGrapherAdapter.getGraphModel(e);
                if (!(ilvGraphModel instanceof IlvGrapherAdapter)) continue;
                IlvGraphLayoutUtil.EnsureAppropriateLinkConnectors((IlvGrapherAdapter)ilvGraphModel, ilvGraphLayout, bl, true, bl3);
            }
        }
        if (bl) {
            IlvGraphLayoutUtil.a(ilvGrapherAdapter, false, bl3);
        } else {
            IlvGraphLayoutUtil.a(ilvGrapherAdapter, bl3);
        }
    }

    public static void EnsureAppropriateLinks(IlvGraphModel ilvGraphModel, IlvLayoutProvider ilvLayoutProvider) {
        IlvGraphLayoutUtil.EnsureAppropriateLinks(ilvGraphModel, ilvLayoutProvider, true);
    }

    public static void EnsureAppropriateLinks(IlvGraphModel ilvGraphModel, IlvLayoutProvider ilvLayoutProvider, boolean bl) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        if (ilvLayoutProvider == null) {
            throw new IllegalArgumentException("layoutProvider cannot be null");
        }
        IlvGraphModel ilvGraphModel2 = LayoutUtil.getRootModel(ilvGraphModel);
        IlvGraphLayoutUtil.a(ilvGraphModel2, ilvGraphModel, ilvLayoutProvider, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(IlvGraphModel ilvGraphModel, IlvGraphModel ilvGraphModel2, IlvLayoutProvider ilvLayoutProvider, boolean bl) {
        Object object;
        boolean bl2 = ilvGraphModel2.isLinkCheckEnabled();
        boolean bl3 = ilvGraphModel2.isConnectionPointCheckEnabled();
        try {
            ilvGraphModel2.setLinkCheckEnabled(true);
            ilvGraphModel2.setConnectionPointCheckEnabled(true);
            object = ilvLayoutProvider.getGraphLayout(ilvGraphModel2);
            if (object != null) {
                ((IlvGraphLayout)object).checkAppropriateLinks();
            }
        }
        catch (IlvInappropriateLinkException ilvInappropriateLinkException) {
            IlvGraphLayoutUtil.EnsureAppropriateLinks(ilvInappropriateLinkException, bl);
        }
        finally {
            ilvGraphModel2.setLinkCheckEnabled(bl2);
            ilvGraphModel2.setConnectionPointCheckEnabled(bl3);
        }
        object = ilvGraphModel2.getSubgraphs();
        while (object.hasMoreElements()) {
            IlvGraphLayoutUtil.a(ilvGraphModel, ilvGraphModel.getGraphModel(object.nextElement()), ilvLayoutProvider, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EnsureAppropriateLinks(IlvGraphLayout ilvGraphLayout, boolean bl) {
        if (ilvGraphLayout == null) {
            return;
        }
        IlvGraphModel ilvGraphModel = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("layout must be attached to graph model");
        }
        boolean bl2 = ilvGraphModel.isLinkCheckEnabled();
        boolean bl3 = ilvGraphModel.isConnectionPointCheckEnabled();
        try {
            ilvGraphModel.setLinkCheckEnabled(true);
            ilvGraphModel.setConnectionPointCheckEnabled(true);
            ilvGraphLayout.checkAppropriateLinks();
        }
        catch (IlvInappropriateLinkException ilvInappropriateLinkException) {
            IlvGraphLayoutUtil.EnsureAppropriateLinks(ilvInappropriateLinkException, bl);
        }
        finally {
            ilvGraphModel.setLinkCheckEnabled(bl2);
            ilvGraphModel.setConnectionPointCheckEnabled(bl3);
        }
    }

    public static void EnsureAppropriateLinks(IlvInappropriateLinkException ilvInappropriateLinkException) {
        IlvGraphLayoutUtil.EnsureAppropriateLinks(ilvInappropriateLinkException, true);
    }

    public static void EnsureAppropriateLinks(IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        IlvInappropriateLinkException ilvInappropriateLinkException2;
        for (ilvInappropriateLinkException2 = ilvInappropriateLinkException; ilvInappropriateLinkException2 != null; ilvInappropriateLinkException2 = (IlvInappropriateLinkException)ilvInappropriateLinkException2.getNext()) {
            IlvGraphLayoutUtil.a(ilvInappropriateLinkException2, bl);
        }
        for (ilvInappropriateLinkException2 = ilvInappropriateLinkException; ilvInappropriateLinkException2 != null; ilvInappropriateLinkException2 = (IlvInappropriateLinkException)ilvInappropriateLinkException2.getNext()) {
            IlvGraphLayoutUtil.b(ilvInappropriateLinkException2, bl);
        }
        for (ilvInappropriateLinkException2 = ilvInappropriateLinkException; ilvInappropriateLinkException2 != null; ilvInappropriateLinkException2 = (IlvInappropriateLinkException)ilvInappropriateLinkException2.getNext()) {
            IlvGraphLayoutUtil.c(ilvInappropriateLinkException2, bl);
        }
    }

    private static void a(IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        IlvGraphLayout ilvGraphLayout = ilvInappropriateLinkException.getGraphLayout();
        IlvGraphModel ilvGraphModel = ilvInappropriateLinkException.getGraphModel();
        if (ilvGraphModel == null) {
            ilvGraphModel = ilvGraphLayout.getGraphModel();
        }
        if (!(ilvGraphModel instanceof IlvGrapherAdapter)) {
            return;
        }
        if (ilvGraphLayout.getGrapher() == null) {
            return;
        }
        IlvGraphLayoutUtil.a(ilvGraphLayout, (IlvGrapherAdapter)ilvGraphModel, ilvInappropriateLinkException, bl);
    }

    private static void a(IlvGraphLayout ilvGraphLayout, IlvGrapherAdapter ilvGrapherAdapter, IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        boolean bl2;
        int n = ilvInappropriateLinkException.getType();
        boolean bl3 = (n & 1) != 0;
        boolean bl4 = (n & 2) != 0;
        boolean bl5 = (n & 8) != 0;
        boolean bl6 = bl2 = (n & 0x10) != 0;
        if (bl3 || bl4) {
            IlvGraphLayoutUtil.EnsureAppropriateLinkTypes(ilvGrapherAdapter, ilvGraphLayout, !bl4, false, false, bl);
        }
        if (bl5 || bl2) {
            IlvGraphLayoutUtil.EnsureAppropriateLinkTypes(ilvGrapherAdapter, ilvGraphLayout, !bl2, false, true, bl);
        }
    }

    private static void b(IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        IlvGraphLayout ilvGraphLayout = ilvInappropriateLinkException.getGraphLayout();
        IlvGraphModel ilvGraphModel = ilvInappropriateLinkException.getGraphModel();
        if (ilvGraphModel == null) {
            ilvGraphModel = ilvGraphLayout.getGraphModel();
        }
        if (!(ilvGraphModel instanceof IlvGrapherAdapter)) {
            return;
        }
        if (ilvGraphLayout.getGrapher() == null) {
            return;
        }
        IlvGraphLayoutUtil.b(ilvGraphLayout, (IlvGrapherAdapter)ilvGraphModel, ilvInappropriateLinkException, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b(IlvGraphLayout ilvGraphLayout, IlvGrapherAdapter ilvGrapherAdapter, IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        boolean bl2;
        int n = ilvInappropriateLinkException.getType();
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = bl2 = (n & 0x20) != 0;
        if (bl3 || bl2) {
            IlvGrapher ilvGrapher = ilvGrapherAdapter.getGrapher();
            ilvGrapher.setContentsAdjusting(true);
            try {
                boolean bl5 = !bl2;
                Enumeration enumeration = ilvGrapherAdapter.getNodes();
                while (enumeration.hasMoreElements()) {
                    IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
                    if (bl5) {
                        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached((IlvGraphic)ilvGraphic);
                        if (ilvLinkConnector instanceof IlvPinLinkConnector) continue;
                        IlvGraphLayoutUtil.a(ilvGraphic, bl);
                        continue;
                    }
                    IlvGraphLayoutUtil.a(ilvGraphic, bl);
                }
            }
            finally {
                ilvGrapher.setContentsAdjusting(false);
            }
        }
    }

    private static void c(IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        IlvGraphLayout ilvGraphLayout = ilvInappropriateLinkException.getGraphLayout();
        IlvGraphModel ilvGraphModel = ilvInappropriateLinkException.getGraphModel();
        if (ilvGraphModel == null) {
            ilvGraphModel = ilvGraphLayout.getGraphModel();
        }
        if (!(ilvGraphModel instanceof IlvGrapherAdapter)) {
            return;
        }
        if (ilvGraphLayout.getGrapher() == null) {
            return;
        }
        IlvGraphLayoutUtil.c(ilvGraphLayout, (IlvGrapherAdapter)ilvGraphModel, ilvInappropriateLinkException, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void c(IlvGraphLayout ilvGraphLayout, IlvGrapherAdapter ilvGrapherAdapter, IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        boolean bl2;
        int n = ilvInappropriateLinkException.getType();
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = bl2 = (n & 0x20) != 0;
        if (bl3 || bl2) {
            boolean bl5 = !bl2;
            IlvGrapher ilvGrapher = ilvGrapherAdapter.getGrapher();
            ilvGrapher.setContentsAdjusting(true);
            try {
                IlvGraphLayoutUtil.a(ilvGrapherAdapter.getLinks(), ilvGrapherAdapter, bl5, bl);
                IlvGraphLayoutUtil.a(ilvGrapherAdapter.getInterGraphLinks(), ilvGrapherAdapter, bl5, bl);
            }
            finally {
                ilvGrapher.setContentsAdjusting(false);
            }
        }
    }

    public static void EnsureAppropriateLinks(IlvGraphLayout ilvGraphLayout, IlvInappropriateLinkException ilvInappropriateLinkException) {
        IlvGraphModel ilvGraphModel = ilvInappropriateLinkException.getGraphModel();
        if (ilvGraphModel == null) {
            ilvGraphModel = ilvGraphLayout.getGraphModel();
        }
        if (!(ilvGraphModel instanceof IlvGrapherAdapter)) {
            return;
        }
        IlvGrapherAdapter ilvGrapherAdapter = (IlvGrapherAdapter)ilvGraphModel;
        IlvGraphLayoutUtil.a(ilvGraphLayout, ilvGrapherAdapter, ilvInappropriateLinkException, true);
        IlvGraphLayoutUtil.b(ilvGraphLayout, ilvGrapherAdapter, ilvInappropriateLinkException, true);
        IlvGraphLayoutUtil.c(ilvGraphLayout, ilvGrapherAdapter, ilvInappropriateLinkException, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(IlvGrapherAdapter ilvGrapherAdapter, boolean bl) {
        Enumeration enumeration = ilvGrapherAdapter.getNodes();
        IlvGrapher ilvGrapher = ilvGrapherAdapter.getGrapher();
        ilvGrapher.setContentsAdjusting(true);
        try {
            while (enumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
                IlvGraphLayoutUtil.a(ilvGrapher, ilvGraphic, bl);
            }
            IlvGraphLayoutUtil.a(ilvGrapherAdapter.getLinks(), bl);
            IlvGraphLayoutUtil.a(ilvGrapherAdapter.getInterGraphLinks(), bl);
        }
        finally {
            ilvGrapher.setContentsAdjusting(false);
        }
    }

    private static void a(Enumeration enumeration, boolean bl) {
        while (enumeration.hasMoreElements()) {
            IlvLinkImage ilvLinkImage = (IlvLinkImage)enumeration.nextElement();
            IlvGraphLayoutUtil.b(ilvLinkImage, true, bl);
            IlvGraphLayoutUtil.b(ilvLinkImage, false, bl);
        }
    }

    private static void b(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.Get((IlvLinkImage)ilvLinkImage, (boolean)bl);
        IlvLinkConnector ilvLinkConnector2 = null;
        if (ilvLinkConnector instanceof IlvFreeLinkConnector && !(ilvLinkConnector instanceof IlvClippingLinkConnector) && (ilvLinkConnector2 = IlvLinkConnector.GetAttached((IlvLinkImage)ilvLinkImage, (boolean)bl)) != null) {
            ilvLinkConnector2.detach(ilvLinkImage, bl, bl2);
        }
    }

    private static void a(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic, boolean bl) {
        IlvApplyObject ilvApplyObject = new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                ((IlvFreeLinkConnector)object).disconnectAllLinks();
            }
        };
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached((IlvGraphic)ilvGraphic);
        if (ilvLinkConnector instanceof IlvFreeLinkConnector && !(ilvLinkConnector instanceof IlvClippingLinkConnector)) {
            ilvGrapher.applyToObject(ilvGraphic, ilvApplyObject, (Object)ilvLinkConnector, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(IlvGrapherAdapter ilvGrapherAdapter, boolean bl, boolean bl2) {
        Enumeration enumeration = ilvGrapherAdapter.getNodes();
        IlvGrapher ilvGrapher = ilvGrapherAdapter.getGrapher();
        ilvGrapher.setContentsAdjusting(true);
        try {
            while (enumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
                if (bl) {
                    IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached((IlvGraphic)ilvGraphic);
                    if (ilvLinkConnector instanceof IlvPinLinkConnector) continue;
                    IlvGraphLayoutUtil.a(ilvGraphic, bl2);
                    continue;
                }
                IlvGraphLayoutUtil.a(ilvGraphic, bl2);
            }
            IlvGraphLayoutUtil.a(ilvGrapherAdapter.getLinks(), ilvGrapherAdapter, bl, bl2);
            IlvGraphLayoutUtil.a(ilvGrapherAdapter.getInterGraphLinks(), ilvGrapherAdapter, bl, bl2);
        }
        finally {
            ilvGrapher.setContentsAdjusting(false);
        }
    }

    private static void a(Enumeration enumeration, IlvGrapherAdapter ilvGrapherAdapter, boolean bl, boolean bl2) {
        while (enumeration.hasMoreElements()) {
            IlvLinkImage ilvLinkImage = (IlvLinkImage)enumeration.nextElement();
            IlvGraphLayoutUtil.a(ilvLinkImage, ilvGrapherAdapter, true, bl, bl2);
            IlvGraphLayoutUtil.a(ilvLinkImage, ilvGrapherAdapter, false, bl, bl2);
        }
    }

    private static void a(IlvLinkImage ilvLinkImage, IlvGrapherAdapter ilvGrapherAdapter, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            IlvLinkConnector ilvLinkConnector;
            if (ilvGrapherAdapter.hasPinnedConnectionPoint(ilvLinkImage, bl)) {
                return;
            }
            IlvLinkConnector ilvLinkConnector2 = IlvLinkConnector.GetAttached((IlvLinkImage)ilvLinkImage, (boolean)bl);
            if (ilvLinkConnector2 != null && !(ilvLinkConnector2 instanceof IlvFreeLinkConnector)) {
                ilvLinkConnector2.detach(ilvLinkImage, bl, bl3);
            }
            if ((ilvLinkConnector = IlvLinkConnector.Get((IlvLinkImage)ilvLinkImage, (boolean)bl)) instanceof IlvPinLinkConnector) {
                IlvGraphLayoutUtil.a(ilvLinkImage, bl, bl3);
            } else if (ilvLinkConnector == null || !(ilvLinkConnector instanceof IlvFreeLinkConnector)) {
                IlvGraphLayoutUtil.a(ilvLinkImage, bl, bl3);
            }
        } else {
            IlvLinkConnector ilvLinkConnector = IlvLinkConnector.Get((IlvLinkImage)ilvLinkImage, (boolean)bl);
            if (ilvLinkConnector == null || !(ilvLinkConnector instanceof IlvFreeLinkConnector)) {
                IlvLinkConnector ilvLinkConnector3 = IlvLinkConnector.GetAttached((IlvLinkImage)ilvLinkImage, (boolean)bl);
                if (ilvLinkConnector3 != null && !(ilvLinkConnector3 instanceof IlvFreeLinkConnector)) {
                    ilvLinkConnector3.detach(ilvLinkImage, bl, bl3);
                }
                if ((ilvLinkConnector = IlvLinkConnector.Get((IlvLinkImage)ilvLinkImage, (boolean)bl)) == null || !(ilvLinkConnector instanceof IlvFreeLinkConnector)) {
                    IlvGraphLayoutUtil.a(ilvLinkImage, bl, bl3);
                }
            }
        }
    }

    static void a(IlvGraphic ilvGraphic, boolean bl) {
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached((IlvGraphic)ilvGraphic);
        if (!(ilvLinkConnector instanceof IlvFreeLinkConnector)) {
            ilvLinkConnector = d != null ? d.create(ilvGraphic) : new IlvFreeLinkConnector();
            ilvLinkConnector.attach(ilvGraphic, bl);
        }
    }

    static void a(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached((IlvLinkImage)ilvLinkImage, (boolean)bl);
        if (!(ilvLinkConnector instanceof IlvFreeLinkConnector)) {
            if (d != null) {
                IlvGraphic ilvGraphic = bl ? ilvLinkImage.getFrom() : ilvLinkImage.getTo();
                ilvLinkConnector = d.create(ilvGraphic);
            } else {
                ilvLinkConnector = new IlvFreeLinkConnector();
            }
            ilvLinkConnector.attach(ilvLinkImage, bl, bl2);
        }
    }

    public static void SetFreeLinkConnectorFactory(FreeLinkConnectorFactory freeLinkConnectorFactory) {
        d = freeLinkConnectorFactory;
    }

    public static FreeLinkConnectorFactory GetFreeLinkConnectorFactory() {
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(IlvGraphLayout ilvGraphLayout, IlvGrapherAdapter ilvGrapherAdapter, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        Enumeration enumeration;
        if (ilvGrapherAdapter == null) {
            throw new IllegalArgumentException("grapherAdapter cannot be null");
        }
        IlvGrapher ilvGrapher = ilvGrapherAdapter.getGrapher();
        if (ilvGrapher == null) {
            return;
        }
        if (bl2) {
            enumeration = ilvGrapherAdapter.getSubgraphs();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                object = ilvGrapherAdapter.getGraphModel(e);
                if (!(object instanceof IlvGrapherAdapter)) continue;
                IlvGraphLayoutUtil.a(ilvGraphLayout, (IlvGrapherAdapter)object, bl, true, bl3, bl4);
            }
        }
        if ((enumeration = bl3 ? ilvGrapherAdapter.getInterGraphLinks() : ilvGrapherAdapter.getLinks()) == null || !enumeration.hasMoreElements()) {
            return;
        }
        boolean bl5 = ilvGraphLayout != null && ilvGraphLayout.supportsPreserveFixedLinks() && ilvGraphLayout.isPreserveFixedLinks();
        object = new ArrayList(500);
        Object e = null;
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (bl5 && ilvGraphLayout.isFixed(e) || ilvGrapherAdapter.isReshapeableLink(e, bl)) continue;
            ((ArrayList)object).add(e);
        }
        if (((ArrayList)object).size() == 0) {
            return;
        }
        int n = ((ArrayList)object).size();
        ilvGrapher.setContentsAdjusting(true);
        try {
            for (int i = 0; i < n; ++i) {
                IlvLinkImage ilvLinkImage = (IlvLinkImage)((ArrayList)object).get(i);
                IlvPolylineLinkImage ilvPolylineLinkImage = new IlvPolylineLinkImage(ilvLinkImage.getFrom(), ilvLinkImage.getTo(), ilvLinkImage.isOriented(), null);
                IlvGraphLayoutUtil.a(ilvLinkImage, (IlvLinkImage)ilvPolylineLinkImage);
                IlvGraphLayoutUtil.a(ilvGrapher, ilvLinkImage, (IlvLinkImage)ilvPolylineLinkImage, bl4);
            }
        }
        finally {
            ilvGrapher.setContentsAdjusting(false);
        }
    }

    private static void a(IlvGrapher ilvGrapher, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, boolean bl) {
        IlvGraphLayoutUtil.a(ilvLinkImage, ilvLinkImage2, true, bl);
        IlvGraphLayoutUtil.a(ilvLinkImage, ilvLinkImage2, false, bl);
        ilvGrapher.replaceObject((IlvGraphic)ilvLinkImage, (IlvGraphic)ilvLinkImage2, bl);
    }

    private static void a(IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, boolean bl, boolean bl2) {
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.Get((IlvLinkImage)ilvLinkImage, (boolean)bl);
        if (ilvLinkConnector != null) {
            IlvLinkConnector ilvLinkConnector2 = IlvLinkConnector.GetAttached((IlvLinkImage)ilvLinkImage, (boolean)bl);
            if (ilvLinkConnector2 != null) {
                IlvGraphLayoutUtil.a(ilvLinkConnector2, ilvLinkImage, ilvLinkImage2, bl, bl2, false);
            } else {
                IlvGraphLayoutUtil.a(ilvLinkConnector, ilvLinkImage, ilvLinkImage2, bl, bl2, true);
            }
        }
    }

    private static void a(IlvLinkConnector ilvLinkConnector, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, boolean bl, boolean bl2, boolean bl3) {
        IlvPoint ilvPoint = ilvLinkConnector.getConnectionPoint(ilvLinkImage, bl, null);
        if (!bl3) {
            ilvLinkConnector.disconnectLink(ilvLinkImage, bl);
            ilvLinkConnector.detach(ilvLinkImage, bl, bl2);
            ilvLinkConnector.attach(ilvLinkImage2, bl, bl2);
        }
        ilvLinkConnector.connectLink(ilvLinkImage2, ilvPoint, bl, null);
    }

    private static void a(IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2) {
        ilvLinkImage2.setForeground(ilvLinkImage.getForeground());
        ilvLinkImage2.setLineWidth(ilvLinkImage.getLineWidth());
        ilvLinkImage2.setLineJoin(ilvLinkImage.getLineJoin());
        ilvLinkImage2.setMaximumLineWidth(ilvLinkImage.getMaximumLineWidth());
        ilvLinkImage2.setEndCap(ilvLinkImage.getEndCap());
        ilvLinkImage2.setLineStyle(ilvLinkImage.getLineStyle());
    }

    public static int GetNodeDegree(IlvGraphLayout ilvGraphLayout, IlvGraphic ilvGraphic) {
        return ilvGraphLayout.getGraphModel().getNodeDegree(ilvGraphic);
    }

    public static boolean IsTree(IlvGraphLayout ilvGraphLayout, Object object) {
        IlvGraphModel ilvGraphModel = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel == null) {
            LogResUtil.logAndThrowRuntimeExc(IlvGraphLayout.class, "graphlayout.expert.message.6044E");
        }
        return IlvGraphLayoutUtil.IsTree(ilvGraphModel, object);
    }

    public static boolean IsTree(IlvGraphModel ilvGraphModel, Object object) {
        if (ilvGraphModel == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6012E");
        }
        if (object == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6045E");
        }
        TestTree testTree = new TestTree(ilvGraphModel, b);
        return testTree.a(object);
    }

    public static boolean IsConnected(IlvGraphModel ilvGraphModel) {
        Enumeration enumeration;
        if (ilvGraphModel == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6012E");
        }
        if (!(enumeration = ilvGraphModel.getNodes()).hasMoreElements()) {
            return true;
        }
        if (!ilvGraphModel.getLinks().hasMoreElements()) {
            enumeration.nextElement();
            return !enumeration.hasMoreElements();
        }
        CountNodesInConnectedComponent countNodesInConnectedComponent = new CountNodesInConnectedComponent(ilvGraphModel, c);
        int n = countNodesInConnectedComponent.a(enumeration.nextElement());
        try {
            for (int i = 1; i < n; ++i) {
                enumeration.nextElement();
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{n, ilvGraphModel.getNodesCount(), ilvGraphModel};
            LogResUtil.logAndThrowRuntimeExc(IlvGraphLayout.class, "graphlayout.expert.message.6046E", objectArray);
        }
        return !enumeration.hasMoreElements();
    }

    public static IlvGraphModel GetConnectedComponents(IlvGraphModel ilvGraphModel) {
        return IlvGraphLayoutUtil.a(ilvGraphModel, false);
    }

    static IlvGraphModel a(IlvGraphModel ilvGraphModel, boolean bl) {
        if (ilvGraphModel == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6012E");
        }
        if (!bl && IlvGraphLayoutUtil.IsConnected(ilvGraphModel)) {
            return ilvGraphModel;
        }
        ConnectedComponentsFinder connectedComponentsFinder = new ConnectedComponentsFinder(ilvGraphModel, a);
        return connectedComponentsFinder.getConnectedComponents();
    }

    public static int ComputeNumberOfNodeOverlaps(IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6012E");
        }
        int n = 0;
        int n2 = ilvGraphModel.getNodesCount();
        Object[] objectArray = new Object[n2];
        Enumeration enumeration = ilvGraphModel.getNodes();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n3++] = enumeration.nextElement();
        }
        for (n3 = 0; n3 < n2; ++n3) {
            Object object = objectArray[n3];
            IlvRect ilvRect = ilvGraphModel.boundingBox(object);
            for (int i = n3 + 1; i < n2; ++i) {
                Object object2 = objectArray[i];
                IlvRect ilvRect2 = ilvGraphModel.boundingBox(object2);
                if (!(ilvRect.x <= ilvRect2.x + ilvRect2.width) || !(ilvRect2.x <= ilvRect.x + ilvRect.width) || !(ilvRect.y <= ilvRect2.y + ilvRect2.height) || !(ilvRect2.y <= ilvRect.y + ilvRect.height)) continue;
                ++n;
            }
        }
        objectArray = null;
        return n;
    }

    public static int ComputeNumberOfNodeLinkOverlaps(IlvGraphModel ilvGraphModel) {
        Object object;
        if (ilvGraphModel == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6012E");
        }
        int n = 0;
        int n2 = ilvGraphModel.getLinksCount();
        Object[] objectArray = new Object[n2];
        IlvRect[] ilvRectArray = new IlvRect[n2];
        Enumeration enumeration = ilvGraphModel.getLinks();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            objectArray[n3] = object;
            ilvRectArray[n3++] = ilvGraphModel.boundingBox(object);
        }
        IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint(), new IlvPoint(), new IlvPoint(), new IlvPoint()};
        enumeration = ilvGraphModel.getNodes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            IlvRect ilvRect = ilvGraphModel.boundingBox(e);
            ilvPointArray[0].x = ilvRect.x;
            ilvPointArray[0].y = ilvRect.y;
            ilvPointArray[1].x = ilvRect.x + ilvRect.width;
            ilvPointArray[1].y = ilvRect.y;
            ilvPointArray[2].x = ilvRect.x + ilvRect.width;
            ilvPointArray[2].y = ilvRect.y + ilvRect.height;
            ilvPointArray[3].x = ilvRect.x;
            ilvPointArray[3].y = ilvRect.y + ilvRect.height;
            ilvPointArray[4].x = ilvRect.x;
            ilvPointArray[4].y = ilvRect.y;
            for (n3 = 0; n3 < n2; ++n3) {
                object = objectArray[n3];
                IlvRect ilvRect2 = ilvRectArray[n3];
                if (ilvGraphModel.getFrom(object) == e || ilvGraphModel.getTo(object) == e || !(ilvRect.x <= ilvRect2.x + ilvRect2.width) || !(ilvRect2.x <= ilvRect.x + ilvRect.width) || !(ilvRect.y <= ilvRect2.y + ilvRect2.height) || !(ilvRect2.y <= ilvRect.y + ilvRect.height)) continue;
                IlvPoint[] ilvPointArray2 = ilvGraphModel.getLinkPoints(object);
                int n4 = ilvPointArray2.length;
                block3: for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < n4 - 1; ++j) {
                        if (!IlvGraphLayoutUtil.a(ilvPointArray[i], ilvPointArray[i + 1], ilvPointArray2[j], ilvPointArray2[j + 1], true)) continue;
                        ++n;
                        i = 5;
                        continue block3;
                    }
                }
            }
        }
        ilvPointArray = null;
        objectArray = null;
        ilvRectArray = null;
        return n;
    }

    public static int ComputeNumberOfLinkBends(IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6012E");
        }
        int n = 0;
        Enumeration enumeration = ilvGraphModel.getLinks();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            n += ilvGraphModel.getLinkPointsCount(e) - 2;
        }
        return n;
    }

    public static int ComputeNumberOfLinkCrossings(IlvGraphModel ilvGraphModel) {
        Object object;
        if (ilvGraphModel == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6012E");
        }
        int n = 0;
        int n2 = ilvGraphModel.getLinksCount();
        Object[] objectArray = new Object[n2];
        IlvRect[] ilvRectArray = new IlvRect[n2];
        Enumeration enumeration = ilvGraphModel.getLinks();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            objectArray[n3] = object;
            ilvRectArray[n3++] = ilvGraphModel.boundingBox(object);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            object = objectArray[n3];
            IlvRect ilvRect = ilvRectArray[n3];
            IlvPoint[] ilvPointArray = null;
            int n4 = 0;
            for (int i = n3; i < n2; ++i) {
                Object object2 = objectArray[i];
                IlvRect ilvRect2 = ilvRectArray[i];
                if (!(ilvRect.x <= ilvRect2.x + ilvRect2.width) || !(ilvRect2.x <= ilvRect.x + ilvRect.width) || !(ilvRect.y <= ilvRect2.y + ilvRect2.height) || !(ilvRect2.y <= ilvRect.y + ilvRect.height)) continue;
                if (ilvPointArray == null) {
                    ilvPointArray = ilvGraphModel.getLinkPoints(object);
                    n4 = ilvPointArray.length;
                }
                IlvPoint[] ilvPointArray2 = ilvGraphModel.getLinkPoints(object2);
                int n5 = ilvPointArray2.length;
                for (int j = 0; j < n4 - 1; ++j) {
                    for (int k = 0; k < n5 - 1; ++k) {
                        if (n3 == i && k <= j + 1 || !IlvGraphLayoutUtil.a(ilvPointArray[j], ilvPointArray[j + 1], ilvPointArray2[k], ilvPointArray2[k + 1], true) || j == 0 && k == 0 && ilvPointArray[j].equals((Object)ilvPointArray2[k]) || j == 0 && k == n5 - 2 && ilvPointArray[j].equals((Object)ilvPointArray2[k + 1]) || j == n4 - 2 && k == 0 && ilvPointArray[j + 1].equals((Object)ilvPointArray2[k]) || j == n4 - 2 && k == n5 - 2 && ilvPointArray[j + 1].equals((Object)ilvPointArray2[k + 1])) continue;
                        ++n;
                    }
                }
            }
        }
        objectArray = null;
        ilvRectArray = null;
        return n;
    }

    public static int ComputeNumberOfLinkOverlaps(IlvGraphModel ilvGraphModel) {
        Object object;
        if (ilvGraphModel == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6012E");
        }
        int n = 0;
        int n2 = ilvGraphModel.getLinksCount();
        Object[] objectArray = new Object[n2];
        IlvRect[] ilvRectArray = new IlvRect[n2];
        Enumeration enumeration = ilvGraphModel.getLinks();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            objectArray[n3] = object;
            ilvRectArray[n3++] = ilvGraphModel.boundingBox(object);
        }
        IlvPoint ilvPoint = new IlvPoint();
        for (n3 = 0; n3 < n2; ++n3) {
            object = objectArray[n3];
            IlvRect ilvRect = ilvRectArray[n3];
            IlvPoint[] ilvPointArray = null;
            int n4 = 0;
            float f = 0.0f;
            for (int i = n3; i < n2; ++i) {
                Object object2 = objectArray[i];
                IlvRect ilvRect2 = ilvRectArray[i];
                if (!(ilvRect.x <= ilvRect2.x + ilvRect2.width) || !(ilvRect2.x <= ilvRect.x + ilvRect.width) || !(ilvRect.y <= ilvRect2.y + ilvRect2.height) || !(ilvRect2.y <= ilvRect.y + ilvRect.height)) continue;
                if (ilvPointArray == null) {
                    ilvPointArray = ilvGraphModel.getLinkPoints(object);
                    n4 = ilvPointArray.length;
                    f = ilvGraphModel.getLinkWidth(object);
                }
                IlvPoint[] ilvPointArray2 = ilvGraphModel.getLinkPoints(object2);
                int n5 = ilvPointArray2.length;
                float f2 = ilvGraphModel.getLinkWidth(object2);
                for (int j = 0; j < n4 - 1; ++j) {
                    if (n3 == i && ilvPointArray[j].equals((Object)ilvPointArray[j + 1])) continue;
                    for (int k = 0; k < n5 - 1; ++k) {
                        if (n3 == i && (k <= j || ilvPointArray2[k].equals((Object)ilvPointArray2[k + 1])) || !IlvGraphLayoutUtil.a(ilvPointArray[j], ilvPointArray[j + 1], f, ilvPointArray2[k], ilvPointArray2[k + 1], f2)) continue;
                        if (n3 == i) {
                            boolean bl = true;
                            for (int i2 = j + 1; i2 < k; ++i2) {
                                IlvPoint ilvPoint2 = ilvPointArray[i2 + 1];
                                IlvPoint ilvPoint3 = ilvPointArray[j + 1];
                                double d = ilvPoint2.distance((Point2D)ilvPoint3);
                                if (!(d > (double)f)) continue;
                                ++n;
                                bl = false;
                                break;
                            }
                            if (!bl) continue;
                            ilvPoint.x = 0.5f * (ilvPointArray2[k].x + ilvPointArray2[k + 1].x);
                            ilvPoint.y = 0.5f * (ilvPointArray2[k].y + ilvPointArray2[k + 1].y);
                            if (IlvGraphLayoutUtil.a(ilvPointArray[j], ilvPointArray[j + 1], f, ilvPoint, ilvPointArray2[k + 1], f2)) {
                                ++n;
                                continue;
                            }
                            ilvPoint.x = 0.5f * (ilvPointArray[j].x + ilvPointArray[j + 1].x);
                            ilvPoint.y = 0.5f * (ilvPointArray[j].y + ilvPointArray[j + 1].y);
                            if (!IlvGraphLayoutUtil.a(ilvPointArray[j], ilvPoint, f, ilvPointArray2[k], ilvPointArray2[k + 1], f2)) continue;
                            ++n;
                            continue;
                        }
                        ++n;
                    }
                }
            }
        }
        objectArray = null;
        ilvRectArray = null;
        return n;
    }

    private static boolean a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, boolean bl) {
        double d = ilvPoint2.x - ilvPoint.x;
        double d2 = ilvPoint2.y - ilvPoint.y;
        double d3 = ilvPoint4.x - ilvPoint3.x;
        double d4 = ilvPoint4.y - ilvPoint3.y;
        if (d == 0.0 && d2 == 0.0) {
            return false;
        }
        if (d3 == 0.0 && d4 == 0.0) {
            return false;
        }
        double d5 = d * d4;
        double d6 = d3 * d2;
        if (d5 == d6) {
            return false;
        }
        float f = (float)(((double)ilvPoint.x * d6 - (double)ilvPoint3.x * d5 + (double)(ilvPoint3.y - ilvPoint.y) * d * d3) / (d6 - d5));
        float f2 = (float)(((double)ilvPoint.y * d5 - (double)ilvPoint3.y * d6 + (double)(ilvPoint3.x - ilvPoint.x) * d2 * d4) / (d5 - d6));
        if (Math.abs(d) > Math.abs(d2) ? f < Math.min(ilvPoint.x, ilvPoint2.x) || Math.max(ilvPoint.x, ilvPoint2.x) < f : f2 < Math.min(ilvPoint.y, ilvPoint2.y) || Math.max(ilvPoint.y, ilvPoint2.y) < f2) {
            return false;
        }
        if (Math.abs(d3) > Math.abs(d4) ? f < Math.min(ilvPoint3.x, ilvPoint4.x) || Math.max(ilvPoint3.x, ilvPoint4.x) < f : f2 < Math.min(ilvPoint3.y, ilvPoint4.y) || Math.max(ilvPoint3.y, ilvPoint4.y) < f2) {
            return false;
        }
        if (bl) {
            if (f == ilvPoint2.x && f2 == ilvPoint2.y) {
                return false;
            }
            if (f == ilvPoint4.x && f2 == ilvPoint4.y) {
                return false;
            }
        }
        return true;
    }

    private static boolean a(IlvPoint ilvPoint, IlvPoint ilvPoint2, float f, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f2) {
        double d = ilvPoint2.x - ilvPoint.x;
        double d2 = ilvPoint4.y - ilvPoint3.y;
        double d3 = d * d2;
        double d4 = ilvPoint4.x - ilvPoint3.x;
        double d5 = ilvPoint2.y - ilvPoint.y;
        double d6 = d4 * d5;
        if (d3 != d6) {
            return false;
        }
        if (f <= 0.0f) {
            f = 0.5f;
        }
        if (f2 <= 0.0f) {
            f2 = 0.5f;
        }
        float f3 = d5 == 0.0 ? 0.0f : (float)(0.5 * (double)f / Math.sqrt(d / d5 * d / d5 + 1.0));
        float f4 = d == 0.0 ? 0.0f : (float)(0.5 * (double)f / Math.sqrt(d5 / d * d5 / d + 1.0));
        if (d * d5 > 0.0) {
            f3 = -f3;
        }
        IlvPoint ilvPoint5 = new IlvPoint(ilvPoint.x + f3, ilvPoint.y + f4);
        IlvPoint ilvPoint6 = new IlvPoint(ilvPoint.x - f3, ilvPoint.y - f4);
        IlvPoint ilvPoint7 = new IlvPoint(ilvPoint2.x + f3, ilvPoint2.y + f4);
        IlvPoint ilvPoint8 = new IlvPoint(ilvPoint2.x - f3, ilvPoint2.y - f4);
        f3 = d2 == 0.0 ? 0.0f : (float)(0.5 * (double)f2 / Math.sqrt(d4 / d2 * d4 / d2 + 1.0));
        f4 = d4 == 0.0 ? 0.0f : (float)(0.5 * (double)f2 / Math.sqrt(d2 / d4 * d2 / d4 + 1.0));
        if (d4 * d2 > 0.0) {
            f3 = -f3;
        }
        IlvPoint ilvPoint9 = new IlvPoint(ilvPoint3.x + f3, ilvPoint3.y + f4);
        IlvPoint ilvPoint10 = new IlvPoint(ilvPoint3.x - f3, ilvPoint3.y - f4);
        IlvPoint ilvPoint11 = new IlvPoint(ilvPoint4.x + f3, ilvPoint4.y + f4);
        IlvPoint ilvPoint12 = new IlvPoint(ilvPoint4.x - f3, ilvPoint4.y - f4);
        if (IlvGraphLayoutUtil.a(ilvPoint5, ilvPoint6, ilvPoint9, ilvPoint11, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint5, ilvPoint6, ilvPoint10, ilvPoint12, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint7, ilvPoint8, ilvPoint9, ilvPoint11, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint7, ilvPoint8, ilvPoint10, ilvPoint12, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint9, ilvPoint10, ilvPoint5, ilvPoint7, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint9, ilvPoint10, ilvPoint6, ilvPoint8, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint11, ilvPoint12, ilvPoint5, ilvPoint7, false)) {
            return true;
        }
        return IlvGraphLayoutUtil.a(ilvPoint11, ilvPoint12, ilvPoint6, ilvPoint8, false);
    }

    public static void ConnectLinksToPoint(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic, IlvPoint ilvPoint, IlvTransformer ilvTransformer, boolean bl) {
        IlvClippingUtil.ConnectLinksToPoint((IlvGrapher)ilvGrapher, (IlvGraphic)ilvGraphic, (IlvPoint)ilvPoint, (IlvTransformer)ilvTransformer, (boolean)bl);
    }

    public static IlvPoint BestClipPointOnRay(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n) {
        return IlvClippingUtil.BestClipPointOnRay((IlvPoint)ilvPoint, (IlvPoint)ilvPoint2, (IlvPoint[])ilvPointArray, (int)n);
    }

    public static boolean LineIntersectsSegment(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5) {
        return IlvClippingUtil.LineIntersectsSegment((IlvPoint)ilvPoint, (IlvPoint)ilvPoint2, (IlvPoint)ilvPoint3, (IlvPoint)ilvPoint4, (IlvPoint)ilvPoint5);
    }

    public static int LineIntersectsPolyPoints(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, boolean bl, IlvPoint[] ilvPointArray2) {
        return IlvClippingUtil.LineIntersectsPolyPoints((IlvPoint)ilvPoint, (IlvPoint)ilvPoint2, (IlvPoint[])ilvPointArray, (boolean)bl, (IlvPoint[])ilvPointArray2);
    }

    public static int LineIntersectsEllipse(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvRect ilvRect, IlvPoint[] ilvPointArray) {
        return IlvClippingUtil.LineIntersectsEllipse((IlvPoint)ilvPoint, (IlvPoint)ilvPoint2, (IlvRect)ilvRect, (IlvPoint[])ilvPointArray);
    }

    public static int LineIntersectsArc(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvRect ilvRect, double d, double d2, IlvPoint[] ilvPointArray) {
        return IlvClippingUtil.LineIntersectsArc((IlvPoint)ilvPoint, (IlvPoint)ilvPoint2, (IlvRect)ilvRect, (double)d, (double)d2, (IlvPoint[])ilvPointArray);
    }

    public static int LineIntersectsQuadSpline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n, IlvPoint[] ilvPointArray2) {
        return IlvClippingUtil.LineIntersectsQuadSpline((IlvPoint)ilvPoint, (IlvPoint)ilvPoint2, (IlvPoint[])ilvPointArray, (int)n, (IlvPoint[])ilvPointArray2);
    }

    public static int LineIntersectsCubicSpline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n, IlvPoint[] ilvPointArray2) {
        return IlvClippingUtil.LineIntersectsCubicSpline((IlvPoint)ilvPoint, (IlvPoint)ilvPoint2, (IlvPoint[])ilvPointArray, (int)n, (IlvPoint[])ilvPointArray2);
    }

    public static IlvPoint ArcStartPoint(IlvRect ilvRect, double d) {
        return IlvClippingUtil.ArcStartPoint((IlvRect)ilvRect, (double)d);
    }

    public static IlvPoint ArcEndPoint(IlvRect ilvRect, double d, double d2) {
        return IlvClippingUtil.ArcEndPoint((IlvRect)ilvRect, (double)d, (double)d2);
    }

    public static Enumeration CreateSortedEnumeration(Enumeration enumeration, Comparator comparator) {
        if (comparator == null || enumeration == null || !enumeration.hasMoreElements()) {
            return enumeration;
        }
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        final int n = arrayList.size();
        final Object[] objectArray = arrayList.toArray();
        IlvGraphLayoutUtil.Sort(objectArray, comparator);
        return new Enumeration(){
            private int a = 0;

            @Override
            public boolean hasMoreElements() {
                return this.a < n;
            }

            public Object nextElement() {
                if (this.a < n) {
                    return objectArray[this.a++];
                }
                throw new NoSuchElementException("Enumeration");
            }
        };
    }

    public static void Sort(Object[] objectArray, Comparator comparator) {
        if (comparator == null || objectArray == null || objectArray.length <= 1) {
            return;
        }
        SortByComparator sortByComparator = new SortByComparator(comparator);
        sortByComparator.sort(objectArray);
    }

    private static class SortByComparator
    extends IlvArrayStableSort {
        private Comparator a;

        SortByComparator(Comparator comparator) {
            this.a = comparator;
        }

        @Override
        protected final boolean compare(Object object, Object object2) {
            return this.a.compare(object, object2) <= 0;
        }
    }

    private static final class ConnectedComponentsFinder
    extends IlvGraphModelDFS {
        private transient IlvConnectedComponentAdapter a = null;

        ConnectedComponentsFinder(IlvGraphModel ilvGraphModel, String string) {
            super(ilvGraphModel, string);
        }

        public IlvGraphModel getConnectedComponents() {
            Enumeration enumeration;
            IlvConnectedComponentCollectionAdapter ilvConnectedComponentCollectionAdapter;
            block6: {
                block5: {
                    ilvConnectedComponentCollectionAdapter = new IlvConnectedComponentCollectionAdapter(this._graphModel);
                    enumeration = this._graphModel.getNodes();
                    if (enumeration == null) break block5;
                    if (enumeration.hasMoreElements()) break block6;
                }
                LogResUtil.logAndThrowRuntimeExc(IlvGraphLayout.class, "graphlayout.expert.message.6047E");
            }
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (this.isMarkedNode(e)) continue;
                this.a = new IlvConnectedComponentAdapter(this._graphModel);
                ilvConnectedComponentCollectionAdapter.addNode(this.a);
                super.execute(e, false);
            }
            Enumeration enumeration2 = ilvConnectedComponentCollectionAdapter.getNodes();
            while (enumeration2.hasMoreElements()) {
                Enumeration enumeration3 = ((IlvGraphModel)enumeration2.nextElement()).getNodesAndLinks();
                while (enumeration3.hasMoreElements()) {
                    this._graphModel.setProperty(enumeration3.nextElement(), this._propName, null);
                }
            }
            return ilvConnectedComponentCollectionAdapter;
        }

        @Override
        protected void markNode(Object object) {
            super.markNode(object);
            this.a.addNode(object);
        }

        @Override
        protected void markLink(Object object) {
            super.markLink(object);
            this.a.addLink(object);
        }
    }

    private static final class CountNodesInConnectedComponent
    extends IlvGraphModelDFS {
        private int a = 0;

        CountNodesInConnectedComponent(IlvGraphModel ilvGraphModel, String string) {
            super(ilvGraphModel, string);
        }

        int a(Object object) {
            this.a = 0;
            super.execute(object, true);
            return this.a;
        }

        @Override
        protected void markNode(Object object) {
            super.markNode(object);
            ++this.a;
        }
    }

    private static final class TestTree
    extends IlvGraphModelDFS {
        private boolean a;
        private boolean b;

        TestTree(IlvGraphModel ilvGraphModel, String string) {
            super(ilvGraphModel, string);
        }

        boolean a(Object object) {
            this.b = true;
            this.a = false;
            super.execute(object, true);
            return this.b;
        }

        @Override
        protected void traverseBack(Object object, Object object2) {
            if (this._graphModel.getFrom(object) != this._graphModel.getTo(object)) {
                this.b = false;
                this.a = true;
            }
        }

        @Override
        protected boolean isDone() {
            return this.a;
        }
    }

    public static interface FreeLinkConnectorFactory {
        public IlvFreeLinkConnector create(IlvGraphic var1);
    }
}

