/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import oracle.dbtools.raptor.schemabrowser.model.SBListModel;
import oracle.dbtools.raptor.schemabrowser.model.SBSearchCategory;
import oracle.ide.model.Displayable;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;

public class SearchableListModel<T extends Displayable>
extends AbstractListModel
implements SBListModel<T>,
SearchListener {
    private List<T> m_data = new ArrayList<T>();
    private List<T> m_filteredData = new ArrayList<T>();
    private String m_match;
    private SBSearchCategory m_category;

    public void searchCategoryChanged(SearchEvent searchEvent) {
        SBSearchCategory sBSearchCategory = (SBSearchCategory)searchEvent.getSearchCategory();
        if (sBSearchCategory != this.m_category) {
            this.m_category = sBSearchCategory;
            if (this.m_match != null) {
                this.updateFilter();
            }
        }
    }

    public void searchPerformed(SearchEvent searchEvent) {
        String string = this.m_match;
        if (searchEvent.isFromClear()) {
            this.m_match = null;
        } else {
            String string2 = searchEvent.getSearchText();
            if (!ModelUtil.hasLength((String)string2)) {
                string2 = null;
            }
            this.m_match = string2;
            this.m_category = (SBSearchCategory)searchEvent.getSearchCategory();
        }
        if (ModelUtil.areDifferent((Object)this.m_match, (Object)string)) {
            this.updateFilter();
        }
    }

    public Object getElementAt(int n) {
        return this.m_filteredData.get(n);
    }

    @Override
    public int getSize() {
        return this.m_filteredData.size();
    }

    @Override
    public void addElements(Collection<T> collection) {
        this.m_data.addAll(collection);
        int n = this.m_filteredData.size();
        int n2 = 0;
        if (this.m_match == null) {
            n2 = collection.size();
            this.m_filteredData.addAll(collection);
        } else {
            for (Displayable displayable : collection) {
                if (!this.m_category.match(this.m_match, displayable)) continue;
                this.m_filteredData.add(displayable);
                ++n2;
            }
        }
        if (n2 > 0) {
            this.fireIntervalAdded(this, n, n + n2 - 1);
        }
    }

    @Override
    public void clear() {
        this.m_data.clear();
        int n = this.m_filteredData.size() - 1;
        this.m_filteredData.clear();
        if (n >= 0) {
            this.fireIntervalRemoved(this, 0, n);
        }
    }

    private void updateFilter() {
        this.m_filteredData.clear();
        if (this.m_match == null || this.m_category == null) {
            this.m_filteredData.addAll(this.m_data);
        } else {
            for (Displayable displayable : this.m_data) {
                if (!this.m_category.match(this.m_match, displayable)) continue;
                this.m_filteredData.add(displayable);
            }
        }
        this.fireContentsChanged(this, 0, this.m_filteredData.size() - 1);
    }
}

