/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchyviewer.HierarchyET;
import oracle.hcs.hierarchyviewer.HierarchyViewerDialog;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.Member;
import oracle.hcs.templates.templateview.QDRData;
import oracle.hcs.templates.templateview.TemplateHyperParam;
import oracle.hcs.tree.model.DefaultNode;
import oracle.hcs.tree.model.HierarchyNodeData;
import oracle.hcs.util.HyperLabel;
import oracle.hcs.util.HyperLabelActionListener;
import oracle.ide.Ide;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;

public class TemplateHyperParamMemberKey
extends TemplateHyperParam {
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamMemberKey.class.getName());
    private static final String DEFAULT_NAME = "member_key";
    private static final String DEFAULT_VALUE = "ALL";
    private HyperLabel qdrComponent;
    protected final HyperLabel button;
    private final JLabel label;
    private final JPanel gui = new JPanel(new FlowLayout(0, 0, 0));
    private List<QDRData> qdr;
    protected AnalyticView analyticView;
    private AVHierarchy selectedAVHier;
    private boolean abreviate;
    private static final ParseNode pattern = new ParseNode("member_key", HCSSyntaxType.QDR.toString(), ParseNode.PatternType.SKIP_CHILDREN);
    private final String HIERARCHY_LEVEL_TYPE = "hierarchy_level";
    private final String HIERARCHY_TYPE = "hierarchy";
    private final String OPERATOR_TYPE = "operator";
    private Connection conn;

    public TemplateHyperParamMemberKey() {
        this.gui.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.button = this.createButton();
        this.label = new JLabel(HCSArb.getString("CALC_EDITOR_NESTED_EXPRESION_LABEL"));
        this.label.setVisible(false);
        this.qdrComponent = this.getQDRComponent();
        this.setName(DEFAULT_NAME);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(this.label);
        this.gui.add(this.button);
        this.gui.add(this.label);
        if (this.qdrComponent != null) {
            this.gui.add(this.qdrComponent);
        }
    }

    @Override
    public void init() {
        this.analyticView = this.getTemplateContext().getAV();
        this.qdr = this.buildQDR();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getTemplateContext().getProvider();
        this.conn = oracleDatabaseImpl.getConnection();
    }

    private List<QDRData> buildQDR() {
        if (this.qdr == null || this.qdr.size() > 0) {
            this.qdr = new ArrayList<QDRData>();
        }
        if (this.selectedAVHier != null) {
            this.qdr.add(new QDRData(this.selectedAVHier, null, null));
        }
        return this.qdr;
    }

    @Override
    public Component getComponent() {
        return this.gui;
    }

    @Override
    public Object getValue() {
        return this.getExpression();
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof ParseNode) {
            Object object2;
            ParseNode parseNode = (ParseNode)object;
            String string = parseNode.getType();
            ParseNode parseNode2 = null;
            String string2 = "";
            if (string.equals("hierarchy_level")) {
                parseNode2 = (ParseNode)parseNode.getParent();
                if (parseNode2 != null) {
                    string2 = parseNode2.getChildren() != null && parseNode2.getChildren().size() > 0 ? ((ParseNode)parseNode2.getChildren().get(0)).getFullValue() : "";
                }
            } else if (string.equals("operator") && (object2 = (ParseNode)(parseNode2 = parseNode).getParent()) != null) {
                string2 = ((ParseNode)object2).getFullValue();
            }
            if (parseNode2 != null) {
                Object object3;
                String string3;
                Object object4;
                String string4;
                object2 = new IdentifierElement(string2);
                if (((IdentifierElement)object2).getCount() == 2) {
                    string2 = ((IdentifierElement)object2).getSecond();
                }
                QDRData qDRData = this.findQDRData(string2, this.qdr);
                ArrayList<QDRData> arrayList = new ArrayList<QDRData>();
                QDRData qDRData2 = (QDRData)qDRData.clone();
                qDRData2.clearMembers();
                arrayList.add(qDRData2);
                if (qDRData != null) {
                    string4 = "";
                    for (TreeNode object5 : parseNode2.getChildren()) {
                        object4 = (ParseNode)object5;
                        string3 = ((ParseNode)object4).getType();
                        if (string3.equals("hierarchy")) continue;
                        string4 = ((ParseNode)object4).getFullValue();
                        if ((string4 = string4.replaceAll("\"", "")).equals(DEFAULT_VALUE)) {
                            qDRData.clearMembers();
                            object3 = this.generateQDRText(true, this.qdr);
                            this.setQDRText(this.qdrComponent, (String)object3);
                            return true;
                        }
                        for (TreeNode treeNode : ((ParseNode)object4).getChildren()) {
                            String string5 = ((ParseNode)treeNode).getFullValue();
                            string5 = string5.replaceAll("'", "");
                            qDRData2.addMember(string5, string5, string4, string4);
                        }
                    }
                }
                if (!this.additionalMemberFound(qDRData, string4 = this.getMemberUniqueName(qDRData2.getAdditionalMembers()))) {
                    Object object6 = qDRData2.getAVHierarchy().getName();
                    String string6 = this.getTemplateContext().getSchema().getName();
                    object6 = String.format("%s.%s", string6, object6);
                    object4 = this.getMissingMemberInformation((String)object6, string4);
                    string3 = qDRData2.getAdditionalMembers().get(0).getMemberLevelName();
                    qDRData.clearMembers();
                    qDRData.addMember(string4, (String)object4, string3, string3);
                    object3 = "";
                    object3 = !((String)object4).isEmpty() ? this.generateQDRText(true, this.qdr) : string4;
                    this.setQDRText(this.qdrComponent, (String)object3);
                }
            }
        }
        return true;
    }

    private String getMemberUniqueName(List<Member> list) {
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = String.format("[%s]", list.get(0).getMemberLevelName());
            for (Member member : list) {
                String string2 = String.format("&[%s]", member.getMemberDescription());
                stringBuilder.append(string2);
            }
            return String.format("%s.%s", string, stringBuilder.toString());
        }
        return "";
    }

    private boolean additionalMemberFound(QDRData qDRData, String string) {
        Member member;
        String string2;
        List<Member> list = qDRData.getAdditionalMembers();
        return list != null && string.equals(string2 = (member = list.get(0)).getMemberKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMissingMemberInformation(String string, String string2) {
        ResultSet resultSet = null;
        String string3 = "";
        String string4 = "";
        try {
            SQLException sQLException;
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("member_unique_name", string2);
            String string5 = "select MEMBER_CAPTION, member_description from %s where member_unique_name = :member_unique_name";
            string5 = String.format(string5, string);
            Connections.getInstance().lock(this.conn);
            resultSet = dBUtil.executeOracleQuery(string5, hashMap);
            if (resultSet != null) {
                while (resultSet.next()) {
                    string3 = resultSet.getString(1);
                    string4 = resultSet.getString(2);
                }
            }
            if ((sQLException = dBUtil.getLastException()) != null) {
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
        }
        finally {
            Connections.getInstance().unlock(this.conn);
        }
        return this.getDisplayTextForMember(string3, string4, string2);
    }

    private QDRData findQDRData(String string, List<QDRData> list) {
        for (QDRData qDRData : list) {
            AVHierarchy aVHierarchy = qDRData.getAVHierarchy();
            String string2 = aVHierarchy.getName();
            String string3 = aVHierarchy.getHierarchyAlias();
            if (!string2.equals(string) && !string3.equals(string)) continue;
            return qDRData;
        }
        return null;
    }

    @Override
    public String getExpression() {
        String string = this.generateQDRText(false, this.qdr);
        if (string == null) {
            return DEFAULT_VALUE;
        }
        return string;
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public int getPixelSize(int n) {
        int n2 = 0;
        if (this.qdrComponent != null) {
            String string = this.qdrComponent.getText();
            if (string == null) {
                string = DEFAULT_VALUE;
            }
            n2 = this.qdrComponent.getFontMetrics(this.qdrComponent.getFont()).stringWidth(string);
        }
        if (this.abreviate) {
            return n2 + this.label.getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
        }
        return n2 + this.button.getFontMetrics(this.button.getFont()).stringWidth(this.button.getText());
    }

    @Override
    public boolean isValid() {
        return this.getValue() != null;
    }

    private HyperLabel createButton() {
        HyperLabel hyperLabel = new HyperLabel("");
        hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
            }
        });
        return hyperLabel;
    }

    public AnalyticView getAV() {
        return this.analyticView;
    }

    protected HyperLabel getQDRComponent() {
        HyperLabel hyperLabel = new HyperLabel(DEFAULT_VALUE);
        hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                TemplateHyperParamMemberKey.this.showSelector(TemplateHyperParamMemberKey.this.qdr);
                if (TemplateHyperParamMemberKey.this.qdr != null) {
                    TemplateHyperParamMemberKey.this.refreshQDR();
                }
            }
        });
        return hyperLabel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showSelector(List<QDRData> list) {
        Object object;
        QDRData[] qDRDataArray = null;
        AVHierarchy aVHierarchy = this.selectedAVHier;
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getTemplateContext().getProvider();
        Connection connection = oracleDatabaseImpl.getConnection();
        String string = aVHierarchy.getName();
        String string2 = HCSArb.getString("DIMENSION_MEMBER_SELECTOR_TITLE");
        HierarchyViewerDialog hierarchyViewerDialog = null;
        QDRData qDRData = null;
        for (QDRData qDRData2 : list) {
            String string3 = qDRData2.getAVHierarchy().getName();
            if (!string3.equals(string)) continue;
            qDRData = qDRData2;
        }
        if (qDRData != null) {
            qDRDataArray = new QDRData[]{qDRData};
        }
        HCSSchema hCSSchema = this.getTemplateContext().getSchema();
        ArrayList<HierarchyET> arrayList = new ArrayList<HierarchyET>();
        boolean bl = false;
        if (!bl) {
            object = hCSSchema.findHierarchy(string);
            try {
                arrayList.add(new HierarchyET(connection, (Hierarchy)object));
            }
            catch (IOException | SQLException exception) {
                LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
        if (arrayList.size() > 0) {
            try {
                TreePath[] treePathArray;
                object = string;
                hierarchyViewerDialog = new HierarchyViewerDialog((Window)Ide.getMainWindow(), string2, arrayList, (String)object, "SELECT_DIMENSION_MEMBERS_MODE", null, qDRDataArray, null, true, connection, true);
                hierarchyViewerDialog.setModal(true);
                Dimension dimension = new Dimension(400, 400);
                hierarchyViewerDialog.setMinimumSize(dimension);
                hierarchyViewerDialog.setPreferredSize(dimension);
                hierarchyViewerDialog.setSize(dimension);
                hierarchyViewerDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
                hierarchyViewerDialog.setVisible(true);
                boolean bl2 = hierarchyViewerDialog.isOKSelected();
                if (!bl2 || (treePathArray = hierarchyViewerDialog.getTree().getSelectionPaths()) == null || treePathArray.length <= 0) return;
                qDRData.clearMembers();
                for (int i = 0; i < treePathArray.length; ++i) {
                    TreePath treePath = treePathArray[i];
                    Object object2 = treePath.getLastPathComponent();
                    DefaultNode defaultNode = (DefaultNode)object2;
                    HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)defaultNode.getUserObject();
                    String string4 = (String)hierarchyNodeData.getProperty(hierarchyNodeData.LEVEL_NAME);
                    String string5 = this.getDisplayTextForMember(hierarchyNodeData.memberCaption, hierarchyNodeData.memberDesc, hierarchyNodeData.dimKey);
                    if (string4.equals(DEFAULT_VALUE)) continue;
                    qDRData.addMember(hierarchyNodeData.dimKey, string5, string4, (String)hierarchyNodeData.getProperty(hierarchyNodeData.LEVEL_KEY));
                }
                return;
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                String string6 = exception.getLocalizedMessage();
                MessageDialog.error((Component)hierarchyViewerDialog, (Object)(HCSArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR") + string6), (String)HCSArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), null);
                return;
            }
        } else {
            MessageDialog.error(hierarchyViewerDialog, (Object)HCSArb.get("DIMENSION_MEMBER_SELECTOR_NOT_FOUND"), (String)HCSArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), null);
        }
    }

    private String getDisplayTextForMember(String string, String string2, String string3) {
        if (string != null && !string.isEmpty()) {
            return string;
        }
        if (string2 != null && !string2.isEmpty()) {
            return string2;
        }
        return string3;
    }

    private void refreshQDR() {
        String string = this.generateQDRText(true, this.qdr);
        this.setQDRText(this.qdrComponent, string);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", null, this.qdr);
        LOG.finest("Firing change" + propertyChangeEvent);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    private void setQDRText(JComponent jComponent, String string) {
        if (jComponent == null) {
            return;
        }
        if (string == null) {
            ((HyperLabel)jComponent).setText(DEFAULT_VALUE);
        } else {
            ((HyperLabel)jComponent).setText(string);
        }
    }

    private String generateQDRText(boolean bl, List<QDRData> list) {
        if (list == null) {
            return null;
        }
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder("");
        for (QDRData qDRData : list) {
            if (!qDRData.isMemberSet()) continue;
            bl2 = true;
            String string = this.getFormattedMember(qDRData, bl);
            stringBuilder.append(string);
            stringBuilder.append(",");
        }
        if (bl2) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
        return null;
    }

    public String getFormattedMember(QDRData qDRData, boolean bl) {
        List<Member> list = qDRData.getAdditionalMembers();
        AVHierarchy aVHierarchy = qDRData.getAVHierarchy();
        String string = "";
        if (qDRData.getAdditionalMembers() != null && list.size() == 1) {
            Member member = list.get(0);
            String string2 = "";
            string2 = !bl ? this.getFormattedMemberKey(aVHierarchy, member) : this.quoteString(member.getMemberDescription());
            string = this.formatQDRText(member.getMemberLevelName(), string2);
        }
        return string;
    }

    private String quoteString(String string) {
        return String.format("'%s'", string);
    }

    private String getFormattedMemberKey(AVHierarchy aVHierarchy, Member member) {
        String string = member.getMemberKey();
        IdentifierElement identifierElement = new IdentifierElement(string);
        if (identifierElement.getCount() > 1) {
            string = identifierElement.getSecond();
            List<String> list = this.getMemberKeys(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list.size() == 1) {
                String string2 = list.get(0);
                String string3 = this.quoteString(string2);
                arrayList.add(string3);
            } else {
                String string4 = member.getMemberLevelName();
                AVDimensionality aVDimensionality = (AVDimensionality)aVHierarchy.getParent();
                AttributeDimension attributeDimension = null;
                if (aVDimensionality != null) {
                    attributeDimension = aVDimensionality.getDimension();
                }
                if (attributeDimension != null) {
                    DimensionLevel dimensionLevel = attributeDimension.findLevel(string4);
                    String string5 = dimensionLevel.getLevelKey();
                    String[] stringArray = (string5 = string5.replaceAll("[()]", "")).split(",");
                    if (stringArray.length == list.size()) {
                        for (int i = 0; i < list.size(); ++i) {
                            String string6 = list.get(i);
                            String string7 = stringArray[i];
                            String string8 = this.getCompoundKeyItem(string7, string6);
                            arrayList.add(string8);
                        }
                    }
                }
            }
            string = String.join((CharSequence)",", arrayList);
        }
        return string;
    }

    private String getCompoundKeyItem(String string, String string2) {
        return String.format("%s=%s", string, string2);
    }

    private List<String> getMemberKeys(String string) {
        string = string.replaceAll("\\[", "").replaceAll("\\]", "");
        String[] stringArray = string.split("&");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String formatQDRText(String string, String string2) {
        return String.format("%s[%s]", string, string2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof AVHierarchy) {
            this.selectedAVHier = (AVHierarchy)propertyChangeEvent.getNewValue();
            this.buildQDR();
            this.refreshQDR();
        }
    }
}

