/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.MultiSelectShuttlePanel;
import oracle.hcs.templates.templateview.TemplateHyperParamMultiSelect;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class TemplateHyperParamHierarchyLevels
extends TemplateHyperParamMultiSelect
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamHierarchyLevels.class.getName());
    private AVHierarchy avHier;
    private Hierarchy hierarchy;
    private static final ParseNode pattern = new ParseNode("hierarchy_levels", null, ParseNode.PatternType.LOOP);

    public TemplateHyperParamHierarchyLevels() {
        this.addPropertyChangeListener(this);
        this.selectionJOptionPanePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (TemplateHyperParamHierarchyLevels.this.selectionDialog.isVisible() && propertyChangeEvent.getSource() == TemplateHyperParamHierarchyLevels.this.pane && string.equals("value")) {
                    Object object = TemplateHyperParamHierarchyLevels.this.pane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    if ((Integer)object == 0) {
                        List<String> list = TemplateHyperParamHierarchyLevels.this.multiSelectEditor.getSelectedItems();
                        if (list.size() > 0) {
                            TemplateHyperParamHierarchyLevels.this.selectionDialog.setVisible(false);
                        } else {
                            String string2 = HCSArb.get("AV_DIMENSION_LEVEL_SELECTION_NONE_SELECTED_ERROR_MSG");
                            String string3 = HCSArb.get("AV_DIMENSION_LEVEL_SELECTION_ERROR_TITLE");
                            String string4 = null;
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
                            TemplateHyperParamHierarchyLevels.this.pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        }
                    } else {
                        TemplateHyperParamHierarchyLevels.this.selectionDialog.setVisible(false);
                    }
                }
            }
        };
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    private void setHierarchy(Object object) {
        if (object == this.hierarchy || object == this.avHier) {
            return;
        }
        List<Object> list = new ArrayList();
        if (object != null) {
            if (object instanceof Hierarchy) {
                Hierarchy hierarchy;
                this.hierarchy = hierarchy = (Hierarchy)object;
                list = this.getHierarchyLevels(hierarchy);
            } else if (object instanceof AVHierarchy) {
                AVHierarchy aVHierarchy;
                this.avHier = aVHierarchy = (AVHierarchy)object;
                list = this.getHierarchyLevels(aVHierarchy.getHierarchy());
            }
        }
        this.setValue(list);
    }

    private List<String> getHierarchyLevels(Hierarchy hierarchy) {
        this.helpID = null;
        this.editorTitle = HCSArb.getString("AV_DIMENSION_LEVELS");
        HierarchyLevel[] hierarchyLevelArray = null;
        List<String> list = Collections.emptyList();
        if (hierarchy != null) {
            hierarchyLevelArray = hierarchy.getHierarchyLevels();
        }
        if (hierarchyLevelArray != null && hierarchyLevelArray.length > 0) {
            list = new ArrayList<String>();
            this.setVisible(true);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("ALL");
            String string = HCSArb.getString("AV_DIMENSION_HIERARCHY_AVAIL_LEVELS");
            String string2 = HCSArb.getString("AV_DIMENSION_HIERARCHY_SELECTED_LEVELS");
            for (HierarchyLevel hierarchyLevel : hierarchyLevelArray) {
                String string3 = hierarchyLevel.getLevelName();
                arrayList.add(string3);
            }
            this.multiSelectEditor = new MultiSelectShuttlePanel(arrayList, string, string2, true);
            list.add("ALL");
            list.add(hierarchyLevelArray[0].getLevelName());
        } else {
            this.setVisible(false);
        }
        return list;
    }

    private List<String> getDefaultLevelSelection(Object object) {
        Object object2;
        HierarchyLevel[] hierarchyLevelArray = null;
        if (object instanceof Hierarchy) {
            object2 = (Hierarchy)object;
            hierarchyLevelArray = ((Hierarchy)object2).getHierarchyLevels();
        } else if (object instanceof AVHierarchy) {
            object2 = (AVHierarchy)object;
            hierarchyLevelArray = ((AVHierarchy)object2).getHierarchy().getHierarchyLevels();
        }
        object2 = new ArrayList();
        if (hierarchyLevelArray != null && hierarchyLevelArray.length > 0) {
            object2.add(hierarchyLevelArray[0].getLevelName());
        }
        return object2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)propertyChangeEvent.getNewValue();
            this.setHierarchy(hierarchy);
        } else if (propertyChangeEvent.getNewValue() instanceof AVHierarchy) {
            AVHierarchy aVHierarchy = (AVHierarchy)propertyChangeEvent.getNewValue();
            this.setHierarchy(aVHierarchy);
        }
    }

    @Override
    public void setDefault(String string) {
        if (string == null) {
            super.setDefault(string);
        }
    }

    @Override
    public String getExpression(String string) {
        if (string.equalsIgnoreCase("quoted")) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.selections.iterator();
            if (iterator.hasNext()) {
                stringBuilder.append("'" + (String)iterator.next() + "'");
                while (iterator.hasNext()) {
                    stringBuilder.append(',');
                    stringBuilder.append("'" + (String)iterator.next() + "'");
                }
            }
            return stringBuilder.toString();
        }
        return super.getExpression();
    }

    @Override
    public void init() {
        String string;
        if (this.getParam() != null && (string = this.getParam().getInitialDefault()) != null) {
            this.setValue(string.toUpperCase());
        }
    }

    static {
        pattern.add(new ParseNode("hierarchy_levels", HCSSyntaxType.LEVEL.toString(), ParseNode.PatternType.NONE));
    }
}

