/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.editor.plugins;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.hcs.syntaxbuilder.editor.plugins.CodeEditorTextListener;
import oracle.hcs.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.hcs.syntaxbuilder.parsetree.ParseJTree;
import oracle.hcs.syntaxbuilder.specification.Spec;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.syntaxparser.SyntaxParser;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controls.Toolbar;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public class CalculatedMeasureDebugPlugin
implements EditorPlugin {
    private Toolbar toolbar;
    private final InsertionHandlerEditorPlugin ihandler;
    private final Spec specParser;
    private final SyntaxParser parser;

    public CalculatedMeasureDebugPlugin(InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, Spec spec, SyntaxParser syntaxParser) {
        this.ihandler = insertionHandlerEditorPlugin;
        this.specParser = spec;
        this.parser = syntaxParser;
    }

    public CalculatedMeasureDebugPlugin(InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, Spec spec, SyntaxParser syntaxParser, Toolbar toolbar) {
        this.ihandler = insertionHandlerEditorPlugin;
        this.specParser = spec;
        this.parser = syntaxParser;
        this.toolbar = toolbar;
        this.addButton();
    }

    public void install(BasicEditorPane basicEditorPane) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        this.toolbar = codeEditor.getToolbar();
        this.addButton();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void addButton() {
        this.toolbar.add((Action)new AbstractAction("Parse Tree..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final JTextPane jTextPane = new JTextPane();
                jTextPane.setEditable(false);
                jTextPane.setMinimumSize(new Dimension(430, 100));
                final DefaultTreeModel defaultTreeModel = new DefaultTreeModel(CalculatedMeasureDebugPlugin.this.ihandler.getParseRoot());
                final ParseJTree parseJTree = new ParseJTree(defaultTreeModel, CalculatedMeasureDebugPlugin.this.specParser);
                for (int i = 0; i < parseJTree.getRowCount(); ++i) {
                    parseJTree.expandRow(i);
                }
                parseJTree.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                        if (treePath != null) {
                            ParseNode parseNode = (ParseNode)treePath.getLastPathComponent();
                            jTextPane.setText(String.format("Name=%s  %nType=%s %nisCheckName=%s %nBounds=[%d,%d][%d,%d]%nParamName=%s %nPattern=%s%nvalue=%s", new Object[]{parseNode.getValue(), parseNode.getType(), parseNode.isCheckName(), parseNode.getOffset(), parseNode.getEnd(), parseNode.getReplaceOffset(), parseNode.getReplaceEnd(), parseNode.getParamName(), parseNode.getPatternType(), parseNode.getFullValue()}));
                        }
                    }
                });
                CalculatedMeasureDebugPlugin.this.ihandler.addCodeEditorTextListener(new CodeEditorTextListener(){

                    @Override
                    public void syntaxChecked(String string, boolean bl) {
                        defaultTreeModel.reload();
                        for (int i = 0; i < parseJTree.getRowCount(); ++i) {
                            parseJTree.expandRow(i);
                        }
                    }

                    @Override
                    public void textChanged(String string) {
                    }
                });
                JPanel jPanel = new JPanel(new GridBagLayout());
                int n = 0;
                GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0);
                jPanel.add((Component)new JScrollPane(parseJTree), gridBagConstraints);
                gridBagConstraints = new GridBagConstraints(0, ++n, 1, 7, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0);
                jPanel.add((Component)jTextPane, gridBagConstraints);
                JOptionPane jOptionPane = new JOptionPane(jPanel, -1);
                JDialog jDialog = jOptionPane.createDialog((Component)Ide.getMainWindow(), "Calculation Syntax Parse Tree");
                jDialog.setResizable(true);
                jDialog.setSize(500, 600);
                jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                jDialog.setVisible(true);
            }
        });
    }
}

