/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax.hcsgen;

import oracle.hcs.syntax.hcsgen.ArgumentOwnerState;
import oracle.hcs.syntax.hcsgen.FunctionDescriptorGenerator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

abstract class GeneratorState {
    GeneratorState m_Parent = null;
    FunctionDescriptorGenerator m_Generator = null;
    boolean m_Optional = false;
    boolean m_Repeated = false;

    GeneratorState() {
    }

    GeneratorState getParent() {
        return this.m_Parent;
    }

    void setContext(FunctionDescriptorGenerator functionDescriptorGenerator, GeneratorState generatorState) {
        this.m_Generator = functionDescriptorGenerator;
        this.m_Parent = generatorState;
    }

    FunctionDescriptorGenerator getGenerator() {
        return this.m_Generator;
    }

    boolean isOptional() {
        return this.m_Optional;
    }

    boolean isRepeated() {
        return this.m_Repeated;
    }

    void initialize(Attributes attributes) throws SAXException {
        this.m_Optional = this.getBoolean("optional", attributes);
        this.m_Repeated = this.getBoolean("repeated", attributes);
        if (this.getParent() instanceof ArgumentOwnerState) {
            ((ArgumentOwnerState)this.getParent()).newArgument();
        }
    }

    void append(boolean bl) {
        if (bl) {
            this.getGenerator().append("true");
        } else {
            this.getGenerator().append("false");
        }
    }

    void newLine() {
        this.getGenerator().newLine();
    }

    void newLineAndIndent() {
        this.getGenerator().newLineAndIndent();
    }

    void appendLine(String string) {
        this.getGenerator().appendLine(string);
    }

    void append(String string) {
        this.getGenerator().append(string);
    }

    void incrementIndent() {
        this.getGenerator().incrementIndent();
    }

    void decrementIndent() {
        this.getGenerator().decrementIndent();
    }

    void exit() throws SAXException {
    }

    GeneratorState transition(String string, Attributes attributes) throws SAXException {
        throw new SAXException(string);
    }

    String getAttributeValue(String string, Attributes attributes, boolean bl) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string2 = attributes.getLocalName(i);
            String string3 = attributes.getValue(i);
            if (!string.equalsIgnoreCase(string2)) continue;
            return string3;
        }
        if (bl) {
            throw new SAXException("Expected Attribute " + string);
        }
        return null;
    }

    boolean getBoolean(String string, Attributes attributes) throws SAXException {
        return "TRUE".equalsIgnoreCase(this.getAttributeValue(string, attributes, false));
    }
}

