/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.source;

public class Column
implements Comparable<Column> {
    private String name;
    private String dataType;
    private boolean isPrimaryKey;
    private boolean isNullable;

    public Column(String string, String string2, String string3) {
        this.name = string;
        this.isNullable = true;
        if (string2 != null) {
            this.isNullable = string2.equalsIgnoreCase("Y");
        }
        this.dataType = string3;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setIsPrimaryKey(boolean bl) {
        this.isPrimaryKey = bl;
    }

    public void setIsNullable(boolean bl) {
        this.isNullable = bl;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getName() {
        return this.name;
    }

    public String getDataType() {
        return this.dataType;
    }

    public boolean isDate() {
        return this.dataType.indexOf("DATE") != -1;
    }

    public boolean isNumeric() {
        return this.dataType.indexOf("NUMBER") != -1;
    }

    public boolean isString() {
        return this.dataType.indexOf("VARCHAR") != -1 || this.dataType.indexOf("CHAR") != -1 || this.dataType.indexOf("NVARCHAR") != -1 || this.dataType.indexOf("NCHAR") != -1;
    }

    public boolean isClob() {
        return this.dataType.indexOf("CLOB") != -1;
    }

    public String toString() {
        if (this.getDataType() != null) {
            return this.name + " " + this.getDataType();
        }
        return this.name;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Column && this.name != null && this.dataType != null) {
            Column column = (Column)object;
            if (this.name.equals(column.name) && this.dataType.equals(column.dataType)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        n = 11 * n + (null == this.name ? 0 : this.name.hashCode());
        n = 11 * n + (null == this.dataType ? 0 : this.dataType.hashCode());
        return n;
    }

    @Override
    public int compareTo(Column column) {
        return this.getName().compareTo(column.getName());
    }
}

