/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db;

import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.CascadeConfirmDialog;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceApplier;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public final class ProviderOperator2 {
    private final DBObjectProvider m_pro;
    private final Context m_context;
    private String m_title;

    public ProviderOperator2(DBObjectProvider dBObjectProvider) {
        this(dBObjectProvider, null);
    }

    public ProviderOperator2(DBObjectProvider dBObjectProvider, Context context) {
        this.m_pro = dBObjectProvider;
        this.m_context = context;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public Difference difference(SystemObject[] systemObjectArray, SystemObject[] systemObjectArray2) {
        if (systemObjectArray == null) {
            if (systemObjectArray2 != null) {
                systemObjectArray = new SystemObject[systemObjectArray2.length];
            }
        } else if (systemObjectArray2 == null) {
            systemObjectArray2 = new SystemObject[systemObjectArray.length];
        }
        systemObjectArray = null;
        return this.m_pro.getDiffEngine().difference((Object)systemObjectArray, (Object)systemObjectArray2);
    }

    public boolean createObjects(SystemObject[] systemObjectArray) {
        boolean bl = false;
        if (systemObjectArray != null && systemObjectArray.length > 0) {
            if (systemObjectArray.length == 1) {
                DBEditorConfig dBEditorConfig = DBEditorConfig.newCreateConfig((DBObjectProvider)this.m_pro, (DBObject)systemObjectArray[0]);
                bl = this.updateObjects(dBEditorConfig);
            } else {
                DBObjectTransaction dBObjectTransaction = new DBObjectTransaction(this.m_pro);
                dBObjectTransaction.includeListDifference(this.difference(null, systemObjectArray));
                bl = this.updateObjects(dBObjectTransaction, null);
            }
        }
        return bl;
    }

    public boolean updateObjects(SystemObject[] systemObjectArray, SystemObject[] systemObjectArray2) {
        boolean bl = false;
        if (systemObjectArray != null && systemObjectArray.length > 0) {
            if (systemObjectArray.length == 1 && systemObjectArray2[0] != null) {
                DBEditorConfig dBEditorConfig;
                if (systemObjectArray[0] == null) {
                    dBEditorConfig = DBEditorConfig.newCreateConfig((DBObjectProvider)this.m_pro, (DBObject)systemObjectArray2[0]);
                } else {
                    dBEditorConfig = DBEditorConfig.newEditConfig((DBObjectProvider)this.m_pro, (DBObject)systemObjectArray[0]);
                    dBEditorConfig.setUpdatedObject(systemObjectArray2[0]);
                }
                bl = this.updateObjects(dBEditorConfig);
            } else {
                DBObjectTransaction dBObjectTransaction = new DBObjectTransaction(this.m_pro);
                dBObjectTransaction.includeListDifference(this.difference(systemObjectArray, systemObjectArray2));
                bl = this.updateObjects(dBObjectTransaction, null);
            }
        }
        return bl;
    }

    public boolean updateObjects(DBEditorConfig dBEditorConfig) {
        dBEditorConfig.setOriginalObject(null);
        SystemObject systemObject = dBEditorConfig.getUpdatedObject();
        SystemObject systemObject2 = dBEditorConfig.getOriginalObject();
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        if (systemObject == null) {
            throw new IllegalArgumentException("cannot create/edit without an object");
        }
        if (dBObjectProvider != this.m_pro) {
            throw new IllegalArgumentException("config and operator have different providers");
        }
        if (dBEditorConfig.isCommitToProvider() && CascadeConfirmDialog.confirmReplace((DBEditorConfig)dBEditorConfig)) {
            try {
                Schema schema;
                Schema schema2 = DBUtil.getSchema((DBObject)systemObject);
                if (schema2 != null) {
                    schema = dBObjectProvider.getSchema(schema2.getName());
                    if (schema == null) {
                        dBObjectProvider.createSchema(schema2, false);
                    } else if (systemObject instanceof SchemaObject) {
                        ((SchemaObject)systemObject).setSchema(schema);
                    }
                }
                schema = new DBObjectTransaction(dBObjectProvider);
                schema.addParameter((Object)dBEditorConfig);
                schema.setCascade(true);
                schema.setReplace(true);
                schema.includeUpdate(systemObject2, systemObject);
                this.updateObjects((DBObjectTransaction)schema, dBEditorConfig);
            }
            catch (DBException dBException) {
                dBEditorConfig.setException(dBException);
                dBEditorConfig.setResult(DBEditorConfig.Result.FAILED);
                DBMessageDialog.showErrorDialog((Exception)((Object)dBException), (Object)this, (Level)Level.SEVERE, null, (String)ProviderOperator2.getErrorTitle(dBEditorConfig), null);
            }
        } else {
            if (systemObject2 != null) {
                DifferenceApplier differenceApplier = new DifferenceApplier(dBObjectProvider);
                differenceApplier.apply(systemObject2, systemObject);
            }
            dBEditorConfig.setResult(DBEditorConfig.Result.SUCCESS);
        }
        return dBEditorConfig.getResult() == DBEditorConfig.Result.SUCCESS;
    }

    public boolean commitTransaction(DBObjectTransaction dBObjectTransaction) {
        return this.updateObjects(dBObjectTransaction, null);
    }

    private boolean updateObjects(final DBObjectTransaction dBObjectTransaction, final DBEditorConfig dBEditorConfig) {
        Object object;
        final Holder holder = new Holder((Object)false);
        if (DBMessageDialog.useDialog() && SwingUtilities.isEventDispatchThread()) {
            object = new ProgressBar(DBMessageDialog.getDialogParent(), this.getTitle(dBObjectTransaction, dBEditorConfig), null, true);
            Runnable runnable = new Runnable(){
                final /* synthetic */ ProgressBar val$pbar;
                {
                    this.val$pbar = progressBar;
                }

                @Override
                public void run() {
                    try {
                        dBObjectTransaction.setReplace(true);
                        holder.set((Object)ProviderOperator2.this.updateObjectsImpl(dBObjectTransaction, dBEditorConfig));
                    }
                    finally {
                        this.val$pbar.setDoneStatus();
                    }
                }
            };
            object.setRunnable(runnable);
            object.setCancelable(false);
            object.setDialogName("Transaction Commit:" + DBUtil.createUUID());
            DBUIProgressBar.start((ProgressBar)object, (String)UIBundle.format((String)"DBOBJECT_UPDATING_TEXT", (Object[])new Object[]{dBObjectTransaction.getProvider().getDescription()}), null);
        } else {
            holder.set((Object)this.updateObjectsImpl(dBObjectTransaction, dBEditorConfig));
        }
        if (dBEditorConfig != null && dBEditorConfig.getResult() == DBEditorConfig.Result.FAILED && (object = dBEditorConfig.getException()) != null) {
            this.processException((DBException)((Object)object), dBEditorConfig);
        }
        return (Boolean)holder.get();
    }

    private boolean updateObjectsImpl(DBObjectTransaction dBObjectTransaction, DBEditorConfig dBEditorConfig) {
        boolean bl = false;
        try {
            if (dBEditorConfig != null && dBEditorConfig.getEditorType() == DBEditorFactory.EditorType.EDIT_FLAT) {
                dBObjectTransaction.setRefactorUpdatedObject(true);
            }
            if (this.m_context != null) {
                dBObjectTransaction.addParameter((Object)this.m_context);
            }
            dBObjectTransaction.commit();
            bl = true;
            if (dBEditorConfig != null) {
                dBEditorConfig.setResult(DBEditorConfig.Result.SUCCESS);
            }
        }
        catch (DBException dBException) {
            if (dBEditorConfig == null) {
                this.processException(dBException, null);
            } else {
                dBEditorConfig.setResult(DBEditorConfig.Result.FAILED);
                dBEditorConfig.setException(dBException);
            }
        }
        catch (Exception exception) {
            if (dBEditorConfig != null) {
                dBEditorConfig.setResult(DBEditorConfig.Result.ERROR);
                dBEditorConfig.setException(new DBException((DBObject)dBEditorConfig.getUpdatedObject(), (Throwable)exception));
            }
            DBLog.getLogger((Object)this).log(Level.SEVERE, "Commit of txn threw unexepcted error", exception);
        }
        return bl;
    }

    private void processException(DBException dBException, DBEditorConfig dBEditorConfig) {
        DBObjectProvider dBObjectProvider;
        boolean bl = false;
        if (dBEditorConfig != null && (dBObjectProvider = dBEditorConfig.getProvider()) instanceof Database) {
            SystemObject systemObject = dBEditorConfig.getOriginalObject();
            final SystemObject systemObject2 = dBEditorConfig.getUpdatedObject();
            SystemObject systemObject3 = null;
            try {
                Object object;
                if (systemObject != null) {
                    object = systemObject.getProperty("Timestamp");
                    DBUtil.clearCachedTimestamp((DBObjectProvider)dBObjectProvider, (SystemObject)systemObject);
                    systemObject3 = (SystemObject)DBUtil.getProviderDefinition((DBObject)systemObject, (DBObjectProvider)dBObjectProvider);
                    if (systemObject3 == null && !DBUtil.areNamesAndTypesEqual((DBObject)systemObject, (DBObject)systemObject2)) {
                        systemObject3 = (SystemObject)DBUtil.getProviderDefinition((DBObject)systemObject2, (DBObjectProvider)dBObjectProvider);
                    }
                } else {
                    object = null;
                    systemObject3 = (SystemObject)DBUtil.getProviderDefinition((DBObject)systemObject2, (DBObjectProvider)dBObjectProvider);
                }
                Object object2 = systemObject3 == null ? null : systemObject3.getProperty("Timestamp");
                String string = null;
                if (systemObject != null && systemObject3 == null) {
                    string = UIBundle.get((String)"DBOBJECT_WAS_DROPPED_WARNING");
                } else if (systemObject == null && systemObject3 != null) {
                    string = UIBundle.get((String)"DBOBJECT_WAS_CREATED_WARNING");
                } else if (systemObject != null && object != null && ModelUtil.areDifferent((Object)object, (Object)object2)) {
                    string = UIBundle.get((String)"DBOBJECT_HAD_CHILDREN_DROPPED_WARNING");
                }
                DBMessageDialog.showErrorDialog((Exception)((Object)dBException), (Object)this, (Level)Level.SEVERE, (String)string, (String)ProviderOperator2.getErrorTitle(dBEditorConfig), null);
                bl = true;
                systemObject2.setProperty("Timestamp", object2);
                dBEditorConfig.setOriginalObject(systemObject3);
                if (systemObject3 != null) {
                    if (systemObject == null) {
                        dBEditorConfig.setReplaceAlwaysAllowed(true);
                    } else {
                        SystemObject systemObject4 = systemObject3;
                        DBUIProgressBar dBUIProgressBar = new DBUIProgressBar(ProviderOperator2.getTitle(dBEditorConfig));
                        dBUIProgressBar.execute(new Runnable(){
                            final /* synthetic */ DBObject val$newOriginal;
                            {
                                this.val$newOriginal = dBObject;
                            }

                            @Override
                            public void run() {
                                DBUtil.resetTemporaryCopy((DBObject)systemObject2, (DBObject)this.val$newOriginal, null, (DBObjectProvider)ProviderOperator2.this.m_pro);
                            }
                        });
                    }
                }
            }
            catch (DBException dBException2) {
                DBLog.getLogger().warning("Error determining if old object should be updated: " + dBException2.getMessage());
            }
        }
        if (!bl) {
            DBMessageDialog.showErrorDialog((Exception)((Object)dBException), (Object)this, (Level)Level.SEVERE, (String)dBException.getMessage(), (String)ProviderOperator2.getErrorTitle(dBEditorConfig), null);
        }
    }

    private String getTitle(DBObjectTransaction dBObjectTransaction, DBEditorConfig dBEditorConfig) {
        String string = this.m_title != null ? this.m_title : (dBEditorConfig != null ? ProviderOperator2.getTitle(dBEditorConfig) : UIBundle.get((String)"DBOBJECT_UPDATING_TITLE"));
        return string;
    }

    public static String getErrorTitle(DBEditorConfig dBEditorConfig) {
        return ProviderOperator2.getTitleImpl(dBEditorConfig, true);
    }

    public static String getTitle(DBEditorConfig dBEditorConfig) {
        return ProviderOperator2.getTitleImpl(dBEditorConfig, false);
    }

    private static String getTitleImpl(DBEditorConfig dBEditorConfig, boolean bl) {
        return DBTypeDisplayRegistry.getDialogTitle((String)dBEditorConfig.getObjectType(), (boolean)dBEditorConfig.isEdit(), (boolean)bl);
    }
}

