/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import oracle.dbtools.db.DBUtil;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.db.panels.HCSDDLPanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;

public abstract class DDLBasedActionsHelper
implements AlterHCSObjectHelper {
    private StringBuilder sqlStatementsQuery;
    private Collection<String> statements;
    private Database database;

    public DDLBasedActionsHelper(Database database) {
        this.database = database;
    }

    protected Database getDatabase() {
        return this.database;
    }

    protected void setDatabase(Database database) {
        this.database = database;
    }

    @Override
    public String getSQL() {
        if (this.sqlStatementsQuery != null) {
            return this.sqlStatementsQuery.toString();
        }
        this.sqlStatementsQuery = new StringBuilder();
        this.statements = this.createSqlStatements();
        for (String string : this.statements) {
            if (!string.startsWith("/* ") && !string.endsWith(" */")) {
                this.sqlStatementsQuery.append(String.format("%s;\n\n", string));
                continue;
            }
            this.sqlStatementsQuery.append(String.format("%s\n", string));
        }
        return this.sqlStatementsQuery.toString();
    }

    @Override
    public void commitChanges() throws Exception {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.database.getConnection());
        if (this.statements == null || this.statements.isEmpty()) {
            this.statements = this.createSqlStatements();
        }
        for (String string : this.statements) {
            if (string.startsWith("/* ") || string.endsWith(" */")) continue;
            dBUtil.execute(string);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException == null) continue;
            throw sQLException;
        }
        this.recordMetadataChanges();
    }

    protected Collection<String> createSqlStatements() {
        this.modifyObjects();
        DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig((DBObjectProvider)this.database, (DBObject)this.getOriginalObject());
        dBEditorConfig.setUpdatedObject(this.getUpdatedObject());
        dBEditorConfig.setOriginalObject(this.getOriginalObject());
        dBEditorConfig.setReplaceAllowed(true);
        HCSDDLPanel.printDiff(dBEditorConfig, false);
        return HCSDDLPanel.getSQLStatements(dBEditorConfig);
    }

    protected Collection<String> getStatements() {
        return this.statements;
    }

    @Override
    public void clearDDL() {
        if (this.statements != null) {
            this.statements.clear();
        }
    }

    @Override
    public void clearSqlStatements() {
        this.sqlStatementsQuery = null;
    }

    protected abstract SystemObject getOriginalObject();

    protected abstract SystemObject getUpdatedObject();

    protected abstract void recordMetadataChanges();

    protected abstract void modifyObjects();
}

