/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.metrics;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricGroup;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricInfo;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricsMessages;

public class Metrics {
    private static Metrics instance;
    private Connection conn;
    private LinkedHashSet<MetricGroup> allMetrics;
    private final String GET_ALL_METRICS = "select distinct( trim(METRIC_NAME)) FROM GV$TTSTATS_ELEMENT_METRICS;";
    private final String VM_SHOW_PROPERTY = "ott.show.all.grid.metrics";
    private final String GET_PUBLIC_METRICS = "select distinct( trim(METRIC_NAME))  FROM GV$TTSTATS_ELEMENT_METRICS where METRIC_NAME not like '%zzinternal%';";
    private LinkedHashSet<String> allMetricsInQuery;

    private Metrics(Connection connection) {
        this.conn = connection;
        this.allMetricsInQuery = new LinkedHashSet();
        String string = System.getProperty("ott.show.all.grid.metrics");
        String string2 = "select distinct( trim(METRIC_NAME))  FROM GV$TTSTATS_ELEMENT_METRICS where METRIC_NAME not like '%zzinternal%';";
        if (string != null && string.compareToIgnoreCase("true") == 0) {
            string2 = "select distinct( trim(METRIC_NAME)) FROM GV$TTSTATS_ELEMENT_METRICS;";
        }
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                this.allMetricsInQuery.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static Metrics getInstance(Connection connection) {
        if (instance == null) {
            instance = new Metrics(connection);
            instance.parseData();
        }
        return instance;
    }

    public LinkedHashSet<MetricGroup> getAllMetrics() {
        return this.allMetrics;
    }

    private void parseData() {
        String string;
        Object object;
        Object object2;
        try {
            object2 = XMLInputFactory.newInstance();
            Iterator<Object> iterator = ((XMLInputFactory)object2).createXMLEventReader(Metrics.class.getResourceAsStream("metrics.xml"));
            while (iterator.hasNext()) {
                XMLEvent object3 = iterator.nextEvent();
                switch (object3.getEventType()) {
                    case 1: {
                        object = object3.asStartElement();
                        string = object.getName().getLocalPart();
                        if (string.equals("allMetrics")) {
                            this.allMetrics = new LinkedHashSet();
                            break;
                        }
                        if (!string.equals("metricGroup")) break;
                        this.parseGroup((XMLEventReader)iterator);
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
        object2 = new MetricGroup();
        ((MetricGroup)object2).setName("miscellaneous");
        ((MetricGroup)object2).setVisibleName(MetricsMessages.getString("miscellaneous"));
        for (String string2 : this.allMetricsInQuery) {
            if (string2.startsWith("cg.")) continue;
            object = new MetricInfo();
            ((MetricInfo)object).setName(string2);
            string = MetricsMessages.getString(string2);
            if (string.isEmpty()) {
                ((MetricInfo)object).setVisibleName(string2);
            } else {
                ((MetricInfo)object).setVisibleName(string);
            }
            ((MetricGroup)object2).getMetrics().add((MetricInfo)object);
        }
        this.allMetrics.add((MetricGroup)object2);
    }

    private void parseGroup(XMLEventReader xMLEventReader) throws XMLStreamException {
        MetricGroup metricGroup = new MetricGroup();
        while (xMLEventReader.hasNext()) {
            String string;
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.getEventType() == 1) {
                xMLEvent = xMLEvent2.asStartElement();
                string = xMLEvent.getName().getLocalPart();
                if (string.equals("name")) {
                    xMLEvent2 = xMLEventReader.nextEvent();
                    metricGroup.setName(xMLEvent2.asCharacters().getData().trim());
                    metricGroup.setVisibleName(MetricsMessages.getString(metricGroup.getName()));
                }
                if (string.equals("metric")) {
                    this.parseMetric(metricGroup, xMLEventReader);
                }
            }
            if (xMLEvent2.getEventType() != 2 || !(string = (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart()).equals("metricGroup")) continue;
            break;
        }
        this.allMetrics.add(metricGroup);
    }

    private void parseMetric(MetricGroup metricGroup, XMLEventReader xMLEventReader) throws XMLStreamException {
        MetricInfo metricInfo = new MetricInfo();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            String string;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.getEventType() == 1 && (string = (xMLEvent = xMLEvent2.asStartElement()).getName().getLocalPart()).equals("name")) {
                xMLEvent2 = xMLEventReader.nextEvent();
                metricInfo.setName(xMLEvent2.asCharacters().getData().trim());
                metricInfo.setVisibleName(MetricsMessages.getString(metricInfo.getName()));
                this.allMetricsInQuery.remove(metricInfo.getName());
            }
            if (xMLEvent2.getEventType() != 2 || !(string = (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart()).equals("metric")) continue;
            break;
        }
        metricGroup.getMetrics().add(metricInfo);
    }
}

