/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.distribution;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Duration;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.performancemonitor.DateAxis;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformanceConstants;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.TopologyInfoSplitPane;
import oracle.dbtools.raptor.timesten.utils.JavaFxWorker;

public class ComparableGraphPane
extends BorderPane {
    private HBox optionPane;
    private HashMap<PerformanceConstants.PerformanceChartTypes, ChartObject> chartMap = new HashMap();
    private static String dataTime = "(1/12)";
    String DRAGGING_TEXT = "DRAGGING_TEXT";
    private SplitPane splitPane;
    private MenuButton view;
    private MenuButton timeInterval;
    private MenuButton refreshTime;
    private MenuButton graph;
    private Text text = new Text("");
    private Bounds bounds = this.text.getBoundsInLocal();
    private MenuItem oneColumn;
    private MenuItem twoHorizontalColumn;
    private MenuItem threeHorizonalColumn;
    private MenuItem twoVerticalColumn;
    private MenuItem threeVerticalColumn;
    private ContextMenu contextMenu;
    private HashMap<Label, Tab> labelTabMap;
    private HashMap<LineChart<Date, Number>, String> chartQuery;
    private TabPane columnOne;
    private TabPane columnTwo;
    private TabPane columnThree;
    private CheckMenuItem cpuMenu;
    private CheckMenuItem checkpointMenu;
    private CheckMenuItem txtMenu;
    private CheckMenuItem transmissionRateMenu;
    private CheckMenuItem receiveRateMenu;
    private CheckMenuItem permSpaceUsageMenu;
    private CheckMenuItem tempSpaceUsageMenu;
    private Connection connection;
    private Timeline timeline;
    private HashMap<CheckMenuItem, Tab> menuTab;
    private int poolingInterval;
    private TopologyInfoSplitPane parent;
    private LineChart<Date, Number> cpuChart;
    private LineChart<Date, Number> txtLogChart;
    private LineChart<Date, Number> checkpointChart;
    private LineChart<Date, Number> receptionRate;
    private LineChart<Date, Number> transmissionRate;
    private LineChart<Date, Number> permSpaceUsageChart;
    private LineChart<Date, Number> tempSpaceUsageChart;
    private MenuItem fifteen;
    private MenuItem thirtyMin;
    private MenuItem oneHour;
    private MenuItem twoHour;
    private MenuItem thirtySeconds;
    private MenuItem oneMinute;
    private MenuItem fiveMinute;
    private MenuItem manual;
    private Button refresh;
    private final String TIME = Messages.getString("TimestenGrid.time");
    private final String VALUE = Messages.getString("TimestenGrid.value");
    private DateFormat df = DateFormat.getDateTimeInstance(1, 2, Locale.getDefault());
    private DecimalFormat format = new DecimalFormat("###,###.00");
    private EventHandler<ActionEvent> refreshIntervalSelection = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent actionEvent) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            ComparableGraphPane.this.refreshTime.setText(menuItem.getText());
            if (actionEvent.getSource() == ComparableGraphPane.this.thirtySeconds) {
                ComparableGraphPane.this.poolingInterval = 30000;
            } else if (actionEvent.getSource() == ComparableGraphPane.this.oneMinute) {
                ComparableGraphPane.this.poolingInterval = 60000;
            } else if (actionEvent.getSource() == ComparableGraphPane.this.fiveMinute) {
                ComparableGraphPane.this.poolingInterval = 300000;
            } else if (actionEvent.getSource() == ComparableGraphPane.this.manual) {
                ComparableGraphPane.this.poolingInterval = -1;
                if (ComparableGraphPane.this.timeline != null) {
                    ComparableGraphPane.this.timeline.stop();
                }
                return;
            }
            if (ComparableGraphPane.this.timeline == null) {
                ComparableGraphPane.this.timeline = new Timeline();
                ComparableGraphPane.this.timeline.setCycleCount(-1);
            } else {
                ComparableGraphPane.this.timeline.stop();
            }
            KeyFrame keyFrame = new KeyFrame(Duration.millis((double)ComparableGraphPane.this.poolingInterval), (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ComparableGraphPane.this.refreshCharts();
                }
            }, new KeyValue[0]);
            ComparableGraphPane.this.timeline.getKeyFrames().add((Object)keyFrame);
            ComparableGraphPane.this.timeline.play();
        }
    };
    private EventHandler<ActionEvent> timeIntervalSelection = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent actionEvent) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            ComparableGraphPane.this.timeInterval.setText(menuItem.getText());
            if (actionEvent.getSource() == ComparableGraphPane.this.fifteen) {
                dataTime = "(1/96)";
            } else if (actionEvent.getSource() == ComparableGraphPane.this.thirtyMin) {
                dataTime = "(1/48)";
            } else if (actionEvent.getSource() == ComparableGraphPane.this.oneHour) {
                dataTime = "(1/24)";
            } else if (actionEvent.getSource() == ComparableGraphPane.this.twoHour) {
                dataTime = "(1/12)";
            }
            ComparableGraphPane.this.refreshCharts();
        }
    };
    private EventHandler<MouseEvent> refreshClick = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            ComparableGraphPane.this.refreshCharts();
        }
    };
    private EventHandler<ActionEvent> graphSelection = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent actionEvent) {
            ChartObject chartObject = ComparableGraphPane.this.getChartObject((MenuItem)((CheckMenuItem)actionEvent.getSource()));
            ComparableGraphPane.this.setupTab(chartObject.item, chartObject.chart, chartObject.query);
        }
    };
    private EventHandler<ActionEvent> itemSelection = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent actionEvent) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            ComparableGraphPane.this.view.setText(menuItem.getText());
            ImageView imageView = (ImageView)menuItem.getGraphic();
            ImageView imageView2 = new ImageView(imageView.getImage());
            imageView2.setFitWidth(ComparableGraphPane.this.bounds.getHeight());
            imageView2.setFitHeight(ComparableGraphPane.this.bounds.getHeight());
            ComparableGraphPane.this.view.setGraphic((Node)imageView2);
            if (menuItem == ComparableGraphPane.this.oneColumn) {
                ComparableGraphPane.this.doOneColumn();
            } else if (menuItem == ComparableGraphPane.this.twoHorizontalColumn) {
                ComparableGraphPane.this.doTwoColumns();
                ComparableGraphPane.this.splitPane.setOrientation(Orientation.VERTICAL);
            } else if (menuItem == ComparableGraphPane.this.threeHorizonalColumn) {
                ComparableGraphPane.this.doThreeColumns();
                ComparableGraphPane.this.splitPane.setOrientation(Orientation.VERTICAL);
            } else if (menuItem == ComparableGraphPane.this.twoVerticalColumn) {
                ComparableGraphPane.this.doTwoColumns();
                ComparableGraphPane.this.splitPane.setOrientation(Orientation.HORIZONTAL);
            } else if (menuItem == ComparableGraphPane.this.threeVerticalColumn) {
                ComparableGraphPane.this.doThreeColumns();
                ComparableGraphPane.this.splitPane.setOrientation(Orientation.HORIZONTAL);
            }
        }
    };
    EventHandler<DragEvent> dragOver = new EventHandler<DragEvent>(){

        public void handle(DragEvent dragEvent) {
            Dragboard dragboard = dragEvent.getDragboard();
            if (dragboard.hasString()) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            dragEvent.consume();
        }
    };
    EventHandler<DragEvent> dragDropped = new EventHandler<DragEvent>(){

        public void handle(DragEvent dragEvent) {
            if (dragEvent.getGestureSource() instanceof Label) {
                Tab tab = ComparableGraphPane.this.labelTabMap.get((Label)dragEvent.getGestureSource());
                ComparableGraphPane.this.columnOne.getTabs().remove((Object)tab);
                ComparableGraphPane.this.columnTwo.getTabs().remove((Object)tab);
                ComparableGraphPane.this.columnThree.getTabs().remove((Object)tab);
                TabPane tabPane = (TabPane)dragEvent.getGestureTarget();
                tabPane.getTabs().add((Object)tab);
            }
            dragEvent.consume();
        }
    };

    private void setupButton() {
        this.view = new MenuButton();
        ImageView imageView = new ImageView(new Image(ComparableGraphPane.class.getResourceAsStream("oneColumn.png")));
        ImageView imageView2 = new ImageView(new Image(ComparableGraphPane.class.getResourceAsStream("twoColumnsHorizontal.png")));
        ImageView imageView3 = new ImageView(new Image(ComparableGraphPane.class.getResourceAsStream("threeColumnsHorizontal.png")));
        ImageView imageView4 = new ImageView(new Image(ComparableGraphPane.class.getResourceAsStream("twoColumnsVertical.png")));
        ImageView imageView5 = new ImageView(new Image(ComparableGraphPane.class.getResourceAsStream("threeColumnsVertical.png")));
        this.oneColumn = new MenuItem(Messages.getString("TimestenGrid.oneColumn"), (Node)imageView);
        this.twoHorizontalColumn = new MenuItem(Messages.getString("TimestenGrid.twoHorizontalColumn"), (Node)imageView2);
        this.threeHorizonalColumn = new MenuItem(Messages.getString("TimestenGrid.threeHorizonalColumn"), (Node)imageView3);
        this.twoVerticalColumn = new MenuItem(Messages.getString("TimestenGrid.twoVerticalColumn"), (Node)imageView4);
        this.threeVerticalColumn = new MenuItem(Messages.getString("TimestenGrid.threeVerticalColumn"), (Node)imageView5);
        this.oneColumn.setOnAction(this.itemSelection);
        this.twoHorizontalColumn.setOnAction(this.itemSelection);
        this.threeHorizonalColumn.setOnAction(this.itemSelection);
        this.twoVerticalColumn.setOnAction(this.itemSelection);
        this.threeVerticalColumn.setOnAction(this.itemSelection);
        this.view.getItems().addAll((Object[])new MenuItem[]{this.oneColumn, this.twoHorizontalColumn, this.threeHorizonalColumn, this.twoVerticalColumn, this.threeVerticalColumn});
        this.view.setPrefWidth(200.0);
        ImageView imageView6 = new ImageView(imageView.getImage());
        this.view.setText(this.oneColumn.getText());
        imageView6.setFitWidth(this.bounds.getHeight());
        imageView6.setFitHeight(this.bounds.getHeight());
        this.view.setGraphic((Node)imageView6);
    }

    public void setupGraphOptions() {
        this.graph = new MenuButton(Messages.getString("TimestenGrid.metrics"));
        this.cpuMenu = new CheckMenuItem(Messages.getString("TimestenGrid.cpu"));
        this.checkpointMenu = new CheckMenuItem(Messages.getString("TimestenGrid.checkpointLog"));
        this.txtMenu = new CheckMenuItem(Messages.getString("TimestenGrid.transactionLog"));
        this.transmissionRateMenu = new CheckMenuItem(Messages.getString("TimestenGrid.networkTransmissionRate"));
        this.receiveRateMenu = new CheckMenuItem(Messages.getString("TimestenGrid.networkRecepcionRate"));
        this.permSpaceUsageMenu = new CheckMenuItem(Messages.getString("TimestenGrid.permSpaceUsage"));
        this.tempSpaceUsageMenu = new CheckMenuItem(Messages.getString("TimestenGrid.tempSpaceUsage"));
        this.graph.getItems().addAll((Object[])new MenuItem[]{this.cpuMenu, this.checkpointMenu, this.txtMenu, this.transmissionRateMenu, this.receiveRateMenu, this.permSpaceUsageMenu, this.tempSpaceUsageMenu});
        for (MenuItem menuItem : this.graph.getItems()) {
            menuItem.setOnAction(this.graphSelection);
        }
    }

    public void setupChartMap() {
        this.cpuChart = new LineChart((Axis)new DateAxis(), (Axis)new NumberAxis());
        this.txtLogChart = new LineChart((Axis)new DateAxis(), (Axis)new NumberAxis());
        this.checkpointChart = new LineChart((Axis)new DateAxis(), (Axis)new NumberAxis());
        this.receptionRate = new LineChart((Axis)new DateAxis(), (Axis)new NumberAxis());
        this.transmissionRate = new LineChart((Axis)new DateAxis(), (Axis)new NumberAxis());
        this.permSpaceUsageChart = new LineChart((Axis)new DateAxis(), (Axis)new NumberAxis());
        this.tempSpaceUsageChart = new LineChart((Axis)new DateAxis(), (Axis)new NumberAxis());
        this.cpuChart.setCreateSymbols(false);
        this.txtLogChart.setCreateSymbols(false);
        this.checkpointChart.setCreateSymbols(false);
        this.receptionRate.setCreateSymbols(false);
        this.transmissionRate.setCreateSymbols(false);
        this.permSpaceUsageChart.setCreateSymbols(false);
        this.tempSpaceUsageChart.setCreateSymbols(false);
        this.chartMap.put(PerformanceConstants.PerformanceChartTypes.CPU_CHART, new ChartObject("SELECT /* !!!!! SQL Developer Performance Monitor Query !!!!! */  ELEMENTID, CPU_UTIL, COLLECTED_AT from SYS.GV$TTSTATS_CPU_HIST where ELEMENTID IN (:ELEMENTS:) and collected_at >SYSDATE - :TIME:   ORDER BY ELEMENTID , COLLECTED_AT ;", this.cpuChart, this.cpuMenu));
        this.chartMap.put(PerformanceConstants.PerformanceChartTypes.TRANSACCION_LOG_CHART, new ChartObject("select /* !!!!! SQL Developer Performance Monitor Query !!!!! */ ELEMENTID, percent_used,  COLLECTED_AT from SYS.GV$TTSTATS_DISK_HIST where COLLECTED_AT > SYSDATE - :TIME: AND TT_FILE_TYPE in (2,3) and  ELEMENTID IN (:ELEMENTS:)  ORDER BY ELEMENTID , COLLECTED_AT ", this.txtLogChart, this.txtMenu));
        this.chartMap.put(PerformanceConstants.PerformanceChartTypes.CHECK_POINT_CHART, new ChartObject("select /* !!!!! SQL Developer Performance Monitor Query !!!!! */ ELEMENTID, percent_used,  COLLECTED_AT from SYS.GV$TTSTATS_DISK_HIST where COLLECTED_AT > SYSDATE - :TIME: AND TT_FILE_TYPE in (1,3)and  ELEMENTID IN (:ELEMENTS:)  ORDER BY ELEMENTID , COLLECTED_AT ", this.checkpointChart, this.checkpointMenu));
        this.chartMap.put(PerformanceConstants.PerformanceChartTypes.RECEPTION_RATE_CHART, new ChartObject("select /* !!!!! SQL Developer Performance Monitor Query !!!!! */ ELEMENTID , RX_MB_RATE,  COLLECTED_AT from sys.GV$TTSTATS_NETWORK_HIST  where COLLECTED_AT  > SYSDATE - :TIME:  and  ELEMENTID IN (:ELEMENTS:)  ORDER BY ELEMENTID , COLLECTED_AT ", this.receptionRate, this.receiveRateMenu));
        this.chartMap.put(PerformanceConstants.PerformanceChartTypes.TRANSMISSION_RATE_CHART, new ChartObject("select /* !!!!! SQL Developer Performance Monitor Query !!!!! */ ELEMENTID , TX_MB_RATE, COLLECTED_AT from sys.GV$TTSTATS_NETWORK_HIST  where COLLECTED_AT  > SYSDATE - :TIME:  and  ELEMENTID IN (:ELEMENTS:)  ORDER BY ELEMENTID , COLLECTED_AT ", this.transmissionRate, this.transmissionRateMenu));
        this.chartMap.put(PerformanceConstants.PerformanceChartTypes.PERM_SPACE_USAGE_CHART, new ChartObject("SELECT /* !!!!! SQL Developer Performance Monitor Query !!!!! */ V1.EID ELEMENTID, (V1.INUSE * 100/V1.ALLOCATED) PERM_PERCENT, V1.TIME_STATION COLLECTED_AT  FROM (SELECT N.ELEMENTID EID, N.INT_VALUE INUSE, D.INT_VALUE ALLOCATED, N.COLLECTED_AT TIME_STATION FROM GV$TTSTATS_GENERIC_HIST N, GV$TTSTATS_GENERIC_HIST D  WHERE N.NAME1 = 'perm' AND N.NAME2 = 'in use' and N.NAME3 = 'size' AND D.NAME1 = 'perm' AND D.name2 = 'allocated' AND D.name3 = 'size' AND N.COLLECTED_AT = D.COLLECTED_AT) V1 WHERE V1.TIME_STATION  > SYSDATE - :TIME: AND V1.EID IN (:ELEMENTS:) ORDER BY  ELEMENTID, COLLECTED_AT;", this.permSpaceUsageChart, this.permSpaceUsageMenu));
        this.chartMap.put(PerformanceConstants.PerformanceChartTypes.TEMP_SPACE_USAGE_CHART, new ChartObject("SELECT /* !!!!! SQL Developer Performance Monitor Query !!!!! */ V1.EID ELEMENTID, (V1.INUSE * 100/V1.ALLOCATED) TEMP_PERCENT, V1.TIME_STATION COLLECTED_AT  FROM (SELECT N.ELEMENTID EID, N.INT_VALUE INUSE, D.INT_VALUE ALLOCATED, N.COLLECTED_AT TIME_STATION FROM GV$TTSTATS_GENERIC_HIST N, GV$TTSTATS_GENERIC_HIST D  WHERE N.NAME1 = 'temp' AND N.NAME2 = 'in use' and N.NAME3 = 'size' AND D.NAME1 = 'temp' AND D.name2 = 'allocated' AND D.name3 = 'size' AND N.COLLECTED_AT = D.COLLECTED_AT) V1 WHERE V1.TIME_STATION  > SYSDATE - :TIME: AND V1.EID IN (:ELEMENTS:) ORDER BY  ELEMENTID, COLLECTED_AT;", this.tempSpaceUsageChart, this.tempSpaceUsageMenu));
    }

    private void setupTimeButton() {
        this.timeInterval = new MenuButton();
        this.fifteen = new MenuItem(Messages.getString("TimestenGrid.fifteenMin"));
        this.thirtyMin = new MenuItem(Messages.getString("TimestenGrid.thirtyMin"));
        this.oneHour = new MenuItem(Messages.getString("TimestenGrid.sixtyMin"));
        this.twoHour = new MenuItem(Messages.getString("TimestenGrid.twoHours"));
        this.timeInterval.setText(this.twoHour.getText());
        this.timeInterval.getItems().addAll((Object[])new MenuItem[]{this.fifteen, this.thirtyMin, this.oneHour, this.twoHour});
        for (MenuItem menuItem : this.timeInterval.getItems()) {
            menuItem.setOnAction(this.timeIntervalSelection);
        }
        this.refreshTime = new MenuButton();
        this.manual = new MenuItem(Messages.getString("TimestenGrid.manual"));
        this.thirtySeconds = new MenuItem(Messages.getString("TimestenGrid.thirtySec"));
        this.oneMinute = new MenuItem(Messages.getString("TimestenGrid.fiveMin"));
        this.fiveMinute = new MenuItem(Messages.getString("TimestenGrid.oneMin"));
        this.refreshTime.getItems().addAll((Object[])new MenuItem[]{this.thirtySeconds, this.oneMinute, this.fiveMinute});
        for (MenuItem menuItem : this.refreshTime.getItems()) {
            menuItem.setOnAction(this.refreshIntervalSelection);
        }
        this.refreshTime.setText(this.manual.getText());
        this.refresh = new Button(Messages.getString("TimestenGrid.refresh"));
        this.refresh.setOnMouseClicked(this.refreshClick);
    }

    private void setupTab(final CheckMenuItem checkMenuItem, LineChart<Date, Number> lineChart, String string) {
        if (!checkMenuItem.isSelected()) {
            Tab tab = this.menuTab.get(checkMenuItem);
            if (tab != null) {
                tab.getTabPane().getTabs().remove((Object)tab);
                this.menuTab.remove(checkMenuItem);
            }
        } else {
            Tab tab = this.menuTab.get(checkMenuItem);
            if (tab == null) {
                tab = this.createTab(checkMenuItem.getText());
                this.menuTab.put(checkMenuItem, tab);
                this.columnOne.getTabs().add((Object)tab);
            }
            this.fillChartWithInfo(lineChart, string);
            tab.setContent(lineChart);
            tab.setOnClosed((EventHandler)new EventHandler<Event>(){

                public void handle(Event event) {
                    checkMenuItem.setSelected(false);
                }
            });
        }
    }

    private void doOneColumn() {
        if (this.splitPane.getItems().size() > 1) {
            this.moveToFirstColumn(this.columnTwo);
            this.moveToFirstColumn(this.columnThree);
        }
        this.splitPane.getItems().remove((Object)this.columnTwo);
        this.splitPane.getItems().remove((Object)this.columnThree);
    }

    private void doTwoColumns() {
        if (this.splitPane.getItems().size() > 2) {
            this.moveToFirstColumn(this.columnThree);
        }
        this.splitPane.getItems().clear();
        this.splitPane.getItems().add((Object)this.columnOne);
        this.splitPane.getItems().add((Object)this.columnTwo);
        this.splitPane.setDividerPositions(new double[]{0.5});
    }

    private void doThreeColumns() {
        this.splitPane.getItems().clear();
        this.splitPane.getItems().add((Object)this.columnOne);
        this.splitPane.getItems().add((Object)this.columnTwo);
        this.splitPane.getItems().add((Object)this.columnThree);
        this.splitPane.setDividerPositions(new double[]{0.3333333333333333, 0.3333333333333333});
    }

    public void moveToFirstColumn(TabPane tabPane) {
        this.columnOne.getTabs().addAll((Collection)tabPane.getTabs());
        tabPane.getTabs().clear();
    }

    private void setupMenus() {
    }

    public ComparableGraphPane(TopologyInfoSplitPane topologyInfoSplitPane, Connection connection) {
        this.parent = topologyInfoSplitPane;
        this.connection = connection;
        this.menuTab = new HashMap();
        this.chartQuery = new HashMap();
        this.labelTabMap = new HashMap();
        this.splitPane = new SplitPane();
        this.setupMenus();
        this.setupButton();
        this.setupGraphOptions();
        this.setupTimeButton();
        this.setupChartMap();
        this.optionPane = new HBox(5.0);
        this.optionPane.setAlignment(Pos.BASELINE_LEFT);
        Region region = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        this.columnOne = new TabPane();
        this.columnTwo = new TabPane();
        this.columnThree = new TabPane();
        this.columnOne.setContextMenu(this.contextMenu);
        this.columnOne.setOnDragDropped(this.dragDropped);
        this.columnTwo.setOnDragDropped(this.dragDropped);
        this.columnThree.setOnDragDropped(this.dragDropped);
        this.columnOne.setOnDragOver(this.dragOver);
        this.columnTwo.setOnDragOver(this.dragOver);
        this.columnThree.setOnDragOver(this.dragOver);
        this.optionPane.getChildren().add((Object)this.graph);
        this.optionPane.getChildren().add((Object)new Label(Messages.getString("TimestenGrid.dataFrom")));
        this.optionPane.getChildren().add((Object)this.timeInterval);
        this.optionPane.getChildren().add((Object)new Label(Messages.getString("TimestenGrid.refreshInterval")));
        this.optionPane.getChildren().add((Object)this.refreshTime);
        this.optionPane.getChildren().add((Object)this.refresh);
        this.optionPane.getChildren().add((Object)region);
        this.optionPane.getChildren().add((Object)this.view);
        this.optionPane.setPadding(new Insets(5.0));
        this.splitPane.getItems().add((Object)this.columnOne);
        this.setTop((Node)this.optionPane);
        this.setCenter((Node)this.splitPane);
    }

    private Tab createTab(String string) {
        Label label = new Label(string);
        Tab tab = new Tab();
        tab.setGraphic((Node)label);
        this.labelTabMap.put(label, tab);
        label.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                Dragboard dragboard = ((Label)mouseEvent.getSource()).startDragAndDrop(TransferMode.COPY_OR_MOVE);
                dragboard.setDragView((Image)((Label)mouseEvent.getSource()).getParent().getParent().getParent().snapshot(null, null));
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.putString("TRA");
                dragboard.setContent((Map)clipboardContent);
            }
        });
        return tab;
    }

    public void refreshCharts() {
        for (LineChart<Date, Number> lineChart : this.chartQuery.keySet()) {
            if (!lineChart.isManaged()) continue;
            this.fillChartWithInfoHelper(lineChart, this.chartQuery.get(lineChart));
        }
    }

    private void fillChartWithInfo(LineChart<Date, Number> lineChart, String string) {
        this.chartQuery.put(lineChart, string);
        this.fillChartWithInfoHelper(lineChart, string);
    }

    private void fillChartWithInfoHelper(final LineChart<Date, Number> lineChart, final String string) {
        final String string2 = this.parent.getElementsIdAsStringList();
        if (string2 == null || string2.isEmpty()) {
            lineChart.getData().clear();
            return;
        }
        JavaFxWorker javaFxWorker = new JavaFxWorker(){
            LinkedHashMap<Integer, XYChart.Series<Date, Number>> allSeries = new LinkedHashMap();

            @Override
            public void doInBackground() {
                try (Statement statement = ComparableGraphPane.this.connection.createStatement();){
                    ResultSet resultSet = statement.executeQuery(string.replace(":ELEMENTS:", string2).replace(":TIME:", dataTime));
                    while (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        double d = resultSet.getDouble(2);
                        Timestamp timestamp = resultSet.getTimestamp(3);
                        XYChart.Series series = this.allSeries.get(n);
                        if (series == null) {
                            series = new XYChart.Series();
                            series.setName(Integer.toString(n));
                            this.allSeries.put(n, (XYChart.Series<Date, Number>)series);
                        }
                        XYChart.Data data = new XYChart.Data((Object)timestamp, (Object)d);
                        series.getData().add((Object)data);
                        Circle circle = new Circle(5.0);
                        circle.setFill((Paint)Color.TRANSPARENT);
                        data.setNode((Node)circle);
                        Tooltip.install((Node)circle, (Tooltip)new Tooltip(ComparableGraphPane.this.TIME + " " + ComparableGraphPane.this.df.format((Date)data.getXValue()) + "\n" + ComparableGraphPane.this.VALUE + " " + ComparableGraphPane.this.format.format(((Number)data.getYValue()).doubleValue())));
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }

            @Override
            public void done() {
                lineChart.getData().clear();
                lineChart.getData().addAll(this.allSeries.values());
                this.allSeries.clear();
                this.allSeries = null;
            }
        };
        javaFxWorker.execute();
    }

    private ChartObject getChartObject(MenuItem menuItem) {
        for (ChartObject chartObject : this.chartMap.values()) {
            if (chartObject.item != menuItem) continue;
            return chartObject;
        }
        return null;
    }

    public void showTimeInformation(PerformanceConstants.PerformanceChartTypes performanceChartTypes) {
        if (this.chartMap.containsKey((Object)performanceChartTypes)) {
            ChartObject chartObject = this.chartMap.get((Object)performanceChartTypes);
            chartObject.item.setSelected(true);
            this.setupTab(chartObject.item, chartObject.chart, chartObject.query);
        }
    }

    private class ChartObject {
        String query;
        LineChart<Date, Number> chart;
        CheckMenuItem item;

        public ChartObject(String string, LineChart<Date, Number> lineChart, CheckMenuItem checkMenuItem) {
            this.query = string;
            this.chart = lineChart;
            this.item = checkMenuItem;
        }
    }
}

