/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;

public class InstanceSummaryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private InstanceObject instance;
    private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.attributeColumn"), Messages.getString("TimesTenGrid.valueColumn")};
    static int ROWS;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private SummaryTableModel _model;
    private JTable _table;
    private JScrollPane _scrollPane;

    public InstanceSummaryPanel() {
        this.initGUI();
    }

    public void initGUI() {
        this.setLayout(new GridBagLayout());
        this._model = new SummaryTableModel();
        this._table = new JTable(this._model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                try {
                    string = InstanceSummaryPanel.this._table.getValueAt(n, n2).toString();
                }
                catch (RuntimeException runtimeException) {
                    InstanceSummaryPanel.this.logger.log(Level.SEVERE, runtimeException.getMessage());
                }
                return string;
            }
        };
        this._table.setAutoResizeMode(0);
        this._table.setRowSelectionAllowed(false);
        this._table.setColumnSelectionAllowed(false);
        this._scrollPane = new JScrollPane(this._table);
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void updateInstanceInfo(InstanceObject instanceObject) {
        this.instance = instanceObject;
        ROWS = instanceObject.isMgmtInstance() ? SUMMARY_ROWS.values().length : SUMMARY_ROWS.values().length - 1;
        if (SwingUtilities.isEventDispatchThread()) {
            this._model.fireTableDataChanged();
            TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this._model.fireTableDataChanged();
                    TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                this.logger.log(Level.INFO, exception.getMessage());
            }
        }
    }

    private class SummaryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private SummaryTableModel() {
        }

        @Override
        public int getRowCount() {
            return ROWS;
        }

        @Override
        public int getColumnCount() {
            return InstanceSummaryPanel.this.HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (InstanceSummaryPanel.this.instance == null) {
                return null;
            }
            if (n == SUMMARY_ROWS.HOME_ROW.ordinal()) {
                return n2 == 0 ? Messages.getString("TimesTenGrid.instHome") : InstanceSummaryPanel.this.instance.getHome();
            }
            if (n == SUMMARY_ROWS.INSTANCE_ROW.ordinal()) {
                return n2 == 0 ? Messages.getString("TimesTenGrid.instanceName") : InstanceSummaryPanel.this.instance.getName();
            }
            if (n == SUMMARY_ROWS.HOST_ROW.ordinal()) {
                return n2 == 0 ? Messages.getString("TimesTen.common.hostName") : InstanceSummaryPanel.this.instance.getHost().getName();
            }
            if (n == SUMMARY_ROWS.WALLET_ROW.ordinal()) {
                return n2 == 0 ? Messages.getString("TimesTenGrid.walletDir") : InstanceSummaryPanel.this.instance.getWalletDir();
            }
            if (n == SUMMARY_ROWS.DAEMONP_ROW.ordinal()) {
                return n2 == 0 ? Messages.getString("TimesTenGrid.daemonPortColumn") : Integer.valueOf(InstanceSummaryPanel.this.instance.getDaemonPort());
            }
            if (n == SUMMARY_ROWS.SERVERP_ROW.ordinal()) {
                return n2 == 0 ? Messages.getString("TimesTenGrid.csPortColumn") : Integer.valueOf(InstanceSummaryPanel.this.instance.getCSPort());
            }
            if (n == SUMMARY_ROWS.MGMTP_ROW.ordinal()) {
                return n2 == 0 ? Messages.getString("TimesTenGrid.mgmtPortColumn") : Integer.valueOf(InstanceSummaryPanel.this.instance.getMgmtPort());
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return InstanceSummaryPanel.this.HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    public static enum SUMMARY_ROWS {
        INSTANCE_ROW,
        HOST_ROW,
        HOME_ROW,
        WALLET_ROW,
        DAEMONP_ROW,
        SERVERP_ROW,
        MGMTP_ROW;

    }
}

