/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptions;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptionsPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTablesTable;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoaderPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.OracleTableLoader;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.TableRefresher;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;

public class ResumeLoadOracleTablePanel
extends JPanel
implements ActionListener,
LoaderPanel,
TableRefresher,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JPanel _filePanel;
    private JTabbedPane _tabbedPane;
    private JPanel _loPanel;
    private LoadOptionsPanel _loadOptionsPanel;
    private JPanel _indexPanel;
    private JLabel _indexLabel;
    private JComboBox<LoadOptions.IndexCreationPolicy> _indexComboBox;
    private JCheckBox _indexCreationCheckBox;
    private LoadPanel _loadPanel;
    private JLabel _profileLabel;
    private JTextField _profileTxtField;
    private JButton _browseButton;
    private JButton _resumeButton;
    private LoadTablesTable resumeLoadTable;
    private DBObject _dbObject;
    private TimesTenPassthrough _passthrough;
    private LoadOptions loadOptions;
    private static Logger _logger = Logger.getLogger(ResumeLoadOracleTablePanel.class.getPackage().getName());

    public ResumeLoadOracleTablePanel(DBObject dBObject) {
        this._dbObject = dBObject;
        Common.setTTVersion(dBObject);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.LFO_RESUME_LOADS.toString());
        this.init(dBObject);
    }

    private void init(DBObject dBObject) {
        this.setLayout(new GridBagLayout());
        this._passthrough = new TimesTenPassthrough(dBObject);
        this._tabbedPane = new JTabbedPane();
        this.resumeLoadTable = new LoadTablesTable(this, dBObject, false);
        this.resumeLoadTable.setSelectionMode(0);
        this.resumeLoadTable.getSelectionModel().addListSelectionListener(this);
        this._loadPanel = new LoadPanel(this.resumeLoadTable, true);
        this._loPanel = new JPanel(new GridBagLayout());
        this._indexPanel = new JPanel(new GridBagLayout());
        this._indexPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LoadTablesFromOracle.indexCreation")));
        this._indexComboBox = new JComboBox();
        this._indexComboBox.addItem(LoadOptions.IndexCreationPolicy.COPY_ALL_IDXS);
        this._indexComboBox.addItem(LoadOptions.IndexCreationPolicy.COPY_UNIQUE_IDXS);
        this._indexComboBox.addItem(LoadOptions.IndexCreationPolicy.NO_COPY_IDXS);
        this._indexComboBox.setSelectedIndex(0);
        this._indexComboBox.setEnabled(false);
        this._indexCreationCheckBox = new JCheckBox(Messages.getString("LoadTablesFromOracle.indexCreationCond"));
        this._indexCreationCheckBox.setEnabled(false);
        this._indexCreationCheckBox.setSelected(false);
        this._indexLabel = new JLabel(Messages.getString("LoadTablesFromOracle.indexCreationLabel"));
        this._indexLabel.setLabelFor(this._indexComboBox);
        this._indexPanel.add((Component)this._indexLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
        this._indexPanel.add(this._indexComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
        this._indexPanel.add((Component)this._indexCreationCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
        this._loadOptionsPanel = new LoadOptionsPanel(new LoadOptions());
        this._loadOptionsPanel.showEmptyOptions();
        this._loPanel.add((Component)this._loadOptionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._loPanel.add((Component)this._indexPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._tabbedPane.addTab(Messages.getString("LoadTablesFromOracle.resumeLoads"), this._loadPanel);
        this._tabbedPane.addTab(Messages.getString("LoadTablesFromOracle.options"), this._loPanel);
        this._filePanel = new JPanel(new GridBagLayout());
        this._profileTxtField = new JTextField(25);
        this._profileTxtField.setEnabled(false);
        this._browseButton = new JButton(Messages.getString("TimesTenGrid.browse"));
        this._browseButton.addActionListener(this);
        this._profileLabel = new JLabel(Messages.getString("LoadTablesFromOracle.loadProfileLabel"));
        this._filePanel.add((Component)this._profileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._filePanel.add((Component)this._profileTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._filePanel.add((Component)this._browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._filePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LoadTablesFromOracle.loadProfile")));
        this._resumeButton = new JButton(Messages.getString("LoadTablesFromOracle.resumeLoads"));
        this._resumeButton.addActionListener(this);
        this.add((Component)this._filePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public JButton getResumeButton() {
        return this._resumeButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._browseButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("JSON file (.json)", "json"));
            jFileChooser.setFileFilter(jFileChooser.getChoosableFileFilters()[1]);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.resumeLoadTable.deleteAllRows();
                JsonObject jsonObject = this.validProfile(file);
                if (jsonObject != null) {
                    this._profileTxtField.setText(file.getAbsolutePath());
                    this.loadProfile(jsonObject);
                } else {
                    this._profileTxtField.setText("");
                }
            }
        } else if (actionEvent.getSource() == this._resumeButton) {
            this._resumeButton.setEnabled(false);
            this._browseButton.setEnabled(false);
            this.resumeLoad();
        }
    }

    @Override
    public void updateOnFinish() {
        if (!this.resumeLoadTable.getData().isEmpty()) {
            this._loadPanel.clearCurrentSelectedRowIndex();
            this.resumeLoadTable.clearSelection();
            this.resumeLoadTable.setRowSelectionInterval(0, 0);
        }
    }

    private void resumeLoad() {
        OracleTableLoader oracleTableLoader = new OracleTableLoader(this._dbObject);
        try {
            oracleTableLoader.loadData(this.resumeLoadTable, this);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "Error while loading tables into TimesTen", exception);
        }
    }

    private JsonObject validProfile(File file) {
        int n;
        if (!file.exists()) {
            MessageDialog.error((Component)this, (Object)MessageFormat.format(Messages.getString("LoadTablesFromOracle.fileDoesntExist"), file.getName()), (String)Messages.getString("TimesTen.common.error"), null);
            return null;
        }
        JsonObject jsonObject = null;
        try {
            jsonObject = Json.createReader((Reader)new FileReader(file)).readObject();
            if (jsonObject == null) {
                throw new Exception(Messages.getString("LoadTablesFromOracle.invalidJsonFile"));
            }
        }
        catch (Exception exception) {
            MessageDialog.error((Component)this, (Object)MessageFormat.format(Messages.getString("LoadTablesFromOracle.readFileError"), new Object[]{file.getName()} + exception.getMessage()), (String)Messages.getString("TimesTen.common.error"), null);
            return null;
        }
        String string = jsonObject.getString("connectionName");
        String string2 = Connections.getDisplayName((String)this._dbObject.getConnectionName());
        if (!string.equals(string2) && (n = MessageDialog.confirmOrCancel((Component)this, (Object)MessageFormat.format(Messages.getString("LoadTablesFromOracle.diffConnections"), string2, string), (String)Messages.getString("TimesTen.common.warning"))) != 1) {
            return null;
        }
        return jsonObject;
    }

    private void loadProfile(JsonObject jsonObject) {
        this.loadOptions = new LoadOptions(jsonObject.getString("loadOptions"), jsonObject.getInt("numberOfThreads"), jsonObject.getString("indexCreationPolicy"), jsonObject.getBoolean("createIndexesIfNoErrors"));
        JsonArray jsonArray = jsonObject.getJsonArray("loads");
        for (JsonObject jsonObject2 : jsonArray.getValuesAs(JsonObject.class)) {
            LoadTableRow loadTableRow = new LoadTableRow(jsonObject2.getString("ttUser"), jsonObject2.getString("ttTable"), jsonObject2.getString("query"), jsonObject2.getString("createTableStmt"));
            loadTableRow.setOracleTable(jsonObject2.getString("oracleTable"));
            loadTableRow.setOracleUser(jsonObject2.getString("oracleUser"));
            try {
                loadTableRow.setOracleSCN(Long.parseLong(jsonObject2.getString("oracleSCN")));
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Error while loading the Oracle SCN: " + jsonObject2.getString("oracleSCN"), exception);
            }
            loadTableRow.setRowCount(Long.parseLong(jsonObject2.getString("rowCount")));
            this.resumeLoadTable.addRow(loadTableRow);
        }
        this.resumeLoadTable.refreshTheCompleteTable();
        this._loadOptionsPanel.setLoadOptions(this.loadOptions);
        this._indexCreationCheckBox.setSelected(jsonObject.getBoolean("createIndexesIfNoErrors"));
        Object object = LoadOptions.IndexCreationPolicy.NO_COPY_IDXS;
        if (jsonObject.getString("indexCreationPolicy").equalsIgnoreCase(LoadOptions.IndexCreationPolicy.COPY_UNIQUE_IDXS.toString())) {
            object = LoadOptions.IndexCreationPolicy.COPY_UNIQUE_IDXS;
        } else if (jsonObject.getString("indexCreationPolicy").equalsIgnoreCase(LoadOptions.IndexCreationPolicy.COPY_ALL_IDXS.toString())) {
            object = LoadOptions.IndexCreationPolicy.COPY_ALL_IDXS;
        }
        this._indexComboBox.setSelectedItem(object);
    }

    @Override
    public LoadOptions getLoadOptions() {
        return this.loadOptions;
    }

    @Override
    public TimesTenPassthrough getPassthrough() {
        return this._passthrough;
    }

    @Override
    public Component getLoadComponent() {
        return this;
    }

    @Override
    public void refreshTheCompleteTable() {
        this.resumeLoadTable.refreshTheCompleteTable();
    }

    @Override
    public void refreshRow(int n) {
        this.resumeLoadTable.refreshRow(n);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getFirstIndex() >= 0 && this.resumeLoadTable.getData().size() > 0) {
            this.loadOptions.setResumeFromSCN(this.resumeLoadTable.getData().get(listSelectionEvent.getFirstIndex()).getOracleSCN());
            this._loadOptionsPanel.setLoadOptions(this.loadOptions);
        }
    }
}

