/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.io.File;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;
import oracle.dbtools.raptor.timesten.dialogs.connection.MessageIndeterminateProgressMonitor;
import oracle.dbtools.raptor.timesten.editors.TTSchemaSQLTab;
import oracle.dbtools.raptor.timesten.utils.TTSchema;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public final class ImportData
extends AbstractMenuAction {
    private MessageIndeterminateProgressMonitor _progressMonitor;
    DBObject dbObject;
    private boolean _errorOnSql = false;
    private static String MESSAGE = "message";
    private static String PROGRESS = "progress";
    boolean isClientServer = false;
    File f;
    private static Logger theLogger = Logger.getLogger(ImportData.class.getPackage().getName());

    public final void setArgs(String string) {
    }

    public void launch() {
        try {
            this.dbObject = this.getDBObject();
            String string = this.dbObject.getConnection().getMetaData().getURL().toString();
            this.isClientServer = string.toLowerCase().indexOf(":client:") != -1;
            ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)this.getObjectAction(), (DBObject)this.dbObject);
            this.setBlockOACRefresh(true);
            JFileChooser jFileChooser = new JFileChooser(){

                @Override
                public void approveSelection() {
                    File file = this.getSelectedFile();
                    if (!file.exists() || file.isDirectory()) {
                        MessageDialog.error(null, (Object)Messages.getString("ImportData.fileDoesntExistOrDirectory"), (String)Messages.getString("TimesTen.common.error"), null);
                        return;
                    }
                    if (!file.canRead()) {
                        MessageDialog.error(null, (Object)Messages.getString("ImportData.insufficientPermissions"), (String)Messages.getString("TimesTen.common.error"), null);
                        return;
                    }
                    super.approveSelection();
                }
            };
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showOpenDialog((Component)Ide.getMainWindow());
            if (n == 0) {
                this._progressMonitor = new MessageIndeterminateProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("ImportData.assistantProgress"), Messages.getString("ImportData.assistantProgress"), null);
                this._progressMonitor.addCancellationListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        ImportData.this._progressMonitor.close();
                    }
                });
                this.f = jFileChooser.getSelectedFile();
                ImportDataWorker importDataWorker = new ImportDataWorker();
                importDataWorker.execute();
                this._progressMonitor.start();
            } else {
                objectActionPostProcess = null;
            }
            if (objectActionPostProcess != null) {
                objectActionPostProcess.run();
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    private void importDataCMD() {
        String[] stringArray;
        String string5;
        String[] stringArray2;
        String string2 = this.dbObject.getSchemaName() + "." + this.dbObject.getObjectName();
        String string3 = TTSchemaSQLTab.getDSN(this.dbObject);
        String string4 = null;
        if (string3.toUpperCase().indexOf("TTC_SERVER_DSN") != -1) {
            stringArray2 = TTInstanceInformation.getInstance();
            string4 = "\"" + string3 + ";" + stringArray2.getClientDriver() + "\"";
        } else {
            string4 = "\"DSN=" + string3 + "\"";
        }
        stringArray2 = new String[6];
        boolean bl = System.getProperty("os.name").toLowerCase().startsWith("windows");
        stringArray2[0] = this.isClientServer && !bl ? "ttbulkcpcs" : "ttbulkcp";
        stringArray2[1] = "-i";
        stringArray2[2] = "-connStr";
        stringArray2[3] = string4;
        stringArray2[4] = "\"" + string2 + "\"";
        stringArray2[5] = "\"" + this.f.getPath() + "\"";
        for (String string5 : stringArray2) {
            this._progressMonitor.updateTextArea(string5);
        }
        String string6 = this.dbObject.getConnectionName();
        Connections connections = Connections.getInstance();
        Properties properties = connections.getConnectionInfo(string6);
        string5 = properties.getProperty("password");
        if (string5 == null) {
            string5 = X10ConnectionProperties.getTheInstance().getProperty(Connections.getConnectionName((String)string6), "sys1");
        }
        if ((stringArray = TTSchema.run(stringArray2, true, string5))[1] != null) {
            String string7 = stringArray[1];
            string7 = TTSQLExceptionScrubber.getMessage(string7, null, theLogger);
            string7 = string7.replaceAll("Run 'ttBulkCp -help' for usage information.", "");
            string7 = string7.replaceAll("\n", " ");
            MessageDialog.error(null, (Object)string7, (String)Messages.getString("TimesTen.common.error"), null);
        }
        if (stringArray[0] != null && stringArray[0].length() > 0) {
            MessageDialog.information(null, (Object)stringArray[0], (String)"ttBulkCp", null);
        }
    }

    private class ImportDataWorker
    extends SwingWorker<Void, Void> {
        private ImportDataWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            ImportData.this.importDataCMD();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportData.this._progressMonitor.close();
                }
            });
            return null;
        }

        @Override
        protected void done() {
            ImportData.this._progressMonitor.finish();
        }
    }
}

