/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.NumberFormatter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.TTJPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCColInfo;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsTableModel;

class LOBDialog
extends JEWTDialog {
    CGCTableColsTableModel _tm;
    int _r;
    long _max;
    JFormattedTextField _n;
    JComboBox _menu = null;

    LOBDialog(Dialog dialog, CGCTableColsTableModel cGCTableColsTableModel, int n) {
        super(dialog, Messages.getString("CGCTableColsTableModel.LOBDialogTitle"), 3);
        this._tm = cGCTableColsTableModel;
        this._r = n;
        CGCColInfo cGCColInfo = this._tm.getCol(n);
        TTJPanel tTJPanel = new TTJPanel();
        DecimalFormat decimalFormat = new DecimalFormat("#0");
        this._n = new JFormattedTextField(new NumberFormatter(decimalFormat));
        this._n.setInputVerifier(new InputVerifier(){

            @Override
            public boolean shouldYieldFocus(JComponent jComponent) {
                return this.verify(jComponent);
            }

            @Override
            public boolean verify(JComponent jComponent) {
                if (jComponent instanceof JFormattedTextField) {
                    JFormattedTextField jFormattedTextField = (JFormattedTextField)jComponent;
                    long l = ((Number)jFormattedTextField.getValue()).intValue();
                    JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
                    if (abstractFormatter != null) {
                        String string = jFormattedTextField.getText();
                        try {
                            Object object = abstractFormatter.stringToValue(string);
                            long l2 = Integer.parseInt(string);
                            if (l2 <= 0L || l2 > LOBDialog.this._max) {
                                throw new Exception();
                            }
                            return true;
                        }
                        catch (Exception exception) {
                            jFormattedTextField.setValue(l);
                        }
                    }
                }
                return false;
            }
        });
        tTJPanel.addRow(Messages.getString("CGCTableColsTableModel.Size"), (Component)this._n);
        if (cGCColInfo.getOraTypeName().equals("CLOB")) {
            String[] stringArray = new String[]{"BYTE", "CHAR"};
            this._menu = new JComboBox<String>(stringArray);
            if (this._tm.getTTTypeName(this._r).contains("CHAR)")) {
                this._menu.setSelectedIndex(1);
            }
            tTJPanel.addRow(Messages.getString("AlterTablePanel.unit"), (Component)this._menu);
            this._menu.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    LOBDialog.this._menu.setPopupVisible(true);
                }
            });
        }
        this._max = cGCColInfo.len;
        this._n.setValue(cGCColInfo.getLOBSize());
        this.setContent(tTJPanel);
        this.setSize(400, 200);
        this.pack();
        this.setPreferredSize(tTJPanel.getPreferredSize());
    }

    String getLOBUnit() {
        Object object = "";
        if (this._menu != null) {
            object = " " + this._menu.getSelectedItem();
        }
        return object;
    }

    long getLOBSize() {
        int n = ((Number)this._n.getValue()).intValue();
        return n;
    }
}

