/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.SimpleQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.utils.DBObject;

public final class CacheInfo {
    public static final String CACHE_GROUP_NAME = "CACHE GROUP NAME";
    public static final String NUM_TABLES = "NUM TABLES";
    public static final String ROOT_SCHEMA_NAME = "ROOT SCHEMA NAME";
    public static final String ROOT_TABLE_NAME = "ROOT TABLE NAME";
    public static final String ROOT_TABLE_FULLNAME = "ROOT TABLE FULLNAME";
    public static final String AUTOREFRESH_INTERVAL = "AUTOREFRESH INTERVAL";
    public static final String AUTOREFRESH_LIMIT = "AUTOREFRESH LIMIT";
    public static final String CACHE_GROUP_TYPEv = "CACHE GROUP TYPEv";
    public static final String AUTOREFRESH_STATEv = "AUTOREFRESH STATEv";
    public static final String AUTOREFRESH_MODEv = "AUTOREFRESH MODEv";
    public static final String CACHE_GROUP_TYPE = "CACHE GROUP TYPE";
    public static final String AUTOREFRESH_ENABLED = "AUTOREFRESH ENABLED";
    public static final String AUTOREFRESH_MODE = "AUTOREFRESH MODE";
    public static final String AUTOREFRESH_STATE = "AUTOREFRESH STATE";
    public static final String AUTOREFRESH_UNIT = "AUTOREFRESH UNIT";
    public static final String AUTOREFRESH_INTERVAL_UNIT = "AUTOREFRESH INTERVAL+UNIT";
    public static final int AGENT_RUNNING_YES = 1;
    public static final int AGENT_RUNNING_NO = 0;
    public static final int AGENT_RUNNING_UNKNOWN = -1;

    public static Hashtable<String, String> getCacheInfo(DBObject dBObject) throws Exception {
        Statement statement = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = CGCPanel.allowDynamicCG(dBObject);
        boolean bl2 = false;
        try {
            Connection connection = dBObject.getConnection();
            String string = dBObject.getSchemaName();
            String string2 = dBObject.getObjectName();
            String string3 = " WHERE rtrim(CGOWNER) = '" + string + "' AND rtrim(CGNAME) = '" + string2 + "'";
            String string4 = bl ? ",GRIDINFO" : "";
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT CGOWNER,CGNAME,CGID,ROOT,TBLCNT, REFRESH_MODE, REFRESH_STATE, REFRESH_INTERVAL, CGATTRIBUTES, REFRESH_WITH_LIMIT" + string4 + " FROM SYS.CACHE_GROUP" + string3);
            boolean bl3 = resultSet.next();
            if (bl3) {
                hashtable.put(CACHE_GROUP_NAME, resultSet.getString(1).trim() + "." + resultSet.getString(2).trim());
                byte[] byArray = resultSet.getBytes(9);
                boolean bl4 = (byArray[0] & 1) == 1;
                boolean bl5 = (byArray[0] & 2) == 2;
                boolean bl6 = (byArray[0] & 4) == 4;
                boolean bl7 = (byArray[1] & 1) == 1;
                boolean bl8 = (byArray[1] & 2) == 2;
                boolean bl9 = (byArray[2] & 1) == 1;
                Object object = "";
                Object object2 = "";
                if (!bl6) {
                    hashtable.put(AUTOREFRESH_ENABLED, Messages.getString("TimesTen.common.no"));
                } else {
                    hashtable.put(AUTOREFRESH_ENABLED, Messages.getString("TimesTen.common.yes"));
                    String string5 = resultSet.getString(6);
                    if (string5.equals("N")) {
                        object2 = "No Autorefresh";
                        object = Messages.getString("CacheInfo.autoRefreshNone");
                    } else if (string5.equals("I")) {
                        object2 = "Incremental Autorefresh";
                        object = Messages.getString("CacheInfo.autoRefreshIncremental");
                    } else if (string5.equals("F")) {
                        object2 = "Full Autorefresh";
                        object = Messages.getString("CacheInfo.autoRefreshFull");
                    }
                    hashtable.put(AUTOREFRESH_MODEv, (String)object2);
                    hashtable.put(AUTOREFRESH_MODE, (String)object);
                    string5 = resultSet.getString(7);
                    if (string5.equals("N")) {
                        object = Messages.getString("TimesTen.common.off");
                        object2 = "Off";
                    } else if (string5.equals("Y")) {
                        object = Messages.getString("TimesTen.common.on");
                        object2 = "On";
                    } else if (string5.equals("P")) {
                        object = Messages.getString("TimesTen.common.paused");
                        object2 = "Paused";
                    }
                    hashtable.put(AUTOREFRESH_STATE, (String)object);
                    hashtable.put(AUTOREFRESH_STATEv, (String)object2);
                    long l = resultSet.getLong(8);
                    String string6 = Messages.getString("TimesTen.common.milliseconds");
                    if (l > 1000L && l % 1000L == 0L) {
                        string6 = Messages.getString("TimesTen.common.seconds");
                        if ((l /= 1000L) % 60L == 0L) {
                            string6 = Messages.getString("TimesTen.common.minutes");
                            l /= 60L;
                        }
                    }
                    hashtable.put(AUTOREFRESH_INTERVAL, "" + l);
                    hashtable.put(AUTOREFRESH_UNIT, string6);
                    hashtable.put(AUTOREFRESH_INTERVAL_UNIT, l + " " + string6);
                    hashtable.put(AUTOREFRESH_LIMIT, Long.toString(resultSet.getLong(10)));
                }
                if (bl) {
                    byte[] byArray2 = resultSet.getBytes(11);
                    if (!resultSet.wasNull()) {
                        bl2 = true;
                    }
                }
                if (bl4) {
                    object = Messages.getString("CGCCGPanel.RO");
                    object2 = "Readonly";
                } else if (bl5 && !bl9) {
                    object = Messages.getString("CGCCGPanel.SWT");
                    object2 = "Synchronous Writethrough";
                } else if (bl5 && bl9) {
                    object = Messages.getString("CGCCGPanel.AWT");
                    object2 = "Asynchronous Writethrough";
                } else if ((byArray[0] & 4) == 4) {
                    object = Messages.getString("CGCCGPanel.UM");
                    object2 = "User Managed";
                } else if ((byArray[0] & 8) == 8) {
                    object = Messages.getString("CacheInfo.USER_MANAGED_Restricted");
                    object2 = "USER MANAGED (Restricted)";
                } else if ((byArray[0] & 0) == 0) {
                    object = Messages.getString("CGCCGPanel.UM");
                    object2 = "User Managed";
                } else {
                    object = Messages.getString("TimesTen.common.unknown");
                    object2 = "Unknown";
                }
                if (bl8) {
                    object = Messages.getString("CGC.dynamic") + " " + (String)object;
                    object2 = "Dynamic " + (String)object;
                }
                if (bl2) {
                    object = (String)object + " " + Messages.getString("CGC.global");
                    object2 = (String)object2 + " Global";
                }
                hashtable.put(CACHE_GROUP_TYPE, (String)object);
                hashtable.put(CACHE_GROUP_TYPEv, (String)object2);
                int n = resultSet.getInt(4);
                short s = resultSet.getShort(5);
                resultSet.close();
                resultSet = statement.executeQuery("SELECT TBLOWNER,TBLNAME FROM SYS.TABLES WHERE TBLID=" + n);
                bl3 = resultSet.next();
                if (bl3) {
                    hashtable.put(ROOT_SCHEMA_NAME, resultSet.getString(1).trim());
                    hashtable.put(ROOT_TABLE_NAME, resultSet.getString(2).trim());
                    hashtable.put(ROOT_TABLE_FULLNAME, resultSet.getString(1).trim() + "." + resultSet.getString(2).trim());
                }
                hashtable.put(NUM_TABLES, Short.toString(s));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }

    public static boolean okToResetCacheAdminID(DBObject dBObject) {
        String string = "SELECT CGID FROM SYS.CACHE_GROUP C WHERE CGOWNER = '${userName}' AND (CGATTRIBUTES & 0x02 = 0x02 OR CGATTRIBUTES & 0x01 = 0x01)";
        return !SimpleQuery.anyResultQuery(dBObject, string);
    }

    public static boolean tableIsNonRootCG(DBObject dBObject) {
        String string = "SELECT T.TBLNAME FROM SYS.TABLES T, SYS.CACHE_GROUP C WHERE T.TBLNAME = '${objName}'  AND T.TBLOWNER = '${userName}'  AND T.CACHEGROUP = C.CGID  AND NOT TBLID = C.ROOT";
        return SimpleQuery.anyResultQuery(dBObject, string);
    }

    public static boolean tableIsPartOfARCG(DBObject dBObject) {
        String string = "SELECT T.TBLNAME FROM SYS.TABLES T, SYS.CACHE_GROUP C WHERE T.TBLNAME = '${objName}'  AND T.TBLOWNER = '${userName}'  AND T.CACHEGROUP = C.CGID  AND C.CGATTRIBUTES & 0x04 = 0x04";
        return SimpleQuery.anyResultQuery(dBObject, string);
    }

    public static int cacheAgentIsRunning(DBObject dBObject) {
        String string = "call ttCacheIsAgentAlive('oracle')";
        SQLException sQLException = SimpleQuery.sendQuery(dBObject, string, null);
        if (sQLException == null) {
            return 1;
        }
        String string2 = sQLException.getSQLState();
        int n = sQLException.getErrorCode();
        if (string2.equals("S1000") && n == 5002) {
            return 0;
        }
        Logger.getLogger("CacheInfo").log(Level.WARNING, "Cache agent status unknown: " + string2 + " " + n);
        return -1;
    }

    public static int repAgentIsRunning(DBObject dBObject) {
        String string = "call ttCacheIsAgentAlive('replication')";
        SQLException sQLException = SimpleQuery.sendQuery(dBObject, string, null);
        if (sQLException == null) {
            return 1;
        }
        String string2 = sQLException.getSQLState();
        int n = sQLException.getErrorCode();
        if (string2.equals("S1000") && n == 5057) {
            return 0;
        }
        Logger.getLogger("CacheInfo").log(Level.WARNING, "Rep agent status unknown: " + string2 + " " + n);
        return -1;
    }
}

