/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;

public abstract class PhaosAlgorithmParametersSpi
extends AlgorithmParametersSpi {
    protected String algName;

    PhaosAlgorithmParametersSpi(String algName) {
        this.algName = algName;
    }

    @Override
    protected byte[] engineGetEncoded(String format) throws IOException {
        throw new IOException("Method not supported");
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        throw new IOException("Method not supported");
    }

    @Override
    protected String engineToString() {
        return "Algorithm=" + this.algName;
    }

    static AlgorithmIdentifier getCBCOID(ASN1ObjectID oid) throws NoSuchAlgorithmException {
        if (oid.equals((Object)AlgID.desECB.getOID()) || oid.equals((Object)AlgID.desCBC.getOID())) {
            return AlgID.desCBC;
        }
        if (oid.equals((Object)AlgID.DES_EDE3_ECB.getOID()) || oid.equals((Object)AlgID.DES_EDE3_CBC.getOID())) {
            return AlgID.DES_EDE3_CBC;
        }
        if (oid.equals((Object)AlgID.aes128_ECB.getOID()) || oid.equals((Object)AlgID.aes128_CBC.getOID())) {
            return AlgID.aes128_CBC;
        }
        if (oid.equals((Object)AlgID.aes192_ECB.getOID()) || oid.equals((Object)AlgID.aes192_CBC.getOID())) {
            return AlgID.aes192_CBC;
        }
        if (oid.equals((Object)AlgID.aes256_ECB.getOID()) || oid.equals((Object)AlgID.aes256_CBC.getOID())) {
            return AlgID.aes256_CBC;
        }
        if (oid.equals((Object)AlgID.BLOWFISH.getOID()) || oid.equals((Object)AlgID.blowfishECB.getOID()) || oid.equals((Object)AlgID.blowfishCBC.getOID())) {
            return AlgID.blowfishCBC;
        }
        if (oid.equals((Object)AlgID.RC2_CBC.getOID())) {
            return AlgID.RC2_CBC;
        }
        throw new NoSuchAlgorithmException("Invalid algID: " + oid);
    }

    static AlgorithmIdentifier getECBOID(ASN1ObjectID oid) throws NoSuchAlgorithmException {
        if (oid.equals((Object)AlgID.desECB.getOID()) || oid.equals((Object)AlgID.desCBC.getOID())) {
            return AlgID.desECB;
        }
        if (oid.equals((Object)AlgID.DES_EDE3_ECB.getOID()) || oid.equals((Object)AlgID.DES_EDE3_CBC.getOID())) {
            return AlgID.DES_EDE3_ECB;
        }
        if (oid.equals((Object)AlgID.aes128_ECB.getOID()) || oid.equals((Object)AlgID.aes128_CBC.getOID())) {
            return AlgID.aes128_ECB;
        }
        if (oid.equals((Object)AlgID.aes192_ECB.getOID()) || oid.equals((Object)AlgID.aes192_CBC.getOID())) {
            return AlgID.aes192_ECB;
        }
        if (oid.equals((Object)AlgID.aes256_ECB.getOID()) || oid.equals((Object)AlgID.aes256_CBC.getOID())) {
            return AlgID.aes256_ECB;
        }
        if (oid.equals((Object)AlgID.BLOWFISH.getOID()) || oid.equals((Object)AlgID.blowfishECB.getOID()) || oid.equals((Object)AlgID.blowfishCBC.getOID())) {
            return AlgID.blowfishECB;
        }
        if (oid.equals((Object)AlgID.RC4.getOID())) {
            return AlgID.RC4;
        }
        if (oid.equals((Object)AlgID.rsaEncryption.getOID())) {
            return AlgID.rsaEncryption;
        }
        if (oid.equals((Object)AlgID.rsaWithOAEPEncoding.getOID())) {
            return AlgID.rsaWithOAEPEncoding;
        }
        throw new NoSuchAlgorithmException("Invalid algID: " + oid);
    }

    static String oidToString(ASN1ObjectID oid) throws NoSuchAlgorithmException {
        if (oid.equals((Object)AlgID.desECB.getOID()) || oid.equals((Object)AlgID.desCBC.getOID())) {
            return "DES";
        }
        if (oid.equals((Object)AlgID.DES_EDE3_ECB.getOID()) || oid.equals((Object)AlgID.DES_EDE3_CBC.getOID())) {
            return "DESede";
        }
        if (oid.equals((Object)AlgID.aes128_ECB.getOID()) || oid.equals((Object)AlgID.aes128_CBC.getOID())) {
            return "AES128";
        }
        if (oid.equals((Object)AlgID.aes192_ECB.getOID()) || oid.equals((Object)AlgID.aes192_CBC.getOID())) {
            return "AES192";
        }
        if (oid.equals((Object)AlgID.aes256_ECB.getOID()) || oid.equals((Object)AlgID.aes256_CBC.getOID())) {
            return "AES256";
        }
        if (oid.equals((Object)AlgID.BLOWFISH.getOID()) || oid.equals((Object)AlgID.blowfishECB.getOID()) || oid.equals((Object)AlgID.blowfishCBC.getOID())) {
            return "Blowfish";
        }
        if (oid.equals((Object)AlgID.RC2_CBC.getOID())) {
            return "RC2";
        }
        if (oid.equals((Object)AlgID.RC4.getOID())) {
            return "RC4";
        }
        if (oid.equals((Object)AlgID.rsaEncryption.getOID()) || oid.equals((Object)AlgID.rsaWithOAEPEncoding.getOID())) {
            return "RSA";
        }
        throw new NoSuchAlgorithmException("Invalid algID: " + oid);
    }

    static ASN1ObjectID stringToOid(String alg) throws NoSuchAlgorithmException {
        if (alg.equals("DES")) {
            return AlgID.desCBC.getOID();
        }
        if (alg.equals("DESede")) {
            return AlgID.DES_EDE3_CBC.getOID();
        }
        if (alg.equals("AES128")) {
            return AlgID.aes128_CBC.getOID();
        }
        if (alg.equals("AES192")) {
            return AlgID.aes128_CBC.getOID();
        }
        if (alg.equals("AES256")) {
            return AlgID.aes128_CBC.getOID();
        }
        if (alg.equals("Blowfish")) {
            return AlgID.blowfishCBC.getOID();
        }
        if (alg.equals("RC4")) {
            return AlgID.RC4.getOID();
        }
        if (alg.equals("RC2")) {
            return AlgID.RC2_CBC.getOID();
        }
        if (alg.equals("RSA")) {
            return AlgID.rsaEncryption.getOID();
        }
        throw new NoSuchAlgorithmException("Invalid algID: " + alg);
    }

    static int getBlockSize(ASN1ObjectID oid) throws NoSuchAlgorithmException {
        if (oid.equals((Object)AlgID.desECB.getOID()) || oid.equals((Object)AlgID.desCBC.getOID())) {
            return 8;
        }
        if (oid.equals((Object)AlgID.DES_EDE3_ECB.getOID()) || oid.equals((Object)AlgID.DES_EDE3_CBC.getOID())) {
            return 8;
        }
        if (oid.equals((Object)AlgID.aes128_ECB.getOID()) || oid.equals((Object)AlgID.aes128_CBC.getOID())) {
            return 16;
        }
        if (oid.equals((Object)AlgID.aes192_ECB.getOID()) || oid.equals((Object)AlgID.aes192_CBC.getOID())) {
            return 24;
        }
        if (oid.equals((Object)AlgID.aes256_ECB.getOID()) || oid.equals((Object)AlgID.aes256_CBC.getOID())) {
            return 32;
        }
        if (oid.equals((Object)AlgID.BLOWFISH.getOID()) || oid.equals((Object)AlgID.blowfishECB.getOID()) || oid.equals((Object)AlgID.blowfishCBC.getOID())) {
            return 8;
        }
        if (oid.equals((Object)AlgID.RC2_CBC.getOID())) {
            return 8;
        }
        if (oid.equals((Object)AlgID.RC4.getOID())) {
            return 1;
        }
        if (oid.equals((Object)AlgID.rsaEncryption.getOID()) || oid.equals((Object)AlgID.rsaWithOAEPEncoding.getOID())) {
            return 0;
        }
        throw new NoSuchAlgorithmException("Invalid algID: " + oid);
    }

    static int getKeySize(ASN1ObjectID oid) throws NoSuchAlgorithmException {
        if (oid.equals((Object)AlgID.desECB.getOID()) || oid.equals((Object)AlgID.desCBC.getOID())) {
            return 8;
        }
        if (oid.equals((Object)AlgID.DES_EDE3_ECB.getOID()) || oid.equals((Object)AlgID.DES_EDE3_CBC.getOID())) {
            return 24;
        }
        if (oid.equals((Object)AlgID.aes128_ECB.getOID()) || oid.equals((Object)AlgID.aes128_CBC.getOID())) {
            return 16;
        }
        if (oid.equals((Object)AlgID.aes192_ECB.getOID()) || oid.equals((Object)AlgID.aes192_CBC.getOID())) {
            return 24;
        }
        if (oid.equals((Object)AlgID.aes256_ECB.getOID()) || oid.equals((Object)AlgID.aes256_CBC.getOID())) {
            return 32;
        }
        if (oid.equals((Object)AlgID.BLOWFISH.getOID()) || oid.equals((Object)AlgID.blowfishECB.getOID()) || oid.equals((Object)AlgID.blowfishCBC.getOID())) {
            return 0;
        }
        if (oid.equals((Object)AlgID.RC2_CBC.getOID())) {
            return 0;
        }
        if (oid.equals((Object)AlgID.RC4.getOID())) {
            return 0;
        }
        if (oid.equals((Object)AlgID.rsaEncryption.getOID()) || oid.equals((Object)AlgID.rsaWithOAEPEncoding.getOID())) {
            return 0;
        }
        throw new NoSuchAlgorithmException("Invalid algID: " + oid);
    }
}

