/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.db2ISeriesv6;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.DB2Capturer;
import oracle.dbtools.migration.workbench.plugin.DB2OnlineCapturer;
import oracle.dbtools.migration.workbench.plugin.DB2Plugin;
import oracle.dbtools.migration.workbench.plugin.db2ISeriesv6.DB2IOnlineCapturer;

public class DB2Iv6Plugin
extends DB2Plugin {
    private static final String DB2I_PLATFORM_NAME = "DB2I";

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.contains("AS/400") && n >= 6) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    @Override
    public DB2Capturer getCapturer(MigrationStorer migrationStorer, Connection connection) {
        return new DB2Capturer(migrationStorer, connection){

            @Override
            protected DB2OnlineCapturer getOnlineCapturer(MigrationStorer migrationStorer, Connection connection) {
                return new DB2IOnlineCapturer(migrationStorer, connection);
            }

            @Override
            public String getModelName() throws CaptureException {
                Date date = new Date();
                if (this.m_modelName == null) {
                    try {
                        DatabaseMetaData databaseMetaData = this.m_sourceConnection.getMetaData();
                        String string = databaseMetaData.getURL();
                        String[] stringArray = string.split(":");
                        String string2 = string;
                        if (stringArray.length > 0) {
                            string2 = stringArray[stringArray.length - 1];
                        }
                        this.m_modelName = "\\\\" + string2 + " (" + databaseMetaData.getDatabaseProductName() + ")" + DateFormat.getDateTimeInstance().format(date);
                    }
                    catch (SQLException sQLException) {
                        throw new CaptureException((Throwable)sQLException);
                    }
                }
                return this.m_modelName;
            }
        };
    }

    @Override
    public String getPlatformName() {
        return DB2I_PLATFORM_NAME;
    }

    public String getPublishedVersion() {
        return "6";
    }

    public String getVersionNumber() {
        return this.getPublishedVersion();
    }

    @Override
    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        Object object = "";
        String string = mdColumn.getColumnType();
        String string2 = mdColumn2.getColumnName();
        if (string.equalsIgnoreCase("BLOB") || string.equalsIgnoreCase("CLOB") || string.equalsIgnoreCase("XML")) {
            String string3 = this.maybeQuoteSqlldrFieldReference(mdColumn, mdColumn2);
            String string4 = System.getProperty("line.separator");
            object = " FILLER," + string4;
            object = (String)object + string2 + " LOBFILE(" + string3 + ") TERMINATED BY EOF";
            return object;
        }
        return super.formatSQLLoaderColumn(mdColumn, mdColumn2);
    }

    public String maybeQuoteSqlldrFieldReference(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = mdColumn.getColumnType();
        if (string.equalsIgnoreCase("BLOB") || string.equalsIgnoreCase("CLOB") || string.equalsIgnoreCase("XML")) {
            return mdColumn2.getColumnName() + "_ref";
        }
        return super.maybeQuoteSqlldrFieldReference(mdColumn, mdColumn2);
    }
}

