/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.SimpleType;
import oracle.jdeveloper.xml.dtd.grammar.BuiltInSimpleListType;
import oracle.jdeveloper.xml.dtd.grammar.CDataSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.ComplexTypeAny;
import oracle.jdeveloper.xml.dtd.grammar.ComplexTypeEmpty;
import oracle.jdeveloper.xml.dtd.grammar.ComplexTypeText;
import oracle.jdeveloper.xml.dtd.grammar.EntitySimpleType;
import oracle.jdeveloper.xml.dtd.grammar.IDRefSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.NameSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.NameTokenSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.NotationSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.NumberSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.QNameSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.SgmlIDSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.StringSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.TokenSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.XmlIDSimpleType;

public class GrammarFactory {
    private static AbstractBuiltInSimpleType[] builtInTypes;
    private static final Map<String, ComplexTypeAny> _wildcardTypes;
    private static final Map<String, ComplexTypeEmpty> _emptyTypes;
    private static final Map<String, ComplexTypeText> _textTypes;

    public static SimpleType getBuiltInType(int builtInTypeId) {
        return GrammarFactory._getBuiltInType(builtInTypeId);
    }

    public static ComplexType getWildcardType(String namespace) {
        return GrammarFactory._getWildcardType(namespace);
    }

    public static ComplexType getEmptyType(String namespace) {
        return GrammarFactory._getEmptyType(namespace);
    }

    public static ComplexType getTextType(String namespace) {
        return GrammarFactory._getTextType(namespace);
    }

    static AbstractBuiltInSimpleType _getBuiltInType(int builtInTypeId) {
        if (builtInTypeId < 0 || builtInTypeId >= 15) {
            return null;
        }
        if (builtInTypes == null) {
            builtInTypes = new AbstractBuiltInSimpleType[15];
        }
        if (builtInTypes[builtInTypeId] == null) {
            AbstractBuiltInSimpleType builtInType = null;
            switch (builtInTypeId) {
                case 0: {
                    builtInType = new SgmlIDSimpleType();
                    break;
                }
                case 14: {
                    builtInType = new XmlIDSimpleType();
                    break;
                }
                case 1: {
                    builtInType = new IDRefSimpleType();
                    break;
                }
                case 6: {
                    builtInType = new BuiltInSimpleListType("IDREFS", GrammarFactory._getBuiltInType(1));
                    break;
                }
                case 11: {
                    builtInType = new StringSimpleType();
                    break;
                }
                case 3: {
                    builtInType = new CDataSimpleType();
                    break;
                }
                case 4: {
                    builtInType = new NameSimpleType();
                    break;
                }
                case 12: {
                    builtInType = new TokenSimpleType();
                    break;
                }
                case 5: {
                    builtInType = new NameTokenSimpleType();
                    break;
                }
                case 8: {
                    builtInType = new BuiltInSimpleListType("NMTOKENS", GrammarFactory._getBuiltInType(5));
                    break;
                }
                case 2: {
                    builtInType = new EntitySimpleType();
                    break;
                }
                case 7: {
                    builtInType = new BuiltInSimpleListType("ENTITIES", GrammarFactory._getBuiltInType(2));
                    break;
                }
                case 13: {
                    builtInType = new QNameSimpleType();
                    break;
                }
                case 9: {
                    builtInType = new NotationSimpleType();
                    break;
                }
                case 10: {
                    builtInType = new NumberSimpleType();
                }
            }
            GrammarFactory.builtInTypes[builtInTypeId] = builtInType;
        }
        return builtInTypes[builtInTypeId];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ComplexTypeAny _getWildcardType(String namespace) {
        Map<String, ComplexTypeAny> map = _wildcardTypes;
        synchronized (map) {
            ComplexTypeAny type = _wildcardTypes.get(namespace);
            if (type == null) {
                type = new ComplexTypeAny(namespace);
                _wildcardTypes.put(namespace, type);
            }
            return type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ComplexTypeEmpty _getEmptyType(String namespace) {
        Map<String, ComplexTypeEmpty> map = _emptyTypes;
        synchronized (map) {
            ComplexTypeEmpty type = _emptyTypes.get(namespace);
            if (type == null) {
                type = new ComplexTypeEmpty(namespace);
                _emptyTypes.put(namespace, type);
            }
            return type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ComplexTypeText _getTextType(String namespace) {
        Map<String, ComplexTypeText> map = _textTypes;
        synchronized (map) {
            ComplexTypeText type = _textTypes.get(namespace);
            if (type == null) {
                type = new ComplexTypeText(namespace);
                _textTypes.put(namespace, type);
            }
            return type;
        }
    }

    static {
        _wildcardTypes = new HashMap<String, ComplexTypeAny>();
        _emptyTypes = new HashMap<String, ComplexTypeEmpty>();
        _textTypes = new HashMap<String, ComplexTypeText>();
    }

    protected static abstract class AbstractBuiltInSimpleType
    implements SimpleType {
        private String _name;
        private int _variety;
        protected SimpleType _primitiveType;
        protected SimpleType _baseType;
        protected SimpleType _itemType;

        protected AbstractBuiltInSimpleType(String name) {
            this._name = name;
            this._variety = 0;
            this._primitiveType = this;
        }

        protected AbstractBuiltInSimpleType(String name, SimpleType baseType) {
            this(name, baseType, baseType.getVariety());
        }

        protected AbstractBuiltInSimpleType(String name, SimpleType baseType, int variety) {
            this._name = name;
            this._variety = variety;
            this._baseType = baseType;
            switch (this._variety) {
                case 0: {
                    this._primitiveType = baseType.getPrimitiveType();
                    break;
                }
                case 1: {
                    this._primitiveType = baseType.getPrimitiveType();
                    this._itemType = baseType;
                    break;
                }
                default: {
                    this._variety = baseType.getVariety();
                    this._primitiveType = baseType.getPrimitiveType();
                }
            }
        }

        @Override
        public final Annotation getAnnotation() {
            return null;
        }

        @Override
        public final Collection getConstrainingFacets() {
            return null;
        }

        @Override
        public final String getName() {
            return this._name;
        }

        @Override
        public String getTargetNamespace() {
            return "http://www.w3.org/2001/XMLSchema";
        }

        @Override
        public final SimpleType getBuiltInBaseType() {
            return this._baseType;
        }

        @Override
        public final SimpleType getPrimitiveType() {
            return this._primitiveType;
        }

        @Override
        public final int getVariety() {
            return this._variety;
        }

        @Override
        public List getUnionMemberTypes() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public SimpleType getListItemType() {
            return this._itemType;
        }

        public final String toString() {
            return this.getName();
        }

        @Override
        public Object convertToJavaType(String value) throws GrammarException {
            return null;
        }
    }
}

