/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class WeakListenerProxy<ListenerClass, SubjectClass>
implements InvocationHandler {
    private final Class<ListenerClass> _listenerClass;
    private final Reference<ListenerClass> _listenerRef;
    private final Reference<Object> _subjectRef;
    private final String _listenerRemovalMethodName;
    private Class<SubjectClass> _subjectClass;

    public static <ListenerClass, SubjectClass> ListenerClass create(Class<ListenerClass> listenerClass, ListenerClass listenerToProxy, Class<SubjectClass> subjectClass, SubjectClass subject, String listenerRemovalMethodName) {
        if (listenerClass == null || listenerToProxy == null || subject == null) {
            throw new IllegalArgumentException("null parameter");
        }
        Object ret = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, new WeakListenerProxy<ListenerClass, SubjectClass>(listenerClass, listenerToProxy, subjectClass, subject, listenerRemovalMethodName));
        return listenerClass.cast(ret);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            String name = method.getName();
            if ("equals".equals(name)) {
                return proxy == args[0];
            }
            if ("hashCode".equals(name)) {
                return System.identityHashCode(proxy);
            }
            if ("toString".equals(name)) {
                return "weak listener proxy@" + System.identityHashCode(proxy);
            }
            return null;
        }
        ListenerClass listener = this._listenerRef.get();
        Object subject = this._subjectRef.get();
        if (subject == null) {
            this._listenerRef.clear();
        } else if (listener == null) {
            if (this._listenerRemovalMethodName != null) {
                Method disconnectMethod = this._subjectClass.getMethod(this._listenerRemovalMethodName, this._listenerClass);
                disconnectMethod.invoke(subject, proxy);
                this._subjectRef.clear();
            }
        } else {
            return method.invoke(listener, args);
        }
        return null;
    }

    private WeakListenerProxy(Class<ListenerClass> listenerClass, ListenerClass listenerToProxy, Class<SubjectClass> subjectClass, SubjectClass subject, String listenerRemovalMethodName) {
        this._listenerClass = listenerClass;
        this._listenerRef = new WeakReference<ListenerClass>(listenerToProxy);
        this._subjectClass = subjectClass;
        this._subjectRef = new WeakReference<SubjectClass>(subject);
        this._listenerRemovalMethodName = listenerRemovalMethodName;
    }
}

