/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.Expression;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.Coercions;

final class ASTCoerce
extends Expression {
    private final Expression _expr;
    private final Class _type;

    public ASTCoerce(Expression expr, Class type) {
        this._expr = expr;
        this._type = type;
    }

    @Override
    public Object getValue(VariableResolver vResolver) throws ELException {
        return Coercions.toObject(vResolver, this._expr, this._type);
    }

    @Override
    public boolean isReadOnly(VariableResolver vResolver) throws ELException {
        return this._expr.isReadOnly(vResolver);
    }

    @Override
    public void setValue(VariableResolver vResolver, Object value) throws ELException {
        this._expr.setValue(vResolver, value);
    }

    @Override
    public boolean isConstant() {
        return this._expr.isConstant();
    }

    @Override
    public Class getType(VariableResolver resolver) throws ELException {
        Class underlyingType = this._expr.getType(resolver);
        if (underlyingType.isPrimitive()) {
            underlyingType = ASTCoerce._getBoxedType(underlyingType);
        }
        if (this._type.isAssignableFrom(underlyingType)) {
            return underlyingType;
        }
        return this._type;
    }

    private static Class _getBoxedType(Class primitive) {
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Void.TYPE) {
            return Void.class;
        }
        throw new IllegalArgumentException("Class " + primitive + " is not primitive");
    }

    public String toString() {
        return this._expr.toString();
    }
}

