/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.util;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.PrefixName;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.util.SimpleTypeConverter;
import oracle.bali.xml.grammar.util.SimpleTypeValueProvider;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.util.XmlPackageHintUtils;
import oracle.bali.xml.util.XmlNameUtils;

public class JavaTypeManager {
    private static final SimpleTypeConverter _listConverter = new ListSimpleTypeConverter();
    private static volatile JavaTypeManager _typeManager = null;
    private static final Logger _LOGGER = Logger.getLogger(JavaTypeManager.class.getName());
    private final Object _classLoaderMapLock = new Object();
    private final ConcurrentHashMap<QualifiedName, SimpleTypeConverter> _typeConverterMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<QualifiedName, String> _externallyRegisteredTypeConverterMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<QualifiedName, SimpleTypeValueProvider> _simpleTypeValueProvider;
    private final WeakHashMap<ClassLoader, ConcurrentHashMap<QualifiedName, WeakReference<SimpleTypeConverter>>> _classLoaderToExternalTypeConverterMap = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JavaTypeManager getInstance() {
        if (_typeManager != null) return _typeManager;
        Class<JavaTypeManager> clazz = JavaTypeManager.class;
        synchronized (JavaTypeManager.class) {
            if (_typeManager != null) return _typeManager;
            JavaTypeManager newTypeManager = new JavaTypeManager();
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "string", new StringSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "string", new StringValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "boolean", new BooleanSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "boolean", new BooleanValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "decimal", new DecimalSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "decimal", new DecimalValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "float", new FloatSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "float", new FloatValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "double", new DoubleSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "double", new DoubleValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "integer", new IntegerSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "integer", new IntegerValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger", new IntegerSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger", new IntegerValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "negativeInteger", new IntegerSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "negativeInteger", new IntegerValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger", new IntegerSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger", new IntegerValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "positiveInteger", new IntegerSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "positiveInteger", new IntegerValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "long", new LongSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "long", new LongValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "unsignedLong", new IntegerSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "unsignedLong", new IntegerValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "int", new IntSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "int", new IntValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "unsignedInt", new LongSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "unsignedInt", new LongValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "short", new ShortSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "short", new ShortValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "unsignedShort", new IntSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "unsignedShort", new IntValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "byte", new ByteSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "byte", new ByteValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "date", new DateSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "date", new DateValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "unsignedByte", new ShortSimpleTypeConverter());
            newTypeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "unsignedByte", new ShortValueProvider());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "anyURI", new AnyUriSimpleTypeConverter());
            newTypeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "QName", new QNameSimpleTypeConverter());
            newTypeManager._registerInternalSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASS, new JavaClassConverter());
            newTypeManager._registerInternalSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASSINSTANCE, new JavaClassInstanceConverter());
            newTypeManager._registerInternalSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASSORDIRECTOBJECT, new JavaClassOrDirectObjectConverter());
            newTypeManager._registerInternalSimpleTypeConverter(XmlMetadataConstants.TYPE_RESOURCEPATH, new ResourcePathConverter());
            _typeManager = newTypeManager;
            // ** MonitorExit[var0] (shouldn't be in output)
            return _typeManager;
        }
    }

    public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
        if (simpleType == null) {
            throw new GrammarException("JavaTypeManager:convertToJavaType() simpleType parameter cannot be null");
        }
        if (value == null) {
            throw new GrammarException("JavaTypeManager:convertToJavaType() value parameter cannot be null");
        }
        if (simpleType.getVariety() == 10) {
            throw new GrammarException("JavaTypeManager:convertToJavaType() does not currently support unknown variety simpleTypes");
        }
        SimpleTypeConverter converter = this.getConverter(simpleType);
        if (converter != null) {
            return converter.convertToJavaType(value, simpleType);
        }
        return value;
    }

    public SimpleTypeConverter getSimpleTypeConverter(QualifiedName qName) {
        return this._typeConverterMap.get(qName);
    }

    public Class getJavaClass(SimpleType simpleType) throws GrammarException {
        if (simpleType == null) {
            throw new GrammarException("JavaTypeManager:getJavaClass() type parameter cannot be null");
        }
        if (simpleType.getVariety() == 10) {
            throw new GrammarException("JavaTypeManager:convertToJavaType() does not currently support unknown variety simpleTypes");
        }
        Class javaClass = String.class;
        SimpleTypeConverter converter = this.getConverter(simpleType);
        if (converter != null) {
            javaClass = converter.getJavaClass(simpleType);
        }
        return javaClass;
    }

    public String convertToString(Object javaType, SimpleType simpleType) throws GrammarException {
        if (javaType == null) {
            throw new IllegalArgumentException("JavaTypeManager.covnertToString(): javaType parameter cannot be null");
        }
        if (simpleType == null) {
            throw new GrammarException("JavaTypeManager.covnertToString(): simpleType parameter cannot be null");
        }
        if (simpleType.getVariety() == 10) {
            throw new GrammarException("JavaTypeManager.convertToString(): unsupported SimpleType encountered.");
        }
        SimpleTypeConverter converter = this.getConverter(simpleType);
        if (converter != null) {
            return converter.convertToString(javaType, simpleType);
        }
        return javaType.toString();
    }

    public String getSimpleTypeValue(SimpleType type) {
        if (type == null) {
            throw new IllegalArgumentException("JavaTypeManager:getSimpleTypeValue() type parameter cannot be null");
        }
        SimpleTypeValueProvider provider = this.findBestMatch(type, this._simpleTypeValueProvider, false);
        if (provider != null) {
            return provider.createNewValue(type);
        }
        return null;
    }

    public void registerSimpleTypeConverter(String namespace, String simpleTypeName, SimpleTypeConverter converter) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this.registerSimpleTypeConverter(qName, converter);
    }

    public void registerSimpleTypeConverter(QualifiedName simpleTypeName, SimpleTypeConverter converter) {
        if (simpleTypeName != null && converter != null) {
            this._typeConverterMap.put(simpleTypeName, converter);
        }
    }

    public void registerSimpleTypeConverter(String namespace, String simpleTypeName, String converterClassName) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this.registerSimpleTypeConverter(qName, converterClassName);
    }

    public void registerSimpleTypeConverter(QualifiedName simpleTypeName, String converterClassName) {
        if (simpleTypeName != null && converterClassName != null) {
            this._externallyRegisteredTypeConverterMap.put(simpleTypeName, converterClassName);
        }
    }

    public final void registerSimpleTypeValueProvider(String namespace, String simpleTypeName, SimpleTypeValueProvider provider) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this.registerSimpleTypeValueProvider(qName, provider);
    }

    public void registerSimpleTypeValueProvider(QualifiedName simpleTypeName, SimpleTypeValueProvider provider) {
        if (simpleTypeName != null) {
            this._simpleTypeValueProvider.put(simpleTypeName, provider);
        }
    }

    public SimpleTypeConverter getConverter(SimpleType simpleType) {
        if (simpleType.getVariety() == 0) {
            return this.findBestMatch(simpleType, this._typeConverterMap, true);
        }
        if (simpleType.getVariety() == 1) {
            return _listConverter;
        }
        if (simpleType.getVariety() == 2) {
            return this._getConverterForUnion(simpleType);
        }
        return null;
    }

    protected SimpleTypeConverter getStringConverter() {
        return this.getSimpleTypeConverter(QualifiedName.getQualifiedName("http://www.w3.org/2001/XMLSchema", "string"));
    }

    private SimpleTypeConverter _getConverterForUnion(SimpleType simpleType) {
        if (simpleType.getVariety() == 2) {
            SimpleTypeConverter unionConverter = null;
            List memberTypes = simpleType.getUnionMemberTypes();
            for (SimpleType memberType : memberTypes) {
                SimpleTypeConverter memberConverter = this.getConverter(memberType);
                if (unionConverter == null) {
                    unionConverter = memberConverter;
                    continue;
                }
                if (unionConverter.equals(memberConverter)) continue;
                return this.getStringConverter();
            }
            if (unionConverter != null) {
                return unionConverter;
            }
        }
        return this.getStringConverter();
    }

    public <T> T findBestMatch(SimpleType simpleType, ConcurrentHashMap<QualifiedName, T> search, boolean findTypeConverter) {
        T o = this._getExactMatch(simpleType, search, findTypeConverter);
        if (o == null && (o = this._getExactMatch(simpleType.getBuiltInBaseType(), search, findTypeConverter)) == null) {
            o = this._getExactMatch(simpleType.getPrimitiveType(), search, findTypeConverter);
        }
        return o;
    }

    private <T> T _getExactMatch(SimpleType simpleType, ConcurrentHashMap<QualifiedName, T> search, boolean findTypeConverter) {
        String simpleName;
        SimpleTypeConverter o = null;
        if (simpleType != null && (simpleName = simpleType.getName()) != null && simpleName.length() > 0 && XmlNameUtils.isValidName(simpleName)) {
            QualifiedName key;
            String typeNamespace = simpleType.getTargetNamespace();
            if ("string".equals(simpleName)) {
                typeNamespace = "http://www.w3.org/2001/XMLSchema";
            }
            if ("boolean".equals(simpleName)) {
                typeNamespace = "http://www.w3.org/2001/XMLSchema";
            }
            if ((o = (SimpleTypeConverter)search.get(key = QualifiedName.getQualifiedName(typeNamespace, simpleName))) == null && findTypeConverter && (o = this._checkForCachedExternallyRegisteredTypeConverter(key)) == null && (o = this._getExternallyRegisteredTypeConverter(key)) != null) {
                this._registerExternalTypeConverter(key, o);
            }
        }
        return (T)o;
    }

    private SimpleTypeConverter _getExternallyRegisteredTypeConverter(QualifiedName key) {
        SimpleTypeConverter o = null;
        String className = this._externallyRegisteredTypeConverterMap.get(key);
        if (className != null) {
            try {
                Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
                if (c != null) {
                    o = (SimpleTypeConverter)c.newInstance();
                }
            }
            catch (ClassNotFoundException cnfe) {
                _LOGGER.log(Level.WARNING, "JavaTypeManager._getExternallyRegisteredTypeConverter - ClassNotFoundException: {0}", cnfe);
            }
            catch (IllegalAccessException iae) {
                _LOGGER.log(Level.WARNING, "JavaTypeManager._getExternallyRegisteredTypeConverter - IllegalAccessException: {0}", iae);
            }
            catch (InstantiationException ie) {
                _LOGGER.log(Level.WARNING, "JavaTypeManager._getExternallyRegisteredTypeConverter - InstantiationException: {0}", ie);
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleTypeConverter _checkForCachedExternallyRegisteredTypeConverter(QualifiedName key) {
        SimpleTypeConverter o = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ConcurrentHashMap<QualifiedName, WeakReference<SimpleTypeConverter>> typeConverterMap = null;
        Object object = this._classLoaderMapLock;
        synchronized (object) {
            typeConverterMap = this._classLoaderToExternalTypeConverterMap.get(classLoader);
        }
        if (typeConverterMap != null) {
            WeakReference<SimpleTypeConverter> weakReferenceSimpleTypeConverter = typeConverterMap.get(key);
            if (weakReferenceSimpleTypeConverter == null) {
                return null;
            }
            o = (SimpleTypeConverter)weakReferenceSimpleTypeConverter.get();
            if (o == null) {
                return null;
            }
            return o;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _registerExternalTypeConverter(QualifiedName simpleTypeName, SimpleTypeConverter converter) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ConcurrentHashMap<QualifiedName, WeakReference<SimpleTypeConverter>> typeConverterMap = null;
        Object object = this._classLoaderMapLock;
        synchronized (object) {
            typeConverterMap = this._classLoaderToExternalTypeConverterMap.get(classLoader);
            if (typeConverterMap == null) {
                typeConverterMap = new ConcurrentHashMap();
                this._classLoaderToExternalTypeConverterMap.put(classLoader, typeConverterMap);
            }
        }
        typeConverterMap.put(simpleTypeName, new WeakReference<SimpleTypeConverter>(converter));
    }

    private static <T> T _as(Class<T> clazz, Object o) {
        if (clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        return null;
    }

    private void _registerInternalSimpleTypeConverter(String namespace, String simpleTypeName, SimpleTypeConverter converter) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this._registerInternalSimpleTypeConverter(qName, converter);
    }

    private void _registerInternalSimpleTypeConverter(QualifiedName simpleTypeName, SimpleTypeConverter converter) {
        if (simpleTypeName != null && converter != null) {
            this._typeConverterMap.put(simpleTypeName, converter);
        }
    }

    private JavaTypeManager() {
        this._simpleTypeValueProvider = new ConcurrentHashMap();
    }

    private static RuntimeException _throwRuntimeException(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("The resource ");
        sb.append(value);
        sb.append("\nwas loaded via the context classloader.");
        sb.append("The resource was specified in metadata, with no accompanying hints using the <xml-package-hint-hook> hook.");
        return new RuntimeException(sb.toString());
    }

    private static Class getClassFromHints(String value) {
        Set<ClassLoader> loaders = XmlPackageHintUtils.getClassLoaders(value);
        for (ClassLoader loader : loaders) {
            try {
                Class<?> clazz = loader.loadClass(value);
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (RuntimeException e) {
                _LOGGER.log(Level.SEVERE, "Error trying to load class " + value + " using hints defined in metadata.", e);
            }
        }
        return null;
    }

    private static Object getResourceFromHints(String resource) {
        int lastIndex = resource.lastIndexOf("/");
        if (lastIndex != -1) {
            String value = resource.substring(0, lastIndex + 1);
            value = value.replace("/", ".");
            Set<ClassLoader> loaders = XmlPackageHintUtils.getClassLoaders(value);
            for (ClassLoader loader : loaders) {
                try {
                    URL object = loader.getResource(resource);
                    if (object == null) continue;
                    return object;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private static boolean _isDebug() {
        return Boolean.getBoolean("ide.debugbuild");
    }

    private static boolean _requiresLogging(String value) {
        return JavaTypeManager._isDebug() && !value.startsWith("java.") && !value.startsWith("javax.") && !value.startsWith("org.w3c") && !value.startsWith("oracle.bali.xml");
    }

    private static class StringSimpleTypeConverter
    extends SimpleTypeConverter {
        private StringSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            return value;
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return String.class;
        }
    }

    private static class StringValueProvider
    implements SimpleTypeValueProvider {
        private StringValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            return "abc";
        }
    }

    private static class BooleanSimpleTypeConverter
    extends SimpleTypeConverter {
        private BooleanSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            if ("true".equals(value) || "1".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value) || "0".equals(value)) {
                return Boolean.FALSE;
            }
            throw new GrammarException("BooleanSimpleTypeConverter: " + value + " cannot be converted to this type");
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return Boolean.class;
        }
    }

    private static class BooleanValueProvider
    implements SimpleTypeValueProvider {
        private BooleanValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            return "false";
        }
    }

    private static class DecimalSimpleTypeConverter
    extends SimpleTypeConverter {
        private DecimalSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return new BigDecimal(value);
            }
            catch (Exception e) {
                throw new GrammarException("DecimalSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return BigDecimal.class;
        }
    }

    private static class DecimalValueProvider
    implements SimpleTypeValueProvider {
        private double _count = 0.0;

        DecimalValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            double d = this._count;
            this._count = d + 1.0;
            return "123.123" + d;
        }
    }

    private static class FloatSimpleTypeConverter
    extends SimpleTypeConverter {
        private FloatSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Float.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("FloatSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return Float.class;
        }
    }

    private static class FloatValueProvider
    implements SimpleTypeValueProvider {
        private float _count = 0.0f;

        FloatValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            float f = this._count;
            this._count = f + 1.0f;
            return "123." + f;
        }
    }

    private static class DoubleSimpleTypeConverter
    extends SimpleTypeConverter {
        private DoubleSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Double.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("DoubleSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return Double.class;
        }
    }

    private static class DoubleValueProvider
    implements SimpleTypeValueProvider {
        private double _count = 0.0;

        DoubleValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            double d = this._count;
            this._count = d + 1.0;
            return "123.12" + d;
        }
    }

    private static class IntegerSimpleTypeConverter
    extends SimpleTypeConverter {
        private IntegerSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return new BigInteger(value);
            }
            catch (Exception e) {
                throw new GrammarException("IntegerSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return BigInteger.class;
        }
    }

    private static class IntegerValueProvider
    implements SimpleTypeValueProvider {
        private long _count = 0L;

        IntegerValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            return "123" + this._count++;
        }
    }

    private static class LongSimpleTypeConverter
    extends SimpleTypeConverter {
        private LongSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Long.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("LongSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return Long.class;
        }
    }

    private static class LongValueProvider
    implements SimpleTypeValueProvider {
        private long _count = 0L;

        LongValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            return "12345" + this._count++;
        }
    }

    private static class IntSimpleTypeConverter
    extends SimpleTypeConverter {
        private IntSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("IntSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return Integer.class;
        }
    }

    private static class IntValueProvider
    implements SimpleTypeValueProvider {
        private int _count = 0;

        IntValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            return "12" + this._count++;
        }
    }

    private static class ShortSimpleTypeConverter
    extends SimpleTypeConverter {
        private ShortSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Short.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("ShortSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return Short.class;
        }
    }

    private static class ShortValueProvider
    implements SimpleTypeValueProvider {
        private short _count = 0;

        ShortValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            short s = this._count;
            this._count = (short)(s + 1);
            return String.valueOf(s);
        }
    }

    private static class ByteSimpleTypeConverter
    extends SimpleTypeConverter {
        private ByteSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Byte.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("ByteSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return Byte.class;
        }
    }

    private static class ByteValueProvider
    implements SimpleTypeValueProvider {
        private byte _count = 0;

        ByteValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            byte by = this._count;
            this._count = (byte)(by + 1);
            return Integer.toHexString(by);
        }
    }

    private static class DateSimpleTypeConverter
    extends SimpleTypeConverter {
        private DateSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(value);
            }
            catch (Exception e) {
                throw new GrammarException("DateSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public String convertToString(Object javaType, SimpleType simpleType) {
            if (javaType == null) {
                return null;
            }
            try {
                if (javaType instanceof XMLGregorianCalendar) {
                    XMLGregorianCalendar cal = (XMLGregorianCalendar)javaType;
                    return cal.toXMLFormat();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return javaType.toString();
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return XMLGregorianCalendar.class;
        }
    }

    private static class DateValueProvider
    implements SimpleTypeValueProvider {
        private DateValueProvider() {
        }

        @Override
        public String createNewValue(SimpleType type) {
            return "2012-01-01Z";
        }
    }

    private static class AnyUriSimpleTypeConverter
    extends SimpleTypeConverter {
        private AnyUriSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return new URI(value);
            }
            catch (Exception e) {
                throw new GrammarException("AnyUriSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return URI.class;
        }
    }

    private static class QNameSimpleTypeConverter
    extends SimpleTypeConverter {
        private QNameSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                String prefix = null;
                String localName = null;
                int sepIndex = value.indexOf(58);
                if (sepIndex != -1) {
                    prefix = value.substring(0, sepIndex);
                    if (sepIndex + 1 < value.length()) {
                        localName = value.substring(sepIndex + 1);
                    }
                } else {
                    localName = value;
                }
                return PrefixName.getPrefixName(prefix, localName);
            }
            catch (Exception e) {
                throw new GrammarException("QNameSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return PrefixName.class;
        }

        @Override
        public String convertToString(Object javaType, SimpleType simpleType) {
            if (javaType == null) {
                return null;
            }
            PrefixName pn = null;
            pn = (PrefixName)JavaTypeManager._as(this.getJavaClass(simpleType), javaType);
            if (pn != null) {
                return pn.getPrefixName();
            }
            return super.convertToString(javaType, simpleType);
        }
    }

    private static class JavaClassConverter
    extends SimpleTypeConverter {
        private static HashMap _sPrimitiveTypes = new HashMap();

        private JavaClassConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            Class primitiveClass = (Class)_sPrimitiveTypes.get(value);
            if (primitiveClass != null) {
                return primitiveClass;
            }
            if (Character.isUpperCase(((String)value).charAt(0))) {
                value = "java.lang." + (String)value;
            }
            if (((String)value).endsWith("[]")) {
                return String[].class;
            }
            Class<?> clazz = JavaTypeManager.getClassFromHints((String)value);
            if (clazz != null) {
                return clazz;
            }
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass((String)value);
                if (clazz != null && JavaTypeManager._requiresLogging((String)value)) {
                    _LOGGER.log(Level.SEVERE, "JavaTypeManager using context classloader to load resource {0}", JavaTypeManager._throwRuntimeException((String)value));
                }
                return clazz;
            }
            catch (Exception e) {
                if (JavaTypeManager._isDebug()) {
                    _LOGGER.log(Level.INFO, "JavaTypeManager was unable to load class referenced in metadata: " + (String)value, e);
                }
                throw new GrammarException("error converting to Java class", e);
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return Class.class;
        }

        static {
            _sPrimitiveTypes.put("char", Character.TYPE);
            _sPrimitiveTypes.put("byte", Byte.TYPE);
            _sPrimitiveTypes.put("short", Short.TYPE);
            _sPrimitiveTypes.put("int", Integer.TYPE);
            _sPrimitiveTypes.put("long", Long.TYPE);
            _sPrimitiveTypes.put("float", Float.TYPE);
            _sPrimitiveTypes.put("double", Double.TYPE);
            _sPrimitiveTypes.put("boolean", Boolean.TYPE);
        }
    }

    private static class JavaClassInstanceConverter
    extends SimpleTypeConverter {
        private JavaClassInstanceConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                Class<?> c = JavaTypeManager.getClassFromHints(value);
                if (c == null && (c = Thread.currentThread().getContextClassLoader().loadClass(value)) != null && JavaTypeManager._requiresLogging(value)) {
                    _LOGGER.log(Level.SEVERE, "JavaTypeManager using context classloader to load resource {0}", JavaTypeManager._throwRuntimeException(value));
                }
                return c.newInstance();
            }
            catch (Exception e) {
                throw new GrammarException("error converting to Java class", e);
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return Object.class;
        }
    }

    private static class JavaClassOrDirectObjectConverter
    extends SimpleTypeConverter {
        private JavaClassOrDirectObjectConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            Class<?> clazz = JavaTypeManager.getClassFromHints(value);
            if (clazz != null) {
                return clazz;
            }
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(value);
                if (clazz != null && JavaTypeManager._requiresLogging(value)) {
                    _LOGGER.log(Level.SEVERE, "JavaTypeManager using context classloader to load resource {0}", JavaTypeManager._throwRuntimeException(value));
                }
                return clazz;
            }
            catch (Exception e) {
                throw new GrammarException("error converting to Java class", e);
            }
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return Object.class;
        }
    }

    private static class ResourcePathConverter
    extends SimpleTypeConverter {
        private ResourcePathConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            Object resource;
            String rString = value;
            if (rString.startsWith("/")) {
                rString = rString.substring(1);
            }
            if ((resource = JavaTypeManager.getResourceFromHints(rString)) != null) {
                return resource;
            }
            resource = Thread.currentThread().getContextClassLoader().getResource(rString);
            if (resource != null) {
                if (JavaTypeManager._isDebug() && !rString.startsWith("oracle/javatools/icons") && !rString.startsWith("oracle/ideimpl/resource/images") && !rString.startsWith("oracle/ide/icons/")) {
                    _LOGGER.log(Level.SEVERE, "JavaTypeManager using context classloader to load resource {0}", JavaTypeManager._throwRuntimeException(rString));
                }
            } else if (JavaTypeManager._isDebug()) {
                _LOGGER.log(Level.INFO, "Resource {0} does not exist!", rString);
            }
            return resource;
        }

        @Override
        public Class getJavaClass(SimpleType type) {
            return URL.class;
        }
    }

    private static class ListSimpleTypeConverter
    extends SimpleTypeConverter {
        private ListSimpleTypeConverter() {
        }

        @Override
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            SimpleTypeConverter itemConverter;
            ArrayList<Object> list = new ArrayList<Object>(3);
            if (value != null && (itemConverter = this._getItemConverter(simpleType)) != null) {
                StringTokenizer tokenizer = new StringTokenizer(value);
                while (tokenizer.hasMoreTokens()) {
                    String item = tokenizer.nextToken();
                    Object javaObject = item;
                    javaObject = itemConverter.convertToJavaType(item, simpleType);
                    list.add(javaObject);
                }
            }
            return list;
        }

        @Override
        public Class getJavaClass(SimpleType simpleType) throws GrammarException {
            return List.class;
        }

        @Override
        public String convertToString(Object javaType, SimpleType simpleType) {
            List l;
            StringBuilder sb = new StringBuilder(3);
            SimpleTypeConverter itemConverter = this._getItemConverter(simpleType);
            if (itemConverter != null && (l = JavaTypeManager._as(List.class, javaType)) != null) {
                for (Object o : l) {
                    String s = itemConverter.convertToString(o, simpleType);
                    if (s == null) continue;
                    sb.append(s);
                    sb.append(" ");
                }
            }
            return sb.toString().trim();
        }

        private SimpleTypeConverter _getItemConverter(SimpleType simpleType) {
            if (simpleType.getVariety() == 1) {
                SimpleType itemType = simpleType.getListItemType();
                SimpleTypeConverter itemConverter = JavaTypeManager.getInstance().getConverter(itemType);
                return _listConverter.equals(itemConverter) ? JavaTypeManager.getInstance().getStringConverter() : itemConverter;
            }
            if (simpleType.getVariety() == 2) {
                SimpleTypeConverter unionConverter = null;
                List memberTypes = simpleType.getUnionMemberTypes();
                for (SimpleType memberType : memberTypes) {
                    if (memberType.getVariety() != 1) {
                        return JavaTypeManager.getInstance().getStringConverter();
                    }
                    SimpleType memberItemType = memberType.getListItemType();
                    SimpleTypeConverter memberConverter = JavaTypeManager.getInstance().getConverter(memberItemType);
                    if (unionConverter == null) {
                        unionConverter = memberConverter;
                        continue;
                    }
                    if (unionConverter.equals(memberConverter)) continue;
                    return JavaTypeManager.getInstance().getStringConverter();
                }
                if (!_listConverter.equals(unionConverter) && unionConverter != null) {
                    return unionConverter;
                }
            }
            return JavaTypeManager.getInstance().getStringConverter();
        }
    }
}

