/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.automata;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.automata.ElementDefTransition;
import oracle.bali.xml.grammar.automata.State;
import oracle.bali.xml.grammar.automata.Transition;
import oracle.bali.xml.grammar.automata.WildcardTransition;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import org.w3c.dom.Element;

public class TransitionUtils {
    public static ElementDef getElementDefFromTransition(GrammarResolver resolver, Transition transition, QualifiedName qName, Element element) {
        Grammar g;
        if (transition instanceof ElementDefTransition) {
            return ((ElementDefTransition)transition).getElementDef(resolver, qName, element);
        }
        if (transition instanceof WildcardTransition && (g = resolver.getGrammarForNamespace(qName.getNamespace())) != null) {
            return g.getElementDefByName(qName.getName());
        }
        return null;
    }

    public static int getProcessingRuleFromTransition(GrammarResolver resolver, Transition transition, Set<String> laxNamespaceOverrides) {
        if (transition instanceof WildcardTransition) {
            Wildcard wildcard = ((WildcardTransition)transition).getWildcard();
            if (laxNamespaceOverrides.contains(wildcard.getTargetNamespace())) {
                return 1;
            }
            return wildcard.getProcessingRule();
        }
        return 0;
    }

    public static SearchResult searchForUnambigousMatchingTransition(GrammarResolver resolver, State startingFromState, QualifiedName qName, Element element, Set<String> laxNamespaceOverrides) {
        Transition matchingTransition = null;
        ElementDef matchingTransitionElementDef = null;
        int matchingTransitionProcessingRule = 0;
        HashSet<State> seenStates = new HashSet<State>();
        ArrayDeque<State> stateQueue = new ArrayDeque<State>();
        seenStates.add(startingFromState);
        stateQueue.add(startingFromState);
        while (!stateQueue.isEmpty()) {
            State current = (State)stateQueue.remove();
            for (Transition t : current.getTransitionsFromState()) {
                if (t.accepts(resolver, qName)) {
                    if (matchingTransition == null) {
                        matchingTransition = t;
                        matchingTransitionElementDef = TransitionUtils.getElementDefFromTransition(resolver, t, qName, element);
                        matchingTransitionProcessingRule = TransitionUtils.getProcessingRuleFromTransition(resolver, t, laxNamespaceOverrides);
                        continue;
                    }
                    if (matchingTransition.getToState() != t.getToState()) {
                        return new SearchResult(null, true);
                    }
                    ElementDef tElementDef = TransitionUtils.getElementDefFromTransition(resolver, t, qName, element);
                    int tProcessingRule = TransitionUtils.getProcessingRuleFromTransition(resolver, t, laxNamespaceOverrides);
                    if (matchingTransitionElementDef == tElementDef && matchingTransitionProcessingRule == tProcessingRule) continue;
                    return new SearchResult(null, true);
                }
                if (!seenStates.add(t.getToState())) continue;
                stateQueue.add(t.getToState());
            }
        }
        return new SearchResult(matchingTransition, false);
    }

    public static String summarizeTransitionsFromState(State automataState) {
        List<Transition> transitions;
        int numTransitions;
        String summary = null;
        if (automataState != null && (numTransitions = (transitions = automataState.getTransitionsFromState()).size()) > 0 && numTransitions <= 5) {
            StringBuffer buffer = new StringBuffer();
            boolean containsOnlyElementTransitions = true;
            if (numTransitions > 1) {
                buffer.append("(");
            }
            for (int i = 0; i < numTransitions; ++i) {
                QualifiedName qName;
                Transition t = transitions.get(i);
                if (t instanceof ElementDefTransition) {
                    ElementDefTransition et = (ElementDefTransition)t;
                    qName = et.getElementDef().getQualifiedName();
                    if (i > 0) {
                        buffer.append("|");
                    }
                } else {
                    containsOnlyElementTransitions = false;
                    break;
                }
                buffer.append(qName.getName());
            }
            if (containsOnlyElementTransitions) {
                if (numTransitions > 1) {
                    buffer.append(")");
                }
                summary = buffer.toString();
            }
        }
        return summary;
    }

    public static class SearchResult {
        private final Transition _transition;
        private final boolean _foundConflict;

        public Transition getTransition() {
            return this._transition;
        }

        public boolean foundConflict() {
            return this._foundConflict;
        }

        private SearchResult(Transition t, boolean foundConflict) {
            this._transition = t;
            this._foundConflict = foundConflict;
        }
    }
}

