/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.position;

import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DomPosition {
    public static final int POSITION_INSIDE_NODE = 0;
    public static final int POSITION_BEFORE_NODE = 1;
    public static final int POSITION_AFTER_NODE = 2;
    private static final String[] _POSITION_NAMES = new String[]{"Inside", "Before", "After"};
    private final Node _targetNode;
    private final int _relativePosition;
    private final QualifiedName _attrQName;
    private final int _textOffset;
    private static final int _NO_TEXT_OFFSET = -333;

    DomPosition(Node targetNode, int relativePosition) {
        this(targetNode, relativePosition, null, -333);
    }

    DomPosition(Element targetElement, QualifiedName attrQName, int textOffset) {
        this(targetElement, 0, attrQName, textOffset);
        if (attrQName == null) {
            throw new IllegalArgumentException("attribute name was null!");
        }
    }

    static DomPosition createTextPosition(CharacterData targetTextNode, int textOffset) {
        return new DomPosition(targetTextNode, 0, null, textOffset);
    }

    static DomPosition createInsideOrAfterPosition(Node targetNode) {
        if (targetNode == null) {
            throw new IllegalArgumentException("null target node");
        }
        if (targetNode.getNodeType() == 2) {
            Attr attr = (Attr)targetNode;
            String value = attr.getValue();
            if (value == null) {
                value = "";
            }
            return new DomPosition(attr.getOwnerElement(), DomUtils.getQualifiedName(attr), value.length());
        }
        int relPos = DomPosition.isContainerNode(targetNode) ? 0 : 2;
        return new DomPosition(targetNode, relPos);
    }

    static DomPosition createInsideOrBeforePosition(Node targetNode) {
        if (targetNode == null) {
            throw new IllegalArgumentException("null target node");
        }
        if (targetNode.getNodeType() == 2) {
            Attr attr = (Attr)targetNode;
            return new DomPosition(attr.getOwnerElement(), DomUtils.getQualifiedName(attr), 0);
        }
        int relPos = DomPosition.isContainerNode(targetNode) ? 0 : 1;
        return new DomPosition(targetNode, relPos);
    }

    static DomPosition before(Node node) {
        return new DomPosition(node, 1);
    }

    static DomPosition after(Node node) {
        return new DomPosition(node, 2);
    }

    static DomPosition inside(Node node) {
        return new DomPosition(node, 0);
    }

    public static boolean isContainerNode(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public final DomPosition createDomPosition(Node targetNode) {
        return this.getRetargetedPosition(targetNode, false);
    }

    public DomPosition createPositionWithNewOffset(int textOffset) {
        if (!this.hasTextOffset()) {
            throw new IllegalStateException("no text offset on " + this);
        }
        return new DomPosition(this.getTargetNode(), this.getRelativePosition(), this.getAttributeQName(), textOffset);
    }

    public Node getTargetNode() {
        return this._targetNode;
    }

    public Node getContainerNode() {
        return this.getContainerNode(null);
    }

    public Node getContainerNode(TreeTraversal traversal) {
        if (this._relativePosition == 0) {
            return this._targetNode;
        }
        if (traversal != null) {
            return traversal.getParentNode(this._targetNode);
        }
        return this._targetNode.getParentNode();
    }

    public DomPosition getAfterPosition() {
        if (this.isAfter()) {
            return this;
        }
        return new DomPosition(this.getTargetNode(), 2);
    }

    public DomPosition getBeforePosition() {
        if (this.isBefore()) {
            return this;
        }
        return new DomPosition(this.getTargetNode(), 1);
    }

    public DomPosition getInsidePosition() {
        if (this.isInside()) {
            return this;
        }
        return new DomPosition(this.getTargetNode(), 0);
    }

    public int getRelativePosition() {
        return this._relativePosition;
    }

    public boolean hasTextOffset() {
        return this._textOffset != -333;
    }

    public int getTextOffset() throws IllegalStateException {
        if (!this.hasTextOffset()) {
            throw new IllegalStateException("no text offset");
        }
        return this._textOffset;
    }

    public boolean hasAttributeQName() {
        return this._attrQName != null;
    }

    public QualifiedName getAttributeQName() throws IllegalStateException {
        if (!this.hasAttributeQName()) {
            return null;
        }
        return this._attrQName;
    }

    public DomPosition getRetargetedPosition(Node node, boolean biasForward) {
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        if (node == this.getTargetNode()) {
            return this;
        }
        int textOffset = -333;
        QualifiedName attrQName = null;
        int relPos = this.getRelativePosition();
        switch (node.getNodeType()) {
            case 3: 
            case 4: 
            case 8: {
                if (this.hasTextOffset()) {
                    String value = node.getNodeValue();
                    if (value == null) {
                        textOffset = 0;
                        break;
                    }
                    textOffset = Math.min(this.getTextOffset(), value.length());
                    break;
                }
                relPos = DomPosition._nonInsidePosition(relPos, biasForward);
                break;
            }
            case 10: {
                relPos = DomPosition._nonInsidePosition(relPos, biasForward);
                break;
            }
            case 1: {
                if (!this.hasTextOffset() || !this.hasAttributeQName()) break;
                attrQName = this.getAttributeQName();
                Attr newAttr = DomUtils.getAttribute((Element)node, attrQName);
                if (newAttr == null || newAttr.getValue() == null) {
                    textOffset = 0;
                    break;
                }
                textOffset = Math.min(this.getTextOffset(), newAttr.getValue().length());
                break;
            }
            case 9: {
                relPos = 0;
                break;
            }
            case 7: {
                relPos = DomPosition._nonInsidePosition(relPos, biasForward);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid target node: " + node);
            }
        }
        return new DomPosition(node, relPos, attrQName, textOffset);
    }

    private static int _nonInsidePosition(int origPosition, boolean biasForward) {
        if (origPosition == 0) {
            return biasForward ? 2 : 1;
        }
        return origPosition;
    }

    public final boolean isInside() {
        return this.getRelativePosition() == 0;
    }

    public final boolean isBefore() {
        return this.getRelativePosition() == 1;
    }

    public final boolean isAfter() {
        return this.getRelativePosition() == 2;
    }

    public int hashCode() {
        return this._computeHashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DomPosition) {
            DomPosition otherPosition = (DomPosition)o;
            return otherPosition._targetNode == this._targetNode && otherPosition._relativePosition == this._relativePosition && otherPosition._attrQName == this._attrQName && otherPosition._textOffset == this._textOffset;
        }
        return false;
    }

    public boolean isComparableTo(DomPosition other) {
        if (other == null) {
            return false;
        }
        if (DomUtils.getOwnerDocument(this.getTargetNode()) != DomUtils.getOwnerDocument(other.getTargetNode())) {
            return false;
        }
        int numWithAttr = 0;
        if (this.hasAttributeQName()) {
            ++numWithAttr;
        }
        if (other.hasAttributeQName()) {
            ++numWithAttr;
        }
        switch (numWithAttr) {
            case 1: {
                return false;
            }
            case 2: {
                return this.getAttributeQName() == other.getAttributeQName() && this.getTargetNode() == other.getTargetNode();
            }
        }
        return true;
    }

    public int compare(TreeTraversal traversal, DomPosition other) {
        DomPosition lateNodePos;
        DomPosition earlyNodePos;
        Node otherNode;
        if (this.equals(other)) {
            return 0;
        }
        if (!this.isComparableTo(other)) {
            throw new IllegalArgumentException(this + " is not comparable to " + other);
        }
        Node thisNode = this.getTargetNode();
        if (thisNode == (otherNode = other.getTargetNode())) {
            switch (this.getRelativePosition()) {
                case 1: {
                    return -1;
                }
                case 2: {
                    return 1;
                }
            }
            switch (other.getRelativePosition()) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return -1;
                }
            }
            assert (this.hasTextOffset() && other.hasTextOffset());
            int diff = this.getTextOffset() - other.getTextOffset();
            assert (diff != 0);
            return diff;
        }
        Node earlier = DomUtils.earlierPreorderNode(traversal, thisNode, otherNode);
        if (earlier == thisNode) {
            earlyNodePos = this;
            lateNodePos = other;
        } else {
            earlyNodePos = other;
            lateNodePos = this;
        }
        DomPosition realEarlyPosition = (earlyNodePos.isInside() || earlyNodePos.isAfter()) && DomUtils.isDescendant(traversal, lateNodePos.getTargetNode(), earlyNodePos.getTargetNode()) ? lateNodePos : earlyNodePos;
        if (realEarlyPosition == this) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        Node target = this.getTargetNode();
        StringBuffer buf = new StringBuffer("DomPosition(");
        buf.append("target=");
        buf.append(target.getNodeName());
        buf.append("@");
        buf.append(System.identityHashCode(target));
        buf.append(", pos=");
        buf.append(_POSITION_NAMES[this.getRelativePosition()]);
        if (this.hasAttributeQName()) {
            buf.append(", attr=");
            buf.append(this.getAttributeQName());
        }
        if (this.hasTextOffset()) {
            buf.append(", offset=");
            buf.append(this.getTextOffset());
        }
        buf.append(")");
        return buf.toString();
    }

    private int _computeHashCode() {
        int code = this.getTargetNode().hashCode();
        code += this.getRelativePosition();
        if (this.hasAttributeQName()) {
            code ^= this.getAttributeQName().hashCode();
        }
        if (this.hasTextOffset()) {
            code += this.getTextOffset() + 1;
        }
        return code;
    }

    private DomPosition(Node targetNode, int relativePosition, QualifiedName attrQName, int textOffset) {
        if (targetNode == null) {
            throw new IllegalArgumentException("null target node!");
        }
        switch (relativePosition) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid relative position: " + relativePosition);
            }
        }
        short nodeType = targetNode.getNodeType();
        if (attrQName != null && nodeType != 1) {
            throw new IllegalArgumentException("can't have an attribute name in a position that does not target an element! node=" + targetNode + " attrQName=" + attrQName);
        }
        if (nodeType == 2) {
            throw new IllegalArgumentException("can't have a DomPosition with the target node of Attr. You may want to use the new DomPosition(Element, QualifiedName, int) constructor instead.");
        }
        if (textOffset == -333) {
            switch (nodeType) {
                case 3: 
                case 4: 
                case 8: {
                    if (relativePosition != 0) break;
                    throw new IllegalArgumentException("can't be inside " + targetNode + " with no text offset!");
                }
                case 9: {
                    if (relativePosition == 0) break;
                    throw new IllegalArgumentException("can't create position before or after " + targetNode);
                }
            }
        } else {
            if (textOffset < 0) {
                throw new IllegalArgumentException("invalid text offset: " + textOffset);
            }
            if (relativePosition != 0) {
                throw new IllegalArgumentException("relative position must be inside when there is a text offset in the position. node=" + targetNode + " textOffset=" + textOffset + " relativePosition=" + _POSITION_NAMES[relativePosition]);
            }
            switch (nodeType) {
                case 3: 
                case 4: 
                case 8: {
                    break;
                }
                case 1: {
                    if (attrQName != null) break;
                    throw new IllegalArgumentException("Can't have text offset inside element node " + targetNode + " without an attribute qname!");
                }
                default: {
                    throw new IllegalArgumentException("node can not have text offset: " + targetNode);
                }
            }
        }
        this._targetNode = targetNode;
        this._relativePosition = relativePosition;
        this._attrQName = attrQName;
        this._textOffset = textOffset;
    }
}

