/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RangeSlider;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.SparkchartUtils;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;

public class JChart_2D_BLA
extends JChart_2D_Standard {
    private static final long serialVersionUID = 1L;
    public static final double DEPTH_FACTOR = 12.0;
    public static final boolean DRAW_NEG_SERIES = true;
    public static final boolean DRAW_POS_SERIES = false;
    boolean m_bFromZero;
    boolean m_bBipolar;
    boolean m_bDualY;
    boolean m_bBarAsPictograph;
    int m_nLineThick;
    boolean m_bTransparentMarkers = false;
    boolean m_bNonZeroBaseline = false;
    int m_baseLineYCoord = 0;
    protected Point m_o1AxisStart;
    protected Point m_o1AxisEnd;
    private static final int INVISIBLE_RECT_SIZE = 3;

    @Override
    public void calc() {
        this.m_bTransparentMarkers = this.m_Perspective.getTransparentMarkers();
        this.m_baseLineYCoord = 0;
        super.calc();
        if (this.m_Perspective.getRenderMode() == 1) {
            return;
        }
        this.calcFrontBackOffsets();
        if (this.m_gt.isRiserBar() && this.isComboWithBar() || this.m_Perspective.isContinuousTimeAxis()) {
            this.calcBarOrdinalCoords();
        } else {
            this.calcOrdinalCoords();
        }
        this.m_Perspective.calcReferenceObjects(1);
        this.m_Perspective.calcAnnotations(GraphConstants.AnnotationLocation.BACK);
        if (this.m_bBipolar && this.wantDepthEffect()) {
            this.calcBiPolarTwoHalfD();
        } else {
            if (this.m_bBipolar) {
                this.drawDualAxisLine();
            }
            this.drawAreaRisers();
            AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
            if (this.m_Y1Axis != null) {
                this.m_Y1Axis.calculateGrid();
            }
            if (axisDescriptor.hasY2() && this.m_Y2Axis != null) {
                this.m_Y2Axis.calculateGrid();
            }
            this.drawBarRisers();
            this.drawLineRisers();
        }
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
        }
        if (this.m_bAbsolute) {
            this.drawFitLines();
        }
    }

    private void calcBiPolarTwoHalfD() {
        boolean bY1first = this.m_bHorz && this.m_nDepthAngle > 90;
        this.drawDualAxisLine();
        this.drawAreaRisers(true, bY1first, !bY1first);
        this.drawAreaRisers(true, !bY1first, bY1first);
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calculateGrid();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.calculateGrid();
        }
        this.drawLineRisers();
        this.drawAxisBarRisers(bY1first, !bY1first);
        this.drawAxisBarRisers(!bY1first, bY1first);
    }

    private void drawDualAxisLine() {
        if (this.m_Perspective.getFrameDisplay() && this.m_Perspective.getDualAxisLineDisplay()) {
            double fSplit = (double)this.m_Perspective.getDualAxisSplitPosition() / 100.0;
            this.m_Frame.drawSeparator(this.m_bHorz, fSplit);
        }
    }

    @Override
    protected void calcDataAbsolute() {
        if (this.m_Perspective.isContinuousTimeAxis()) {
            super.calcDataAbsolute();
            return;
        }
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fValue = 0.0;
        int nSeriesPerPixel = this.calcRisersPerPixel();
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        int nDataFormat = this.m_Perspective.getDataTextFormat();
        String szFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                this.m_dataOK[s][g] = true;
                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                if (axisObj == null) continue;
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                fValue = dObj.m_fValue;
                if (!dObj.m_bOK) {
                    this.m_dataOK[s][g] = false;
                }
                if (fValue <= 0.0 && axisObj.isLogScale()) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                if (this.isIgnoredOffScale(axisObj, fValue)) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                this.m_numYCoords[s][g] = (int)axisObj.getValueCoord(fValue);
                if (!this.m_bDataTextDisplay) continue;
                if (bNumberFormatCallBackActive) {
                    int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
                    this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                    this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                    continue;
                }
                this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
            }
        }
        this.calcOverdrawEliminate(nSeriesPerPixel);
    }

    private void calcOverdrawEliminate(int nSeriesPerPixel) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        if (this.m_Perspective.getOverdrawSkip() && nSeriesPerPixel > 4) {
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                int nBunchEnd = this.m_nSeries / nSeriesPerPixel - 1;
                for (int iBunch = 1; iBunch < nBunchEnd; ++iBunch) {
                    int s;
                    int sRel;
                    int sRelStart = iBunch * nSeriesPerPixel;
                    int sRelBound = sRelStart + nSeriesPerPixel;
                    PfjAssert.pfjAssert(sRelBound <= this.m_nSeries);
                    int sForMin = -1;
                    int sForMax = -1;
                    int nMinCoord = Integer.MAX_VALUE;
                    int nMaxCoord = -2147483647;
                    for (sRel = sRelStart; sRel < sRelBound; ++sRel) {
                        s = sEnum.seriesAt(sRel);
                        PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                        if (!this.m_dataOK[s][g]) continue;
                        int nCoord = this.m_numYCoords[s][g];
                        if (nCoord < nMinCoord) {
                            nMinCoord = nCoord;
                            sForMin = s;
                        }
                        if (nCoord <= nMaxCoord) continue;
                        nMaxCoord = nCoord;
                        sForMax = s;
                    }
                    if (sForMin == -1) continue;
                    for (sRel = sRelStart; sRel < sRelBound; ++sRel) {
                        s = sEnum.seriesAt(sRel);
                        PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                        if (s == sForMin || s == sForMax) continue;
                        this.m_dataOK[s][g] = false;
                    }
                }
            }
        }
    }

    @Override
    protected void copyParams() {
        super.copyParams();
        this.m_bFromZero = this.m_Perspective.getScaleFromZero();
        this.m_bBipolar = this.m_gt.isBipolar();
        this.m_bDualY = this.m_gt.isDualY();
        this.m_bBarAsPictograph = this.m_nDepthRadius > 0 ? false : this.m_Perspective.getDisplayBarAsPictograph();
        this.m_nLineThick = this.m_Perspective.getDataLineThickness();
    }

    private void drawAreaRisers() {
        if (this.m_nGroups >= 2) {
            if (this.wantDepthEffect()) {
                if (this.m_bBipolar) {
                    this.drawAreaRisers(true, false, true);
                }
                this.drawAreaRisers(true, true, false);
            } else {
                if (this.m_bBipolar) {
                    this.drawAreaRisers(false, false, true);
                }
                this.drawAreaRisers(false, true, false);
            }
            if (this.isSparkchart() && SparkchartUtils.isDrawingMarkers(this.m_Perspective)) {
                this.drawMarkers();
            }
        }
    }

    private void drawAreaRisers(boolean area25D, boolean bDrawY1, boolean bDrawY2) {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        RelativeAxisObj yAxisObj = null;
        int g = 0;
        Point p = null;
        Point p0 = null;
        int nZeroCoord = 0;
        int baseCoord = 0;
        boolean bReverseSeries = false;
        boolean bReverseGroups = false;
        boolean bRightToLeft = this.getRightToLeftOrder();
        boolean bNegNZValue = false;
        boolean bNegData = false;
        double fBaseline = 0.0;
        Point finalp = null;
        Point startp = null;
        Vector allVectPoints = new Vector();
        boolean bDescending = bDrawY1 ? this.m_Y1Axis.isDescending() : this.m_Y2Axis.isDescending();
        bReverseSeries = area25D ? !this.m_bAbsolute && !this.m_bStacked && (this.m_bHorz ? bDescending != bRightToLeft : bDescending) : !this.m_bAbsolute;
        boolean bForwardSeries = !bReverseSeries;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        while (sEnum.hasMoreElements()) {
            Point last;
            PointInfo pInfoNext;
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            startp = null;
            Vector seriesVect = new Vector();
            int count = 0;
            if (this.m_seriesTypes[s] != 3) continue;
            yAxisObj = this.whichAxisForSeries(s, null);
            int maxCoord = (int)yAxisObj.getValueCoord(yAxisObj.getMaxValue());
            int minCoord = (int)yAxisObj.getValueCoord(yAxisObj.getMinValue());
            if (bDescending) {
                int temp = minCoord;
                minCoord = maxCoord;
                maxCoord = temp;
            }
            if (yAxisObj == null) continue;
            int axisID = yAxisObj.getAxisObjID();
            if (bDrawY1 ? axisID != 0 && this.m_bBipolar : bDrawY2 && axisID != 1 && this.m_bBipolar) continue;
            baseCoord = (int)yAxisObj.getBaseCoord();
            nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            if (baseCoord > maxCoord) {
                baseCoord = maxCoord;
            } else if (baseCoord < minCoord) {
                baseCoord = minCoord;
            }
            if (nZeroCoord > maxCoord) {
                nZeroCoord = maxCoord;
            } else if (nZeroCoord < minCoord) {
                nZeroCoord = minCoord;
            }
            IdentObj id = yAxisObj.getAxisIdentObj();
            this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(id);
            if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                fBaseline = this.m_Perspective.getNonZeroBaselineValue(id);
                if (yAxisObj.isLogScale() && fBaseline <= 0.0) {
                    this.m_bNonZeroBaseline = false;
                }
            }
            if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                boolean bl = bNegNZValue = fBaseline < 0.0;
                this.m_baseLineYCoord = bNegNZValue ? (fBaseline >= yAxisObj.getMinValue() ? (int)yAxisObj.getValueCoord(fBaseline) : (int)yAxisObj.getValueCoord(yAxisObj.getBaseMin())) : (fBaseline <= yAxisObj.getMaxValue() ? (int)yAxisObj.getValueCoord(fBaseline) : (int)yAxisObj.getValueCoord(yAxisObj.getBaseMax()));
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                bNegData = dObj.m_fValue < 0.0;
            }
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                PointInfo pInfo;
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!gEnum.hasMoreElements()) continue;
                int gNext = gEnum.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis()) {
                    if (this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                        while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                            gNext = gEnum.nextGroup();
                            if (!gEnum.hasMoreElements()) continue;
                            gNext = gEnum.peekAtNextGroup();
                        }
                    }
                }
                PfjAssert.pfjAssert(gNext >= 0 && gNext < this.m_nTotalGroups);
                if (this.m_dataOK[s][g] && this.m_dataOK[s][gNext]) {
                    double newy;
                    pInfo = this.getPointInfo(seriesVect, s, g);
                    pInfoNext = this.getPointInfo(seriesVect, s, gNext);
                    BlackBoxIF blackBox = this.assignSeriesColor(s, g, false);
                    blackBox = blackBox.runRules(s, g);
                    p0 = this.getCoords(s, g);
                    p = this.getCoords(s, gNext);
                    finalp = new Point(p);
                    startp = new Point(p0);
                    if (this.m_numYCoords[s][g] > maxCoord && this.m_numYCoords[s][gNext] > maxCoord) {
                        if (this.m_bHorz) {
                            p0.x = p.x = maxCoord;
                        } else {
                            p0.y = p.y = maxCoord;
                        }
                    } else if (this.m_numYCoords[s][g] > maxCoord) {
                        if (this.m_bHorz) {
                            newy = this.calcyPosition(p0, p, maxCoord);
                            p0.x = maxCoord;
                            p0.y = (int)newy;
                        } else {
                            double newx = this.calcxPosition(p0, p, maxCoord);
                            p0.y = maxCoord;
                            p0.x = (int)newx;
                        }
                    } else if (this.m_numYCoords[s][gNext] > maxCoord) {
                        if (this.m_bHorz) {
                            double newy2 = this.calcyPosition(p0, p, maxCoord);
                            p.x = maxCoord;
                            p.y = (int)newy2;
                        } else {
                            double newx = this.calcxPosition(p0, p, maxCoord);
                            p.y = maxCoord;
                            p.x = (int)newx;
                        }
                    }
                    if (this.m_numYCoords[s][g] < minCoord && this.m_numYCoords[s][gNext] < minCoord) {
                        if (this.m_bHorz) {
                            p0.x = p.x = minCoord;
                        } else {
                            p0.y = p.y = minCoord;
                        }
                    } else if (this.m_numYCoords[s][g] < minCoord) {
                        if (this.m_bHorz) {
                            newy = this.calcyPosition(p0, p, minCoord);
                            p0.x = minCoord;
                            p0.y = (int)newy;
                        } else {
                            newx = this.calcxPosition(p0, p, minCoord);
                            p0.y = minCoord;
                            p0.x = (int)newx;
                        }
                    } else if (this.m_numYCoords[s][gNext] < minCoord) {
                        if (this.m_bHorz) {
                            newy = this.calcyPosition(p0, p, minCoord);
                            p.x = minCoord;
                            p.y = (int)newy;
                        } else {
                            newx = this.calcxPosition(p0, p, minCoord);
                            p.y = minCoord;
                            p.x = (int)newx;
                        }
                    }
                    int x0 = p0.x;
                    int y0 = p0.y;
                    if (count == 0 && !this.m_bHorz) {
                        Point st;
                        pInfo.lt = st = this.checkStartPointVertical(startp, s, g, p0);
                    } else if (count == 0 && this.m_bHorz) {
                        Point st;
                        pInfo.lt = st = this.checkStartPointHorizontal(startp, s, g, p0);
                    }
                    pInfo.rt = p0;
                    pInfoNext.lt = p;
                    ++count;
                    finalp.y = p.y;
                    continue;
                }
                if (count != 0) {
                    if (this.m_bHorz) {
                        last = this.checkEndPointHorizontal(finalp, s, g, p);
                        pInfoNext = this.getPointInfo(seriesVect, s, g);
                        pInfoNext.rt = last;
                    } else {
                        last = this.checkEndPointVertical(finalp, s, g, p);
                        pInfoNext = this.getPointInfo(seriesVect, s, g);
                        pInfoNext.rt = last;
                    }
                    count = 0;
                }
                if (!this.m_dataOK[s][g] || g == 0 && !this.m_dataOK[s][gNext]) {
                    pInfo = this.getPointInfo(seriesVect, s, g);
                    pInfo.setStatus(0);
                    pInfo.rt = pInfo.lt = this.getCoords(s, g);
                }
                if (gNext != this.m_nTotalGroups - 1) continue;
                pInfo = this.getPointInfo(seriesVect, s, gNext);
                pInfo.setStatus(0);
                pInfo.rt = pInfo.lt = this.getCoords(s, gNext);
            }
            if (count != 0) {
                if (this.m_bHorz) {
                    last = this.checkEndPointHorizontal(finalp, s, g, p);
                    pInfoNext = this.getPointInfo(seriesVect, s, g);
                    pInfoNext.rt = last;
                } else {
                    last = this.checkEndPointVertical(finalp, s, g, p);
                    pInfoNext = this.getPointInfo(seriesVect, s, g);
                    pInfoNext.rt = last;
                }
            }
            allVectPoints.add(seriesVect);
        }
        if (area25D) {
            this.drawAreaRiserFromVector25D(allVectPoints, yAxisObj, nZeroCoord, baseCoord, bForwardSeries);
        } else {
            this.drawAreaRiserFromVector(allVectPoints, yAxisObj, nZeroCoord, baseCoord);
        }
        if (!area25D && this.m_bTransparentMarkers) {
            this.drawTransparentMarkers(3);
        }
    }

    private void drawAxisBarRisers(boolean bDrawY1, boolean bDrawY2) {
        if (this.m_bAbsolute) {
            this.drawAxisBarRisersAbsolute(bDrawY1, bDrawY2);
        } else if (this.m_bDualY && !this.m_bBipolar) {
            this.drawAxisBarRisersStackedDualY(bDrawY1, bDrawY2);
        } else {
            this.drawAxisBarRisersStacked(bDrawY1, bDrawY2);
        }
    }

    private void drawAxisBarRisersAbsolute(boolean bDrawY1, boolean bDrawY2) {
        boolean bReverseSeries;
        boolean bReverseGroups;
        boolean bRightToLeft = this.getRightToLeftOrder();
        if (this.m_bHorz) {
            if (this.m_Perspective.getDepthRadius() > 0 && this.m_Perspective.getDepthAngle() > 0) {
                bReverseGroups = true;
                bReverseSeries = true;
            } else {
                bReverseGroups = false;
                bReverseSeries = false;
            }
        } else {
            bReverseGroups = bRightToLeft;
            bReverseSeries = bRightToLeft;
        }
        boolean bForwardSeries = !bReverseSeries;
        boolean bForwardGroups = !bReverseGroups;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        int sFirst = sEnum.getFirstSeries();
        int sLast = sEnum.getLastSeries();
        int gFirst = gEnum.getFirstGroup();
        while (gEnum.hasMoreElements()) {
            int axisID;
            RelativeAxisObj yAxisObj;
            int s;
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (bDrawY1) {
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                    if (this.m_seriesTypes[s] != 1 || (yAxisObj = this.whichAxisForSeries(s, null)) == null || (axisID = yAxisObj.getAxisObjID()) != 0 && this.m_bBipolar) continue;
                    this.drawOneBarRiser(s, g, sEnum, gEnum);
                }
            }
            if (!bDrawY2 || !this.m_bBipolar) continue;
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                yAxisObj = this.whichAxisForSeries(s, null);
                if (yAxisObj == null || (axisID = yAxisObj.getAxisObjID()) != 1 && this.m_bBipolar) continue;
                this.drawOneBarRiser(s, g, sEnum, gEnum);
            }
        }
    }

    private void drawAxisBarRisersStacked(boolean bDrawY1, boolean bDrawY2) {
        boolean bRightToLeft = this.getRightToLeftOrder();
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = !bReverseGroups;
        boolean bDescending = bDrawY1 ? this.m_Y1Axis.isDescending() : this.m_Y2Axis.isDescending();
        boolean bReverseSeries = bDescending;
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (bReverseSeries) {
                this.drawBarGroup(g, bDrawY1, bDrawY2, true, false, gEnum);
                this.drawBarGroup(g, bDrawY1, bDrawY2, false, true, gEnum);
                continue;
            }
            this.drawBarGroup(g, bDrawY1, bDrawY2, true, true, gEnum);
            this.drawBarGroup(g, bDrawY1, bDrawY2, false, false, gEnum);
        }
    }

    private void drawAxisBarRisersStackedDualY(boolean bDrawY1, boolean bDrawY2) {
        boolean bY1ReverseSeries;
        boolean bRightToLeft = this.getRightToLeftOrder();
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = !bReverseGroups;
        boolean bReverseSeries = false;
        boolean bY2first = this.m_bHorz || bRightToLeft;
        boolean bY1Descending = this.m_Y1Axis.isDescending();
        boolean bY2Descending = this.m_Y2Axis.isDescending();
        boolean bl = this.m_bHorz ? bY1Descending != bRightToLeft : (bY1ReverseSeries = bY1Descending);
        boolean bY2ReverseSeries = this.m_bHorz ? bY2Descending != bRightToLeft : bY2Descending;
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (bY2first) {
                if (bY2ReverseSeries) {
                    this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, false, gEnum);
                    this.drawBarGroup(g, false, bDrawY2, bReverseSeries, true, gEnum);
                } else {
                    this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, true, gEnum);
                    this.drawBarGroup(g, false, bDrawY2, bReverseSeries, false, gEnum);
                }
                if (bY1ReverseSeries) {
                    this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, false, gEnum);
                    this.drawBarGroup(g, bDrawY1, false, bReverseSeries, true, gEnum);
                    continue;
                }
                this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, true, gEnum);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, false, gEnum);
                continue;
            }
            if (bY1ReverseSeries) {
                this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, false, gEnum);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, true, gEnum);
            } else {
                this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, true, gEnum);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, false, gEnum);
            }
            if (bY2ReverseSeries) {
                this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, false, gEnum);
                this.drawBarGroup(g, false, bDrawY2, bReverseSeries, true, gEnum);
                continue;
            }
            this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, true, gEnum);
            this.drawBarGroup(g, false, bDrawY2, bReverseSeries, false, gEnum);
        }
    }

    private void drawBarAsPictograph(Axis2DObj yAxisObj, Rectangle rVirt, IdentObj id, BlackBoxIF blackBox) {
        Rectangle rPicto = new Rectangle(rVirt);
        int nGridlines = yAxisObj.getNumMajorGrids();
        int top = rVirt.y + rVirt.height;
        int bottom = rVirt.y;
        int left = rVirt.x;
        int right = rVirt.x + rVirt.width;
        double fPrevGridPosVC = yAxisObj.getBaseCoord();
        for (int iGrid = 0; iGrid <= nGridlines; ++iGrid) {
            Rectangle rClip;
            double fGridPosRel = yAxisObj.getMajorGridPos(iGrid);
            double fGridPosVC = yAxisObj.scaleToVC(fGridPosRel);
            double gap = fGridPosVC - fPrevGridPosVC;
            if (this.m_bHorz) {
                if (yAxisObj.isAscending()) {
                    if (fPrevGridPosVC > (double)left) {
                        left = (int)fPrevGridPosVC;
                    }
                    if (fGridPosVC >= (double)(rVirt.x + rVirt.width)) {
                        right = rVirt.x + rVirt.width;
                        rPicto.x = left;
                        rPicto.width = (int)gap;
                        rClip = new Rectangle(this.m_rClip);
                        if (right < rClip.x + rClip.width) {
                            rClip.width = right - rClip.x;
                        }
                        new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                        continue;
                    }
                    if (!(fGridPosVC > (double)left + gap / 10.0)) continue;
                    right = (int)fGridPosVC;
                    rPicto.x = left;
                    rPicto.width = right - left;
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                    fPrevGridPosVC = fGridPosVC;
                    continue;
                }
                if (fPrevGridPosVC < (double)right) {
                    right = (int)fPrevGridPosVC;
                }
                if (fGridPosVC < (double)rVirt.x) {
                    rPicto.x = left = rVirt.x;
                    rPicto.width = right - left;
                    rClip = new Rectangle(this.m_rClip);
                    if (left > rClip.x) {
                        rClip.x = left;
                    }
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    continue;
                }
                if (!(fGridPosVC < (double)right - gap / 10.0)) continue;
                rPicto.x = left = (int)fGridPosVC;
                rPicto.width = right - left;
                new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                fPrevGridPosVC = fGridPosVC;
                continue;
            }
            if (yAxisObj.isAscending()) {
                if (fPrevGridPosVC > (double)bottom) {
                    bottom = (int)fPrevGridPosVC;
                }
                if (fGridPosVC >= (double)(rVirt.y + rVirt.height)) {
                    top = rVirt.y + rVirt.height;
                    rPicto.y = bottom;
                    rPicto.height = (int)gap;
                    rClip = new Rectangle(this.m_rClip);
                    if (top < rClip.y + rClip.height) {
                        rClip.height = top - rClip.y;
                    }
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    break;
                }
                if (!(fGridPosVC > (double)bottom + gap / 10.0)) continue;
                top = (int)fGridPosVC;
                rPicto.y = bottom;
                rPicto.height = top - bottom;
                new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                fPrevGridPosVC = fGridPosVC;
                continue;
            }
            if (fPrevGridPosVC < (double)top) {
                top = (int)fPrevGridPosVC;
            }
            if (fGridPosVC <= (double)rVirt.y) {
                rPicto.y = bottom = rVirt.y;
                rPicto.height = top - bottom;
                rClip = new Rectangle(this.m_rClip);
                if (bottom > rClip.y) {
                    rClip.y = bottom;
                }
                new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                break;
            }
            if (!(fGridPosVC < (double)top - gap / 10.0)) continue;
            rPicto.y = bottom = (int)fGridPosVC;
            rPicto.height = top - bottom;
            new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
            fPrevGridPosVC = fGridPosVC;
        }
    }

    private void drawBarGroup(int g, boolean bDrawY1, boolean bDrawY2, boolean bReverseSeries, boolean bNegative, GroupsEnumerator gEnum) {
        boolean bForwardSeries = !bReverseSeries;
        int gFirst = gEnum.getFirstGroup();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        int sFirst = sEnum.getFirstSeries();
        int sLast = sEnum.getLastSeries();
        ArrayList<Integer> seriesList = new ArrayList<Integer>();
        if (this.m_Perspective.getDepthRadius() > 0 && this.m_Perspective.getDepthAngle() > 0) {
            while (sEnum.hasMoreElements()) {
                series = sEnum.nextSeries();
                seriesList.add(series);
            }
        } else {
            while (sEnum.hasMoreElements()) {
                series = sEnum.nextSeries();
                boolean isAdded = false;
                for (int j = 0; j < seriesList.size(); ++j) {
                    if (this.m_numYCoords[series][g] <= this.m_numYCoords[(Integer)seriesList.get(j)][g]) continue;
                    seriesList.add(j, series);
                    isAdded = true;
                    break;
                }
                if (isAdded) continue;
                seriesList.add(series);
            }
            if (this.m_bHorz) {
                Collections.reverse(seriesList);
            }
        }
        for (int i = 0; i < seriesList.size(); ++i) {
            boolean bNegValue;
            RelativeAxisObj yAxisObj;
            int s = (Integer)seriesList.get(i);
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 1 || this.m_gt.isWaterfall() && s == 0 || (yAxisObj = this.whichAxisForSeries(s, null)) == null) continue;
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            boolean bl = bDescending ? this.m_numYCoords[s][g] > nZeroCoord : (bNegValue = this.m_numYCoords[s][g] < nZeroCoord);
            if (!bNegValue && this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue < 0.0) {
                bNegValue = true;
            }
            if (bNegValue != bNegative) continue;
            int axisID = yAxisObj.getAxisObjID();
            if (!bDrawY1 && axisID == 0 || !bDrawY2 && axisID == 1) continue;
            this.drawOneBarRiser(s, g, sEnum, gEnum);
        }
    }

    private void drawBarRisers() {
        if (this.m_bBipolar) {
            this.drawAxisBarRisers(false, true);
            this.drawAxisBarRisers(true, false);
        } else if (this.m_bDualY) {
            this.drawAxisBarRisers(true, true);
        } else {
            this.drawAxisBarRisers(true, false);
        }
    }

    private void drawLineRisers() {
        if (this.m_Perspective.getConnectLineMarkers()) {
            this.drawLines(false);
        }
        if (this.wantDepthEffect()) {
            if (this.m_Perspective.getConnectLineMarkers()) {
                return;
            }
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator(true);
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                this.drawMarkersWithDepth(s, false);
            }
        } else if (!this.m_bMarkerDisplay && this.m_bTransparentMarkers) {
            this.drawTransparentMarkers(2);
        } else {
            this.drawMarkers();
        }
    }

    private void drawOneBarRiser(int s, int g, SeriesEnumerator sEnum, GroupsEnumerator gEnum) {
        boolean isPattern;
        int left = 0;
        int nValueCoord = this.m_numYCoords[s][g];
        double fBaseline = 0.0;
        boolean bNegNZValue = false;
        boolean bNegData = false;
        boolean bl = isPattern = this.m_Perspective.getIntegerProp(Attr.SeriesEffect) == 3;
        if (this.m_dataOK[s][g] && this.m_seriesTypes[s] == 1) {
            Axis2DObj yAxisObj;
            int sFirst = sEnum.getFirstSeries();
            int sLast = sEnum.getLastSeries();
            int gFirst = gEnum.getFirstGroup();
            int gLast = gEnum.getLastGroup();
            if (this.m_gt.isWaterfall()) {
                int nTemp;
                if (sLast < sFirst) {
                    nTemp = sLast;
                    sLast = sFirst;
                    sFirst = nTemp;
                }
                if (gLast < gFirst) {
                    nTemp = gLast;
                    gLast = gFirst;
                    gFirst = nTemp;
                }
            }
            if ((yAxisObj = (Axis2DObj)this.whichAxisForSeries(s, null)) != null) {
                int top;
                int bottom;
                int right;
                int nHigh;
                int nLow;
                int nBaseCoord;
                int sPrev;
                boolean bNegValue;
                DatumObj dObj;
                int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
                boolean bDescending = yAxisObj.isDescending();
                boolean bDrawingPictograph = this.m_bBarAsPictograph && yAxisObj.getNumMajorGrids() > 1;
                BlackBoxIF blackBox = this.assignSeriesColor(s, g);
                blackBox = this.checkForMarkerColorOverride(g, blackBox);
                blackBox = blackBox.runRules(s, g);
                BlackBoxIF blackBoxNew = this.getMissingDataBlackBox(s, g);
                if (blackBoxNew == null) {
                    blackBoxNew = blackBox;
                }
                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                IdentObj id = axisObj.getAxisIdentObj();
                this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(id);
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    fBaseline = this.m_Perspective.getNonZeroBaselineValue(id);
                    if (yAxisObj.isLogScale() && fBaseline <= 0.0) {
                        this.m_bNonZeroBaseline = false;
                    }
                }
                if (this.m_gt.isWaterfall()) {
                    dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                    bNegValue = dObj.m_bOK && dObj.m_fValue < 0.0;
                    sPrev = this.prevSeriesForAxis(s, yAxisObj);
                } else {
                    boolean useNegValue = bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
                    if (!bNegValue && this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue < fBaseline) {
                        useNegValue = true;
                    }
                    sPrev = this.prevSeriesForAxis(s, g, yAxisObj, useNegValue);
                }
                boolean bFromZero = this.wantRisersFromZero(yAxisObj);
                if (this.m_bAbsolute || sPrev == -2) {
                    nBaseCoord = bFromZero ? nZeroCoord : (int)yAxisObj.getBaseCoord();
                } else {
                    int sIndex = sPrev;
                    if (this.m_gt.isWaterfall()) {
                        double currVal = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                        DatumObj dObj2 = this.getDataValue(sIndex, g, DataItem.DI_GENERAL);
                        while ((currVal < 0.0 && dObj2.m_fValue >= 0.0 || currVal >= 0.0 && dObj2.m_fValue < 0.0) && sIndex >= 1) {
                            dObj2 = this.getDataValue(--sIndex, g, DataItem.DI_GENERAL);
                        }
                    }
                    nBaseCoord = this.m_numYCoords[sIndex][g];
                }
                if (bFromZero) {
                    nLow = bDescending != bNegValue ? nValueCoord : nBaseCoord;
                    nHigh = bDescending != bNegValue ? nBaseCoord : nValueCoord;
                } else {
                    nLow = bDescending ? nValueCoord : nBaseCoord;
                    int n = nHigh = bDescending ? nBaseCoord : nValueCoord;
                }
                if (bDescending && this.m_bNonZeroBaseline) {
                    int temp = nLow;
                    nLow = nHigh;
                    nHigh = temp;
                }
                if (this.m_bHorz) {
                    left = nLow;
                    right = nHigh;
                    bottom = !this.m_gt.isRiserBar() ? this.m_ordCoords[s][g] - this.m_barThickCoord / 2 : this.m_ordCoords[s][g];
                    top = bottom + this.m_barThickCoord;
                } else {
                    bottom = nLow;
                    top = nHigh;
                    left = !this.m_gt.isRiserBar() ? this.m_ordCoords[s][g] - this.m_barThickCoord / 2 : this.m_ordCoords[s][g];
                    right = left + this.m_barThickCoord;
                }
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    boolean bl2 = bNegNZValue = fBaseline < 0.0;
                    this.m_baseLineYCoord = bNegNZValue ? (fBaseline >= axisObj.getMinValue() ? (int)axisObj.getValueCoord(fBaseline) : (int)axisObj.getValueCoord(axisObj.getBaseMin())) : (fBaseline <= axisObj.getMaxValue() ? (int)axisObj.getValueCoord(fBaseline) : (int)axisObj.getValueCoord(axisObj.getBaseMax()));
                    dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                    boolean bl3 = bNegData = dObj.m_fValue < 0.0;
                }
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    if (this.m_bHorz) {
                        if (!bNegNZValue) {
                            if (bNegData) {
                                if (nHigh <= this.m_baseLineYCoord) {
                                    right = this.m_baseLineYCoord;
                                } else if (nHigh > this.m_baseLineYCoord) {
                                    right = left;
                                    left = this.m_baseLineYCoord;
                                }
                            } else if (nHigh >= this.m_baseLineYCoord) {
                                left = this.m_baseLineYCoord;
                            } else if (nHigh < this.m_baseLineYCoord) {
                                left = right;
                                right = this.m_baseLineYCoord;
                            }
                        } else if (bNegData) {
                            if (nLow <= this.m_baseLineYCoord) {
                                right = this.m_baseLineYCoord;
                            } else if (nLow > this.m_baseLineYCoord) {
                                right = left;
                                left = this.m_baseLineYCoord;
                            }
                        } else if (nHigh >= this.m_baseLineYCoord) {
                            left = this.m_baseLineYCoord;
                        } else if (nHigh < this.m_baseLineYCoord) {
                            left = right;
                            right = this.m_baseLineYCoord;
                        }
                    } else if (!bNegNZValue) {
                        if (bNegData) {
                            if (nHigh <= this.m_baseLineYCoord) {
                                top = this.m_baseLineYCoord;
                            } else if (nHigh > this.m_baseLineYCoord) {
                                bottom = this.m_baseLineYCoord;
                            }
                        } else if (nHigh >= this.m_baseLineYCoord) {
                            bottom = this.m_baseLineYCoord;
                        } else if (nHigh < this.m_baseLineYCoord) {
                            bottom = top;
                            top = this.m_baseLineYCoord;
                        }
                    } else if (bNegData) {
                        if (nLow >= this.m_baseLineYCoord) {
                            top = bottom;
                            bottom = this.m_baseLineYCoord;
                        } else if (nLow < this.m_baseLineYCoord) {
                            top = this.m_baseLineYCoord;
                        }
                    } else if (nHigh >= this.m_baseLineYCoord) {
                        bottom = this.m_baseLineYCoord;
                    } else if (nHigh < this.m_baseLineYCoord) {
                        bottom = top;
                        top = this.m_baseLineYCoord;
                    }
                }
                Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
                int maxCoord = (int)yAxisObj.getValueCoord(yAxisObj.getMaxValue());
                int minCoord = (int)yAxisObj.getValueCoord(yAxisObj.getMinValue());
                if (bDescending) {
                    int temp = minCoord;
                    minCoord = maxCoord;
                    maxCoord = temp;
                }
                if (!this.m_bHorz) {
                    if (rVirt.y >= maxCoord && rVirt.height != 0 && rVirt.y + rVirt.height >= maxCoord || rVirt.y > maxCoord && rVirt.height == 0 || rVirt.y <= minCoord && rVirt.height != 0 && rVirt.y + rVirt.height <= minCoord || rVirt.y < minCoord && rVirt.height == 0) {
                        return;
                    }
                    if (rVirt.y < minCoord) {
                        rVirt.height -= minCoord - rVirt.y;
                        rVirt.y = minCoord;
                    }
                    if (rVirt.y + rVirt.height > maxCoord) {
                        rVirt.height = maxCoord - rVirt.y;
                    }
                } else {
                    if (rVirt.x >= maxCoord && rVirt.width != 0 && rVirt.x + rVirt.width >= maxCoord || rVirt.x > maxCoord && rVirt.width == 0 || rVirt.x <= minCoord && rVirt.width != 0 && rVirt.x + rVirt.width <= minCoord || rVirt.x < minCoord && rVirt.width == 0) {
                        return;
                    }
                    if (rVirt.x < minCoord) {
                        rVirt.width -= minCoord - rVirt.x;
                        rVirt.x = minCoord;
                    }
                    if (rVirt.x + rVirt.width > maxCoord) {
                        rVirt.width = maxCoord - rVirt.x;
                    }
                }
                if (this.wantDepthEffect() && this.m_Frame != null) {
                    if (rVirt.width < 0 || rVirt.height < 0) {
                        return;
                    }
                    VC vc = this.m_Perspective.getVC();
                    if (!this.m_bHorz && (rVirt.height == 0 || vc.virtToDestHeight(rVirt.height) == 0) || this.m_bHorz && (rVirt.width == 0 || vc.virtToDestWidth(rVirt.width) == 0)) {
                        double min = axisObj.getMinValue();
                        double max = axisObj.getMaxValue();
                        double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                        if (fValue < min || fValue > max) {
                            return;
                        }
                    }
                    if (this.m_autoGradient && !this.m_smallMarker && !isPattern && this.m_Perspective.m_VC.virtToDestHeight(rVirt.height) <= 3 && !this.m_Perspective.isExportingToXML()) {
                        BlackBoxIF bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                        bb = bb.runRules(s, g);
                        this.drawTwoHalfDBarRiser(s, g, rVirt, bb);
                    } else {
                        this.drawTwoHalfDBarRiser(s, g, rVirt, blackBoxNew);
                    }
                } else {
                    IdentObj idFront = new IdentObj(277, s, g);
                    if (bDrawingPictograph) {
                        this.drawBarAsPictograph(yAxisObj, rVirt, idFront, blackBoxNew);
                    } else {
                        int drawType = 0;
                        RangeSlider horzRS = this.m_Perspective.getHorzRangeSlider();
                        VC vc = horzRS != null ? horzRS.getVC() : this.m_Perspective.getVC();
                        boolean isInvisible = false;
                        if (!this.m_bHorz && (rVirt.height == 0 || vc.virtToDestHeight((double)rVirt.height) < 1.0)) {
                            double base = 0.0;
                            if (this.m_bAbsolute && this.m_bNonZeroBaseline) {
                                base = fBaseline;
                            }
                            double min = axisObj.getMinValue();
                            double max = axisObj.getMaxValue();
                            double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                            if (fValue >= min && fValue <= max) {
                                if (fValue < 0.0) {
                                    rVirt.y -= vc.destToVirtHeight(3);
                                    rVirt.height = vc.destToVirtHeight(3);
                                    drawType = 1;
                                } else {
                                    rVirt.height = vc.destToVirtHeight(3);
                                    drawType = 2;
                                }
                                isInvisible = true;
                            }
                        } else if (this.m_bHorz && (rVirt.width == 0 || vc.virtToDestWidth((double)rVirt.width) < 1.0)) {
                            double min = axisObj.getMinValue();
                            double max = axisObj.getMaxValue();
                            double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                            if (fValue >= min && fValue <= max) {
                                if (fValue < 0.0) {
                                    rVirt.x -= vc.destToVirtWidth(3);
                                    rVirt.width = vc.destToVirtWidth(3);
                                    drawType = 4;
                                } else {
                                    rVirt.width = vc.destToVirtWidth(3);
                                    drawType = 3;
                                }
                                isInvisible = true;
                            }
                        }
                        int barShape = this.m_Perspective.getBarShape();
                        boolean bHoriz = this.m_Perspective.getJGraphType().isOrientHorz();
                        if (this.m_autoGradient && !isPattern && (!this.m_Perspective.isExportingToXML() || barShape != 0) && (!bHoriz && vc.virtToDestHeight(rVirt.height) <= 3 || bHoriz && vc.virtToDestWidth(rVirt.width) <= 3)) {
                            BlackBoxIF bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                            bb = bb.runRules(s, g);
                            bb = this.checkForMarkerColorOverride(g, bb);
                            if (isInvisible) {
                                bb.setTransparentFillColor(true);
                                bb.setTransparentBorderColor(true);
                            } else if (!bHoriz) {
                                if (vc.virtToDestWidth(rVirt.width) <= 1) {
                                    rVirt.width = 0;
                                    bb.setBorderColor(bb.getFillColor());
                                    bb.setTransparentBorderColor(false);
                                }
                            } else if (vc.virtToDestHeight(rVirt.height) <= 1) {
                                rVirt.height = 0;
                                bb.setBorderColor(bb.getFillColor());
                                bb.setTransparentBorderColor(false);
                            }
                            if (barShape == 0) {
                                new DetRect(this.m_Detectiv, idFront, rVirt, bb, this.m_rClip);
                            } else if (barShape == 2 || barShape == 3) {
                                IdentObj idFront2 = new IdentObj(312, s, g);
                                Polygon leftRect = null;
                                Polygon rightRect = null;
                                if (!bHoriz) {
                                    leftRect = new Polygon();
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y + rVirt.height);
                                    leftRect.addPoint(rVirt.x, rVirt.y + rVirt.height);
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    rightRect = new Polygon();
                                    rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                } else {
                                    leftRect = new Polygon();
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height / 2);
                                    leftRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    rightRect = new Polygon();
                                    rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height / 2);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                }
                                fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                                new DetPolygon(this.m_Detectiv, idFront, leftRect, bb, fIntensity);
                                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                                new DetPolygon(this.m_Detectiv, idFront2, rightRect, bb, fIntensity);
                            } else if (barShape == 1) {
                                BlackBoxIF bbox = new BlackBoxObj(this.m_Perspective, new IdentObj(-3, s, g));
                                bbox = bbox.runRules(s, g);
                                this.applyCylinderBarsGradientEffect(bbox);
                                new DetRect(this.m_Detectiv, idFront, rVirt, bbox, this.m_rClip, drawType);
                            }
                        } else if (barShape == 0) {
                            BlackBoxIF bb;
                            if (isInvisible) {
                                if (blackBoxNew instanceof BlackBoxObj) {
                                    bb = new BlackBoxObj((BlackBoxObj)blackBoxNew);
                                } else if (blackBoxNew instanceof SimpleBlackBoxObj) {
                                    bb = new SimpleBlackBoxObj(this.m_Perspective);
                                    ((SimpleBlackBoxObj)bb).copy((SimpleBlackBoxObj)blackBoxNew);
                                } else {
                                    bb = blackBoxNew;
                                }
                                if (this.m_Perspective.isExportingToXML()) {
                                    bb.setHidden(true);
                                } else {
                                    bb.setTransparentFillColor(true);
                                    bb.setTransparentBorderColor(true);
                                }
                                drawType = 0;
                            } else {
                                bb = blackBoxNew;
                            }
                            if (!bHoriz) {
                                if (vc.virtToDestWidth(rVirt.width) < 1) {
                                    rVirt.width = vc.destToVirtWidth(1);
                                }
                            } else if (vc.virtToDestHeight(rVirt.height) < 1) {
                                rVirt.height = vc.destToVirtHeight(1);
                            }
                            new DetRect(this.m_Detectiv, idFront, rVirt, bb, this.m_rClip, drawType);
                        } else if (barShape == 2 || barShape == 3) {
                            IdentObj idFront2 = new IdentObj(312, s, g);
                            Polygon leftRect = null;
                            Polygon rightRect = null;
                            if (!bHoriz) {
                                leftRect = new Polygon();
                                leftRect.addPoint(rVirt.x, rVirt.y);
                                leftRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                leftRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y + rVirt.height);
                                leftRect.addPoint(rVirt.x, rVirt.y + rVirt.height);
                                leftRect.addPoint(rVirt.x, rVirt.y);
                                rightRect = new Polygon();
                                rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y);
                                rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                                rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y + rVirt.height);
                                rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                            } else {
                                leftRect = new Polygon();
                                leftRect.addPoint(rVirt.x, rVirt.y);
                                leftRect.addPoint(rVirt.x + rVirt.width, rVirt.y);
                                leftRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height / 2);
                                leftRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                leftRect.addPoint(rVirt.x, rVirt.y);
                                rightRect = new Polygon();
                                rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height / 2);
                                rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                                rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height);
                                rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                            }
                            BlackBoxIF bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                            bb = bb.runRules(s, g);
                            fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                            new DetPolygon(this.m_Detectiv, idFront, leftRect, blackBoxNew, fIntensity);
                            fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                            new DetPolygon(this.m_Detectiv, idFront2, rightRect, bb, fIntensity);
                        } else if (barShape == 1) {
                            BlackBoxIF bbox = new BlackBoxObj(this.m_Perspective, new IdentObj(-3, s, g));
                            bbox = bbox.runRules(s, g);
                            this.applyCylinderBarsGradientEffect(bbox);
                            new DetRect(this.m_Detectiv, idFront, rVirt, bbox, this.m_rClip, drawType);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected Point getCoords(int s, int g) {
        int nCenterOrd = !this.m_bIsThisAComboWithBar && this.m_bExtendToFrameEdge ? this.m_ordCoords[s][g] : (this.m_gt.isRiserBar() ? this.m_ordCoords[s][g] + this.m_barThickCoord / 2 : this.m_ordCoords[s][g]);
        Point ptCenter = this.m_bHorz ? new Point(this.m_numYCoords[s][g], nCenterOrd) : new Point(nCenterOrd, this.m_numYCoords[s][g]);
        return ptCenter;
    }

    @Override
    protected Point getVCPositionsXY(int s, double x, double y) throws AssertionException {
        int maxValue;
        SeriesEnumerator sEnum = this.m_sEnumForward;
        int sFirst = sEnum.getFirstSeries();
        Axis2DObj xAxis = (Axis2DObj)this.m_O1Axis;
        Axis2DObj yAxis = (Axis2DObj)this.whichAxisForSeries(s, null);
        int xCoordLow = (int)xAxis.getLowCoord((double)(s - sFirst), x);
        int yCoord = (int)yAxis.getValueCoord(y);
        if (yCoord > (maxValue = (int)yAxis.getValueCoord(yAxis.getMaxValue()))) {
            return null;
        }
        int graphType = this.m_Perspective.getGraphType();
        int xCoordMin = (int)xAxis.getLowCoord(s - sFirst, 0);
        if (xCoordMin < xAxis.m_axisOrgVC) {
            xCoordLow += this.m_barThickCoord;
        }
        int xCoord = graphType >= 41 && graphType <= 47 || graphType >= 31 && graphType <= 35 ? xCoordLow : xCoordLow + this.m_barThickCoord / 2;
        if (this.wantDepthEffect()) {
            Point frontOffset = this.m_seriesFrontOffsets[s];
            xCoord -= frontOffset.x;
            yCoord -= frontOffset.y;
        }
        if (this.m_bHorz) {
            return new Point(yCoord, xCoord);
        }
        return new Point(xCoord, yCoord);
    }

    public boolean isBottomStackedArea(int s) {
        return this.isVisibleStackedArea(s, false);
    }

    public boolean isTopStackedArea(int s) {
        return this.isVisibleStackedArea(s, true);
    }

    public boolean isVisibleStackedArea(int sCurrent, boolean bTopFace) {
        int s;
        int axisCurrent = this.getAxisAssignment(sCurrent);
        boolean bForward = !bTopFace;
        boolean bIsTop = true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForward);
        while (bIsTop && sEnum.hasMoreElements()) {
            boolean bDone;
            s = sEnum.nextSeries();
            boolean bl = bForward ? s >= sCurrent : (bDone = s <= sCurrent);
            if (bDone) break;
            if (this.m_seriesTypes[s] != 3 || this.getAxisAssignment(s) != axisCurrent) continue;
            bIsTop = false;
        }
        if (!bForward && !bIsTop && sEnum.hasMoreElements() && this.m_seriesTypes[s = sEnum.nextSeries()] == 3 && this.m_Perspective.getFillColor(this.m_Perspective.getSeries(s)).getAlpha() > 0) {
            bIsTop = true;
        }
        return bIsTop;
    }

    @Override
    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataTextTemplate;
        return ResultString;
    }

    protected boolean wantRisersFromZero(RelativeAxisObj yAxisObj) {
        boolean bFromZero = this.m_bFromZero;
        if (!bFromZero) {
            bFromZero = yAxisObj.hasNegData() && !this.m_bAbsolute && !yAxisObj.isLogScale();
        }
        return bFromZero;
    }

    protected void drawAreaRiserFromVector(Vector allVectPoints, RelativeAxisObj yAxisObj, int nZeroCoord, int baseCoord) {
        BlackBoxIF blackBox = null;
        Object pt1 = null;
        Object pt2 = null;
        Object ld = null;
        Object ld2 = null;
        Object first = null;
        int s = 0;
        int g = 0;
        int allVSize = allVectPoints.size();
        VC vc = this.m_Perspective.getVC();
        block0: for (int j = 0; j < allVSize; ++j) {
            Vector seriesVect = (Vector)allVectPoints.elementAt(j);
            Polygon polygon = new Polygon();
            boolean bAreaRendered = false;
            int startIndex = -1;
            int endIndex = -1;
            int prevX = -1;
            int prevY = -1;
            double fXValue = 0.0;
            double fYValue = 0.0;
            Point cStartPoint = null;
            boolean done = false;
            while (!done) {
                int y;
                startIndex = this.getStartGroupInSeriesVect(seriesVect, startIndex + 1);
                endIndex = this.getEndGroupInSeriesVect(seriesVect, startIndex + 1);
                if (startIndex == -1) {
                    if (endIndex == -1 || bAreaRendered) continue block0;
                    double min = this.getO1Axis().getMinValue();
                    double max = this.getO1Axis().getMaxValue();
                    polygon = new Polygon();
                    PointInfo info = (PointInfo)seriesVect.elementAt(0);
                    s = info.series;
                    RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                    IdentObj AxisId = axisObj.getAxisIdentObj();
                    boolean bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                    boolean bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                    int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
                    int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
                    y = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                    int leftGroup = -1;
                    int rightGroup = -1;
                    for (int i = 1; i < this.m_nTotalGroups; ++i) {
                        double value = this.getDataValue((int)s, (int)i, (DataItem)DataItem.DI_XY_X).m_fValue;
                        if (value < min) {
                            leftGroup = i;
                            continue;
                        }
                        if (!(value > max)) continue;
                        rightGroup = i;
                        break;
                    }
                    if (rightGroup - leftGroup < 1) continue;
                    DatumObj obj = this.getDataValue(s, leftGroup, DataItem.DI_XY_X);
                    fXValue = obj.m_fValue;
                    obj = this.getDataValue(s, leftGroup, DataItem.DI_XY_Y);
                    fYValue = obj.m_fValue;
                    DatumObj obj3 = this.getDataValue(s, rightGroup, DataItem.DI_XY_X);
                    double fXValue3 = obj3.m_fValue;
                    obj3 = this.getDataValue(s, rightGroup, DataItem.DI_XY_Y);
                    double fYValue3 = obj3.m_fValue;
                    if (rightGroup - leftGroup == 1) {
                        if (obj.m_bOK && obj3.m_bOK) {
                            double x1 = this.getO1Axis().getValueCoord(fXValue);
                            RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                            double y1 = yAxis.getValueCoord(fYValue);
                            Point leftPoint = new Point((int)x1, (int)y1);
                            double x3 = this.getO1Axis().getValueCoord(fXValue3);
                            double y3 = yAxis.getValueCoord(fYValue3);
                            Point rightPoint = new Point((int)x3, (int)y3);
                            double minXCoord = this.getO1Axis().getValueCoord(min);
                            double yCoord1 = this.calcyPosition(leftPoint, rightPoint, minXCoord);
                            double maxXCoord = this.getO1Axis().getValueCoord(max);
                            double yCoord3 = this.calcyPosition(leftPoint, rightPoint, maxXCoord);
                            if (!bAutoMin && yCoord1 < (double)minCoord) {
                                yCoord1 = minCoord;
                            }
                            if (!bAutoMin && yCoord3 < (double)minCoord) {
                                yCoord3 = minCoord;
                            }
                            if (!bAutoMax && yCoord1 > (double)maxCoord) {
                                yCoord1 = maxCoord;
                            }
                            if (!bAutoMax && yCoord3 > (double)maxCoord) {
                                yCoord3 = maxCoord;
                            }
                            polygon.addPoint((int)minXCoord, (int)yCoord1);
                            polygon.addPoint((int)maxXCoord, (int)yCoord3);
                            polygon.addPoint((int)maxXCoord, y);
                            polygon.addPoint((int)minXCoord, y);
                            polygon.addPoint((int)minXCoord, (int)yCoord1);
                        }
                    } else if (rightGroup - leftGroup == 2) {
                        DatumObj obj2 = this.getDataValue(s, leftGroup + 1, DataItem.DI_XY_X);
                        double fXValue2 = obj2.m_fValue;
                        obj2 = this.getDataValue(s, leftGroup + 1, DataItem.DI_XY_Y);
                        double fYValue2 = obj2.m_fValue;
                        if (obj.m_bOK && obj2.m_bOK && obj3.m_bOK) {
                            double x1 = this.getO1Axis().getValueCoord(fXValue);
                            RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                            double y1 = yAxis.getValueCoord(fYValue);
                            Point leftPoint = new Point((int)x1, (int)y1);
                            double x2 = this.getO1Axis().getValueCoord(fXValue2);
                            double y2 = yAxis.getValueCoord(fYValue2);
                            Point midPoint = new Point((int)x2, (int)y2);
                            double x3 = this.getO1Axis().getValueCoord(fXValue3);
                            double y3 = yAxis.getValueCoord(fYValue3);
                            Point rightPoint = new Point((int)x3, (int)y3);
                            double minXCoord = this.getO1Axis().getValueCoord(min);
                            double yCoord1 = this.calcyPosition(leftPoint, midPoint, minXCoord);
                            double maxXCoord = this.getO1Axis().getValueCoord(max);
                            double yCoord3 = this.calcyPosition(midPoint, rightPoint, maxXCoord);
                            if (!bAutoMin && yCoord1 < (double)minCoord) {
                                yCoord1 = minCoord;
                            }
                            if (!bAutoMin && y2 < (double)minCoord) {
                                y2 = minCoord;
                            }
                            if (!bAutoMin && yCoord3 < (double)minCoord) {
                                yCoord3 = minCoord;
                            }
                            if (!bAutoMax && yCoord1 > (double)maxCoord) {
                                yCoord1 = maxCoord;
                            }
                            if (!bAutoMax && y2 > (double)maxCoord) {
                                y2 = maxCoord;
                            }
                            if (!bAutoMax && yCoord3 > (double)maxCoord) {
                                yCoord3 = maxCoord;
                            }
                            polygon.addPoint((int)minXCoord, (int)yCoord1);
                            polygon.addPoint((int)x2, (int)y2);
                            polygon.addPoint((int)maxXCoord, (int)yCoord3);
                            polygon.addPoint((int)maxXCoord, y);
                            polygon.addPoint((int)minXCoord, y);
                            polygon.addPoint((int)minXCoord, (int)yCoord1);
                        }
                    }
                    blackBox = this.assignSeriesColor(s, g, false);
                    blackBox = blackBox.runRules(s, g);
                    new DetPolygon(this.m_Detectiv, new IdentObj(256, s), polygon, blackBox, this.m_rClip);
                    continue block0;
                }
                if (endIndex - startIndex > 0) {
                    for (int k = startIndex; k <= endIndex; ++k) {
                        int x;
                        PointInfo info = (PointInfo)seriesVect.elementAt(k);
                        s = info.series;
                        g = info.group;
                        if (k == startIndex && this.m_Perspective.isContinuousTimeAxis() && g > 0 && this.m_dataOK[s][g]) {
                            DatumObj obj = this.getDataValue(s, g - 1, DataItem.DI_XY_X);
                            fXValue = obj.m_fValue;
                            obj = this.getDataValue(s, g - 1, DataItem.DI_XY_Y);
                            fYValue = obj.m_fValue;
                            double x1 = 0.0;
                            double y1 = 0.0;
                            if (obj.m_bOK) {
                                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                                IdentObj AxisId = axisObj.getAxisIdentObj();
                                boolean bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                                boolean bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                                int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
                                int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
                                x1 = this.getO1Axis().getValueCoord(fXValue);
                                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                                y1 = yAxis.getValueCoord(fYValue);
                                Point pt3 = new Point(info.lt.x, info.lt.y);
                                double min = this.getO1Axis().getMinValue();
                                double minXCoord = this.getO1Axis().getValueCoord(min);
                                double yCoord = this.calcyPosition(new Point((int)x1, (int)y1), pt3, minXCoord);
                                if (!bAutoMin && yCoord < (double)minCoord) {
                                    yCoord = minCoord;
                                }
                                if (!bAutoMax && yCoord > (double)maxCoord) {
                                    yCoord = maxCoord;
                                }
                                polygon.addPoint((int)minXCoord, (int)yCoord);
                                cStartPoint = new Point((int)minXCoord, (int)yCoord);
                            }
                        }
                        int destX = this.m_Perspective.m_VC.virtToDestX(info.lt.x);
                        int destY = this.m_Perspective.m_VC.virtToDestY(info.lt.y);
                        if (destX != prevX || destY != prevY) {
                            polygon.addPoint(info.lt.x, info.lt.y);
                            prevX = destX;
                            prevY = destY;
                        }
                        if (!info.lt.equals(info.rt)) {
                            polygon.addPoint(info.rt.x, info.rt.y);
                        }
                        if (k != endIndex) continue;
                        PointInfo startInfo = (PointInfo)seriesVect.elementAt(startIndex);
                        blackBox = this.assignSeriesColor(s, -3, false);
                        blackBox = blackBox.runRules(s, -3);
                        IdentObj groupIdent = new IdentObj(256, s);
                        if (this.m_bAbsolute || j == allVSize - 1) {
                            PointInfo endInfo = (PointInfo)seriesVect.elementAt(endIndex);
                            if (this.m_bHorz) {
                                x = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                                polygon.addPoint(x, endInfo.rt.y);
                                polygon.addPoint(x, startInfo.lt.y);
                            } else {
                                y = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                                if (this.m_Perspective.isContinuousTimeAxis() && g < this.m_nTotalGroups - 1 && this.m_dataOK[s][g]) {
                                    DatumObj obj = this.getDataValue(s, g + 1, DataItem.DI_XY_X);
                                    fXValue = obj.m_fValue;
                                    obj = this.getDataValue(s, g + 1, DataItem.DI_XY_Y);
                                    fYValue = obj.m_fValue;
                                    double x1 = 0.0;
                                    double y1 = 0.0;
                                    if (obj.m_bOK) {
                                        RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                                        IdentObj AxisId = axisObj.getAxisIdentObj();
                                        boolean bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                                        boolean bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                                        int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
                                        int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
                                        x1 = this.getO1Axis().getValueCoord(fXValue);
                                        RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                                        y1 = yAxis.getValueCoord(fYValue);
                                        Point pt4 = new Point(endInfo.rt.x, endInfo.rt.y);
                                        double max = this.getO1Axis().getMaxValue();
                                        double maxXCoord = this.getO1Axis().getValueCoord(max);
                                        double yCoord = this.calcyPosition(new Point((int)x1, (int)y1), pt4, maxXCoord);
                                        if (!bAutoMin && yCoord < (double)minCoord) {
                                            yCoord = minCoord;
                                        }
                                        if (!bAutoMax && yCoord > (double)maxCoord) {
                                            yCoord = maxCoord;
                                        }
                                        polygon.addPoint((int)maxXCoord, (int)yCoord);
                                        polygon.addPoint((int)maxXCoord, y);
                                    } else {
                                        polygon.addPoint(endInfo.rt.x, y);
                                    }
                                } else {
                                    polygon.addPoint(endInfo.rt.x, y);
                                }
                                if (cStartPoint != null) {
                                    polygon.addPoint(cStartPoint.x, y);
                                } else {
                                    polygon.addPoint(startInfo.lt.x, y);
                                }
                            }
                            if (cStartPoint != null) {
                                polygon.addPoint(cStartPoint.x, cStartPoint.y);
                            } else {
                                polygon.addPoint(startInfo.lt.x, startInfo.lt.y);
                            }
                            ArrayList<Integer> groups = new ArrayList<Integer>();
                            for (int i = startIndex; i <= endIndex; ++i) {
                                groups.add(i);
                            }
                            new DetPolygon(this.m_Detectiv, groupIdent, polygon, blackBox, this.m_rClip, groups);
                            bAreaRendered = true;
                            polygon = new Polygon();
                            continue;
                        }
                        Vector seriesBelow = null;
                        int lastx = ((PointInfo)seriesVect.elementAt((int)endIndex)).rt.x;
                        int firstx = ((PointInfo)seriesVect.elementAt((int)startIndex)).lt.x;
                        int lasty = ((PointInfo)seriesVect.elementAt((int)endIndex)).rt.y;
                        int firsty = ((PointInfo)seriesVect.elementAt((int)startIndex)).lt.y;
                        boolean found = false;
                        for (int i = j + 1; i < allVSize; ++i) {
                            seriesBelow = (Vector)allVectPoints.elementAt(i);
                            for (int m = 0; m < seriesBelow.size(); ++m) {
                                if (((PointInfo)seriesBelow.elementAt(m)).getStatus() != 1) continue;
                                found = true;
                                break;
                            }
                            if (found) break;
                        }
                        if (!found) {
                            if (this.m_bHorz) {
                                x = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                polygon.addPoint(x, lasty);
                                polygon.addPoint(x, firsty);
                            } else {
                                y = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                polygon.addPoint(lastx, y);
                                polygon.addPoint(firstx, y);
                            }
                        } else {
                            int eindex = -1;
                            int sindex = -1;
                            for (int n = seriesBelow.size() - 1; n >= 0; --n) {
                                PointInfo belowInfo = (PointInfo)seriesBelow.elementAt(n);
                                if (belowInfo.rt.x == lastx) {
                                    eindex = n;
                                }
                                if (belowInfo.lt.x != firstx) continue;
                                sindex = n;
                            }
                            if (eindex == -1 || sindex == -1) {
                                if (this.m_bHorz) {
                                    x = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                    polygon.addPoint(x, lasty);
                                    polygon.addPoint(x, firsty);
                                } else {
                                    y = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                    polygon.addPoint(lastx, y);
                                    polygon.addPoint(firstx, y);
                                }
                            } else {
                                for (int i = eindex; i >= sindex; --i) {
                                    PointInfo prevInfo = (PointInfo)seriesBelow.elementAt(i);
                                    polygon.addPoint(prevInfo.rt.x, prevInfo.rt.y);
                                    if (prevInfo.lt.equals(prevInfo.rt)) continue;
                                    polygon.addPoint(prevInfo.lt.x, prevInfo.lt.y);
                                }
                            }
                        }
                        polygon.addPoint(startInfo.lt.x, startInfo.lt.y);
                        new DetPolygon(this.m_Detectiv, groupIdent, polygon, blackBox, this.m_rClip);
                        bAreaRendered = true;
                        polygon = new Polygon();
                    }
                }
                startIndex = endIndex;
            }
        }
    }

    protected void drawAreaRiserFromVector25D(Vector allVectPoints, RelativeAxisObj yAxisObj, int nZeroCoord, int baseCoord, boolean bForwardSeries) {
        int s = 0;
        int g = 0;
        int allVSize = allVectPoints.size();
        boolean l = false;
        ArrayList front = new ArrayList();
        for (int j = 0; j < allVSize; ++j) {
            Vector seriesVect = (Vector)allVectPoints.elementAt(j);
            Vector<Point> facePoints = new Vector<Point>();
            Vector<Point> topPoints = new Vector<Point>();
            Vector<Point> leftPoints = new Vector<Point>();
            Vector<Point> rightPoints = new Vector<Point>();
            Vector<Point> bottomPoints = new Vector<Point>();
            Point cStartPoint = null;
            double fXValue = 0.0;
            double fYValue = 0.0;
            int startIndex = -1;
            int endIndex = -1;
            boolean done = false;
            while (!done) {
                startIndex = this.getStartGroupInSeriesVect(seriesVect, startIndex + 1);
                endIndex = this.getEndGroupInSeriesVect(seriesVect, startIndex + 1);
                if (startIndex == -1) break;
                if (endIndex - startIndex > 0) {
                    for (int k = startIndex; k <= endIndex; ++k) {
                        PointInfo info = (PointInfo)seriesVect.elementAt(k);
                        s = info.series;
                        g = info.group;
                        if (k == startIndex && this.m_Perspective.isContinuousTimeAxis() && g > 0 && this.m_dataOK[s][g]) {
                            DatumObj obj = this.getDataValue(s, g - 1, DataItem.DI_XY_X);
                            fXValue = obj.m_fValue;
                            obj = this.getDataValue(s, g - 1, DataItem.DI_XY_Y);
                            fYValue = obj.m_fValue;
                            double x1 = 0.0;
                            double y1 = 0.0;
                            if (obj.m_bOK) {
                                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                                IdentObj AxisId = axisObj.getAxisIdentObj();
                                boolean bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                                boolean bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                                int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
                                int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
                                x1 = this.getO1Axis().getValueCoord(fXValue);
                                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                                y1 = yAxis.getValueCoord(fYValue);
                                Point pt3 = new Point(info.lt.x, info.lt.y);
                                double min = this.getO1Axis().getMinValue();
                                double minXCoord = this.getO1Axis().getValueCoord(min);
                                double yCoord = this.calcyPosition(new Point((int)x1, (int)y1), pt3, minXCoord);
                                if (!bAutoMin && yCoord < (double)minCoord) {
                                    yCoord = minCoord;
                                }
                                if (!bAutoMax && yCoord > (double)maxCoord) {
                                    yCoord = maxCoord;
                                }
                                cStartPoint = new Point((int)minXCoord, (int)yCoord);
                                facePoints.add(cStartPoint);
                                topPoints.add(cStartPoint);
                                leftPoints.add(cStartPoint);
                            } else if (k == startIndex) {
                                leftPoints.add(info.lt);
                            }
                        } else if (k == startIndex) {
                            leftPoints.add(info.lt);
                        }
                        facePoints.add(info.lt);
                        topPoints.add(info.lt);
                        if (!info.lt.equals(info.rt)) {
                            facePoints.add(info.rt);
                            topPoints.add(info.rt);
                        }
                        if (k != endIndex) continue;
                        rightPoints.add(info.rt);
                        PointInfo startInfo = (PointInfo)seriesVect.elementAt(startIndex);
                        int closerToBase = bForwardSeries ? 0 : allVSize - 1;
                        if (this.m_bAbsolute || j == closerToBase) {
                            Point bottomLeft;
                            Point bottomRight;
                            PointInfo endInfo = (PointInfo)seriesVect.elementAt(endIndex);
                            if (this.m_bHorz) {
                                x = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                                bottomRight = new Point(x, endInfo.rt.y);
                                bottomLeft = new Point(x, startInfo.lt.y);
                            } else {
                                y = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                                if (this.m_Perspective.isContinuousTimeAxis() && g < this.m_nTotalGroups - 1 && this.m_dataOK[s][g]) {
                                    DatumObj obj = this.getDataValue(s, g + 1, DataItem.DI_XY_X);
                                    fXValue = obj.m_fValue;
                                    obj = this.getDataValue(s, g + 1, DataItem.DI_XY_Y);
                                    fYValue = obj.m_fValue;
                                    double x1 = 0.0;
                                    double y1 = 0.0;
                                    if (obj.m_bOK) {
                                        RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                                        IdentObj AxisId = axisObj.getAxisIdentObj();
                                        boolean bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                                        boolean bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                                        int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
                                        int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
                                        x1 = this.getO1Axis().getValueCoord(fXValue);
                                        RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                                        y1 = yAxis.getValueCoord(fYValue);
                                        Point pt4 = new Point(endInfo.rt.x, endInfo.rt.y);
                                        double max = this.getO1Axis().getMaxValue();
                                        double maxXCoord = this.getO1Axis().getValueCoord(max);
                                        double yCoord = this.calcyPosition(new Point((int)x1, (int)y1), pt4, maxXCoord);
                                        if (!bAutoMin && yCoord < (double)minCoord) {
                                            yCoord = minCoord;
                                        }
                                        if (!bAutoMax && yCoord > (double)maxCoord) {
                                            yCoord = maxCoord;
                                        }
                                        facePoints.add(new Point((int)maxXCoord, (int)yCoord));
                                        topPoints.add(new Point((int)maxXCoord, (int)yCoord));
                                        bottomRight = new Point((int)maxXCoord, y);
                                        rightPoints.removeElementAt(rightPoints.size() - 1);
                                        rightPoints.add(new Point((int)maxXCoord, (int)yCoord));
                                    } else {
                                        bottomRight = new Point(endInfo.rt.x, y);
                                    }
                                } else {
                                    bottomRight = new Point(endInfo.rt.x, y);
                                }
                                bottomLeft = cStartPoint != null ? new Point(cStartPoint.x, y) : new Point(startInfo.lt.x, y);
                            }
                            facePoints.add(bottomRight);
                            facePoints.add(bottomLeft);
                            leftPoints.add(bottomLeft);
                            rightPoints.add(bottomRight);
                            bottomPoints.add(bottomRight);
                            bottomPoints.add(bottomLeft);
                            if (cStartPoint != null) {
                                facePoints.add(cStartPoint);
                            } else {
                                facePoints.add(startInfo.lt);
                            }
                        } else {
                            Vector seriesBelow = null;
                            int lastx = ((PointInfo)seriesVect.elementAt((int)endIndex)).rt.x;
                            int firstx = ((PointInfo)seriesVect.elementAt((int)startIndex)).lt.x;
                            int lasty = ((PointInfo)seriesVect.elementAt((int)endIndex)).rt.y;
                            int firsty = ((PointInfo)seriesVect.elementAt((int)startIndex)).lt.y;
                            boolean found = false;
                            if (bForwardSeries) {
                                for (i = j - 1; i >= 0; --i) {
                                    seriesBelow = (Vector)allVectPoints.elementAt(i);
                                    for (m = 0; m < seriesBelow.size(); ++m) {
                                        if (((PointInfo)seriesBelow.elementAt(m)).getStatus() != 1) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                for (i = j + 1; i < allVSize; ++i) {
                                    seriesBelow = (Vector)allVectPoints.elementAt(i);
                                    for (m = 0; m < seriesBelow.size(); ++m) {
                                        if (((PointInfo)seriesBelow.elementAt(m)).getStatus() != 1) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            if (!found) {
                                Point bottomLeft;
                                Point bottomRight;
                                if (this.m_bHorz) {
                                    x = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                    bottomRight = new Point(x, lasty);
                                    bottomLeft = new Point(x, firsty);
                                } else {
                                    y = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                    bottomRight = new Point(lastx, y);
                                    bottomLeft = new Point(firstx, y);
                                }
                                facePoints.add(bottomRight);
                                facePoints.add(bottomLeft);
                                leftPoints.add(bottomLeft);
                                rightPoints.add(bottomRight);
                                bottomPoints.add(bottomRight);
                                bottomPoints.add(bottomLeft);
                                facePoints.add(startInfo.lt);
                            } else {
                                int eindex = -1;
                                int sindex = -1;
                                for (int n = seriesBelow.size() - 1; n >= 0; --n) {
                                    PointInfo belowInfo = (PointInfo)seriesBelow.elementAt(n);
                                    if (belowInfo.rt.x == lastx) {
                                        eindex = n;
                                    }
                                    if (belowInfo.lt.x != firstx) continue;
                                    sindex = n;
                                }
                                if (eindex == -1 || sindex == -1) {
                                    Point bottomLeft;
                                    Point bottomRight;
                                    if (this.m_bHorz) {
                                        x = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                        bottomRight = new Point(x, lasty);
                                        bottomLeft = new Point(x, firsty);
                                    } else {
                                        y = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                        bottomRight = new Point(lastx, y);
                                        bottomLeft = new Point(firstx, y);
                                    }
                                    facePoints.add(bottomRight);
                                    facePoints.add(bottomLeft);
                                    leftPoints.add(bottomLeft);
                                    rightPoints.add(bottomRight);
                                    bottomPoints.add(bottomRight);
                                    bottomPoints.add(bottomLeft);
                                    facePoints.add(startInfo.lt);
                                } else {
                                    for (int i = eindex; i >= sindex; --i) {
                                        PointInfo prevInfo = (PointInfo)seriesBelow.elementAt(i);
                                        facePoints.add(prevInfo.rt);
                                        bottomPoints.add(prevInfo.rt);
                                        if (i == eindex) {
                                            rightPoints.add(prevInfo.rt);
                                        }
                                        if (i == sindex) {
                                            leftPoints.add(prevInfo.lt);
                                        }
                                        if (prevInfo.lt.equals(prevInfo.rt)) continue;
                                        facePoints.add(prevInfo.lt);
                                        bottomPoints.add(prevInfo.lt);
                                    }
                                    facePoints.add(startInfo.lt);
                                }
                            }
                        }
                        if (this.m_bStacked) {
                            ArrayList listOfPoints;
                            if (front.size() <= s) {
                                for (int i = front.size(); i <= s; ++i) {
                                    front.add(null);
                                }
                            }
                            if ((listOfPoints = (ArrayList)front.get(s)) == null) {
                                listOfPoints = new ArrayList();
                            }
                            listOfPoints.add(facePoints);
                            front.set(s, listOfPoints);
                        }
                        this.draw25DPolygon(facePoints, topPoints, leftPoints, rightPoints, bottomPoints, bForwardSeries, s, g);
                        facePoints = new Vector();
                        topPoints = new Vector();
                        leftPoints = new Vector();
                        rightPoints = new Vector();
                        bottomPoints = new Vector();
                    }
                }
                startIndex = endIndex;
            }
            if (!this.m_bTransparentMarkers) continue;
            this.drawTransparentMarkersWithDepth(s, 3);
        }
        if (this.m_bStacked && !front.isEmpty()) {
            this.drawFront(front);
        }
    }

    private int getStartGroupInSeriesVect(Vector seriesVect, int index) {
        for (int k = index; k < seriesVect.size(); ++k) {
            PointInfo info = (PointInfo)seriesVect.elementAt(k);
            if (info.getStatus() != 1) continue;
            return k;
        }
        return -1;
    }

    private int getEndGroupInSeriesVect(Vector seriesVect, int index) {
        for (int k = index; k < seriesVect.size(); ++k) {
            PointInfo info = (PointInfo)seriesVect.elementAt(k);
            if (info.getStatus() == 0) {
                return k - 1;
            }
            if (k != seriesVect.size() - 1) continue;
            return k;
        }
        return -1;
    }

    private PointInfo getPointInfo(Vector seriesVect, int s, int g) {
        if (seriesVect.size() == 0) {
            PointInfo info = new PointInfo(s, g);
            seriesVect.add(info);
            return info;
        }
        PointInfo info = (PointInfo)seriesVect.lastElement();
        if (info.group == g) {
            return info;
        }
        info = new PointInfo(s, g);
        seriesVect.add(info);
        return info;
    }

    private void drawFront(ArrayList front) {
        double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
        for (int i = front.size() - 1; i >= 0; --i) {
            Point frontOffset;
            ArrayList listOfPoints = (ArrayList)front.get(i);
            if (this.wantDepthEffect()) {
                Point backOffset = this.m_seriesBackOffsets[i];
                frontOffset = this.m_seriesFrontOffsets[i];
            } else {
                frontOffset = new Point();
            }
            BlackBoxIF blackBox = this.assignSeriesColor(i, 0, false);
            blackBox = blackBox.runRules(i, -3);
            BlackBoxIF riserBlackBox = this.getMissingDataBlackBox(i, 0);
            if (riserBlackBox == null) {
                riserBlackBox = blackBox;
            }
            if (listOfPoints == null || listOfPoints.isEmpty()) continue;
            for (int k = 0; k < listOfPoints.size(); ++k) {
                Vector facePoints = (Vector)listOfPoints.get(k);
                Polygon polyFront = new Polygon();
                Point p = null;
                for (int j = 0; j < facePoints.size(); ++j) {
                    p = (Point)facePoints.elementAt(j);
                    polyFront.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                }
                new DetPolygon(this.m_Detectiv, new IdentObj(256, i), polyFront, riserBlackBox, fIntensity);
            }
        }
    }

    private void draw25DPolygon(Vector facePoints, Vector topPoints, Vector leftPoints, Vector rightPoints, Vector bottomPoints, boolean bForwardSeries, int s, int g) {
        int j;
        int dy;
        int dx;
        Point frontOffset;
        BlackBoxIF blackBox = this.assignSeriesColor(s, -3, false);
        blackBox = blackBox.runRules(s, -3);
        double fIntensity = 1.0;
        double fIntensityTop = 1.0;
        double fIntensitySide = 1.0;
        double fIntensityBottom = 1.0;
        boolean bRightToLeft = this.getRightToLeftOrder();
        boolean bShowLeftSide = bRightToLeft || this.m_bHorz;
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, null);
        boolean bDescending = yAxisObj.isDescending();
        int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
        BlackBoxIF riserBlackBox = this.getMissingDataBlackBox(s, g);
        if (riserBlackBox == null) {
            riserBlackBox = blackBox;
        }
        BlackBoxIF blackBoxNew = riserBlackBox;
        if (riserBlackBox instanceof BlackBoxObj) {
            BlackBoxObj newBox = new BlackBoxObj((BlackBoxObj)riserBlackBox);
            newBox.setFillType(1);
            blackBoxNew = newBox;
            blackBoxNew = blackBoxNew.runRules(s, -3);
        }
        if (this.wantDepthEffect()) {
            Point backOffset = this.m_seriesBackOffsets[s];
            frontOffset = this.m_seriesFrontOffsets[s];
            dx = frontOffset.x - backOffset.x;
            dy = frontOffset.y - backOffset.y;
        } else {
            frontOffset = new Point();
            dx = 0;
            dy = 0;
        }
        Polygon polyFront = new Polygon();
        Polygon polyTop = null;
        Polygon polyBottom = null;
        Point p = null;
        for (int i = 0; i < facePoints.size(); ++i) {
            p = (Point)facePoints.elementAt(i);
            polyFront.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
        }
        if (this.m_bAbsolute || this.isTopStackedArea(s)) {
            if (this.m_bColorAutoshadeRisers) {
                double d = fIntensityTop = this.m_bHorz ? 0.6 : 0.8;
            }
            if (!bShowLeftSide) {
                for (j = 0; j < topPoints.size() - 1; ++j) {
                    polyTop = new Polygon();
                    p = (Point)topPoints.elementAt(j);
                    polyTop.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    Point p2 = (Point)topPoints.elementAt(j + 1);
                    polyTop.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
                    polyTop.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
                    polyTop.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
                    polyTop.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(314, s), polyTop, blackBoxNew, fIntensityTop);
                }
            } else {
                for (j = topPoints.size() - 1; j > 0; --j) {
                    polyTop = new Polygon();
                    p = (Point)topPoints.elementAt(j);
                    polyTop.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    Point p2 = (Point)topPoints.elementAt(j - 1);
                    polyTop.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
                    polyTop.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
                    polyTop.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
                    polyTop.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(314, s), polyTop, blackBoxNew, fIntensityTop);
                }
            }
        }
        if (this.m_bAbsolute || this.isBottomStackedArea(s)) {
            if (this.m_bColorAutoshadeRisers) {
                double d = fIntensityBottom = this.m_bHorz ? 0.6 : 0.8;
            }
            if (!bShowLeftSide) {
                for (j = 0; j < bottomPoints.size() - 1; ++j) {
                    polyBottom = new Polygon();
                    p = (Point)bottomPoints.elementAt(j);
                    polyBottom.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    Point p2 = (Point)bottomPoints.elementAt(j + 1);
                    polyBottom.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
                    polyBottom.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
                    polyBottom.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
                    polyBottom.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(316, s), polyBottom, blackBoxNew, fIntensityBottom);
                }
            } else {
                for (j = bottomPoints.size() - 1; j > 0; --j) {
                    polyBottom = new Polygon();
                    p = (Point)bottomPoints.elementAt(j);
                    polyBottom.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    Point p2 = (Point)bottomPoints.elementAt(j - 1);
                    polyBottom.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
                    polyBottom.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
                    polyBottom.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
                    polyBottom.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(316, s), polyBottom, blackBoxNew, fIntensityBottom);
                }
            }
        }
        if (bShowLeftSide) {
            Polygon polyLeft = new Polygon();
            p = (Point)leftPoints.elementAt(0);
            Point p2 = (Point)leftPoints.elementAt(1);
            polyLeft.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
            polyLeft.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
            polyLeft.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
            polyLeft.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
            polyLeft.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
            if (this.m_bColorAutoshadeRisers) {
                fIntensitySide = this.m_bHorz ? 0.8 : 0.6;
            }
            new DetPolygon(this.m_Detectiv, new IdentObj(315, s), polyLeft, blackBoxNew, fIntensitySide);
        } else if (rightPoints.size() >= 2) {
            Polygon polyRight = new Polygon();
            p = (Point)rightPoints.elementAt(0);
            Point p2 = (Point)rightPoints.elementAt(1);
            polyRight.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
            polyRight.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
            polyRight.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
            polyRight.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
            polyRight.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
            if (this.m_bColorAutoshadeRisers) {
                fIntensitySide = this.m_bHorz ? 0.8 : 0.6;
            }
            new DetPolygon(this.m_Detectiv, new IdentObj(315, s), polyRight, blackBoxNew, fIntensitySide);
        }
        if (!this.m_bStacked) {
            if (this.m_bColorAutoshadeRisers) {
                fIntensity = 1.0;
            }
            new DetPolygon(this.m_Detectiv, new IdentObj(256, s), polyFront, riserBlackBox, fIntensity);
        }
    }

    private boolean getRightToLeftOrder() {
        return this.m_nDepthAngle > 90 || this.m_Perspective.getCommonGraph().is3DEffect() && !this.getO1Axis().isAscending();
    }

    private class PointInfo {
        public Point lt = null;
        public Point rt = null;
        public static final int NULL_STATUS = 0;
        public static final int OK_STATUS = 1;
        public int group = -1;
        public int series = -1;
        int status = 1;

        public PointInfo(int s, int g) {
            this.series = s;
            this.group = g;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int stat) {
            this.status = stat;
        }
    }
}

