/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.ImageViewExportXMLWriter;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataSelection;
import oracle.dss.graph.DataStyleContext;
import oracle.dss.graph.DataStyleType;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.graph.GraphNumberFormatCallback;
import oracle.dss.graph.GraphSelection;
import oracle.dss.graph.GraphSelectionSet;
import oracle.dss.graph.GraphXMLWriterCallback;
import oracle.dss.graph.SFX;
import oracle.dss.graph.ToolTipTextCallback;
import oracle.dss.graph.managers.GraphRuleFormatter;
import oracle.dss.graph.managers.GraphStyle;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.DataContext;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.GraphEventParams;
import oracle.dss.graph.pfj.JChart_2D_BLA;
import oracle.dss.graph.pfj.JChart_2D_Circular;
import oracle.dss.graph.pfj.JChart_2D_Funnel;
import oracle.dss.graph.pfj.JChart_2D_Hilo;
import oracle.dss.graph.pfj.JChart_2D_Hist;
import oracle.dss.graph.pfj.JChart_2D_Pareto;
import oracle.dss.graph.pfj.JChart_2D_Pie;
import oracle.dss.graph.pfj.JChart_2D_PieBar;
import oracle.dss.graph.pfj.JChart_2D_Polar;
import oracle.dss.graph.pfj.JChart_2D_Scat;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.NumberFormatCallBack;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.RangeSlider;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BorderObj;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.draw.ToolTips;
import oracle.dss.presutil.GradientStopObj;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.format.DvtNumberConverter;
import oracle.dss.util.format.NumberConverter;
import oracle.dss.util.renderers.utils.GradientUtils;
import oracle.javatools.annotations.Concealed;

public class GraphExportXMLWriter
extends ImageViewExportXMLWriter {
    protected Perspective m_pfj = null;
    private GraphXMLWriterCallback m_xmlCallback;
    private boolean m_bElementFilled = true;
    protected DetObj m_detObj = null;
    public static final String ELEM_GRAPH = "graph";
    public static final String ELEM_REF_OBJ = "ro";
    public static final String ELEM_REFERENCE_OBJECTS = "ros";
    public static final String ELEM_MARKER = "m";
    public static final String ELEM_PIE_METADATA = "pie";
    public static final String ELEM_SCROLLABLE_LEGEND_METADATA = "scrollableLegend";
    public static final String ELEM_RANGE_SLIDER_METADATA = "rs";
    public static final String ELEM_RANGE_SLIDER_ZBUTTON_METADATA = "rszb";
    public static final String ELEM_RANGE_SLIDER_STYLE = "rss";
    public static final String ELEM_RANGE_SLIDER_STATE_NORMAL = "stN";
    public static final String ELEM_RANGE_SLIDER_STATE_HOVER = "stH";
    public static final String ELEM_RANGE_SLIDER_STATE_ACTIVE = "stA";
    public static final String ATTR_DATA_SCROLL_EVENT_JS = "dataScrollEventJs";
    public static final String ATTR_DATA_ZOOM_IN_BUTTON_EVENT_JS = "dataZoomInButtonEventJs";
    public static final String ATTR_DATA_ZOOM_OUT_BUTTON_EVENT_JS = "dataZoomOutButtonEventJs";
    public static final String ATTR_DATA_ZOOM_IN_CLICK_EVENT_JS = "dataZoomInClickEventJs";
    public static final String ATTR_DATA_ZOOM_OUT_CLICK_EVENT_JS = "dataZoomOutClickEventJs";
    public static final String ATTR_DATA_ZOOM_IN_RECT_EVENT_JS = "dataZoomInRectEventJs";
    public static final String ATTR_DATA_ZOOM_OUT_RECT_EVENT_JS = "dataZoomOutRectEventJs";
    public static final String ATTR_DRAG_AND_DROP_BOUNDS_NONE = "dragUnbounded";
    public static final String ATTR_HIDE_SHOW_SERIES_EVENT_JS = "hideShowSeriesEventJs";
    public static final String ATTR_SELECTION = "sel";
    public static final String ATTR_SELECTION_LISTENER = "selList";
    public static final String ATTR_SELECTION_INFO = "selectionInfo";
    public static final String ATTR_GRAPH_TYPE = "graphType";
    public static final String ATTR_GROUP_LABELS = "groupLabels";
    public static final String ATTR_O1_GROUP_LABELS = "O1GroupLabels";
    public static final String ATTR_LINE_SELECT_POINT_EVENT_JS = "lspJS";
    public static final String ATTR_TIME_AXIS_RESOURCES = "taR";
    public static final String ATTR_FLIPPED = "flipped";
    public static final String ATTR_RESOURCES = "resources";
    public static final String ATTR_SERIES_COLORS = "sc";
    public static final String ATTR_SERIES_LABELS = "seriesLabels";
    public static final String ATTR_LAYERS = "layers";
    public static final String ATTR_SCROLL_LABELS = "scrollLabels";
    public static final String ATTR_SCROLL_MAX_VAL = "scrollMaxVal";
    public static final String ATTR_ZOOM_AND_SCROLL = "zoomAndScroll";
    public static final String ATTR_DATE_FORMAT = "dateFormat";
    public static final String ATTR_MENU_ID = "me";
    public static final String ATTR_TIME_ZONE_OFFSET = "timeZone";
    public static final String ATTR_MARQUEE_ZOOM = "mz";
    public static final String ATTR_PAN_SCROLLING = "pan";
    public static final String ATTR_TOOLTIP_TEMPLATE = "tt";
    public static final String ATTR_VIEWFORMAT_X = "XVF";
    public static final String ATTR_VIEWFORMAT_Y1 = "YVF";
    public static final String ATTR_VIEWFORMAT_Y2 = "Y2VF";
    public static final String ATTR_VIEWFORMAT_Z = "ZVF";
    public static final String ATTR_VIEWFORMAT_VOLUME = "VVF";
    public static final String ATTR_VIEWFORMAT_PIESLICELABEL = "PSLVF";
    public static final String ATTR_VIEWFORMAT_X_SCROLLBAR = "XAVF";
    public static final String ATTR_VIEWFORMAT_Y1_SCROLLBAR = "YAVF";
    public static final String ATTR_VIEWFORMAT_Y2_SCROLLBAR = "Y2AVF";
    private static final int COMPONENT_TYPE_MARKERTEXT = 0;
    private static final int COMPONENT_TYPE_SCROLLBAR = 1;
    public static final String ATTR_VIEWFORMAT_HIGH = "YVF";
    public static final String ATTR_VIEWFORMAT_LOW = "YVF";
    public static final String ATTR_VIEWFORMAT_OPEN = "YVF";
    public static final String ATTR_VIEWFORMAT_CLOSE = "YVF";
    public static final String MONTH_FORMAT = "MONTH";
    public static final String DAY_FORMAT = "DAY";
    public static final String HOUR_FORMAT = "HOUR";
    public static final String MINUTE_FORMAT = "MINUTE";
    public static final String SECOND_FORMAT = "SECOND";
    public static final String ATTR_SCROLL_MIN_VAL = "scrollMinVal";
    public static final String ATTR_SCROLL_SPAN = "scrollSpan";
    public static final String ATTR_SCROLL_START = "scrollStart";
    public static final String ATTR_SCROLL_TOTAL = "scrollTotal";
    public static final String ATTR_SERIES_ROLLOVER_BEHAVIOR = "sr";
    public static final String ATTR_HIDE_SHOW_SERIES_NO_RESCALE = "hs";
    public static final String ATTR_TIME_AXIS_END_DATE = "taed";
    public static final String ATTR_TIME_AXIS_END_PIXEL = "taep";
    public static final String ATTR_TIME_AXIS_EVENT_JS = "taJS";
    public static final String ATTR_TIME_AXIS_START_DATE = "tasd";
    public static final String ATTR_TIME_AXIS_START_PIXEL = "tasp";
    public static final String ATTR_TIME_SELECTOR_EVENT_JS = "tsJS";
    public static final String ATTR_TRANSLATED_END = "tranE";
    public static final String ATTR_TRANSLATED_START = "tranS";
    public static final String ATTR_Y1_COORDS = "y1Coords";
    public static final String ATTR_Y1_VALS = "y1Vals";
    public static final String ATTR_X1_COORDS = "x1Coords";
    public static final String ATTR_X1_VALS = "x1Vals";
    public static final String ATTR_ZOOM_DIR = "zoomDir";
    public static final String ATTR_PIE_TILT = "pieTilt";
    public static final String ATTR_PIE_DEPTH = "depth";
    public static final String ATTR_PIE_ROTATE = "rotate";
    public static final String ATTR_PIE_SLICE_EXPLODE = "ex";
    public static final String PIE_SLICE_EXPLODE_INTERACTIVITY = "pse";
    public static final String PIE_SLICE_EXPLODE_ALL_INTERACTIVITY = "psea";
    public static final String ATTR_PIE_SLICE_LABEL = "psl";
    public static final String ATTR_PIE_SLICE_LABEL_CUSTOM_TEXT = "l";
    public static final String ATTR_DATA_CURSOR = "dataCursor";
    public static final String ATTR_DATA_CURSOR_DISPLAY = "display";
    public static final String ATTR_DATA_CURSOR_BEHAVIOR = "behavior";
    public static final String ATTR_DATA_CURSOR_LINE_FILL_COLOR = "lineFillColor";
    public static final String ATTR_MAGNIFY_LENS = "magnifyLens";
    public static final String ATTR_MAGNIFY_LENS_DISPLAY = "display";
    public static final String ATTR_MAGNIFY_LENS_RIM_FILL_COLOR = "rimFillColor";
    public static final String ATTR_THREED_EFFECT = "threed";
    public static final String ATTR_MARKER_TYPE = "mt";
    public static final String ATTR_LINE_MARKER_SIZE = "ms";
    public static final String ATTR_SERIES_EFFECT = "se";
    public static final String ATTR_VISUAL_EFFECTS = "ve";
    public static final String VAL_SERIES_EFFECT_GRADIENT = "g";
    public static final String VAL_SERIES_EFFECT_COLOR = "c";
    public static final String ATTR_PIE_FEELER_COLOR = "pfc";
    public static final String ATTR_SLICE_LABEL_TYPE = "slt";
    public static final String ATTR_SLICE_LABEL_POSITION = "slp";
    public static final String VAL_SLICE_LABEL_TYPE_VALUE = "v";
    public static final String VAL_SLICE_LABEL_TYPE_PERCENT = "p";
    public static final String VAL_SLICE_LABEL_TYPE_TEXT = "t";
    public static final String VAL_SLICE_LABEL_TYPE_TEXT_PERCENT = "tp";
    public static final String VAL_SLICE_LABEL_TYPE_TEXT_VALUE = "tv";
    public static final String VAL_SLICE_LABEL_TYPE_CUSTOM_TEXT = "ct";
    public static final String VAL_SLICE_LABEL_POSITION_INSIDE = "i";
    public static final String VAL_SLICE_LABEL_POSITION_OUTSIDE_WITHOUT_FEELER = "o";
    public static final String VAL_SLICE_LABEL_POSITION_OUTSIDE_WITH_FEELER = "of";
    public static final String VAL_SLICE_LABEL_POSITION_OUTSIDE_FEELER_IF_NEEDED = "ofin";
    public static final String VAL_SLICE_LABEL_POSITION_NO_LABELS = "n";
    public static final String ATTR_FLASH_BIDI_TEXT = "fbt";
    public static final String ID_SCROLLABLE_LEGEND = "scrollableLegend";
    public static final String URL_SM_DRILL_UP_ARROW = "/bi/images/graph/graph_drill_up.gif";
    public static final String URL_LG_DRILL_UP_ARROW = "/bi/images/graph/large_drill_up.gif";
    public static final String OBJ_LINE_MARKER = "LM";
    private static final String ATTR_XVALUE = "X";
    public static final String ATTR_XVALUE_LABELS = "XL";
    private static final String ATTR_YVALUE = "Y";
    public static final String ATTR_YVALUE_LABELS = "YL";
    private static final String ATTR_ZVALUE = "Z";
    public static final String ATTR_ZVALUE_LABELS = "ZL";
    private static final String ATTR_CUMULATIVE_STACKED_VALUE = "CUMSTKV";
    private static final String ATTR_CUMULATIVE_PERCENT_VALUE = "CUMPCTV";
    private static final String ATTR_PIE_PERCENT_VALUE = "PIEPCTV";
    private static final String ATTR_HILO_HIGH_VALUE = "HV";
    private static final String ATTR_HILO_LOW_VALUE = "LV";
    private static final String ATTR_HILO_OPEN_VALUE = "OV";
    private static final String ATTR_HILO_CLOSE_VALUE = "CV";
    private static final String ATTR_HILO_VOLUME_VALUE = "VV";
    private static final String ATTR_FUNNEL_ACTUAL_VALUE = "AV";
    private static final String ATTR_FUNNEL_TARGET_VALUE = "TV";
    private static final String ATTR_FUNNEL_UNFORMATTED_ACTUAL_VALUE = "AUV";
    private static final String ATTR_FUNNEL_UNFORMATTED_TARGET_VALUE = "TUV";
    private static final String ATTR_X_MEMBER = "XM";
    private static final String ATTR_Y_MEMBER = "YM";
    private static final String ATTR_Z_MEMBER = "ZM";
    private static final String ATTR_HILO_HIGH_MEMBER = "HM";
    private static final String ATTR_HILO_LOW_MEMBER = "LM";
    private static final String ATTR_HILO_OPEN_MEMBER = "OM";
    private static final String ATTR_HILO_CLOSE_MEMBER = "CM";
    public static final String ATTR_AL_SHAPE = "ums";
    public static final String ATTR_AL_COLOR = "umc";
    private static final String ATTR_C = "c";
    private static final String ATTR_B = "b";
    private static final String NULL_VALUE_PLACEHOLDER = "NaN";
    private static final int NORMAL = 0;
    private static final int HOVER = 1;
    private static final int ACTIVE = 2;
    protected CommonGraph m_graph;
    protected JChart_Base m_chart;
    protected int m_graphType;
    private String m_tooltipTemplate;
    private DataFormat m_dataFormat;
    private boolean m_bSeriesMacros = false;
    private boolean m_bGroupMacros = false;
    private HashMap<String, StringBuilder> m_dataBlockMap;
    private ArrayList<String> m_viewFormatList;
    private boolean m_bCumulativeStackedValue = false;
    private boolean m_bCumulativePercentageValue = false;
    private boolean m_bPiePercentValue = false;
    private boolean m_bHiloHighValue = false;
    private boolean m_bHiloLowValue = false;
    private boolean m_bHiloOpenValue = false;
    private boolean m_bHiloCloseValue = false;
    private boolean m_bHiloVolumeValue = false;
    private boolean m_bXMember = false;
    private boolean m_bYMember = false;
    private boolean m_bZMember = false;
    private boolean m_bHiloHighMember = false;
    private boolean m_bHiloLowMember = false;
    private boolean m_bHiloOpenMember = false;
    private boolean m_bHiloCloseMember = false;
    private boolean m_bMemberMacros = false;

    public GraphExportXMLWriter(CommonGraph cg, OutputStream os, ErrorHandler eh, String charEnc) {
        super(os, eh, charEnc);
        this.m_graph = cg;
        this.init(cg.getPFJ());
    }

    public GraphExportXMLWriter(CommonGraph cg, OutputStream os, ErrorHandler eh) {
        super(os, eh);
        this.m_graph = cg;
        this.init(cg.getPFJ());
    }

    public GraphExportXMLWriter(CommonGraph cg, Writer writer, ErrorHandler eh, String charEnc) {
        super(writer, eh, charEnc);
        this.m_graph = cg;
        this.init(cg.getPFJ());
    }

    public GraphExportXMLWriter(CommonGraph cg, Writer writer, ErrorHandler eh) {
        super(writer, eh);
        this.m_graph = cg;
        this.init(cg.getPFJ());
    }

    protected void init(Perspective p) {
        this.m_pfj = p;
        this.m_chart = this.m_pfj.getGraphObject();
        this.m_graphType = this.m_pfj.getGraphType();
        this.m_tooltipTemplate = null;
        JGraphType aGraphType = this.m_pfj.getJGraphType();
        this.m_dataFormat = aGraphType.getDataFormat();
        this.m_xmlCallback = this.m_graph.getXMLWriterCallback();
        this.initXMLWriterCallback(this.m_xmlCallback);
    }

    public void init(DetObj detObj) {
        this.m_detObj = detObj;
        this.m_bElementFilled = false;
        if (this.m_xmlCallback != null) {
            int series = this.m_detObj.getSeriesID();
            this.m_xmlCallback.setSeriesIndex(series);
            int group = this.m_detObj.getGroupID();
            this.m_xmlCallback.setGroupIndex(group);
            int objId = this.m_detObj.getObjectID();
            if (objId == 258 || objId == 318 || objId == 317 || objId == 8 || objId == 10 || objId == 6 || objId == 7 || objId == 298 || objId == 74) {
                this.m_xmlCallback.setObjectID(objId);
            }
        }
    }

    public String getDataZoomInRectSubmitJS() {
        if (this.m_xmlCallback != null) {
            String[][] params = GraphEventParams.getZoomInRectParams(this.m_xmlCallback.getId());
            return this.generateEvent(params);
        }
        return null;
    }

    public String getDataZoomOutRectSubmitJS() {
        if (this.m_xmlCallback != null) {
            String[][] params = GraphEventParams.getZoomOutRectParams(this.m_xmlCallback.getId());
            return this.generateEvent(params);
        }
        return null;
    }

    public String getDataZoomInClickSubmitJS() {
        if (this.m_xmlCallback != null) {
            String[][] params = GraphEventParams.getZoomInClickParams(this.m_xmlCallback.getId());
            return this.generateEvent(params);
        }
        return null;
    }

    public String getDataZoomOutClickSubmitJS() {
        if (this.m_xmlCallback != null) {
            String[][] params = GraphEventParams.getZoomOutClickParams(this.m_xmlCallback.getId());
            return this.generateEvent(params);
        }
        return null;
    }

    public String getDataZoomInButtonSubmitJS(String axis) {
        if (this.m_xmlCallback != null) {
            String[][] params = GraphEventParams.getZoomInButtonParams(this.m_xmlCallback.getId(), axis);
            return this.generateEvent(params);
        }
        return null;
    }

    public String getDataZoomOutButtonSubmitJS(String axis) {
        if (this.m_xmlCallback != null) {
            String[][] params = GraphEventParams.getZoomOutButtonParams(this.m_xmlCallback.getId(), axis);
            return this.generateEvent(params);
        }
        return null;
    }

    public String getSelectionJS() {
        if (this.m_xmlCallback != null) {
            String[][] params = GraphEventParams.getSelectionParams(this.m_xmlCallback.getId());
            return this.generateEvent(params);
        }
        return null;
    }

    public String getDataScrollSubmitJS(String axis) {
        return null;
    }

    public String getDataScrollbarZoomSubmitJS(String axis) {
        if (this.m_xmlCallback != null) {
            String[][] params = GraphEventParams.getScrollParams(this.m_xmlCallback.getId(), axis);
            return this.generateEvent(params);
        }
        return null;
    }

    public String getDrillJS(DetObj detObj) {
        return null;
    }

    public String getDrillTooltip(DetObj detObj) {
        return null;
    }

    public String getLineSelectPointSubmitJS() {
        return null;
    }

    public String getTimeAxisEventSubmitJS() {
        return null;
    }

    public String getTimeSelectorSubmitJS() {
        if (this.m_xmlCallback != null) {
            String[][] params = GraphEventParams.getTimeSelectorParams(this.m_xmlCallback.getId());
            return this.generateEvent(params);
        }
        return null;
    }

    @Override
    protected Locale getLocale() {
        return this.m_graph.getLocale();
    }

    public boolean startGraphElement() throws IOException, Exception {
        this.startElement(ELEM_GRAPH);
        Dimension rSize = this.m_pfj.getImageSize();
        this.writeAttribute("w", rSize.width);
        this.writeAttribute("h", rSize.height);
        this.writeAttribute(ATTR_GRAPH_TYPE, CommonGraph.convertGraphTypeToString(this.m_pfj.getGraphType()));
        if (!this.m_pfj.isFunnel()) {
            Object sSeriesRolloverBehavior = "";
            int seriesRolloverBehavior = this.m_pfj.getIntegerProp(Attr.SeriesRolloverBehavior);
            if ((seriesRolloverBehavior & 1) == 1) {
                sSeriesRolloverBehavior = (String)sSeriesRolloverBehavior + "RB_HIGHLIGHT";
            }
            if ((seriesRolloverBehavior & 2) == 2) {
                if (((String)sSeriesRolloverBehavior).length() > 0) {
                    sSeriesRolloverBehavior = (String)sSeriesRolloverBehavior + " ";
                }
                sSeriesRolloverBehavior = (String)sSeriesRolloverBehavior + "RB_DIM";
            }
            if (sSeriesRolloverBehavior != null && ((String)sSeriesRolloverBehavior).length() > 0) {
                this.writeAttribute(ATTR_SERIES_ROLLOVER_BEHAVIOR, (String)sSeriesRolloverBehavior);
            }
        }
        this.writeSelectionAttributes();
        int zoomAndScroll = this.m_pfj.getZoomAndScroll();
        if (zoomAndScroll == 0) {
            this.writeAttribute(ATTR_ZOOM_AND_SCROLL, "ZS_LIVE_SCROLL");
        } else if (zoomAndScroll == 1) {
            this.writeAttribute(ATTR_ZOOM_AND_SCROLL, "ZS_DELAYED_SCROLL");
        }
        if (this.m_pfj.getZoomAndScroll() == 0 && (this.m_pfj.getHorzRangeSlider() != null && this.m_pfj.getHorzRangeSlider().getZoomRatio() != 1.0 || this.m_pfj.getY1RangeSlider() != null && this.m_pfj.getY1RangeSlider().getZoomRatio() != 1.0 || this.m_pfj.getY2RangeSlider() != null && this.m_pfj.getY2RangeSlider().getZoomRatio() != 1.0)) {
            this.writeAttribute(ATTR_PAN_SCROLLING, VAL_SLICE_LABEL_TYPE_TEXT);
        }
        if ((this.isActiveDataService() || this.isPPRAnimation()) && this.m_pfj.getBarShape() == 0) {
            this.writeAttribute("ads", "on");
        }
        this.writeAnimationAttributes();
        if (this.m_pfj.getDepthRadius() > 0 && this.m_pfj.getDepthAngle() > 0) {
            this.writeAttribute(ATTR_THREED_EFFECT, VAL_SLICE_LABEL_TYPE_TEXT);
        }
        if (this.m_pfj.getVisualEffects() != 0) {
            this.writeAttribute(ATTR_VISUAL_EFFECTS, VAL_SLICE_LABEL_TYPE_TEXT);
        }
        if (this.m_graph.getSeriesEffect() == 0) {
            this.writeAttribute(ATTR_SERIES_EFFECT, "c");
        } else {
            this.writeAttribute(ATTR_SERIES_EFFECT, VAL_SERIES_EFFECT_GRADIENT);
        }
        if (this.m_graph.getInteractiveSliceBehavior().contains((Object)GraphConstants.InteractiveSliceBehavior.EXPLODE)) {
            this.writeAttribute(PIE_SLICE_EXPLODE_INTERACTIVITY, VAL_SLICE_LABEL_TYPE_TEXT);
        }
        if (this.m_graph.getInteractiveSliceBehavior().contains((Object)GraphConstants.InteractiveSliceBehavior.EXPLODE_ALL)) {
            String explodeAll = this.m_graph.getIntlString("af_dvt_graph.PIE_EXPLODE_ALL");
            String uniteAll = this.m_graph.getIntlString("af_dvt_graph.PIE_UNITE_ALL");
            this.writeAttribute(PIE_SLICE_EXPLODE_ALL_INTERACTIVITY, explodeAll + ";" + uniteAll);
        }
        if (this.m_pfj.getFlashBidiText()) {
            this.writeAttribute(ATTR_FLASH_BIDI_TEXT, VAL_SLICE_LABEL_TYPE_TEXT);
        }
        return true;
    }

    protected void endGraphElement() throws IOException, Exception {
        this.endElement();
    }

    public boolean startHandleElem(String id, Rectangle clipRect, Rectangle boundRect) throws IOException, Exception {
        StringBuffer r;
        this.startElement("h");
        this.writeAttribute("id", id);
        if (clipRect != null) {
            r = new StringBuffer().append(clipRect.x).append(',').append(clipRect.y).append(',').append(clipRect.width).append(',').append(clipRect.height);
            this.writeAttribute("c", r.toString());
        }
        if (boundRect != null) {
            r = new StringBuffer().append(boundRect.x).append(',').append(boundRect.y).append(',').append(boundRect.x + boundRect.width).append(',').append(boundRect.y + boundRect.height);
            this.writeAttribute(ATTR_B, r.toString());
        }
        return true;
    }

    protected void writeDataCursor() throws IOException, Exception {
        Set keys;
        HashMap<String, String> attrs = new HashMap<String, String>();
        boolean forceOff = false;
        if (0 == this.m_graph.getMarkerTooltipType()) {
            forceOff = true;
        }
        GraphConstants.DataCursor dataCursor = this.m_pfj.getDataCursor();
        if (forceOff) {
            attrs.put("display", GraphConstants.DataCursor.OFF.toString());
        } else if (!Attr.DataCursor.getDefault().equals((Object)dataCursor)) {
            attrs.put("display", dataCursor.toString());
        }
        GraphConstants.DataCursorBehavior dataCursorBehavior = this.m_pfj.getDataCursorBehavior();
        if (!Attr.DataCursorBehavior.getDefault().equals((Object)dataCursorBehavior)) {
            attrs.put(ATTR_DATA_CURSOR_BEHAVIOR, dataCursorBehavior.toString());
        }
        Color lineColor = this.m_graph.getDataCursorLineFillColor();
        if (!Attr.DataCursorLineFillColor.getDefault().equals(lineColor)) {
            attrs.put(ATTR_DATA_CURSOR_LINE_FILL_COLOR, GraphExportXMLWriter.colorToHex(lineColor));
        }
        if ((keys = attrs.keySet()).size() > 0) {
            this.startElement(ATTR_DATA_CURSOR);
            for (String key : keys) {
                this.writeAttribute(key, (String)attrs.get(key));
            }
            this.endElement();
        }
    }

    protected void writeMagnifyLens() throws IOException, Exception {
        Set keys;
        GraphConstants.MagnifyLens magnifyLens = this.m_pfj.getMagnifyLens();
        HashMap<String, String> attrs = new HashMap<String, String>();
        Color borderColor = this.m_graph.getMagnifyLensRimFillColor();
        if (!Attr.MagnifyLens.getDefault().equals((Object)magnifyLens)) {
            attrs.put("display", magnifyLens.toString());
        }
        if (!Attr.MagnifyLensRimFillColor.getDefault().equals(borderColor)) {
            attrs.put(ATTR_MAGNIFY_LENS_RIM_FILL_COLOR, GraphExportXMLWriter.colorToHex(borderColor));
        }
        if ((keys = attrs.keySet()).size() > 0) {
            this.startElement(ATTR_MAGNIFY_LENS);
            for (String key : keys) {
                this.writeAttribute(key, (String)attrs.get(key));
            }
            this.endElement();
        }
    }

    protected void writeToolTipFormatting() throws IOException, Exception {
        Color dtFillColor;
        IdentObj toolTipIdentObj = this.m_pfj.getToolTip();
        Integer ha = (Integer)this.m_pfj.getTextJustHorizObj(toolTipIdentObj, false);
        String fontString = this.getFontString(toolTipIdentObj);
        int halign = -1;
        if (ha != null) {
            if (ha == 0 || ha == 2 || ha == 4) {
                halign = ha;
            }
        } else if (this.isBIDILocale()) {
            halign = 4;
        }
        boolean alignmentExist = halign != -1;
        Color fillColor = this.m_pfj.getFillColor(this.m_pfj.getToolTipFrame(), false);
        if (alignmentExist || fontString != null || fillColor != null) {
            int fid = 0;
            if (fontString != null) {
                fid = this.getFontID(fontString);
            }
            this.startElement("ttf");
            if (fontString != null) {
                this.writeFontIndexAttribute(fid);
            }
            if (fillColor != null) {
                this.writeAttribute("fc", fillColor);
            }
            if (alignmentExist) {
                if (halign == 0) {
                    this.writeCachedAttribute("j", "c", null);
                } else if (halign == 4) {
                    this.writeCachedAttribute("j", "r", null);
                } else if (halign == 2) {
                    this.writeCachedAttribute("j", ATTR_PIE_SLICE_LABEL_CUSTOM_TEXT, null);
                }
            }
            this.endElement();
        }
        if ((dtFillColor = this.m_pfj.getFillColor(this.m_pfj.getDataTip(), false)) != null) {
            this.startElement("dtf");
            if (dtFillColor != null) {
                this.writeAttribute("fc", dtFillColor);
            }
            this.endElement();
        }
    }

    private String getFontString(IdentObj identObj) {
        boolean fontNodeExist;
        String fontName = this.m_pfj.getFontName(identObj, false);
        Integer fontSize = (Integer)this.m_pfj.getFontSizeObj(identObj, false);
        Color fontColor = this.m_pfj.getFillColor(identObj, false);
        Integer fontStyle = (Integer)this.m_pfj.getFontStyleObj(identObj, false);
        Font font = null;
        boolean bl = fontNodeExist = fontName != null || fontSize != null || fontColor != null || fontStyle != null;
        if (!fontNodeExist) {
            return null;
        }
        if (fontName == null) {
            fontName = this.m_pfj.getFontName(identObj, true);
        }
        if (fontSize == null) {
            fontSize = (Integer)this.m_pfj.getFontSizeObj(identObj, true);
        }
        if (fontColor == null) {
            fontColor = this.m_pfj.getFillColor(identObj, true);
        }
        if (fontColor == null) {
            fontColor = Color.black;
        }
        if (fontStyle == null) {
            fontStyle = (Integer)this.m_pfj.getFontStyleObj(identObj, true);
        }
        font = new Font(fontName, TextStyleObj.getStyleBI(fontStyle), fontSize);
        String fontString = GraphExportXMLWriter.getFontAttributes(font, fontColor, (fontStyle & 4) != 0, this.m_eh);
        return fontString;
    }

    protected void writeRangeSliderStyle() throws IOException, Exception {
        Color normC = this.m_pfj.getFillColor(this.m_pfj.getRangeSliderTheme(0), false);
        Color hovC = this.m_pfj.getFillColor(this.m_pfj.getRangeSliderTheme(1), false);
        Color actC = this.m_pfj.getFillColor(this.m_pfj.getRangeSliderTheme(2), false);
        if (normC != null || hovC != null || actC != null) {
            this.startElement(ELEM_RANGE_SLIDER_STYLE);
            if (normC != null) {
                this.writeAttribute(ELEM_RANGE_SLIDER_STATE_NORMAL, normC);
            }
            if (hovC != null) {
                this.writeAttribute(ELEM_RANGE_SLIDER_STATE_HOVER, hovC);
            }
            if (actC != null) {
                this.writeAttribute(ELEM_RANGE_SLIDER_STATE_ACTIVE, actC);
            }
            this.endElement();
        }
    }

    protected void writeGraphDataBlock() throws IOException, Exception {
        this.startElement("data");
        this.writeSeriesAndGroupAttributes();
        this.endElement();
    }

    protected void writeGraphXMLMetadata() throws IOException, Exception {
        this.startElement("md");
        if (this.m_pfj.isY1AxisPresent()) {
            RelativeAxisObj y1Axis;
            double maxVal;
            double minVal;
            double baselineVal = this.m_graph.getY1BaseLine().getValue();
            RangeSlider y1RS = this.m_pfj.getY1RangeSlider();
            if (this.m_pfj.getZoomAndScroll() == 0 && y1RS != null) {
                minVal = y1RS.getZoomMin();
                maxVal = y1RS.getZoomMax();
            } else {
                minVal = this.m_pfj.getY1ScaleMin();
                maxVal = this.m_pfj.getY1ScaleMax();
            }
            StringBuilder sb = DataviewUtils.getSharedStringBuilder();
            sb.append(baselineVal).append(',').append(minVal).append(',').append(maxVal);
            this.writeAttribute(ATTR_Y1_VALS, sb.toString());
            JChart_Base chart = this.m_pfj.getGraphObject();
            if (chart instanceof JChart_2D_Standard && (y1Axis = ((JChart_2D_Standard)chart).getY1Axis()) != null) {
                double baseline = this.m_pfj.getVC().virtToDestY(y1Axis.getValueCoord(baselineVal));
                double minCoord = this.m_pfj.getVC().virtToDestY(y1Axis.getMinCoord());
                double maxCoord = this.m_pfj.getVC().virtToDestY(y1Axis.getMaxCoord());
                sb = DataviewUtils.getSharedStringBuilder();
                sb.append(baseline).append(',').append(minCoord).append(',').append(maxCoord);
                this.writeAttribute(ATTR_Y1_COORDS, sb.toString());
            }
        }
        if (this.m_pfj.isX1AxisPresent() && (this.m_pfj.isChartBubble() || this.m_pfj.isChartScatter())) {
            RelativeAxisObj x1Axis;
            double maxVal;
            double minVal;
            RangeSlider x1RS = this.m_pfj.getHorzRangeSlider();
            if (this.m_pfj.getZoomAndScroll() == 0 && x1RS != null) {
                minVal = x1RS.getZoomMin();
                maxVal = x1RS.getZoomMax();
            } else {
                minVal = this.m_pfj.getX1ScaleMin();
                maxVal = this.m_pfj.getX1ScaleMax();
            }
            StringBuilder sb = DataviewUtils.getSharedStringBuilder();
            sb.append(minVal).append(',').append(maxVal);
            this.writeAttribute(ATTR_X1_VALS, sb.toString());
            JChart_Base chart = this.m_pfj.getGraphObject();
            if (chart instanceof JChart_2D_Standard && (x1Axis = ((JChart_2D_Standard)chart).getX1Axis()) != null) {
                double minCoord = this.m_pfj.getVC().virtToDestX(x1Axis.getMinCoord());
                double maxCoord = this.m_pfj.getVC().virtToDestX(x1Axis.getMaxCoord());
                sb = DataviewUtils.getSharedStringBuilder();
                sb.append(minCoord).append(',').append(maxCoord);
                this.writeAttribute(ATTR_X1_COORDS, sb.toString());
            }
        }
        if (this.m_graph.getGraphType() == 55) {
            Color feelerColor = this.m_graph.getPieFeeler().getLineColor();
            this.writeAttribute(ATTR_PIE_FEELER_COLOR, feelerColor);
            int textType = this.m_graph.getSliceLabel().getTextType();
            if (this.m_graph.getCustomMarkerTextCallback() != null || this.m_pfj.getZeroLabelDisplay()) {
                this.writeAttribute(ATTR_SLICE_LABEL_TYPE, VAL_SLICE_LABEL_TYPE_CUSTOM_TEXT);
            } else if (textType == 0) {
                this.writeAttribute(ATTR_SLICE_LABEL_TYPE, VAL_SLICE_LABEL_TYPE_VALUE);
            } else if (textType == 1) {
                this.writeAttribute(ATTR_SLICE_LABEL_TYPE, VAL_SLICE_LABEL_TYPE_PERCENT);
            } else if (textType == 2) {
                this.writeAttribute(ATTR_SLICE_LABEL_TYPE, VAL_SLICE_LABEL_TYPE_TEXT);
            } else if (textType == 3) {
                this.writeAttribute(ATTR_SLICE_LABEL_TYPE, VAL_SLICE_LABEL_TYPE_TEXT_PERCENT);
            } else if (textType == 4) {
                this.writeAttribute(ATTR_SLICE_LABEL_TYPE, VAL_SLICE_LABEL_TYPE_TEXT_VALUE);
            }
            int labelPosition = this.m_graph.getSlice().getLabelPosition();
            boolean labelRendered = this.m_graph.getSliceLabel().isVisible();
            if (!labelRendered || labelPosition == 0) {
                this.writeAttribute(ATTR_SLICE_LABEL_POSITION, VAL_SLICE_LABEL_POSITION_NO_LABELS);
            } else if (labelPosition == 1) {
                this.writeAttribute(ATTR_SLICE_LABEL_POSITION, VAL_SLICE_LABEL_POSITION_OUTSIDE_WITH_FEELER);
            } else if (labelPosition == 3) {
                this.writeAttribute(ATTR_SLICE_LABEL_POSITION, VAL_SLICE_LABEL_POSITION_INSIDE);
            } else if (labelPosition == 2) {
                this.writeAttribute(ATTR_SLICE_LABEL_POSITION, VAL_SLICE_LABEL_POSITION_OUTSIDE_WITHOUT_FEELER);
            } else if (labelPosition == 4) {
                this.writeAttribute(ATTR_SLICE_LABEL_POSITION, VAL_SLICE_LABEL_POSITION_OUTSIDE_FEELER_IF_NEEDED);
            }
        }
        this.m_viewFormatList = new ArrayList();
        if (this.m_chart instanceof JChart_2D_Pie) {
            this.writeViewFormatAttribute(5);
        }
        this.writeTooltipTemplate();
        this.writeLayersAttributes();
        this.writeAdditionalMetadata();
        this.endElement();
        this.writeGraphDataBlock();
    }

    @Override
    public boolean startTextElement(int x, int y, int len) throws IOException, Exception {
        boolean ret = super.startTextElement(x, y, len);
        if (ret) {
            this.writeCachedAttribute(ATTR_TOOLTIP_TEMPLATE, "f", null);
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point2D a, Point2D b) throws IOException, Exception {
        boolean ret = false;
        if (!bb.getTransparentBorderColor() && (ret = a instanceof Point && b instanceof Point ? this.startLineElement(((Point)a).x, ((Point)a).y, ((Point)b).x, ((Point)b).y) : this.startLineElement(a.getX(), a.getY(), b.getX(), b.getY()))) {
            this.writeIdentObjAttributes(id);
            this.writeCachedAttribute("c", bb.getBorderColor(), ATTR_PIE_SLICE_LABEL_CUSTOM_TEXT);
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point2D a, Point2D b, int nThick, int style, boolean isMarker) throws IOException, Exception {
        boolean ret = false;
        String sStyle = null;
        if (style != 0) {
            sStyle = BaseGraphComponent.convertLineStyleToString(style);
            if (style == 1) {
                if (isMarker) {
                    nThick = 2;
                }
            } else if (style == 2) {
                if (isMarker) {
                    nThick = 2;
                }
                if (nThick <= 1) {
                    nThick = 2;
                }
            } else if (style == 3 && isMarker) {
                nThick = 2;
            }
        }
        if (!bb.getTransparentBorderColor()) {
            ret = a instanceof Point && b instanceof Point ? this.startLineElement(((Point)a).x, ((Point)a).y, ((Point)b).x, ((Point)b).y) : this.startLineElement(a.getX(), a.getY(), b.getX(), b.getY());
            if (ret) {
                this.writeCachedAttribute("c", bb.getBorderColor(), ATTR_PIE_SLICE_LABEL_CUSTOM_TEXT);
            }
        } else if (!bb.getTransparentFillColor() && (ret = a instanceof Point && b instanceof Point ? this.startLineElement(((Point)a).x, ((Point)a).y, ((Point)b).x, ((Point)b).y) : this.startLineElement(a.getX(), a.getY(), b.getX(), b.getY()))) {
            this.writeCachedAttribute("c", bb.getFillColor(), ATTR_PIE_SLICE_LABEL_CUSTOM_TEXT);
        }
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (nThick != 1) {
                this.writeAttribute("lw", nThick);
            }
            if (sStyle != null) {
                this.writeAttribute("ls", sStyle);
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle rect, int type) throws IOException, Exception {
        boolean ret = false;
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (type == 2) {
            x1 = rect.x;
            y1 = rect.y + rect.height;
            x2 = rect.x + rect.width;
            y2 = y1;
        } else if (type == 1) {
            x1 = rect.x;
            y1 = rect.y;
            x2 = x1 + rect.width;
            y2 = y1;
        } else if (type == 3) {
            x1 = rect.x;
            y1 = rect.y;
            x2 = rect.x;
            y2 = rect.y + rect.height;
        } else if (type == 4) {
            x1 = rect.x + rect.width;
            y1 = rect.y;
            x2 = x1;
            y2 = rect.y + rect.height;
        }
        if (!bb.getTransparentBorderColor()) {
            ret = this.startLineElement(x1, y1, x2, y2);
            if (ret) {
                this.writeIdentObjAttributes(id);
                this.writeCachedAttribute("c", bb.getBorderColor(), ATTR_PIE_SLICE_LABEL_CUSTOM_TEXT);
            }
        } else if (!bb.getTransparentFillColor() && (ret = this.startLineElement(x1, y1, x2, y2))) {
            this.writeIdentObjAttributes(id);
            this.writeCachedAttribute("c", bb.getFillColor(), ATTR_PIE_SLICE_LABEL_CUSTOM_TEXT);
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r) throws IOException, Exception {
        return this.startElement(id, bb, r, false, false);
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r, boolean bOval, boolean bNoFill) throws IOException, Exception {
        return this.startElement(id, bb, r, bOval, bNoFill, false);
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r, boolean bOval, boolean bNoFill, boolean bDotted) throws IOException, Exception {
        boolean ret = false;
        if (bb.getDropShadowOffset() != null) {
            Rectangle rDropShadow = new Rectangle(r.x + bb.getDropShadowOffset().width, r.y + bb.getDropShadowOffset().height, r.width, r.height);
            if (bOval) {
                if (this.startCircleOrOvalElement(rDropShadow)) {
                    this.writeCachedAttribute("fc", bb.getDropShadowColor(), null);
                    this.endElement();
                }
            } else if (this.startRectElement(rDropShadow)) {
                this.writeCachedAttribute("fc", bb.getDropShadowColor(), null);
                this.endElement();
            }
        }
        if (bOval) {
            boolean bTransparentBorder = bb.getTransparentBorderColor();
            boolean bTransparentFill = bb.getTransparentFillColor() || bNoFill;
            ret = this.startCircleOrOvalElement(r);
            if (ret) {
                this.writeIdentObjAttributes(id);
                if (!bTransparentBorder) {
                    this.writeAttribute("bc", bb.getBorderColor());
                }
                if (!bTransparentFill) {
                    this.writeFillAttributes(id, bb, r);
                } else {
                    this.writeCachedAttribute("ft", "ftC", null);
                    this.writeCachedAttribute("fc", "", null);
                }
            }
        } else {
            boolean bTransparentBorder = bb.getTransparentBorderColor();
            boolean bTransparentFill = bb.getTransparentFillColor() || bNoFill;
            ret = this.startRectElement(r);
            if (ret) {
                this.writeIdentObjAttributes(id);
                if (bb.isHidden()) {
                    this.writeAttribute(VAL_SLICE_LABEL_TYPE_VALUE, "h");
                }
                if (!bTransparentFill) {
                    this.writeFillAttributes(id, bb, r);
                } else {
                    this.writeCachedAttribute("ft", "ftC", null);
                    this.writeCachedAttribute("fc", "", null);
                }
                if (!bTransparentBorder) {
                    this.writeAttribute("bc", bb.getBorderColor());
                }
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r, boolean bOval, boolean bNoFill, int nWidth) throws IOException, Exception {
        boolean ret = false;
        if (bOval) {
            boolean bTransparentFill = bb.getTransparentFillColor() || bNoFill;
            boolean bTransparentBorder = bb.getTransparentBorderColor();
            ret = this.startCircleOrOvalElement(r);
            if (ret) {
                this.writeIdentObjAttributes(id);
                if (!bTransparentFill) {
                    this.writeFillAttributes(id, bb, r);
                } else {
                    this.writeCachedAttribute("ft", "ftC", null);
                    this.writeCachedAttribute("fc", "", null);
                }
                if (!bTransparentBorder) {
                    this.writeAttribute("bc", bb.getBorderColor());
                    if (nWidth > 1) {
                        this.writeAttribute("bw", nWidth);
                    }
                }
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Polygon p) throws IOException, Exception {
        boolean ret = false;
        if (bb.getDropShadowOffset() != null) {
            Polygon pDropShadow = new Polygon();
            for (int i = 0; i < p.npoints; ++i) {
                pDropShadow.addPoint(p.xpoints[i] + bb.getDropShadowOffset().width, p.ypoints[i] + bb.getDropShadowOffset().height);
            }
            if (this.startPolygonElement(pDropShadow)) {
                this.writeCachedAttribute("fc", bb.getDropShadowColor(), "pg");
                this.endElement();
            }
        }
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        ret = this.startPolygonElement(p);
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (!bTransparentFill) {
                this.writeFillAttributes(id, bb, p);
            } else {
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeCachedAttribute("fc", "", null);
            }
            if (!bTransparentBorder) {
                this.writeAttribute("bc", bb.getBorderColor());
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point[] points) throws IOException, Exception {
        boolean ret = false;
        if (!bb.getTransparentBorderColor() && (ret = this.startPolylineElement(points))) {
            this.writeIdentObjAttributes(id);
            this.writeCachedAttribute("c", bb.getBorderColor(), "pl");
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point[] points, int nThick, int style, boolean isMarker, boolean shadow) throws IOException, Exception {
        boolean ret = false;
        String sStyle = null;
        if (style != 0) {
            sStyle = BaseGraphComponent.convertLineStyleToString(style);
            if (style == 1) {
                if (isMarker) {
                    nThick = 2;
                }
            } else if (style == 2) {
                if (isMarker) {
                    nThick = 2;
                }
                if (nThick <= 1) {
                    nThick = 2;
                }
            } else if (style == 3 && isMarker) {
                nThick = 2;
            }
        }
        if (!bb.getTransparentBorderColor()) {
            ret = this.startPolylineElement(points);
            if (ret) {
                Color c = shadow ? GraphExportXMLWriter.getBrighter(bb.getBorderColor()) : bb.getBorderColor();
                this.writeCachedAttribute("c", c, "pl");
            }
        } else if (!bb.getTransparentFillColor() && (ret = this.startPolylineElement(points))) {
            Color c = shadow ? GraphExportXMLWriter.getBrighter(bb.getFillColor()) : bb.getFillColor();
            this.writeCachedAttribute("c", c, "pl");
        }
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (nThick != 1) {
                this.writeAttribute("lw", nThick);
            }
            if (sStyle != null) {
                this.writeAttribute("ls", sStyle);
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Arc2D arc) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        if (arc != null) {
            ret = this.startCircleOrOvalElement(arc);
        }
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (!bTransparentFill) {
                this.writeFillAttributes(id, bb, arc);
            } else {
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeCachedAttribute("fc", "", null);
            }
            if (!bTransparentBorder) {
                this.writeAttribute("bc", bb.getBorderColor());
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Area area) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        ret = this.startPathElement(area);
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (!bTransparentFill) {
                this.writeFillAttributes(id, bb, area);
            } else {
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeCachedAttribute("fc", "", null);
            }
            if (!bTransparentBorder) {
                this.writeAttribute("bc", bb.getBorderColor());
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Ellipse2D ellipse) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        ret = this.startCircleOrOvalElement(ellipse.getBounds());
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (!bTransparentFill) {
                this.writeFillAttributes(id, bb, ellipse);
            } else {
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeCachedAttribute("fc", "", null);
            }
            if (!bTransparentBorder) {
                this.writeAttribute("bc", bb.getBorderColor());
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, GeneralPath path) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        ret = this.startPathElement(path);
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (!bTransparentFill) {
                this.writeFillAttributes(id, bb, path);
            } else {
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeCachedAttribute("fc", "", null);
            }
            if (!bTransparentBorder) {
                this.writeAttribute("bc", bb.getBorderColor());
            }
        }
        return ret;
    }

    @Concealed
    protected boolean useLineMarker() {
        return true;
    }

    public boolean startMarkerElement(IdentObj id, BlackBoxIF bb, String markerShape, List<Point> coords, List<Integer> sizes) throws IOException, Exception {
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        boolean bSelectionSupported = this.m_graph.getDataSelection() == GraphConstants.DataSelection.single || this.m_graph.getDataSelection() == GraphConstants.DataSelection.multiple;
        boolean bLineMarker = false;
        if (!bSelectionSupported && bTransparentFill && bTransparentBorder && ObjClassID.stripExceptionalOffset(id.getObjectID()) == 259 && !this.hasShapeAttributes() && this.m_tooltipTemplate != null && this.m_pfj.isChartBLAType() && !this.m_pfj.getCommonGraph().is3DEffect() && this.m_graph.getSeriesRolloverBehavior() == 0 && this.useLineMarker()) {
            bLineMarker = true;
        }
        if (bLineMarker) {
            this.startElement("lm");
        } else {
            this.startElement(ELEM_MARKER);
        }
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        for (Point pt : coords) {
            sb.append(pt.x).append(',').append(pt.y).append(',');
        }
        sb.setLength(sb.length() - 1);
        this.writeAttribute(VAL_SLICE_LABEL_TYPE_PERCENT, sb.toString());
        this.writeIdentObjAttributes(id);
        if (bLineMarker) {
            this.writeAttribute(ATTR_LINE_MARKER_SIZE, sizes.get(0));
            return true;
        }
        sb.setLength(0);
        sb.append(markerShape).append(',');
        if (this.m_pfj.isChartBubble()) {
            for (Integer size : sizes) {
                sb.append(size).append(',');
            }
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(sizes.get(0));
        }
        this.writeCachedAttribute(ATTR_MARKER_TYPE, sb.toString(), null);
        if (!bTransparentFill) {
            this.writeFillAttributes(id, bb, null);
        } else {
            this.writeCachedAttribute("ft", "ftC", null);
            this.writeCachedAttribute("fc", "", null);
        }
        if (!bTransparentBorder) {
            this.writeAttribute("bc", bb.getBorderColor());
        }
        return true;
    }

    public boolean startPieSliceElement(IdentObj id, BlackBoxIF bb, double explode, String customLabel) throws IOException, Exception {
        this.startElement("sl");
        this.writeAttribute(ATTR_PIE_SLICE_EXPLODE, explode);
        this.writeIdentObjAttributes(id);
        if (!bb.getTransparentFillColor()) {
            this.writeFillAttributes(id, bb, null);
        } else {
            this.writeCachedAttribute("ft", "ftC", null);
            this.writeCachedAttribute("fc", "", null);
        }
        if (!bb.getTransparentBorderColor()) {
            this.writeAttribute("bc", bb.getBorderColor());
        }
        if (this.m_pfj.getCustomMarkerTextCallback() != null || this.m_pfj.getZeroLabelDisplay()) {
            this.writeAttribute(ATTR_PIE_SLICE_LABEL_CUSTOM_TEXT, customLabel);
        }
        return true;
    }

    public void writeElement(IdentObj id, BlackBoxIF bb, Graphics g, String szText, Rectangle rBounds, Rectangle rInnerBounds, TextStyleObj textStyle, VC vc, String drillJS, String link, String[] tooltipsArray, String fullText) throws IOException, Exception {
        if (!bb.getTransparentFillColor()) {
            Color dropShadowColor = this.m_pfj.getShadowColor(id);
            Dimension dropShadowOffset = null;
            if (this.m_pfj.getShadowDisplay(id) && !bb.getTransparentFillColor()) {
                dropShadowOffset = new Dimension(this.m_pfj.getVC().virtToDestWidth(this.m_pfj.getShadowXOffset(id) * 50), this.m_pfj.getVC().virtToDestHeight(this.m_pfj.getShadowYOffset(id) * 50));
            }
            this.fillColorText(id, bb, g, szText, rBounds, rInnerBounds, dropShadowColor, dropShadowOffset, textStyle, vc, 1, drillJS, link, tooltipsArray, fullText);
        }
    }

    protected void fillColorText(IdentObj id, BlackBoxIF bb, Graphics g, String szText, Rectangle rBounds, Rectangle rInnerBounds, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, int nBackgroundFillType, String drillJS, String link, String[] tooltipsArray, String fullText) throws IOException, Exception {
        Color fillColor = bb.getFillColor();
        if (textStyle.getRotationAngle() == 0) {
            this.drawStyledText(id, textStyle, fillColor, g, szText, rInnerBounds, dropShadowColor, dropShadowOffset, vc, drillJS, link, tooltipsArray, fullText);
        } else {
            this.fillColorTextRotated(id, fillColor, g, szText, rInnerBounds, dropShadowColor, dropShadowOffset, textStyle, vc, nBackgroundFillType, drillJS, link, tooltipsArray, fullText);
        }
    }

    protected void fillColorTextRotated(IdentObj id, Color textColor, Graphics g, String szText, Rectangle rectBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, int nBackgroundFillType, String drillJS, String link, String[] tooltipsArray, String fullText) throws IOException, Exception {
        if (rectBoundsDC.width <= 0 || rectBoundsDC.height <= 0) {
            if (this.m_eh != null) {
                this.m_eh.log("invalid rectBoundsDC", this.getClass().getName(), "protected void fillColorTextRotated");
            }
            return;
        }
        Rectangle rTextDC = null;
        rTextDC = textStyle.getRotationAngle() == 270 || textStyle.getRotationAngle() == 90 ? new Rectangle(0, 0, rectBoundsDC.height, rectBoundsDC.width) : new Rectangle(0, 0, rectBoundsDC.height, rectBoundsDC.width);
        Rectangle rBoundsDC = new Rectangle(rectBoundsDC.x, rectBoundsDC.y, rectBoundsDC.width, rectBoundsDC.height);
        if (textStyle != null && textStyle.getWordWrap()) {
            Dimension dimTextDC = textStyle.preDraw(g, szText, rTextDC, vc, dropShadowOffset, this.m_pfj.getFontMetricsResolver());
            rTextDC.width = Math.max(rTextDC.width, dimTextDC.width);
            rTextDC.height = Math.max(rTextDC.height, dimTextDC.height);
        }
        if (rTextDC.width <= 1 || rTextDC.height <= 1) {
            if (this.m_eh != null) {
                this.m_eh.log("text bounds too small to draw", this.getClass().getName(), "protected void fillColorTextRotated");
            }
            return;
        }
        if (textStyle.getRotationAngle() == 270 || textStyle.getRotationAngle() == 90) {
            rBoundsDC.height = rTextDC.width;
            rBoundsDC.width = rTextDC.height;
        }
        int oldw = rBoundsDC.width;
        int oldh = rBoundsDC.height;
        if (textStyle.getRotationAngle() == 270 || textStyle.getRotationAngle() == 90) {
            int width = rBoundsDC.width;
            rBoundsDC.width = rBoundsDC.height;
            rBoundsDC.height = width;
            rBoundsDC.y = rBoundsDC.y + oldh / 2 - oldw / 2;
            rBoundsDC.x = rBoundsDC.x - oldh / 2 + oldw / 2;
        }
        int angle = textStyle.getRotationAngle();
        int cx = rBoundsDC.x + rBoundsDC.width / 2;
        int cy = rBoundsDC.y + rBoundsDC.height / 2;
        this.drawStyledText(id, textStyle, textColor, angle, cx, cy, g, szText, rBoundsDC, dropShadowColor, dropShadowOffset, vc, drillJS, link, tooltipsArray, fullText);
    }

    protected void drawStyledText(IdentObj id, TextStyleObj textStyleObj, Color textColor, Graphics gx, String strText, Rectangle rBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, VC vc, String drillJS, String link, String[] tooltipsArray, String fullText) throws IOException, Exception {
        this.drawStyledText(id, textStyleObj, textColor, 0.0, 0, 0, gx, strText, rBoundsDC, dropShadowColor, dropShadowOffset, vc, drillJS, link, tooltipsArray, fullText);
    }

    protected void drawStyledText(IdentObj id, TextStyleObj textStyleObj, Color textColor, double angle, int cx, int cy, Graphics gx, String strText, Rectangle rBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, VC vc, String drillJS, String link, String[] tooltipsArray, String fullText) throws IOException, Exception {
        int nFontSizeDC = textStyleObj.getFontSizeDC(vc);
        int nStyle = TextStyleObj.getStyleBI(textStyleObj.getFontStyle());
        Font font = textStyleObj.getFont(textStyleObj.getFontName(), nStyle, nFontSizeDC);
        FontMetrics fm = ImageViewExportXMLWriter.getFontMetrics(gx, font);
        Vector<String> strLines = new Vector<String>();
        int nNumLines = 1;
        if (textStyleObj.getWordWrap()) {
            nNumLines = textStyleObj.extractLinesWordWrap(strText, strLines, rBoundsDC.width, fm, this.m_pfj.getFontMetricsResolver());
        } else {
            strLines.addElement(strText);
        }
        Dimension dimThisLineDC = new Dimension(0, 0);
        Rectangle rTextBoundsDC = new Rectangle(rBoundsDC.x, rBoundsDC.y, rBoundsDC.width, rBoundsDC.height);
        Dimension dimMaxDC = new Dimension(rTextBoundsDC.width, rTextBoundsDC.height);
        for (int nLine = 0; nLine < nNumLines; ++nLine) {
            int fid;
            String fontString;
            String strThisLine = (String)strLines.elementAt(nLine);
            dimThisLineDC = textStyleObj.getTextSizeDC(gx, strThisLine, nFontSizeDC, vc, dimMaxDC, dropShadowOffset, false, this.m_pfj.getFontMetricsResolver());
            Point ptTextDC = textStyleObj.alignTextInBox(nLine, nNumLines, fm, rTextBoundsDC, dimThisLineDC, this.m_pfj);
            if (dropShadowOffset != null) {
                fontString = GraphExportXMLWriter.getFontAttributes(font, dropShadowColor, (textStyleObj.getFontStyle() & 4) != 0, this.m_eh);
                fid = this.getFontID(fontString);
                Point ptDropShadow = new Point(ptTextDC.x + dropShadowOffset.width, ptTextDC.y + dropShadowOffset.height);
                if (this.startTextElement(ptDropShadow.x, ptDropShadow.y, this.m_pfj.getFontMetricsResolver().stringWidth(strThisLine, fm))) {
                    int halign;
                    this.writeFontIndexAttribute(fid);
                    this.writeCachedAttribute("a", angle, null);
                    if (angle != 0.0) {
                        this.writeAttribute("cx", cx);
                        this.writeAttribute("cy", cy);
                    }
                    if ((halign = textStyleObj.getHorizAlign()) == 0) {
                        this.writeCachedAttribute("j", "c", null);
                    } else if (halign == 4) {
                        this.writeCachedAttribute("j", "r", null);
                    } else {
                        this.writeCachedAttribute("j", ATTR_PIE_SLICE_LABEL_CUSTOM_TEXT, null);
                    }
                    this.writeText(strThisLine);
                    this.endElement();
                } else if (this.m_eh != null) {
                    this.m_eh.log("could not start text element dropshadow", this.getClass().getName(), "protected void drawStyledText");
                }
            }
            if (textStyleObj.isDisplayDrillIcon()) {
                Image image = null;
                image = nFontSizeDC < 18 ? TextStyleObj.SMALL_DRILL_IMAGE : TextStyleObj.LARGE_DRILL_IMAGE;
                int imageSize = image.getWidth(null);
                this.startElement("img");
                this.writeAttribute("x", rTextBoundsDC.x);
                this.writeAttribute("y", rTextBoundsDC.y + (rTextBoundsDC.height - imageSize) / 2);
                this.writeAttribute("w", imageSize);
                this.writeAttribute("h", imageSize);
                String facesResourceURL = this.m_pfj.getFacesResourceURL();
                if (facesResourceURL == null) {
                    facesResourceURL = "";
                }
                if (nFontSizeDC < 18) {
                    this.writeAttribute("url", facesResourceURL + URL_SM_DRILL_UP_ARROW);
                } else {
                    this.writeAttribute("url", facesResourceURL + URL_LG_DRILL_UP_ARROW);
                }
                this.writeAdditionalTextInfo(id, drillJS, link, tooltipsArray, strThisLine, fullText);
                this.endElement();
                ptTextDC.x += imageSize + 2;
                dimThisLineDC.width -= imageSize + 2;
            }
            fontString = GraphExportXMLWriter.getFontAttributes(font, textColor, (textStyleObj.getFontStyle() & 4) != 0, this.m_eh);
            fid = this.getFontID(fontString);
            if (this.startTextElement(ptTextDC.x, ptTextDC.y, this.m_pfj.getFontMetricsResolver().stringWidth(strThisLine, fm))) {
                int halign;
                this.writeIdentObjAttributes(id);
                this.writeFontIndexAttribute(fid);
                this.writeCachedAttribute("a", angle, null);
                if (angle != 0.0) {
                    this.writeAttribute("cx", cx);
                    this.writeAttribute("cy", cy);
                }
                if ((halign = textStyleObj.getHorizAlign()) == 0) {
                    this.writeCachedAttribute("j", "c", null);
                } else if (halign == 4) {
                    this.writeCachedAttribute("j", "r", null);
                } else {
                    this.writeCachedAttribute("j", ATTR_PIE_SLICE_LABEL_CUSTOM_TEXT, null);
                }
                this.writeAdditionalTextInfo(id, drillJS, link, tooltipsArray, strThisLine, fullText);
                this.writeText(strThisLine);
                this.endElement();
                continue;
            }
            if (this.m_eh == null) continue;
            this.m_eh.log("could not start text element", this.getClass().getName(), "protected void drawStyledText");
        }
    }

    protected boolean isShowFullText(IdentObj id) {
        return false;
    }

    protected void writeAdditionalTextInfo(IdentObj id, String drillJS, String link, String[] tooltipsArray, String displayText, String fullText) throws IOException, Exception {
        if (drillJS != null && drillJS.length() > 0) {
            this.writeAttribute("drillJs", drillJS);
        }
        if (link != null && link.length() > 0) {
            this.writeAttribute("link", link);
        }
        if (!this.hasAlt() && tooltipsArray != null && tooltipsArray.length > 0) {
            this.writeTooltipAttribute(tooltipsArray);
        }
        if (this.isShowFullText(id) && displayText != null && !displayText.equals(fullText)) {
            this.writeAttribute("ut", fullText);
        }
        this.writeCustomPropertyAttribute();
        this.writeShapeAttributesElement();
        int graphID = this.m_pfj.getReferenceObjectGraphID(id.getObjectID());
        if (graphID != -1 && this.m_pfj.getReferenceObjectDisplay(graphID) == 2) {
            this.writeReferenceObjectsElement(id);
        }
    }

    protected void writeIdentObjAttributes(IdentObj identObj) throws IOException, Exception {
        List groupList;
        String s;
        int id = ObjClassID.stripExceptionalOffset(identObj.getObjectID());
        int group = identObj.getGroupID();
        int series = identObj.getSeriesID();
        int misc = identObj.getMiscID();
        int stack = identObj.getStackID();
        if (id == 339 || id == 340 || id == 341 || id == 342 || id == 336 || id == 626) {
            this.writeCachedAttribute("go", VAL_SLICE_LABEL_TYPE_TEXT, null);
        } else {
            this.writeCachedAttribute("go", "f", null);
        }
        if (id >= 0 && (s = this.convertObjectIdToString(identObj)) != null && s.length() > 0) {
            this.writeCachedAttribute("O", s, null);
        }
        String groupValue = null;
        Object gIdOverride = null;
        if (this.m_detObj != null && (id == 258 || id == 256) && (groupList = this.m_detObj.getGroupList()) != null) {
            int startGroup = this.m_pfj.getEffectiveGroupOffset();
            StringBuilder sb = DataviewUtils.getSharedStringBuilder();
            boolean bContinuousRange = false;
            int rangeStartGroup = -1;
            for (int gi = 0; gi < groupList.size(); ++gi) {
                Object nextGroupIObj;
                Object groupIObj = groupList.get(gi);
                if (groupIObj == null || !(groupIObj instanceof Integer)) continue;
                int groupIndex = (Integer)groupIObj;
                int nextGroupIndex = -1;
                if (gi + 1 < groupList.size() && (nextGroupIObj = groupList.get(gi + 1)) != null && nextGroupIObj instanceof Integer) {
                    nextGroupIndex = (Integer)nextGroupIObj;
                }
                if (!bContinuousRange) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    rangeStartGroup = groupIndex;
                    if (nextGroupIndex == groupIndex + 1) {
                        bContinuousRange = true;
                    }
                } else {
                    if (nextGroupIndex == groupIndex + 1) continue;
                    if (groupIndex - rangeStartGroup > 1) {
                        sb.append("-");
                    } else {
                        sb.append(",");
                    }
                    bContinuousRange = false;
                }
                sb.append(groupIndex - startGroup);
            }
            if (sb.length() > 0) {
                gIdOverride = "(" + sb.toString() + ")";
            }
        }
        if (gIdOverride != null) {
            groupValue = gIdOverride;
        } else if (group >= 0) {
            int[] missingGroups;
            int g = group;
            if (this.m_pfj.isTimeAxis() && (missingGroups = this.m_pfj.getMissingGroups()) != null) {
                int missingCount = 0;
                for (int k = 0; k < missingGroups.length; ++k) {
                    if (g < missingGroups[k]) continue;
                    ++missingCount;
                }
                g -= missingCount;
            }
            groupValue = Integer.toString(g);
        } else {
            groupValue = "";
        }
        this.writeCachedAttribute("G", groupValue, null);
        if (series >= 0) {
            this.writeCachedAttribute("S", series, (String)null);
        } else {
            this.writeCachedAttribute("S", "", null);
        }
        if (misc >= 0) {
            this.writeAttribute("M", misc);
        }
        if (stack >= 0) {
            this.writeAttribute("stId", stack);
        }
        if (this.m_tooltipTemplate != null && this.useTooltipTemplate(id)) {
            this.writeCachedAttribute(ATTR_TOOLTIP_TEMPLATE, VAL_SLICE_LABEL_TYPE_TEXT, null);
        }
    }

    protected void writeTooltipTemplate() throws IOException, Exception {
        ToolTipTextCallback tooltipCallback = this.m_pfj.getToolTipCallBack();
        if (tooltipCallback == null || tooltipCallback.getCustomToolTipCallback() != null) {
            return;
        }
        String template = tooltipCallback.getToolTipTemplate();
        if (template == null || template.length() == 0) {
            return;
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        ToolTips.CustomToolTipIntoLines(template, tooltip);
        this.m_tooltipTemplate = GraphExportXMLWriter._buildTooltipString(tooltip);
        this.m_tooltipTemplate = this.m_tooltipTemplate.replace("[SL]", "[S]");
        this.m_tooltipTemplate = this.m_tooltipTemplate.replace("[GL]", "[G]");
        this.m_tooltipTemplate = this.m_tooltipTemplate.replace("[XV]", "[X]");
        this.m_tooltipTemplate = this.m_tooltipTemplate.replace("[YV]", "[Y]");
        this.m_tooltipTemplate = this.m_tooltipTemplate.replace("[ZV]", "[Z]");
        this.m_bSeriesMacros = this.m_tooltipTemplate.contains("[S]");
        this.m_bGroupMacros = this.m_tooltipTemplate.contains("[G]");
        this.m_bCumulativeStackedValue = this.m_tooltipTemplate.contains("[CUMSTKV]");
        this.m_bCumulativePercentageValue = this.m_tooltipTemplate.contains("[CUMPCTV]");
        this.m_bPiePercentValue = this.m_tooltipTemplate.contains("[PIEPCTV]");
        this.m_bHiloHighValue = this.m_tooltipTemplate.contains("[HV]");
        this.m_bHiloLowValue = this.m_tooltipTemplate.contains("[LV]");
        this.m_bHiloOpenValue = this.m_tooltipTemplate.contains("[OV]");
        this.m_bHiloCloseValue = this.m_tooltipTemplate.contains("[CV]");
        this.m_bHiloVolumeValue = this.m_tooltipTemplate.contains("[VV]");
        this.m_bXMember = this.m_tooltipTemplate.contains("[XM]");
        this.m_bYMember = this.m_tooltipTemplate.contains("[YM]");
        this.m_bZMember = this.m_tooltipTemplate.contains("[ZM]");
        this.m_bHiloHighMember = this.m_tooltipTemplate.contains("[HM]");
        this.m_bHiloLowMember = this.m_tooltipTemplate.contains("[LM]");
        this.m_bHiloOpenMember = this.m_tooltipTemplate.contains("[OM]");
        this.m_bHiloCloseMember = this.m_tooltipTemplate.contains("[CM]");
        this.m_bMemberMacros = this.m_bXMember || this.m_bYMember || this.m_bZMember || this.m_bHiloOpenMember || this.m_bHiloCloseMember || this.m_bHiloHighMember || this.m_bHiloLowMember;
        this.writeAttribute(ATTR_TOOLTIP_TEMPLATE, this.m_tooltipTemplate);
    }

    protected void writeDataBlockAttributes() throws IOException, Exception {
        int[] missingGroups;
        this.m_viewFormatList = new ArrayList();
        if ((this.m_pfj.getGraphType() == 65 || this.m_pfj.isChartBubble() || this.m_pfj.isChartScatter()) && !this.m_pfj.isMixedFreqTimeAxis()) {
            this.writeViewFormatAttribute(0);
        }
        if (!(this.m_pfj.isChartStockType() || this.m_pfj.isChartFunnelType() || this.m_pfj.getJGraphType().isDualY())) {
            this.writeViewFormatAttribute(1);
        }
        if (this.m_pfj.isChartBubble()) {
            this.writeViewFormatAttribute(3);
        }
        if (this.m_pfj.getY1RangeSlider() != null) {
            this.writeViewFormatAttribute(2, 1);
        }
        if (this.m_pfj.getY2RangeSlider() != null) {
            this.writeViewFormatAttribute(3, 1);
        }
        if (this.m_pfj.getHorzRangeSlider() != null) {
            this.writeViewFormatAttribute(1, 1);
        }
        this.m_dataBlockMap = new HashMap();
        int startSeries = 0;
        int startGroup = 0;
        int numSeries = this.m_pfj.getNumTotalSeries();
        int numGroups = this.m_pfj.getNumTotalGroups();
        boolean[] bMissing = null;
        if (this.m_pfj.isTimeAxis() && (missingGroups = this.m_pfj.getMissingGroups()) != null) {
            bMissing = new boolean[numGroups];
            for (int i = 0; i < numGroups; ++i) {
                bMissing[i] = false;
            }
            for (int k = 0; k < missingGroups.length; ++k) {
                int g = missingGroups[k];
                if (g >= bMissing.length) continue;
                bMissing[g] = true;
            }
        }
        for (int s = startSeries; s < startSeries + numSeries; ++s) {
            for (int g = startGroup; g < startGroup + numGroups; ++g) {
                if (bMissing == null || !bMissing[g]) {
                    this.writeDataValueAttributes(s, g);
                }
                this.writeMemberMacroAttributes(s, g);
            }
        }
        Set<String> keySet = this.m_dataBlockMap.keySet();
        for (String key : keySet) {
            StringBuilder value = this.m_dataBlockMap.get(key);
            if (value == null || value.length() <= 0) continue;
            this.writeAttribute(key, value.toString());
        }
    }

    @Concealed
    public static String writeValueFormat(ViewFormat vf, boolean isPercent) {
        return GraphExportXMLWriter._writeValueFormat(vf, isPercent);
    }

    @Concealed
    private static String _writeValueFormat(ViewFormat vf, boolean isPowerPlusTwo) {
        boolean bIsDecimalDigitUsed;
        StringBuffer sb = new StringBuffer();
        NumberFormat format = vf.getNumberFormat();
        DecimalFormat decFormat = null;
        if (!(format instanceof DecimalFormat)) {
            return null;
        }
        decFormat = (DecimalFormat)format;
        DecimalFormatSymbols decFmtSymb = decFormat.getDecimalFormatSymbols();
        double multiplier = decFormat.getMultiplier();
        int groupSize = decFormat.getGroupingSize();
        if (!decFormat.isGroupingUsed()) {
            groupSize = 0;
        }
        int minFractLen = decFormat.getMinimumFractionDigits();
        int maxFractLen = decFormat.getMaximumFractionDigits();
        int minIntLen = decFormat.getMinimumIntegerDigits();
        int maxIntLen = decFormat.getMaximumIntegerDigits();
        String posPrefix = decFormat.getPositivePrefix();
        String posSuffix = decFormat.getPositiveSuffix();
        String negPrefix = decFormat.getNegativePrefix();
        String negSuffix = decFormat.getNegativeSuffix();
        char sPadDigit = decFmtSymb.getZeroDigit();
        String sInvalidValue = decFmtSymb.getNaN();
        char decSeparator = decFmtSymb.getDecimalSeparator();
        char groupingSeparator = decFmtSymb.getGroupingSeparator();
        boolean showScaleSymbol = false;
        String scaleDownK = vf.getScaleDownThousandsSymbol();
        String scaleDownM = vf.getScaleDownMillionsSymbol();
        String scaleDownB = vf.getScaleDownBillionsSymbol();
        String scaleDownT = vf.getScaleDownTrillionsSymbol();
        String scaleDownQ = vf.getScaleDownQuadrillionsSymbol();
        NumberConverter converter = vf.getNumberConverter();
        DvtNumberConverter numConverter = null;
        if (converter != null && converter instanceof DvtNumberConverter) {
            numConverter = (DvtNumberConverter)converter;
        }
        if (numConverter != null) {
            boolean currencyType = false;
            String pattern = numConverter.getPattern();
            if (pattern != null) {
                if (pattern.indexOf(164) != -1) {
                    currencyType = true;
                }
            } else if (numConverter.getType().equalsIgnoreCase("currency")) {
                currencyType = true;
            }
            if (currencyType) {
                decSeparator = decFmtSymb.getMonetaryDecimalSeparator();
            }
        }
        double scaleMultiplier = Double.NaN;
        showScaleSymbol = true;
        if (vf.isScaleFactorUsed()) {
            if (vf.getScaleFactor() == 0) {
                scaleMultiplier = 1.0;
                showScaleSymbol = false;
            } else {
                scaleMultiplier = StrictMath.pow(10.0, -vf.getScaleFactor() * 3);
                showScaleSymbol = true;
            }
        }
        if (!(bIsDecimalDigitUsed = vf.isDecimalDigitUsed())) {
            maxFractLen = -1;
            minFractLen = -1;
        } else if (numConverter == null) {
            maxFractLen = vf.getDecimalDigit();
            minFractLen = vf.getDecimalDigit();
        }
        if (numConverter == null) {
            boolean leadingZero = vf.isLeadingZero();
            minIntLen = leadingZero ? 1 : 0;
            if (vf.isThousandSeparatorUsed()) {
                groupingSeparator = vf.getThousandSeparatorSymbol();
            }
            if (vf.isDecimalSeparatorUsed()) {
                decSeparator = vf.getDecimalSeparatorSymbol();
            }
        }
        String sep = "~;";
        sb.append(scaleMultiplier).append(sep);
        if (decSeparator != '\u0000') {
            sb.append(decSeparator);
        }
        sb.append(sep);
        if (groupingSeparator != '\u0000') {
            sb.append(groupingSeparator);
        }
        sb.append(sep);
        sb.append(scaleDownK).append(sep);
        sb.append(scaleDownM).append(sep);
        sb.append(scaleDownB).append(sep);
        sb.append(scaleDownT).append(sep);
        sb.append(scaleDownQ).append(sep);
        sb.append(posPrefix).append(sep);
        sb.append(posSuffix).append(sep);
        sb.append(negPrefix).append(sep);
        sb.append(negSuffix).append(sep);
        sb.append(groupSize).append(sep);
        sb.append(Math.min(99, minFractLen)).append(sep);
        sb.append(Math.min(99, maxFractLen)).append(sep);
        sb.append(Math.min(99, minIntLen)).append(sep);
        sb.append(Math.min(99, maxIntLen)).append(sep);
        if (sPadDigit != '\u0000') {
            sb.append(sPadDigit);
        }
        sb.append(sep);
        if (showScaleSymbol) {
            sb.append(VAL_SLICE_LABEL_TYPE_TEXT);
        } else {
            sb.append("f");
        }
        sb.append(sep);
        sb.append(sInvalidValue).append(sep);
        sb.append(multiplier).append(sep);
        if (isPowerPlusTwo) {
            sb.append(VAL_SLICE_LABEL_TYPE_TEXT);
        } else {
            sb.append("f");
        }
        sb.append(sep);
        return sb.toString();
    }

    protected void writeViewFormatAttribute(int valueType) throws IOException, Exception {
        this.writeViewFormatAttribute(valueType, 0);
    }

    private void writeViewFormatAttribute(int valueType, int componentType) throws IOException, Exception {
        NumberFormatCallBack callback;
        if (this.m_pfj.isNumberFormatCallBack() && (callback = this.m_pfj.getNumberFormatCallBack()) instanceof GraphNumberFormatCallback) {
            ViewFormat vf = null;
            vf = componentType == 0 ? (valueType == 5 ? this.m_graph.getSliceLabel().getViewFormat() : ((GraphNumberFormatCallback)callback).getTooltipViewFormat(valueType)) : (valueType == 2 ? this.m_graph.getY1Axis().getViewFormat() : (valueType == 1 ? this.m_graph.getX1Axis().getViewFormat() : this.m_graph.getY2Axis().getViewFormat()));
            GraphFormatManager fm = this.m_graph.getGraphFormatManager();
            if (fm instanceof GraphRuleFormatter && !((GraphRuleFormatter)fm).isUsingRuleBundles()) {
                NumberFormat format = vf.getNumberFormat();
                if (format == null || !(format instanceof DecimalFormat)) {
                    return;
                }
                boolean isPowerPlusTwo = false;
                boolean isForcedPercent = false;
                DvtNumberConverter dnc = null;
                NumberConverter nc = vf.getNumberConverter();
                if (nc != null && nc instanceof DvtNumberConverter) {
                    dnc = (DvtNumberConverter)nc;
                }
                int sliceTextType = this.m_graph.getSliceLabel().getTextType();
                boolean isNumberTypeUsed = vf.isNumberTypeUsed();
                int numberType = vf.getNumberType();
                boolean isScaleFactorUsed = vf.isScaleFactorUsed();
                int scaleFactor = vf.getScaleFactor();
                boolean restoreScaleFactor = false;
                if (valueType == 5 && (1 == sliceTextType || 3 == sliceTextType)) {
                    isPowerPlusTwo = true;
                    isForcedPercent = true;
                    vf.setScaleFactor(0);
                    restoreScaleFactor = true;
                } else if (componentType == 1 && this.m_pfj.getJGraphType().isScalingPercent() && valueType == 2 && !isNumberTypeUsed && !(vf.getNumberConverter() instanceof DvtNumberConverter)) {
                    isForcedPercent = true;
                }
                if (isForcedPercent) {
                    vf.setNumberType(2);
                }
                String valueFormat = GraphExportXMLWriter._writeValueFormat(vf, isPowerPlusTwo);
                String attr = GraphExportXMLWriter._convertValueTypeToViewFormatAttr(valueType, componentType);
                if (isForcedPercent) {
                    vf.setNumberType(numberType);
                    vf.setNumberTypeUsed(isNumberTypeUsed);
                }
                if (restoreScaleFactor) {
                    vf.setScaleFactor(scaleFactor);
                    vf.setScaleFactorUsed(isScaleFactorUsed);
                }
                if (attr != null && valueFormat != null) {
                    this.writeAttribute(attr, valueFormat);
                    this.m_viewFormatList.add(attr);
                }
            }
        }
    }

    private void writeDataValueAttributes(int series, int group) throws IOException, Exception {
        Point2D pt2D;
        String xValue = null;
        String yValue = null;
        String zValue = null;
        if (this.m_chart instanceof JChart_2D_Scat) {
            block66: {
                block65: {
                    double fXValue = 0.0;
                    fYValue = 0.0;
                    fZValue = 0.0;
                    try {
                        String date;
                        fXValue = ((JChart_2D_Scat)this.m_chart).getXValue(series, group);
                        xValue = this.m_pfj.isMixedFreqTimeAxis() ? (date = this.m_pfj.getToolTipCallBack().convertDateToString(new Date((long)fXValue))) : this._formatValueWithLabel(ValueType.X, series, group, fXValue);
                    }
                    catch (AssertionException e) {
                        if (this.m_pfj.isMixedFreqTimeAxis()) {
                            xValue = NULL_VALUE_PLACEHOLDER;
                        } else {
                            this._addDataValue(ATTR_XVALUE, NULL_VALUE_PLACEHOLDER);
                        }
                        if (this.m_viewFormatList.contains(ATTR_VIEWFORMAT_X)) break block65;
                        xValue = NULL_VALUE_PLACEHOLDER;
                    }
                }
                try {
                    fYValue = ((JChart_2D_Scat)this.m_chart).getYValue(series, group);
                    yValue = this._formatValueWithLabel(ValueType.Y1, series, group, fYValue);
                }
                catch (AssertionException e) {
                    this._addDataValue(ATTR_YVALUE, NULL_VALUE_PLACEHOLDER);
                    if (this.m_viewFormatList.contains("YVF")) break block66;
                    yValue = NULL_VALUE_PLACEHOLDER;
                }
            }
            if (this.m_pfj.isChartBubble()) {
                try {
                    fZValue = ((JChart_2D_Scat)this.m_chart).getXYZ_ZValue(series, group);
                    zValue = this._formatValueWithLabel(ValueType.Z, series, group, fZValue);
                }
                catch (AssertionException e) {
                    this._addDataValue(ATTR_ZVALUE, NULL_VALUE_PLACEHOLDER);
                    if (!this.m_viewFormatList.contains(ATTR_VIEWFORMAT_Z)) {
                        zValue = NULL_VALUE_PLACEHOLDER;
                    }
                }
            }
        } else if (this.m_chart instanceof JChart_2D_Polar) {
            double fXValue = 0.0;
            fYValue = 0.0;
            fZValue = 0.0;
            try {
                fXValue = ((JChart_2D_Polar)this.m_chart).getXValue(series, group);
            }
            catch (AssertionException e) {
                fXValue = 0.0;
            }
            xValue = this._formatValueWithLabel(ValueType.X, series, group, fXValue);
            try {
                fYValue = ((JChart_2D_Polar)this.m_chart).getYValue(series, group);
            }
            catch (AssertionException e) {
                fYValue = 0.0;
            }
            yValue = this._formatValueWithLabel(ValueType.Y1, series, group, fYValue);
            if (this.m_tooltipTemplate != null && this.m_tooltipTemplate.contains("[Z]")) {
                try {
                    fZValue = ((JChart_2D_Polar)this.m_chart).getXYZ_ZValue(series, group);
                }
                catch (AssertionException e) {
                    fZValue = 0.0;
                }
                zValue = this._formatValueWithLabel(ValueType.Z, series, group, fZValue);
            }
        } else if (this.m_chart instanceof JChart_2D_PieBar) {
            if (group < 0) {
                double fSeriesTotal = ((JChart_2D_Pie)this.m_chart).getSeriesTotal(series);
                yValue = this._formatValueWithLabel(ValueType.Y1, series, group, fSeriesTotal);
            } else {
                double fGroupValue = ((JChart_2D_PieBar)this.m_chart).getGroupValueForBar(group);
                yValue = this._formatValueWithLabel(ValueType.Y1, series, group, fGroupValue);
            }
        } else if (this.m_chart instanceof JChart_2D_BLA || this.m_chart instanceof JChart_2D_Circular || this.m_chart instanceof JChart_2D_Hist || this.m_chart instanceof JChart_2D_Pie || this.m_chart instanceof JChart_2D_Pareto) {
            try {
                pt2D = this.m_graph.getSeries().getVisibility(series) == 0 || this.m_pfj.getIntegerProp(Attr.HideAndShowBehavior) == 2 ? this.m_chart.getDataValuesXY(series, group) : new Point(0, 0);
            }
            catch (AssertionException e) {
                pt2D = new Point2D.Double();
            }
            if (this.m_tooltipTemplate != null && this.m_tooltipTemplate.contains("[X]")) {
                String date;
                xValue = this.m_pfj.isMixedFreqTimeAxis() ? (date = this.m_pfj.getToolTipCallBack().convertDateToString(new Date((long)pt2D.getX()))) : this._formatValueWithLabel(ValueType.X, series, group, pt2D.getX());
            }
            yValue = this._formatValueWithLabel(ValueType.Y1, series, group, pt2D.getY());
        }
        if (this.m_chart instanceof JChart_2D_Pareto && this.m_bCumulativePercentageValue) {
            try {
                int numGroups = this.m_pfj.getNumTotalGroups();
                double fYValue = ((JChart_2D_Standard)this.m_chart).getParetoValue(series, group);
                double fTotal = ((JChart_2D_Standard)this.m_chart).getParetoValue(series, numGroups - 1);
                if (fTotal > 0.0) {
                    double percent = fYValue / fTotal;
                    String percentStr = this.m_pfj.getToolTipCallBack().getFormattedValue(percent, 51, true, false);
                    this._addDataValue(ATTR_CUMULATIVE_PERCENT_VALUE, percentStr);
                }
            }
            catch (AssertionException numGroups) {
                // empty catch block
            }
        }
        if (this.m_chart instanceof JChart_2D_BLA) {
            if (this.m_bCumulativeStackedValue) {
                double fTmpCumulValue = ((JChart_2D_Standard)this.m_chart).getStackedCumulativeValue(series, group);
                String stackedValue = ToolTips.FormatValue(this.m_pfj, series, group, fTmpCumulValue, null);
                this._addDataValue(ATTR_CUMULATIVE_STACKED_VALUE, stackedValue);
            }
            if (this.m_bCumulativePercentageValue) {
                double fPercentValue = ((JChart_2D_Standard)this.m_chart).getPercentCumulativeValue(series, group);
                String percentValue = ToolTips.FormatValue(this.m_pfj, series, group, fPercentValue, null);
                this._addDataValue(ATTR_CUMULATIVE_PERCENT_VALUE, percentValue);
            }
        }
        if (this.m_chart instanceof JChart_2D_PieBar && this.m_bPiePercentValue) {
            if (group >= 0) {
                double fGroupTotal = ((JChart_2D_Pie)this.m_chart).getGroupTotal(group);
                double fSumTotal = ((JChart_2D_Pie)this.m_chart).getSumTotal();
                fPercentage = fGroupTotal / fSumTotal;
                percentValue = ToolTips.FormatValue(this.m_pfj, series, group, fPercentage, "PIE_PERCENTAGE_VALUE");
                this._addDataValue(ATTR_PIE_PERCENT_VALUE, percentValue);
            } else {
                double fSeriesTotal = ((JChart_2D_Pie)this.m_chart).getSeriesTotal(series);
                double fSumTotal = ((JChart_2D_PieBar)this.m_chart).getSumTotal();
                fPercentage = fSeriesTotal / fSumTotal;
                percentValue = ToolTips.FormatValue(this.m_pfj, series, group, fPercentage, "PIE_PERCENTAGE_VALUE");
                this._addDataValue(ATTR_PIE_PERCENT_VALUE, percentValue);
            }
        } else if (this.m_chart instanceof JChart_2D_Pie && this.m_bPiePercentValue) {
            try {
                pt2D = this.m_chart.getDataValuesXY(series, group);
            }
            catch (AssertionException e) {
                pt2D = new Point2D.Double();
            }
            double fGroupTotal = ((JChart_2D_Pie)this.m_chart).getGroupTotal(group);
            double fPercentage = pt2D.getY() / fGroupTotal;
            String percentValue = ToolTips.FormatValue(this.m_pfj, series, group, fPercentage, "PIE_PERCENTAGE_VALUE");
            this._addDataValue(ATTR_PIE_PERCENT_VALUE, percentValue);
        }
        if (this.m_chart instanceof JChart_2D_Hilo) {
            double fDataValue;
            if (this.m_bHiloHighValue && ((JChart_2D_Hilo)this.m_chart).hasHighValue(this.m_dataFormat)) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_chart).getHighValue(series, group);
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                }
                String value = this._formatValue(ValueType.HIGH, series, group, fDataValue);
                this._addDataValue(ATTR_HILO_HIGH_VALUE, value);
            }
            if (this.m_bHiloLowValue && ((JChart_2D_Hilo)this.m_chart).hasLowValue(this.m_dataFormat)) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_chart).getLowValue(series, group);
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                }
                String value = this._formatValue(ValueType.LOW, series, group, fDataValue);
                this._addDataValue(ATTR_HILO_LOW_VALUE, value);
            }
            if (this.m_bHiloOpenValue && ((JChart_2D_Hilo)this.m_chart).hasOpenValue(this.m_dataFormat)) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_chart).getOpenValue(series, group);
                    String value = this._formatValue(ValueType.OPEN, series, group, fDataValue);
                    this._addDataValue(ATTR_HILO_OPEN_VALUE, value);
                }
                catch (AssertionException e) {
                    if (!this.m_pfj.getJGraphType().isStockCandleType()) {
                        String value = "";
                        this._addDataValue(ATTR_HILO_OPEN_VALUE, value);
                    }
                    String value = this._formatValue(ValueType.OPEN, series, group, 0.0);
                    this._addDataValue(ATTR_HILO_OPEN_VALUE, value);
                }
            }
            if (this.m_bHiloCloseValue && ((JChart_2D_Hilo)this.m_chart).hasCloseValue(this.m_dataFormat)) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_chart).getCloseValue(series, group);
                    String value = this._formatValue(ValueType.CLOSE, series, group, fDataValue);
                    this._addDataValue(ATTR_HILO_CLOSE_VALUE, value);
                }
                catch (AssertionException e) {
                    if (!this.m_pfj.getJGraphType().isStockCandleType()) {
                        String value = "";
                        this._addDataValue(ATTR_HILO_CLOSE_VALUE, value);
                    }
                    String value = this._formatValue(ValueType.CLOSE, series, group, 0.0);
                    this._addDataValue(ATTR_HILO_CLOSE_VALUE, value);
                }
            }
            if (this.m_bHiloVolumeValue && ((JChart_2D_Hilo)this.m_chart).hasVolumeValue(this.m_dataFormat)) {
                try {
                    series = 0;
                    fDataValue = ((JChart_2D_Hilo)this.m_chart).getVolumeValue(series, group);
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                }
                String value = ToolTips.FormatValue(this.m_pfj, series, group, fDataValue, "VOLUME");
                this._addDataValue(ATTR_HILO_VOLUME_VALUE, value);
            }
        }
        if (this.m_chart instanceof JChart_2D_Funnel) {
            double fActualValue = ((JChart_2D_Funnel)this.m_chart).getActualValue(group);
            String aValue = this._formatValue(ValueType.Y1, series, group, fActualValue);
            this._addDataValue(ATTR_FUNNEL_ACTUAL_VALUE, aValue);
            this._addDataValue(ATTR_FUNNEL_UNFORMATTED_ACTUAL_VALUE, Double.toString(fActualValue));
            double fTargetValue = ((JChart_2D_Funnel)this.m_chart).getTargetValue(group);
            String tValue = this._formatValue(ValueType.Y1, series, group, fTargetValue);
            this._addDataValue(ATTR_FUNNEL_TARGET_VALUE, tValue);
            this._addDataValue(ATTR_FUNNEL_UNFORMATTED_TARGET_VALUE, Double.toString(fTargetValue));
        }
        if (xValue != null) {
            this._addDataValue(ATTR_XVALUE_LABELS, xValue);
        }
        if (yValue != null) {
            this._addDataValue(ATTR_YVALUE_LABELS, yValue);
        }
        if (zValue != null) {
            this._addDataValue(ATTR_ZVALUE_LABELS, zValue);
        }
    }

    private void _addDataValue(String macro, String value) {
        if (this.m_dataBlockMap == null) {
            return;
        }
        StringBuilder currValues = this.m_dataBlockMap.get(macro);
        if (currValues == null) {
            currValues = value != null ? new StringBuilder(value) : new StringBuilder();
            this.m_dataBlockMap.put(macro, currValues);
        } else {
            if (macro == ATTR_XVALUE || macro == ATTR_YVALUE || macro == ATTR_ZVALUE) {
                currValues.append(',');
            } else {
                currValues.append("~;");
            }
            currValues.append(value);
        }
    }

    protected void writeMemberMacroAttributes(int series, int group) throws IOException, Exception {
        if (!this.m_bMemberMacros) {
            return;
        }
        ToolTipTextCallback tt = this.m_pfj.getToolTipCallBack();
        int row = tt.getRowID(series, group);
        int col = tt.getColID(series, group);
        int dataValuesPerMarker = tt.getDataValuesPerMarker();
        String valueLabel = null;
        if (this.m_bXMember || this.m_bYMember || this.m_bZMember) {
            if (this.m_pfj.isChartBLAType() || this.m_pfj.isChartScatter() || this.m_pfj.isChartBubble() || this.m_pfj.isChartCircular()) {
                switch (dataValuesPerMarker) {
                    case 1: {
                        valueLabel = tt.getValueMember(row, col, 0);
                        this._addDataValue(ATTR_Y_MEMBER, valueLabel);
                        break;
                    }
                    case 2: {
                        valueLabel = tt.getValueMember(row, col, 0);
                        this._addDataValue(ATTR_X_MEMBER, valueLabel);
                        valueLabel = tt.getValueMember(row, col, 1);
                        this._addDataValue(ATTR_Y_MEMBER, valueLabel);
                        break;
                    }
                    case 3: {
                        valueLabel = tt.getValueMember(row, col, 0);
                        this._addDataValue(ATTR_X_MEMBER, valueLabel);
                        valueLabel = tt.getValueMember(row, col, 1);
                        this._addDataValue(ATTR_Y_MEMBER, valueLabel);
                        valueLabel = tt.getValueMember(row, col, 2);
                        this._addDataValue(ATTR_Z_MEMBER, valueLabel);
                        break;
                    }
                }
            } else if (this.m_pfj.isChartPieType()) {
                valueLabel = tt.getValueMember(row, col, 0);
                this._addDataValue(ATTR_Y_MEMBER, valueLabel);
            } else if (this.m_pfj.isChartFunnelType()) {
                valueLabel = tt.getValueMember(row, col, 0);
                this._addDataValue(ATTR_X_MEMBER, valueLabel);
                valueLabel = tt.getValueMember(row, col, 1);
                this._addDataValue(ATTR_Y_MEMBER, valueLabel);
            }
        } else if (this.m_pfj.isChartStockType()) {
            switch (dataValuesPerMarker) {
                case 2: {
                    int graphType = this.m_pfj.getGraphType();
                    if (graphType == 72 || graphType == 84) {
                        valueLabel = tt.getValueMember(row, col, 0);
                        this._addDataValue(ATTR_HILO_OPEN_MEMBER, valueLabel);
                        valueLabel = tt.getValueMember(row, col, 1);
                        this._addDataValue(ATTR_HILO_CLOSE_MEMBER, valueLabel);
                        break;
                    }
                    valueLabel = tt.getValueMember(row, col, 0);
                    this._addDataValue(ATTR_HILO_HIGH_MEMBER, valueLabel);
                    valueLabel = tt.getValueMember(row, col, 1);
                    this._addDataValue("LM", valueLabel);
                    break;
                }
                case 3: {
                    valueLabel = tt.getValueMember(row, col, 0);
                    this._addDataValue(ATTR_HILO_HIGH_MEMBER, valueLabel);
                    valueLabel = tt.getValueMember(row, col, 1);
                    this._addDataValue("LM", valueLabel);
                    valueLabel = tt.getValueMember(row, col, 2);
                    this._addDataValue(ATTR_HILO_CLOSE_MEMBER, valueLabel);
                    break;
                }
                case 4: {
                    valueLabel = tt.getValueMember(row, col, 0);
                    this._addDataValue(ATTR_HILO_OPEN_MEMBER, valueLabel);
                    valueLabel = tt.getValueMember(row, col, 1);
                    this._addDataValue(ATTR_HILO_HIGH_MEMBER, valueLabel);
                    valueLabel = tt.getValueMember(row, col, 2);
                    this._addDataValue("LM", valueLabel);
                    valueLabel = tt.getValueMember(row, col, 3);
                    this._addDataValue(ATTR_HILO_CLOSE_MEMBER, valueLabel);
                    break;
                }
            }
        }
    }

    protected void writeLayersAttributes() throws IOException, Exception {
        if (this.m_pfj.m_ScatterGraphDataStyle != null && this.m_pfj.m_ScatterGraphDataStyle.m_contextList != null) {
            ArrayList contextList = this.m_pfj.m_ScatterGraphDataStyle.m_contextList;
            StringBuilder layers = new StringBuilder();
            for (DataStyleContext context : contextList) {
                Object dataStyle;
                String value = "";
                DataStyleType contextType = context.getType();
                if (contextType == DataStyleType.MARKER_COLOR || contextType == DataStyleType.MARKER_SHAPE) {
                    ArrayList<Integer> seriesList = context.getSeries();
                    if (seriesList != null) {
                        StringBuilder sb = new StringBuilder();
                        for (Integer i : seriesList) {
                            sb.append(i.toString()).append(',');
                        }
                        sb.setLength(sb.length() - 1);
                        value = sb.toString();
                    }
                } else if (contextType == DataStyleType.UNDERLAY_COLOR) {
                    dataStyle = context.getStyle();
                    if (dataStyle instanceof Color) {
                        value = PresUtils.toHexStringWithAlpha(((Color)dataStyle).getRGB());
                    }
                } else if (contextType == DataStyleType.UNDERLAY_SHAPE && (dataStyle = context.getStyle()) instanceof DataStyleType.Shape) {
                    DataStyleType.Shape shape = (DataStyleType.Shape)((Object)dataStyle);
                    switch (shape) {
                        case CIRCLE: {
                            value = "c";
                            break;
                        }
                        case SQUARE: {
                            value = "s";
                            break;
                        }
                        case DIAMOND: {
                            value = "d";
                            break;
                        }
                        case TRIANGLE_UP: {
                            value = VAL_SLICE_LABEL_TYPE_TEXT;
                            break;
                        }
                        case TRIANGLE_DN: {
                            value = "td";
                        }
                    }
                }
                layers.append(value).append("~;");
            }
            if (layers != null && layers.length() > 0) {
                layers.setLength(layers.length() - 2);
                this.writeAttribute(ATTR_LAYERS, layers.toString());
            }
        }
    }

    protected void writeSeriesAndGroupAttributes() throws IOException, Exception {
        int g;
        int startSeries = 0;
        int startGroup = 0;
        ToolTipTextCallback tt = this.m_pfj.getToolTipCallBack();
        int row = tt.getRowID(startSeries, startGroup);
        int col = tt.getColID(startSeries, startGroup);
        boolean bDataRowAsSeries = this.m_graph.isDataRowShownAsASeries();
        boolean bMarkerTooltipTemplate = this.m_graph.getMarkerTooltipTemplate() != null;
        String label = null;
        ArrayList<String> tooltip = new ArrayList<String>();
        StringBuilder ids = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        StringBuilder seriesColors = new StringBuilder();
        boolean bFunnelGraph = this.m_pfj.isChartFunnelType();
        StringBuilder pieSliceLabels = null;
        if (this.m_pfj.isChartPieType() || this.m_pfj.isChartPieRing()) {
            pieSliceLabels = new StringBuilder();
        }
        int start = startSeries;
        int count = this.m_pfj.getNumTotalSeries();
        for (int s = start; s < start + count; ++s) {
            ids.append(this.m_pfj.getDataGridCallback().getSeriesSliceId(s)).append("~;");
            if (pieSliceLabels != null) {
                pieSliceLabels.append(this.m_pfj.getSeriesLabel(s)).append("~;");
            }
            if (this.m_bSeriesMacros) {
                if (!bMarkerTooltipTemplate) {
                    row = tt.getRowID(s, startGroup);
                    col = tt.getColID(s, startGroup);
                    label = bDataRowAsSeries ? tt.getRowLabels(row, col) : tt.getColumnLabels(row, col);
                } else {
                    label = this.m_pfj.getSeriesLabel(s);
                }
                ToolTips.CustomToolTipIntoLines(label, tooltip);
                label = GraphExportXMLWriter._buildTooltipString(tooltip);
                labels.append(label).append("~;");
                tooltip.clear();
            }
            if (bFunnelGraph) {
                seriesColors.append(GraphExportXMLWriter.colorToHexWithAlpha((Color)Attr.TextFillColor.getDefault())).append(',');
                continue;
            }
            seriesColors.append(GraphExportXMLWriter.colorToHexWithAlpha(this.m_pfj.getSeriesFillColor(s))).append(',');
        }
        if (ids.length() > 0) {
            ids.setLength(ids.length() - 2);
            this.writeAttribute("series", ids.toString());
            if (this.m_bSeriesMacros) {
                labels.setLength(labels.length() - 2);
                this.writeAttribute(ATTR_SERIES_LABELS, labels.toString());
            }
        }
        if (seriesColors.length() > 0) {
            seriesColors.setLength(seriesColors.length() - 1);
            this.writeAttribute(ATTR_SERIES_COLORS, seriesColors.toString());
        }
        if (pieSliceLabels != null && pieSliceLabels.length() > 0) {
            pieSliceLabels.setLength(pieSliceLabels.length() - 2);
            this.writeAttribute(ATTR_PIE_SLICE_LABEL, pieSliceLabels.toString());
        }
        ids.setLength(0);
        labels.setLength(0);
        start = startGroup;
        count = this.m_pfj.getNumTotalGroups();
        if (this.m_pfj.isTimeAxis() && this.m_pfj.getMissingGroups() != null) {
            count -= this.m_pfj.getMissingGroups().length;
        }
        for (g = start; g < start + count; ++g) {
            ids.append(this.m_pfj.getDataGridCallback().getGroupSliceId(g)).append("~;");
            if (!this.m_bGroupMacros) continue;
            if (!bMarkerTooltipTemplate) {
                row = tt.getRowID(startSeries, g);
                col = tt.getColID(startSeries, g);
                label = bDataRowAsSeries ? tt.getColumnLabels(row, col) : tt.getRowLabels(row, col);
            } else {
                label = this.m_pfj.getGroupLabel(g);
            }
            ToolTips.CustomToolTipIntoLines(label, tooltip);
            label = GraphExportXMLWriter._buildTooltipString(tooltip);
            labels.append(label).append("~;");
            tooltip.clear();
        }
        if (ids.length() > 0) {
            ids.setLength(ids.length() - 2);
            this.writeAttribute("groups", ids.toString());
            if (this.m_bGroupMacros) {
                labels.setLength(labels.length() - 2);
                this.writeAttribute(ATTR_GROUP_LABELS, labels.toString());
            }
        }
        if (this.m_pfj.getHorzRangeSlider() != null && this.m_pfj.getJGraphType().getAxisDescriptor().hasO1() && !this.m_pfj.isContinuousTimeAxis()) {
            ids.setLength(0);
            labels.setLength(0);
            start = startGroup;
            count = this.m_pfj.getNumTotalGroups();
            for (g = start; g < start + count; ++g) {
                ids.append(this.m_pfj.getGroupLabels().get(g)).append("~;");
            }
            if (ids.length() > 0) {
                ids.setLength(ids.length() - 2);
                this.writeAttribute(ATTR_O1_GROUP_LABELS, ids.toString());
            }
        }
        this.writeDataBlockAttributes();
    }

    protected void writeFillAttributes(IdentObj id, BlackBoxIF bb, Shape shape) throws IOException, Exception {
        this.m_bElementFilled = true;
        switch (bb.getFillType()) {
            case 1: {
                break;
            }
            case 2: {
                this.writeCachedAttribute("ft", "ftG", null);
                return;
            }
            case 3: {
                String szURL = this.m_pfj.getTexture(bb.getIdentObj());
                Image img = this.m_pfj.getTexture(szURL);
                if (img != null) {
                    int nDisplayMode = this.m_pfj.getTextureDisplayMode(bb.getIdentObj());
                    if (nDisplayMode == 0) {
                        this.writeCachedAttribute("ft", "ftT", null);
                        this.writeAttribute("TDM", VAL_SLICE_LABEL_TYPE_TEXT);
                        this.writeAttribute("tURL", szURL);
                        return;
                    }
                    if (nDisplayMode == 1) {
                        this.writeCachedAttribute("ft", "ftT", null);
                        this.writeAttribute("TDM", "s");
                        this.writeAttribute("tURL", szURL);
                        return;
                    }
                    if (this.m_eh == null) break;
                    this.m_eh.log("unknown display mode", this.getClass().getName(), "writeFillAttributes(IdentObj id, BlackBoxIF bb, Rectangle bounds)");
                    break;
                }
                if (this.m_eh == null) break;
                this.m_eh.log("texture image null", this.getClass().getName(), "writeFillAttributes(IdentObj id, BlackBoxIF bb, Rectangle bounds)");
                break;
            }
            case 4: {
                int pattern = this.m_pfj.getFillPattern(bb.getIdentObj());
                String sPattern = GraphExportXMLWriter.convertFillPatternToXMLAttr(pattern);
                if (sPattern != null) {
                    this.writeCachedAttribute("ft", "ftP", null);
                    this.writeAttribute("fp", sPattern);
                    GraphStyle gs = bb.getGraphStyle(id.getSeriesID(), id.getGroupID());
                    if (gs != null && gs.getFillColor() != null) {
                        Color color = gs.getFillColor();
                        if (color == null) break;
                        this.writeCachedAttribute("fc", GraphExportXMLWriter.colorToHexWithAlpha(color), null);
                        return;
                    }
                    this.writeCachedAttribute("fc", GraphExportXMLWriter.colorToHexWithAlpha(this.m_pfj.getFillColor(bb.getIdentObj())), null);
                    return;
                }
                if (this.m_eh == null) break;
                this.m_eh.log("invalid pattern", this.getClass().getName(), "writeFillAttributes(IdentObj id, BlackBoxIF bb, Rectangle bounds)");
            }
        }
        this.writeCachedAttribute("ft", "ftC", null);
        this.writeCachedAttribute("fc", bb.getFillColor(), null);
    }

    public void writeFillChildren(IdentObj id, BlackBoxIF bb) throws IOException, Exception {
        this.writeFillChildren(id, bb, null);
    }

    public void writeFillChildren(IdentObj id, BlackBoxIF bb, Rectangle rect) throws IOException, Exception {
        if (!this.isElementFilled()) {
            return;
        }
        switch (bb.getFillType()) {
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                if (!(bb.getFillObj() instanceof FillGradientObj)) break;
                this.writeGradientElement((FillGradientObj)bb.getFillObj(), rect, id, VAL_SERIES_EFFECT_GRADIENT);
            }
        }
    }

    public void writeBorderChildren(IdentObj id, BlackBoxIF bb, Rectangle rect) throws IOException, Exception {
        BorderObj border = bb.getBorderObj();
        if (border != null && border.getGradient() != null) {
            this.writeGradientElement(border.getGradient(), rect, id, "lg");
        }
    }

    public void writeVisualEffectsAttributes(Map map) throws IOException, Exception {
        if (map == null) {
            this.writeCachedAttribute("sh", "", null);
            return;
        }
        Color sColor = (Color)map.get("shadowColor");
        Double sDistance = (Double)map.get("shadowDistance");
        Double sStrength = (Double)map.get("shadowStrength");
        Double sAngle = (Double)map.get("shadowAngle");
        Double sBlurX = (Double)map.get("shadowBlurX");
        Double sBlurY = (Double)map.get("shadowBlurY");
        Integer sQuality = (Integer)map.get("shadowQuality");
        Integer sInner = (Integer)map.get("shadowInner");
        Integer sKnockout = (Integer)map.get("shadowKnockout");
        Integer sHide = (Integer)map.get("shadowHide");
        if (sColor != null || sDistance != null || sStrength != null || sAngle != null || sBlurX != null || sBlurY != null || sQuality != null || sInner != null || sKnockout != null || sHide != null) {
            this.writeShadowAttribute(sColor, sDistance, sStrength, sAngle, sBlurX, sBlurY, sQuality, sInner, sKnockout, sHide);
        } else {
            this.writeCachedAttribute("sh", "", null);
        }
        Color bHighlightColor = (Color)map.get("bevelHighlightColor");
        Color bShadowColor = (Color)map.get("bevelShadowColor");
        Double bDistance = (Double)map.get("bevelDistance");
        Double bStrength = (Double)map.get("bevelStrength");
        Double bAngle = (Double)map.get("bevelAngle");
        Double bBlurX = (Double)map.get("bevelBlurX");
        Double bBlurY = (Double)map.get("bevelBlurY");
        Integer bQuality = (Integer)map.get("bevelQuality");
        String bType = (String)map.get("bevelType");
        if (bHighlightColor != null || bShadowColor != null || bDistance != null || bStrength != null || bAngle != null || bBlurX != null || bBlurY != null || bQuality != null || bType != null) {
            this.writeBevelAttribute(bHighlightColor, bShadowColor, bDistance, bStrength, bAngle, bBlurX, bBlurY, bQuality, bType);
        }
        Color gColor = (Color)map.get("glowColor");
        Double gBlurX = (Double)map.get("glowBlurX");
        Double gBlurY = (Double)map.get("glowBlurY");
        Double gStrength = (Double)map.get("glowStrength");
        Integer gQuality = (Integer)map.get("glowQuality");
        Integer gInner = (Integer)map.get("glowInner");
        Integer gKnockout = (Integer)map.get("glowKnockout");
        if (gColor != null || gBlurX != null || gBlurY != null || gStrength != null || gQuality != null || gInner != null || gKnockout != null) {
            this.writeGlowAttribute(gColor, gBlurX, gBlurY, gStrength, gQuality, gInner, gKnockout);
        }
    }

    public boolean isElementFilled() {
        return this.m_bElementFilled;
    }

    public void writeReferenceObjectsElement(IdentObj id) throws IOException, Exception {
        boolean bElemStarted = false;
        int graphID = this.m_pfj.getReferenceObjectGraphID(id.getObjectID());
        if (graphID != -1 && this.m_pfj.m_referenceObjects != null && this.m_pfj.m_referenceObjects.size() > 0) {
            for (int i = 0; i < this.m_pfj.m_referenceObjects.size(); ++i) {
                int series;
                IdentObj ro = (IdentObj)this.m_pfj.m_referenceObjects.get(i);
                if (this.m_pfj.getReferenceAssociation(ro) != graphID || graphID == 31 && (series = this.m_pfj.getReferenceSeries(ro).intValue()) != id.getSeriesID()) continue;
                if (!bElemStarted) {
                    bElemStarted = true;
                    this.startElement(ELEM_REFERENCE_OBJECTS);
                }
                this.startElement(ELEM_REF_OBJ);
                this.writeIdentObjAttributes(ro);
                this.endElement();
            }
        }
        if (bElemStarted) {
            this.endElement();
        }
    }

    protected void writeGradientElement(FillGradientObj gradient, Rectangle rect, IdentObj id, String elemType) throws IOException, Exception {
        int direction = 0;
        direction = gradient != null ? gradient.getDirection() : this.m_pfj.getGradientDirection(id);
        boolean bReverseStops = false;
        boolean bRadialCorner = false;
        int oldDirection = direction;
        switch (direction) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                direction = SFX._calcReversedGradientDirection(direction);
                bReverseStops = true;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                direction = 9;
                bRadialCorner = true;
                break;
            }
        }
        String sDirection = GradientUtils.convertGradientDirectionToXMLString(direction);
        if (sDirection == null || sDirection.length() == 0) {
            sDirection = GradientUtils.convertGradientDirectionToXMLString(1);
            if (this.m_eh != null) {
                this.m_eh.log("invalid gradient direction string", this.getClass().getName(), "writeGradientElement(BlackBoxIF bb, Rectangle rect)");
            }
        }
        if (sDirection != null) {
            int angle;
            this.startElement(elemType);
            this.writeCachedAttribute("dir", sDirection, null);
            int objId = ObjClassID.stripExceptionalOffset(id.getObjectID());
            if (objId == 298 && this.m_graph != null && this.m_graph.is3DEffect()) {
                this.writeAttribute("ang", "297");
            } else if (objId == 340 && this.m_graph != null && this.m_graph.is3DEffect()) {
                this.writeAttribute("ang", "120");
            } else if (objId == 341 && this.m_graph.is3DEffect()) {
                this.writeAttribute("ang", "245");
            } else if (objId == 313 && this.m_graph.is3DEffect()) {
                this.writeAttribute("ang", "290");
            } else if (objId == 357 && (angle = GraphExportXMLWriter.convertGradientDirectionToAngle(direction)) >= 0) {
                this.writeAttribute("ang", angle);
            }
            if (rect != null) {
                if (gradient.getBoundingBox() != null) {
                    Rectangle box = gradient.getBoundingBox().getBounds();
                    this.writeAttribute(ATTR_B, box.x + "," + box.y + "," + box.width + "," + box.height);
                } else {
                    this.writeAttribute(ATTR_B, rect.x + "," + rect.y + "," + rect.width + "," + rect.height);
                }
                if (direction == 9) {
                    if (!bRadialCorner) {
                        int cx = rect.x + rect.width / 2;
                        int cy = rect.y + rect.height / 2;
                        this.writeAttribute("cx", cx);
                        this.writeAttribute("cy", cy);
                        if (rect.width == rect.height) {
                            this.writeAttribute("r", rect.width / 2);
                        } else {
                            this.writeAttribute("rx", rect.width / 2);
                            this.writeAttribute("ry", rect.height / 2);
                        }
                    } else {
                        int cx = 0;
                        int cy = 0;
                        switch (oldDirection) {
                            case 12: {
                                cx = rect.x;
                                cy = rect.y + rect.height;
                                break;
                            }
                            case 13: {
                                cx = rect.x + rect.width;
                                cy = rect.y + rect.height;
                                break;
                            }
                            case 10: {
                                cx = rect.x;
                                cy = rect.y;
                                break;
                            }
                            case 11: {
                                cx = rect.x + rect.width;
                                cy = rect.y;
                            }
                        }
                        this.writeAttribute("cx", cx);
                        this.writeAttribute("cy", cy);
                        double scale = 1.41;
                        if (rect.width == rect.height) {
                            this.writeAttribute("r", Math.round(scale * (double)rect.width));
                        } else {
                            this.writeAttribute("rx", Math.round(scale * (double)rect.width));
                            this.writeAttribute("ry", Math.round(scale * (double)rect.height));
                        }
                    }
                }
            }
            this.writeGradientStopAttributes(gradient, bReverseStops, id);
            this.endElement();
        }
    }

    protected void writeGradientStopAttributes(FillGradientObj gradient, boolean bReverseStops, IdentObj id) throws IOException, Exception {
        int pinCount = 0;
        List<GradientStopObj> pins = null;
        if (gradient != null) {
            pins = gradient.getStopList();
            pinCount = pins.size();
        } else {
            pinCount = this.m_pfj.getGradientNumPins(id);
        }
        if (!bReverseStops) {
            StringBuilder pos = DataviewUtils.getSharedStringBuilder();
            StringBuilder c = DataviewUtils.getSharedStringBuilder2();
            for (int pin = 0; pin < pinCount; ++pin) {
                if (pos.length() > 0) {
                    pos.append(",");
                }
                if (c.length() > 0) {
                    c.append(",");
                }
                GradientStopObj colorPinObj = null;
                if (pins != null) {
                    colorPinObj = pins.get(pin);
                }
                double offset = 0.5;
                offset = colorPinObj == null ? this.m_pfj.getGradientPinPosition(id, pin) : colorPinObj.getPosition();
                Color color = null;
                color = colorPinObj == null ? this.m_pfj.getGradientPinRightColor(id, pin) : colorPinObj.getColor();
                pos.append(offset);
                c.append(GraphExportXMLWriter.colorToHexWithAlpha(color));
            }
            this.writeCachedAttribute(VAL_SLICE_LABEL_TYPE_PERCENT, pos.toString(), null);
            this.writeAttribute("c", c.toString());
        } else {
            StringBuilder pos = DataviewUtils.getSharedStringBuilder();
            StringBuilder c = DataviewUtils.getSharedStringBuilder2();
            for (int pin = pinCount - 1; pin >= 0; --pin) {
                if (pos.length() > 0) {
                    pos.append(",");
                }
                if (c.length() > 0) {
                    c.append(",");
                }
                GradientStopObj colorPinObj = null;
                if (pins != null) {
                    colorPinObj = pins.get(pin);
                }
                double offset = 0.5;
                offset = colorPinObj == null ? this.m_pfj.getGradientPinPosition(id, pin) : colorPinObj.getPosition();
                Color color = null;
                color = colorPinObj == null ? this.m_pfj.getGradientPinRightColor(id, pin) : colorPinObj.getColor();
                pos.append(1.0 - offset);
                c.append(GraphExportXMLWriter.colorToHexWithAlpha(color));
            }
            this.writeCachedAttribute(VAL_SLICE_LABEL_TYPE_PERCENT, pos.toString(), null);
            this.writeAttribute("c", c.toString());
        }
    }

    @Override
    public boolean isAnimationOnDisplay() {
        int type = this.m_graph.getAnimationOnDisplay();
        if (type >= 1) {
            return true;
        }
        return super.isAnimationOnDisplay();
    }

    private final int getAnimationOnDisplay(CommonGraph graph) {
        int type = graph.getAnimationOnDisplay();
        if (type == 1) {
            if (graph.getBarShape() == 0) {
                int graphType = graph.getGraphType();
                switch (graphType) {
                    case 17: 
                    case 18: 
                    case 55: {
                        return type;
                    }
                    case 31: 
                    case 41: 
                    case 61: 
                    case 89: 
                    case 97: {
                        if (graph.is3DEffect()) break;
                        return type;
                    }
                }
            }
            return 2;
        }
        return type;
    }

    private final int getAnimationOnDataChange(CommonGraph graph) {
        int type = graph.getAnimationOnDataChange();
        if (type == 1 || type == 2) {
            if (graph.getBarShape() == 0) {
                int graphType = graph.getGraphType();
                switch (graphType) {
                    case 17: 
                    case 18: 
                    case 55: {
                        return type;
                    }
                    case 31: 
                    case 41: 
                    case 61: 
                    case 89: 
                    case 97: {
                        if (graph.is3DEffect()) break;
                        return type;
                    }
                }
            }
            return 3;
        }
        return type;
    }

    @Override
    public void writeAnimationAttributes() throws IOException, Exception {
        Color animationDownColor;
        Color animationUpColor;
        int animationDuration;
        int animationIndicators;
        if (this.m_graph == null) {
            return;
        }
        if (this.m_pfj.isAnimationOnDataChangeSet()) {
            this.writeAttribute("aDC", CommonGraph.convertAnimationOnDataChangeToString(this.getAnimationOnDataChange(this.m_graph)));
        }
        if ((animationIndicators = this.m_graph.getAnimationIndicators()) != (Integer)Attr.AnimationIndicators.getDefault()) {
            this.writeAttribute("aI", CommonGraph.convertAnimationIndicatorsToString(animationIndicators));
        }
        if ((animationDuration = this.m_graph.getAnimationDuration()) != (Integer)Attr.AnimationDuration.getDefault()) {
            this.writeAttribute("aDu", animationDuration);
        }
        if (this.isAnimationOnDisplay()) {
            this.writeAttribute("aDi", CommonGraph.convertAnimationOnDisplayToString(this.getAnimationOnDisplay(this.m_graph)));
        }
        if (!(animationUpColor = this.m_graph.getAnimationUpColor()).equals(Attr.AnimationUpColor.getDefault())) {
            this.writeAttribute("aU", animationUpColor);
        }
        if (!(animationDownColor = this.m_graph.getAnimationDownColor()).equals(Attr.AnimationDownColor.getDefault())) {
            this.writeAttribute("aD", animationDownColor);
        }
    }

    public void writeDataZoomAndScrollEventJsAttributes(DetObj detObj) throws IOException, Exception {
        int objectID = detObj.getObjectID();
        String dataZoomInButtonJs = null;
        String dataZoomOutButtonJs = null;
        String dataScrollJs = null;
        JChart_Base chartBase = this.m_pfj.getGraphObject();
        JChart_2D_Standard ch = null;
        if (chartBase instanceof JChart_2D_Standard) {
            ch = (JChart_2D_Standard)chartBase;
        }
        Axis2DObj axisObj = null;
        boolean bAutoMin = false;
        boolean bAutoMax = false;
        double autoMinVal = 0.0;
        double autoMaxVal = 0.0;
        switch (objectID) {
            case 3007: {
                dataZoomInButtonJs = this.getDataZoomInButtonSubmitJS("O1");
                break;
            }
            case 3001: {
                dataZoomInButtonJs = this.getDataZoomInButtonSubmitJS("Y1");
                break;
            }
            case 3019: {
                dataZoomInButtonJs = this.getDataZoomInButtonSubmitJS("Y2");
                break;
            }
            case 3013: {
                dataZoomInButtonJs = this.getDataZoomInButtonSubmitJS("X1");
                break;
            }
            case 3008: {
                dataZoomOutButtonJs = this.getDataZoomOutButtonSubmitJS("O1");
                break;
            }
            case 3002: {
                dataZoomOutButtonJs = this.getDataZoomOutButtonSubmitJS("Y1");
                break;
            }
            case 3020: {
                dataZoomOutButtonJs = this.getDataZoomOutButtonSubmitJS("Y2");
                break;
            }
            case 3014: {
                dataZoomOutButtonJs = this.getDataZoomOutButtonSubmitJS("X1");
                break;
            }
            case 3011: {
                dataScrollJs = this.getDataScrollSubmitJS("O1");
                this.writeAttribute(ATTR_SCROLL_START, this.m_pfj.getEffectiveGroupOffset());
                this.writeAttribute(ATTR_SCROLL_SPAN, this.m_pfj.getNumGroups());
                this.writeAttribute(ATTR_SCROLL_TOTAL, this.m_pfj.getNumTotalGroups());
                StringBuilder sb = DataviewUtils.getSharedStringBuilder();
                for (int i = 0; i < this.m_pfj.getNumTotalGroups(); ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    if (this.m_pfj.isTimeAxis()) {
                        sb.append("'" + this.m_pfj.getUnnestedGroupLabel(i) + "'");
                        continue;
                    }
                    sb.append("'" + this.m_pfj.getGroupLabel(i) + "'");
                }
                if (sb.length() <= 0) break;
                this.writeAttribute(ATTR_SCROLL_LABELS, sb.toString());
                break;
            }
            case 3005: {
                dataScrollJs = this.getDataScrollSubmitJS("Y1");
                if (ch == null) break;
                axisObj = (Axis2DObj)ch.m_Y1Axis;
                bAutoMin = this.m_pfj.getY1ScaleMinAuto();
                bAutoMax = this.m_pfj.getY1ScaleMaxAuto();
                autoMinVal = this.m_pfj.getY1ScaleMinAutoValue();
                autoMaxVal = this.m_pfj.getY1ScaleMaxAutoValue();
                break;
            }
            case 3023: {
                dataScrollJs = this.getDataScrollSubmitJS("Y2");
                if (ch == null) break;
                axisObj = (Axis2DObj)ch.m_Y2Axis;
                bAutoMin = this.m_pfj.getY2ScaleMinAuto();
                bAutoMax = this.m_pfj.getY2ScaleMaxAuto();
                autoMinVal = this.m_pfj.getY2ScaleMinAutoValue();
                autoMaxVal = this.m_pfj.getY2ScaleMaxAutoValue();
                break;
            }
            case 3017: {
                dataScrollJs = this.getDataScrollSubmitJS("X1");
                if (ch == null) break;
                axisObj = (Axis2DObj)ch.m_X1Axis;
                if (this.m_pfj.isContinuousTimeAxis()) {
                    axisObj = (Axis2DObj)ch.m_O1Axis;
                }
                bAutoMin = this.m_pfj.getX1ScaleMinAuto();
                bAutoMax = this.m_pfj.getX1ScaleMaxAuto();
                if (this.m_pfj.isContinuousTimeAxis()) {
                    bAutoMin = false;
                    bAutoMax = false;
                }
                autoMinVal = this.m_pfj.getX1ScaleMinAutoValue();
                autoMaxVal = this.m_pfj.getX1ScaleMaxAutoValue();
                break;
            }
        }
        if (dataZoomInButtonJs != null) {
            this.writeAttribute(ATTR_DATA_ZOOM_IN_BUTTON_EVENT_JS, dataZoomInButtonJs);
        }
        if (dataZoomOutButtonJs != null) {
            this.writeAttribute(ATTR_DATA_ZOOM_OUT_BUTTON_EVENT_JS, dataZoomOutButtonJs);
        }
        if (dataScrollJs != null) {
            this.writeAttribute(ATTR_DATA_SCROLL_EVENT_JS, dataScrollJs);
        }
        if (axisObj != null) {
            if (axisObj.getAutoMinMaxArray() != null) {
                if (!bAutoMin) {
                    autoMinVal = axisObj.getAutoMinMaxArray()[0];
                }
                if (!bAutoMax) {
                    autoMaxVal = axisObj.getAutoMinMaxArray()[1];
                }
            }
            boolean bHoriz = !axisObj.isVertical();
            double autoMin = axisObj.getValueCoordForZoom(autoMinVal);
            double autoMax = axisObj.getValueCoordForZoom(autoMaxVal);
            double min = axisObj.getMinCoord();
            double max = axisObj.getMaxCoord();
            int start = 0;
            int span = 0;
            int total = 0;
            if (bHoriz) {
                total = Math.abs(this.m_pfj.getVC().virtToDestWidth((int)(autoMax - autoMin)));
                span = Math.abs(this.m_pfj.getVC().virtToDestWidth((int)(max - min)));
                start = Math.abs(this.m_pfj.getVC().virtToDestWidth((int)(min - autoMin)));
            } else {
                total = Math.abs(this.m_pfj.getVC().virtToDestHeight((int)(autoMax - autoMin)));
                span = Math.abs(this.m_pfj.getVC().virtToDestHeight((int)(max - min)));
                start = Math.abs(this.m_pfj.getVC().virtToDestHeight((int)(min - autoMin)));
            }
            this.writeAttribute(ATTR_SCROLL_START, start);
            this.writeAttribute(ATTR_SCROLL_SPAN, span);
            this.writeAttribute(ATTR_SCROLL_TOTAL, total);
            this.writeAttribute(ATTR_SCROLL_MIN_VAL, autoMinVal);
            this.writeAttribute(ATTR_SCROLL_MAX_VAL, autoMaxVal);
            if (objectID == 3017 && this.m_pfj.isContinuousTimeAxis()) {
                int freq = this.m_pfj.getDateFrequency();
                String format = SECOND_FORMAT;
                switch (freq) {
                    case 0: {
                        format = MONTH_FORMAT;
                        break;
                    }
                    case 1: {
                        format = DAY_FORMAT;
                        break;
                    }
                    case 2: {
                        format = HOUR_FORMAT;
                        break;
                    }
                    case 4: {
                        format = MINUTE_FORMAT;
                        break;
                    }
                    case 5: {
                        format = SECOND_FORMAT;
                    }
                }
                this.writeAttribute(ATTR_DATE_FORMAT, format);
            }
        }
    }

    public boolean useTooltipTemplate(IdentObj id) {
        int objectID = ObjClassID.stripExceptionalOffset(id.getObjectID());
        return this.useTooltipTemplate(objectID);
    }

    public boolean useTooltipTemplate(int objectID) {
        if (this.m_tooltipTemplate == null) {
            return false;
        }
        return ToolTips.useMarkerTooltipTemplate(objectID, this.m_graphType);
    }

    protected String convertObjectIdToString(IdentObj identObj) {
        int id = ObjClassID.stripExceptionalOffset(identObj.getObjectID());
        switch (id) {
            case 1: {
                return "CB";
            }
            case 301: {
                return "PieBarConnectLines";
            }
            case 317: {
                return "LRS";
            }
            case 258: {
                return "LR";
            }
            case 318: {
                return "LRT";
            }
            case 259: {
                return "LM";
            }
            case 277: {
                return "BR";
            }
            case 312: {
                return "BRS";
            }
            case 313: {
                return "BRB";
            }
            case 331: {
                return "PieBarRiser";
            }
            case 334: {
                return "PieBarRiserSide";
            }
            case 335: {
                return "PieBarRiserTop";
            }
            case 310: {
                return "StockVolumeRiser";
            }
            case 303: {
                return "SR";
            }
            case 306: {
                return "StockLowerRiser";
            }
            case 307: {
                return "SCT";
            }
            case 308: {
                return "SOT";
            }
            case 319: {
                return "StockRisingRiser";
            }
            case 320: {
                return "StockFallingRiser";
            }
            case 321: {
                return "StockHighLine";
            }
            case 322: {
                return "StockLowLine";
            }
            case 474: {
                return "ParetoLineMarker";
            }
            case 473: {
                return "ParetoLineRiser";
            }
            case 475: {
                return "ParetoLineRiserTop";
            }
            case 476: {
                return "ParetoLineRiserSide";
            }
            case 315: {
                return "AreaRiserSide";
            }
            case 256: {
                return "AR";
            }
            case 314: {
                return "ART";
            }
            case 316: {
                return "ARB";
            }
            case 606: {
                return "CRF";
            }
            case 41: {
                return "CurveFitLineRiser";
            }
            case 12: {
                return "LA";
            }
            case 13: 
            case 73: 
            case 343: {
                return "LeM";
            }
            case 74: {
                return "LegendTitle";
            }
            case 14: 
            case 344: {
                return "LT";
            }
            case 18: {
                if (this.m_pfj.getGraphType() != 12) break;
                return "SpectralLegendMarker";
            }
            case 260: {
                return "DataText";
            }
            case 294: {
                return "PFL";
            }
            case 296: {
                return "PieLabel";
            }
            case 297: {
                return "PieRingLabel";
            }
            case 2: {
                return "F";
            }
            case 15: {
                return "FrameSide";
            }
            case 16: {
                return "FrameBottom";
            }
            case 302: {
                return "PieFrame";
            }
            case 328: {
                return "QL";
            }
            case 329: {
                return "ScatterQuadrantLine";
            }
            case 298: {
                return "Sl";
            }
            case 299: {
                return "SC";
            }
            case 300: {
                return "SliceRing";
            }
            case 514: {
                return "ToolTips";
            }
            case 332: {
                return "PieBarSlice";
            }
            case 333: {
                return "PieBarSliecCrust";
            }
            case 295: {
                if (this.m_graph != null && this.m_graph.getSlice().getLabelPosition() == 3) {
                    return "PSLI";
                }
                return "PSL";
            }
            case 17: {
                return "FrameSeparator";
            }
            case 269: {
                return "O1AxisLine";
            }
            case 279: {
                return "X1AxisLine";
            }
            case 271: {
                return "O1MajorGrid";
            }
            case 281: {
                return "X1MG";
            }
            case 282: {
                return "X1MinorGrid";
            }
            case 614: {
                return "CubeFloorGridX";
            }
            case 618: {
                return "CubeRightWallGridX";
            }
            case 270: {
                return "O1L";
            }
            case 280: {
                return "X1L";
            }
            case 8: {
                return "O1Title";
            }
            case 10: {
                return "X1Title";
            }
            case 283: {
                return "Y1AxisLine";
            }
            case 285: {
                return "Y1MG";
            }
            case 286: {
                return "Y1MinorGrid";
            }
            case 616: {
                return "CubeLeftWallGridY";
            }
            case 619: {
                return "CubeRightWallGridY";
            }
            case 284: {
                return "Y1L";
            }
            case 6: {
                return "Y1Title";
            }
            case 292: {
                return "Y1ZeroLine";
            }
            case 287: {
                return "Y2AxisLine";
            }
            case 289: {
                return "Y2MajorGrid";
            }
            case 290: {
                return "Y2MinorGrid";
            }
            case 288: {
                return "Y2Label";
            }
            case 7: {
                return "Y2Title";
            }
            case 293: {
                return "Y2ZeroLine";
            }
            case 608: {
                return "CubeRiserGridY";
            }
            case 615: {
                return "CubeFloorGridZ";
            }
            case 617: {
                return "CubeLeftWallGridZ";
            }
            case 274: {
                return "O2L";
            }
            case 9: {
                return "O2Title";
            }
            case 603: {
                return "CubeFloor";
            }
            case 604: {
                return "CubeLeftWall";
            }
            case 605: {
                return "CubeRightWall";
            }
            case 3: {
                return "Footnote";
            }
            case 4: {
                return "Subtitle";
            }
            case 5: {
                return "Title";
            }
            case 357: {
                int location = this.m_pfj.getReferenceObjectLocation(identObj);
                if (location == 0) {
                    return "ROF";
                }
                return "ROB";
            }
            case 358: {
                return "ReferenceLine";
            }
            case 511: {
                return "SelectPointMarker";
            }
            case 503: {
                return "RLLT";
            }
            case 504: {
                return "RLM";
            }
            case 232: {
                return "O1DrillLabel";
            }
            case 233: {
                return "O2DrillLabel";
            }
            case 235: {
                return "DrillText";
            }
            case 234: {
                return "DrillMarker";
            }
            case 513: {
                return "TimeSelector";
            }
            case 359: {
                return "SeriesObjects";
            }
            case 348: {
                return "BoxBar";
            }
            case 347: {
                return "BoxLine";
            }
            case 349: {
                return "BoxMark";
            }
            case 620: {
                return "FunnelFrame";
            }
            case 621: {
                return "FunnelSlice";
            }
            case 622: {
                return "FunnelSliceLabel";
            }
            case 623: {
                return "FunnelLeftSurface";
            }
            case 624: {
                return "FunnelLines";
            }
            case 625: {
                return "FunnelLabelBackgroundRect";
            }
            case 626: {
                return "FunnelSkeleton";
            }
            case 627: {
                return "FunnelBoundingRect";
            }
            case 3001: {
                return "ZoomInY1";
            }
            case 3002: {
                return "ZoomOutY1";
            }
            case 3003: {
                return "ScrollIconFY1";
            }
            case 3004: {
                return "ScrollIconSY1";
            }
            case 3005: {
                return "DataScrollerY1";
            }
            case 3006: {
                return "ScrollThumbY1";
            }
            case 3007: {
                return "ZoomInO1";
            }
            case 3008: {
                return "ZoomOutO1";
            }
            case 3009: {
                return "ScrollIconFO1";
            }
            case 3010: {
                return "ScrollIconSO1";
            }
            case 3011: {
                return "DataScrollerO1";
            }
            case 3012: {
                return "ScrollThumbO1";
            }
            case 3019: {
                return "ZoomInY2";
            }
            case 3020: {
                return "ZoomOutY2";
            }
            case 3021: {
                return "ScrollIconFY2";
            }
            case 3022: {
                return "ScrollIconSY2";
            }
            case 3023: {
                return "DataScrollerY2";
            }
            case 3024: {
                return "ScrollThumbY2";
            }
            case 3013: {
                return "ZoomInX1";
            }
            case 3014: {
                return "ZoomOutX1";
            }
            case 3015: {
                return "ScrollIconFX1";
            }
            case 3016: {
                return "ScrollIconSX1";
            }
            case 3017: {
                return "DataScrollerX1";
            }
            case 3018: {
                return "ScrollThumbX1";
            }
            case 3000: {
                return "Common";
            }
            case 3025: {
                return "CommonArrow";
            }
            case 338: {
                return "PGO";
            }
            case 339: {
                return "PieGlowOverlay";
            }
            case 340: {
                return "PieBorder";
            }
            case 345: {
                return "ZoomWindow";
            }
        }
        return "Other";
    }

    private static int convertGradientDirectionToAngle(int direction) {
        switch (direction) {
            case 1: {
                return 0;
            }
            case 3: {
                return 270;
            }
            case 5: {
                return 225;
            }
            case 7: {
                return 315;
            }
        }
        return -1;
    }

    private static String _convertValueTypeToViewFormatAttr(int valueType, int componentType) {
        if (componentType == 0) {
            switch (valueType) {
                case 0: {
                    return ATTR_VIEWFORMAT_X;
                }
                case 1: {
                    return "YVF";
                }
                case 2: {
                    return ATTR_VIEWFORMAT_Y2;
                }
                case 3: {
                    return ATTR_VIEWFORMAT_Z;
                }
                case 4: {
                    return ATTR_VIEWFORMAT_VOLUME;
                }
                case 5: {
                    return ATTR_VIEWFORMAT_PIESLICELABEL;
                }
            }
        } else if (componentType == 1) {
            switch (valueType) {
                case 2: {
                    return ATTR_VIEWFORMAT_Y1_SCROLLBAR;
                }
                case 1: {
                    return ATTR_VIEWFORMAT_X_SCROLLBAR;
                }
                case 3: {
                    return ATTR_VIEWFORMAT_Y2_SCROLLBAR;
                }
            }
        }
        return null;
    }

    private String _formatValue(ValueType type, int series, int group, double val) {
        if (type == ValueType.Y1) {
            return ToolTips.FormatValue(this.m_pfj, series, group, val, "YVALUE");
        }
        if (type == ValueType.HIGH && !this.m_viewFormatList.contains("YVF")) {
            return ToolTips.FormatValue(this.m_pfj, series, group, val, "HIGH");
        }
        if (type == ValueType.LOW && !this.m_viewFormatList.contains("YVF")) {
            return ToolTips.FormatValue(this.m_pfj, series, group, val, "LOW");
        }
        if (type == ValueType.OPEN && !this.m_viewFormatList.contains("YVF")) {
            return ToolTips.FormatValue(this.m_pfj, series, group, val, "OPEN");
        }
        if (type == ValueType.CLOSE && !this.m_viewFormatList.contains("YVF")) {
            return ToolTips.FormatValue(this.m_pfj, series, group, val, "CLOSE");
        }
        return String.valueOf(val);
    }

    private String _formatValueWithLabel(ValueType type, int series, int group, double val) {
        if (type == ValueType.X) {
            this._addDataValue(ATTR_XVALUE, String.valueOf(val));
            if (!this.m_viewFormatList.contains(ATTR_VIEWFORMAT_X)) {
                return ToolTips.FormatValue(this.m_pfj, series, group, val, "XVALUE");
            }
        } else if (type == ValueType.Y1) {
            this._addDataValue(ATTR_YVALUE, String.valueOf(val));
            if (!this.m_viewFormatList.contains("YVF")) {
                return ToolTips.FormatValue(this.m_pfj, series, group, val, "YVALUE");
            }
        } else if (type == ValueType.Z) {
            this._addDataValue(ATTR_ZVALUE, String.valueOf(val));
            if (!this.m_viewFormatList.contains(ATTR_VIEWFORMAT_Z)) {
                return ToolTips.FormatValue(this.m_pfj, series, group, val, "ZVALUE");
            }
        }
        return null;
    }

    public static String getTimeAxisResources(Perspective pfj) {
        char delimiter = ',';
        GregorianCalendar cal = new GregorianCalendar(2000, 0, 1);
        Locale locale = pfj.getLocale();
        StringBuilder timeAxisResources = new StringBuilder();
        for (int i = 0; i < 12; ++i) {
            Date date = cal.getTime();
            String monthStr = locale.getLanguage().equals("ja") ? pfj.formatDate(date, 1, "Month") : pfj.formatDate(date, 1, "Mon");
            timeAxisResources.append(monthStr).append(delimiter);
            ((Calendar)cal).roll(2, true);
        }
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        if (pfj.isUser12HFormat()) {
            String[] ampmString = dateFormatSymbols.getAmPmStrings();
            timeAxisResources.append(ampmString[0]).append(delimiter);
            timeAxisResources.append(ampmString[1]).append(delimiter);
        } else {
            timeAxisResources.append("").append(delimiter);
            timeAxisResources.append("").append(delimiter);
        }
        String language = locale.getLanguage();
        if (language.equals("ko") || language.equals("ja") || language.equals("zh") || language.equals("ar") || language.equals("he") || language.equals("iw")) {
            timeAxisResources.append('t').append(delimiter);
        } else {
            timeAxisResources.append('f').append(delimiter);
        }
        String dmy = pfj.getDMYOrder(locale);
        timeAxisResources.append(dmy).append(delimiter);
        pfj.getYearDayTrailingCharacters();
        timeAxisResources.append(pfj.yearTrailingCharacter).append(delimiter);
        timeAxisResources.append(pfj.dayTrailingCharacter);
        return timeAxisResources.toString();
    }

    public static String getTimeZoneOffset(Perspective pfj) {
        TimeZone timeZone = pfj.getTDGDateFormat().getTimeZone();
        if (timeZone != null) {
            int offset = timeZone.getOffset(System.currentTimeMillis());
            offset /= 1000;
            return String.valueOf(offset /= 60);
        }
        return "0";
    }

    @Concealed
    public static String convertFillPatternToXMLAttr(int pattern) {
        switch (pattern) {
            case 0: {
                return "sDUL";
            }
            case 1: {
                return "sCh";
            }
            case 2: {
                return "sDUR";
            }
            case 3: {
                return "sTCh";
            }
            case 4: {
                return "sC";
            }
            case 5: {
                return "sDCh";
            }
            case 6: {
                return "lDUL";
            }
            case 7: {
                return "lCh";
            }
            case 8: {
                return "lDUR";
            }
            case 9: {
                return "lTCh";
            }
            case 10: {
                return "lC";
            }
            case 11: {
                return "lDCh";
            }
        }
        return null;
    }

    public void writeSelectionAttributes() throws IOException, Exception {
        if (this.m_graph == null) {
            return;
        }
        if (this.m_graph.getDataSelection() == GraphConstants.DataSelection.single) {
            this.writeAttribute(ATTR_SELECTION, "s");
        } else if (this.m_graph.getDataSelection() == GraphConstants.DataSelection.multiple) {
            this.writeAttribute(ATTR_SELECTION, ELEM_MARKER);
        }
    }

    protected void writeAdditionalMetadata() throws IOException, Exception {
        GraphSelectionSet selection = this.m_graph.getSelection();
        if (selection != null && selection.size() > 0) {
            String SERIES_SEP = "~;";
            String GROUP_SEP = "~:";
            StringBuilder selInfo = new StringBuilder();
            String prevSeriesId = null;
            for (GraphSelection gs : selection) {
                if (!(gs instanceof DataSelection)) continue;
                DataContext dataContext = this.getDataContext(gs);
                String seriesId = dataContext.getSeriesId();
                String groupId = dataContext.getGroupId();
                if (seriesId == null || groupId == null) continue;
                if (seriesId.equals(prevSeriesId)) {
                    selInfo.append(GROUP_SEP + dataContext.getGroupId());
                    continue;
                }
                if (selInfo.length() > 0) {
                    selInfo.append(SERIES_SEP);
                }
                selInfo.append(seriesId + GROUP_SEP + groupId);
                prevSeriesId = seriesId;
            }
            if (selInfo != null && selInfo.length() > 0) {
                this.writeAttribute(ATTR_SELECTION, selInfo.toString());
            }
        }
        this.writeAdditionalSelectionMetadata();
    }

    protected void writeAdditionalSelectionMetadata() throws IOException, Exception {
        if (this.m_graph.getSelectionListeners().length > 0) {
            this.writeAttribute("selJS", this.getSelectionJS());
        }
    }

    private DataContext getDataContext(GraphSelection s) {
        if (!(s instanceof DataSelection)) {
            return null;
        }
        DataSelection ds = (DataSelection)s;
        return new DataContext(this.m_graph, ds.getSeriesKey(), ds.getGroupKeys());
    }

    private static enum ValueType {
        X,
        Y1,
        Y2,
        Z,
        HIGH,
        LOW,
        OPEN,
        CLOSE,
        VOLUME;

    }
}

